/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import java.util.LinkedHashSet;

public class PortFilters {
    protected static final DeviceTemplate.PortFilter[] DEFAULT_FILTERS = new DeviceTemplate.PortFilter[]{new AllFilter(), new MappedUpFilter(), new MappedUpExternalTypeFilter(), new ExternalTypeFilter()};
    protected LinkedHashSet<DeviceTemplate.PortFilter> mFilters = new LinkedHashSet();

    public PortFilters() {
        AUtil.addAll(this.mFilters, (Object[])DEFAULT_FILTERS);
    }

    public IterableIterator<DeviceTemplate.PortFilter> getFilters() {
        return new AIterableItr(this.mFilters);
    }

    public void addFilter(DeviceTemplate.PortFilter filter) {
        this.mFilters.add(filter);
    }

    public void removeFilter(DeviceTemplate.PortFilter filter) {
        this.mFilters.remove(filter);
    }

    public static class MappedUpExternalTypeFilter
    extends MappedUpFilter {
        public MappedUpExternalTypeFilter() {
            this.NAME = "External (type and mapped)";
            this.DESCRIPTION = "Pins of type BALLPAD, BONDFINGERPAD, BUMPPAD, IOPAD, and WIREBONDPAD from the Device and on descendant Nets that map to Device";
        }

        @Override
        public boolean include(DeviceTemplate refTemplate, DeviceTemplate.DescendantPin descendantPort) {
            if (!super.include(refTemplate, descendantPort)) {
                return false;
            }
            switch (((PinTemplate)descendantPort.getDbObject()).getType()) {
                case BALLPAD: 
                case BONDFINGERPAD: 
                case BUMPPAD: 
                case IOPAD: 
                case WIREBONDPAD: {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ExternalTypeFilter
    implements DeviceTemplate.PortFilter {
        protected String NAME = "External (type)";
        protected String DESCRIPTION = "Pins of type BALLPAD, BONDFINGERPAD, BUMPPAD, IOPAD, or WIREBONDPAD";

        public String getName() {
            return this.NAME;
        }

        public String getDescription() {
            return this.DESCRIPTION;
        }

        public boolean include(DeviceTemplate refTemplate, DeviceTemplate.DescendantPin descendantPort) {
            switch (((PinTemplate)descendantPort.getDbObject()).getType()) {
                case BALLPAD: 
                case BONDFINGERPAD: 
                case BUMPPAD: 
                case IOPAD: 
                case WIREBONDPAD: {
                    return true;
                }
            }
            return false;
        }
    }

    public static class MappedUpFilter
    implements DeviceTemplate.PortFilter {
        protected String NAME = "External (mapped)";
        protected String DESCRIPTION = "Pins on the Device and on descendant Nets that map to the reference Device";

        public String getName() {
            return this.NAME;
        }

        public String getDescription() {
            return this.DESCRIPTION;
        }

        public boolean include(DeviceTemplate refTemplate, DeviceTemplate.DescendantPin descendantPort) {
            Net desNet = ((PinTemplate)descendantPort.getDbObject()).getNet();
            if (desNet.isUnused()) {
                return false;
            }
            Net topNet = NetMap.getNetAt((Net)desNet, (DevicePath)descendantPort.getPath(), (DeviceTemplate)refTemplate);
            return topNet != null && topNet.getDeviceTemplate() == refTemplate;
        }
    }

    public static class AllFilter
    implements DeviceTemplate.PortFilter {
        protected String NAME = "All";
        protected String DESCRIPTION = "All pins";

        public String getName() {
            return this.NAME;
        }

        public String getDescription() {
            return this.DESCRIPTION;
        }

        public boolean include(DeviceTemplate refTemplate, DeviceTemplate.DescendantPin descendantPort) {
            return true;
        }
    }
}

