/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.A2DSpanMgr;
import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ADisplayList;
import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AScreenTransform;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HDLView;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPinT;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.ObjectLocator;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SchemView
extends JPanel {
    protected DevicePath topPath;
    protected Overlay canvas = null;
    protected boolean drawing = false;
    protected boolean shapesValid = false;
    protected boolean justPeepHole = false;
    protected MyObjectLocatorListener myObjectLocatorListener;
    protected MyMouseMotionListener myMouseMotionListener;
    protected JLabel status;
    protected JButton zoomFit;
    protected static String myId = "schemView";
    protected static boolean zooming = false;
    protected HashMap<DevicePath, ARect> pathToRect = new HashMap();
    protected HashMap<HierPinT, ARect> hierPinTemplateToRect = new HashMap();
    protected HashMap<Net, Integer> netToSlot = new HashMap();
    protected HashMap<HierPinT, SchemPinInfo> hierPinToInfo = new HashMap();
    Context ctx = new Context();
    protected ActionListener zoomFitAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SchemView.this.shapesValid = false;
            SchemView.this.ctx.zoom = null;
            SchemView.this.updateUI();
        }
    };

    public void setPath(DevicePath path) {
        this.topPath = path;
        this.ctx.canvas = this;
    }

    public void start() {
        this.canvas = new Overlay();
        GridBagManager l = new GridBagManager((Container)this);
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLALL);
        l.pushFillX();
        l.addFillX();
        this.status = new JLabel("");
        l.add((Component)this.status, (GridBagConstraints)GridBagManager.LEFT);
        this.zoomFit = new JButton(OrbitIcons.ZOOM_FIT);
        l.add((Component)this.zoomFit, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.zoomFit.addActionListener(this.zoomFitAction);
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLALL);
        l.add((Component)this.canvas, (GridBagConstraints)GridBagManager.FILLALL);
        l.pop();
        this.canvas.setPreferredSize(new Dimension(500, 500));
        this.myObjectLocatorListener = new MyObjectLocatorListener();
        ObjectLocator.addListener(new MyObjectLocatorListener());
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.canvas.addMouseMotionListener(this.myMouseMotionListener);
        this.canvas.addMouseListener(new MyMouseButtonListener());
        this.canvas.addMouseWheelListener(new MyMouseWheelListener());
        UIUtil.center((Component)this);
        this.setVisible(true);
        this.updateUI();
    }

    public void shutDown() {
        ObjectLocator.remove(this.myObjectLocatorListener);
    }

    protected Object getObjectAt(APoint2D p) {
        ARect r;
        boolean inSomething = false;
        for (HierPinT hp : this.hierPinTemplateToRect.keySet()) {
            r = this.hierPinTemplateToRect.get(hp);
            if (!r.contains(p)) continue;
            Net topNet = NetMap.getTopmostNet((Net)((PinTemplate)hp.getDbObject()).getNet(), (DevicePath)hp.getPath());
            this.status.setText("Pin " + ((PinTemplate)hp.getDbObject()).getName() + " Top Net is " + topNet.getName());
            inSomething = true;
            return hp;
        }
        if (!inSomething) {
            for (DevicePath dp : this.pathToRect.keySet()) {
                r = this.pathToRect.get(dp);
                if (!r.contains(p)) continue;
                String message = "<html> Device " + dp.getParent().toString() + "<bold>" + dp.getLast().getName() + "</bold><hmtl>";
                this.status.setText(message);
                inSomething = true;
                return dp;
            }
        }
        this.status.setText("");
        return null;
    }

    public class Overlay
    extends JComponent {
        @Override
        protected void paintComponent(Graphics graphics) {
            if (SchemView.this.drawing) {
                return;
            }
            SchemView.this.drawing = true;
            Graphics2D g = (Graphics2D)graphics;
            Rectangle screen = g.getClipBounds();
            SchemView.this.ctx.g = g;
            Rectangle clip = g.getClipBounds();
            SchemView.this.ctx.xform.setScreen(clip);
            if (!SchemView.this.shapesValid) {
                this.deriveDataToShapes(SchemView.this.topPath);
                SchemView.this.ctx.xform.setWorld(SchemView.this.ctx.universe);
                this.drawSchematic(g, SchemView.this.topPath, SchemView.this.ctx);
                SchemView.this.shapesValid = true;
            }
            if (SchemView.this.justPeepHole) {
                Point p = this.getMousePosition();
                if (p != null) {
                    // empty if block
                }
                SchemView.this.justPeepHole = false;
            } else {
                ALog.logInfo((String)"normal");
                if (SchemView.this.ctx.zoom == null) {
                    SchemView.this.ctx.xform.setWorld(SchemView.this.ctx.universe);
                } else {
                    SchemView.this.ctx.xform.setWorld(SchemView.this.ctx.zoom);
                }
                g.setColor(Color.gray);
                g.fill(screen);
                SchemView.this.ctx.dl.draw(SchemView.this.ctx.g, SchemView.this.ctx.xform);
            }
            SchemView.this.drawing = false;
        }

        protected void deriveDataToShapes(DevicePath topPath) {
            SchemView.this.ctx.topPath = topPath;
            this.deriveNetStats();
            DevicePath bigPath = null;
            int maxPins = 0;
            for (DevicePath child : topPath.getChildren()) {
                Device c = child.getLast();
                DeviceTemplate t = c.getTemplate();
                int numPins = 0;
                for (PinTemplate pt : t.getPins()) {
                    if (pt.getNet().isUnused()) continue;
                    ++numPins;
                }
                if (numPins > maxPins) {
                    maxPins = numPins;
                    bigPath = child;
                }
                SchemView.this.ctx.childToNumPins.put(child, numPins);
            }
            long bigSymboldHeight = this.getDeviceDimensions(bigPath, SchemView.this.ctx).height();
            long worldHeight = bigSymboldHeight + (long)(SchemView.this.ctx.numNets + 1) * SchemView.this.ctx.wireSpacing + SchemView.this.ctx.worldTextSize;
            long worldWidth = 0L;
            LinkedList<DevicePath> sortedList = new LinkedList<DevicePath>();
            for (DevicePath child : SchemView.this.ctx.topPath.getChildren()) {
                worldWidth += 2L * ((long)(this.pinsOnSide(child) + 1) * SchemView.this.ctx.wireSpacing);
                worldWidth += this.getDeviceDimensions(child, SchemView.this.ctx).width();
                sortedList.add(child);
            }
            SchemView.this.ctx.maxTopOfDevice = bigSymboldHeight + SchemView.this.ctx.worldTextSize;
            SchemView.this.ctx.universe = new ARect(0L, 0L, worldWidth, worldHeight);
            Collections.sort(sortedList, new SchematicSorter(SchemView.this.ctx));
            SchemView.this.ctx.sortedChildren = sortedList;
        }

        protected void drawSchematic(Graphics2D g, DevicePath topPath, Context ctx) {
            APoint2D loc = new APoint2D(0L, 0L);
            ctx.netToPts.clear();
            for (DevicePath child : ctx.sortedChildren) {
                long thisDeviceSpacing = (long)(this.pinsOnSide(child) + 1) * ctx.wireSpacing;
                loc.moveBy(thisDeviceSpacing, 0L);
                this.drawDevice(child, loc, ctx);
                loc.moveBy(this.getDeviceDimensions(child, ctx).width() + thisDeviceSpacing, 0L);
            }
            this.drawWires();
            ctx.dl.doneAdding();
        }

        protected void drawDevice(DevicePath d, APoint2D loc, Context ctx) {
            ctx.g.setColor(Color.GREEN);
            ARect r = this.getDeviceDimensions(d, ctx);
            r.moveLLTo(new APoint2D(loc.getX(), ctx.xform.getWorld().bottom() + ctx.worldTextSize));
            SchemView.this.pathToRect.put(d, r);
            ctx.dl.add((Object)d, (AGeom)r, Color.red, "devices", false);
            ctx.dl.add(null, d.getLast().getName(), r, "deviceText", Color.green);
            this.drawPins(d, r, ctx);
        }

        protected int pinsOnSide(DevicePath path) {
            LinkedList<PinTemplate> pins = new LinkedList<PinTemplate>();
            for (PinTemplate pt : path.getLast().getTemplate().getPins()) {
                pins.add(pt);
            }
            int num = pins.size();
            int onSide = num / 2;
            if (onSide * 2 != num) {
                ++onSide;
            }
            return onSide;
        }

        protected void drawPins(DevicePath path, ARect bounds, Context ctx) {
            LinkedList<PinTemplate> pins = new LinkedList<PinTemplate>();
            for (PinTemplate pt : path.getLast().getTemplate().getPins()) {
                pins.add(pt);
            }
            Collections.sort(pins, new HDLView.PinSorter());
            int num = pins.size();
            int onLeft = num / 2;
            int idx = 0;
            long x = bounds.left();
            long y = bounds.top() - ctx.worldTextSize;
            boolean left = true;
            int sideNum = 0;
            for (PinTemplate pt : pins) {
                this.drawPin(path, pt, ctx, bounds, x, y, left, sideNum);
                ++sideNum;
                y -= ctx.worldTextSize * 2L;
                if (!left || ++idx < onLeft) continue;
                left = false;
                x = bounds.right();
                y = bounds.top() - ctx.worldTextSize;
                sideNum = 0;
            }
        }

        protected void drawBusses() {
            int netIdx = 0;
            for (Net n : SchemView.this.ctx.netToPts.keySet()) {
                Point screenPt;
                boolean first = true;
                GeneralPath screenPath = new GeneralPath();
                APoint2D lastP = null;
                for (APoint2D p : (LinkedList)SchemView.this.ctx.netToPts.get((Object)n)) {
                    screenPt = SchemView.this.ctx.xform.getScreenPt(p);
                    if (first) {
                        screenPath.moveTo(screenPt.x, screenPt.y);
                    } else {
                        screenPath.lineTo(screenPt.x, screenPt.y);
                    }
                    first = false;
                    lastP = p;
                }
                if (SchemView.this.ctx.internalNet.contains(n) && lastP != null) {
                    ARect r;
                    String pinName = "Internal";
                    PinTemplate pt = SchemView.this.ctx.internalNetToExternalPin.get(n);
                    if (pt != null) {
                        pinName = pt.getName();
                    }
                    if (netIdx >= SchemView.this.ctx.numNets / 2) {
                        lastP.setX(SchemView.this.ctx.xform.getWorld().right());
                        r = new ARect(lastP.getX() - 20L * SchemView.this.ctx.worldTextSize, lastP.getY(), lastP.getX(), lastP.getY() + SchemView.this.ctx.worldTextSize);
                        SchemView.this.ctx.dl.add(null, pinName, r, "pinName", Color.green);
                        if (pt != null) {
                            this.drawPinDirection(SchemView.this.ctx.topPath, pt, SchemView.this.ctx, lastP.getX(), lastP.getY(), false);
                        }
                    } else {
                        lastP.setX(SchemView.this.ctx.xform.getWorld().left());
                        lastP.setX(SchemView.this.ctx.xform.getWorld().right());
                        r = new ARect(lastP.getX(), lastP.getY(), lastP.getX() + 20L * SchemView.this.ctx.worldTextSize, lastP.getY() + SchemView.this.ctx.worldTextSize);
                        SchemView.this.ctx.dl.add(null, pinName, r, "pinName", Color.green);
                        if (pt != null) {
                            this.drawPinDirection(SchemView.this.ctx.topPath, pt, SchemView.this.ctx, lastP.getX(), lastP.getY(), true);
                        }
                    }
                    screenPt = SchemView.this.ctx.xform.getScreenPt(lastP);
                    screenPath.lineTo(screenPt.x, screenPt.y);
                }
                if (SchemView.this.ctx.internalNet.contains(n)) {
                    SchemView.this.ctx.g.setColor(Color.RED);
                } else {
                    SchemView.this.ctx.g.setColor(Color.black);
                }
                SchemView.this.ctx.g.draw(screenPath);
                ++netIdx;
            }
        }

        protected void drawPin(DevicePath path, PinTemplate pt, Context ctx, ARect bounds, long x, long y, boolean left, int sideNum) {
            String text = pt.getName();
            if (text == null || text.length() == 0) {
                return;
            }
            ARect r = new ARect(bounds);
            r.bottom(y - ctx.worldTextSize / 2L);
            r.top(r.bottom() + ctx.worldTextSize);
            if (left) {
                r.right(r.left() + r.width() / 2L);
            } else {
                r.left(r.right() - r.width() / 2L);
            }
            ARect pinBounds = this.drawPinDirection(path, pt, ctx, x, y, left);
            ctx.dl.add(null, pt.getName(), r, "pinName", Color.blue);
            HierPinT hpt = new HierPinT(path, pt);
            SchemPinInfo spi = new SchemPinInfo();
            spi.setLeft(left);
            spi.setRect(pinBounds);
            spi.setSideIndex(sideNum);
            SchemView.this.hierPinToInfo.put(hpt, spi);
        }

        protected void drawWires() {
            A2DSpanMgr sm = new A2DSpanMgr();
            sm.setBound(SchemView.this.ctx.universe);
            for (DevicePath child : SchemView.this.ctx.topPath.getChildren()) {
                ARect r = SchemView.this.pathToRect.get(child);
                sm.addSpan(r.left(), r.right(), r.top(), true, (Object)child.getLast());
            }
            for (Net n : SchemView.this.ctx.activeNet) {
                APath path = new APath();
                LinkedList<SchemPinInfo> pins = new LinkedList<SchemPinInfo>();
                for (HierPinT hp : SchemView.this.ctx.netToHierPortTemplate.getCollection((Object)n)) {
                    SchemPinInfo spi = SchemView.this.hierPinToInfo.get(hp);
                    pins.add(spi);
                }
                Collections.sort(pins, new WireFlowSorter());
                int size = pins.size();
                if (size < 2) continue;
                for (int i = 0; i < size - 1; ++i) {
                    ARect from = ((SchemPinInfo)pins.get(i)).getRect();
                    ARect to = ((SchemPinInfo)pins.get(i + 1)).getRect();
                    long x0 = from.centerX();
                    long dx1 = (long)(((SchemPinInfo)pins.get(i)).getSideIndex() + 1) * SchemView.this.ctx.wireSpacing;
                    long x1 = ((SchemPinInfo)pins.get(i)).isLeft() ? x0 - dx1 : x0 + dx1;
                    long x3 = to.centerX();
                    long dx2 = (long)(((SchemPinInfo)pins.get(i + 1)).getSideIndex() + 1) * SchemView.this.ctx.wireSpacing;
                    long x2 = ((SchemPinInfo)pins.get(i + 1)).isLeft() ? x3 - dx2 : x3 + dx2;
                    long y0 = from.centerY();
                    int slot = SchemView.this.netToSlot.get(n);
                    long y1 = SchemView.this.ctx.maxTopOfDevice + (long)slot * SchemView.this.ctx.wireSpacing;
                    long y2 = to.centerY();
                    if (sm.hardInSpan(from.centerX(), to.centerX())) {
                        path.addPoint(new APoint2D(x0, y0));
                        path.addPoint(new APoint2D(x1, y0));
                        path.addPoint(new APoint2D(x1, y1));
                        path.addPoint(new APoint2D(x2, y1));
                        path.addPoint(new APoint2D(x2, y2));
                        path.addPoint(new APoint2D(x3, y2));
                        continue;
                    }
                    path.addPoint(new APoint2D(x0, y0));
                    path.addPoint(new APoint2D(x1, y0));
                    path.addPoint(new APoint2D(x1, y2));
                    path.addPoint(new APoint2D(x3, y2));
                }
                Color color = Color.black;
                PinTemplate externalPinTemplate = SchemView.this.ctx.internalNetToExternalPin.get(n);
                if (externalPinTemplate != null) {
                    color = Color.red;
                }
                path.setWidth(SchemView.this.ctx.wireSpacing / 2L);
                SchemView.this.ctx.dl.add((Object)n, (AGeom)path, color, "wire", true);
            }
        }

        protected void drawPinToBus(DevicePath path, PinTemplate pt, Context ctx, ARect bounds, long x, long y, boolean left, int sideNum) {
            Net templateNet = NetMap.getParentNet((Device)path.getLast(), (Net)pt.getNet());
            if (templateNet != null) {
                LinkedList ports;
                int numOtherPins = 0;
                if (ctx.internalNet.contains(templateNet)) {
                    ++numOtherPins;
                }
                if ((ports = (LinkedList)ctx.netToHierPortTemplate.get((Object)templateNet)) != null && ports.size() > 1) {
                    ++numOtherPins;
                }
                if (numOtherPins >= 1) {
                    Integer slot = SchemView.this.netToSlot.get(templateNet);
                    APath bussPath = new APath(ctx.wireSpacing / 2L, new APoint2D[]{new APoint2D(x, y)});
                    APoint2D worldP = new APoint2D(x, y);
                    long dx = (long)(sideNum + 1) * ctx.wireSpacing;
                    if (left) {
                        worldP.moveBy(-dx, 0L);
                    } else {
                        worldP.moveBy(dx, 0L);
                    }
                    bussPath.addPoint(new APoint2D(worldP));
                    long netY = ctx.maxTopOfDevice + (long)slot.intValue() * ctx.wireSpacing;
                    worldP.setY(netY);
                    bussPath.addPoint(new APoint2D(worldP));
                    Color color = Color.black;
                    if (ctx.internalNet.contains(templateNet)) {
                        color = Color.red;
                    }
                    ctx.dl.add((Object)templateNet, (AGeom)bussPath, color, "wire", true);
                    ctx.netToPts.add((Object)templateNet, (Object)worldP);
                }
            }
        }

        protected ARect drawPinDirection(DevicePath path, PinTemplate pt, Context ctx, long x, long y, boolean left) {
            ARect bounds;
            PinTemplate.Direction d = pt.getDirection();
            HierPinT hp = new HierPinT(path, pt);
            if (d.equals((Object)PinTemplate.Direction.IN)) {
                APolygon p = new APolygon();
                p.addPoint(x, y);
                long xoff = left ? x - ctx.wireSpacing : x + ctx.wireSpacing;
                p.addPoint(xoff, y - ctx.wireSpacing);
                p.addPoint(xoff, y + ctx.wireSpacing);
                bounds = p.getBounds();
                ctx.dl.add((Object)hp, (AGeom)p, Color.green, "pin", true);
            } else if (d.equals((Object)PinTemplate.Direction.OUT)) {
                APolygon p = new APolygon();
                long xoff = left ? x - ctx.wireSpacing : x + ctx.wireSpacing;
                p.addPoint(xoff, y);
                p.addPoint(x, y - ctx.wireSpacing);
                p.addPoint(x, y + ctx.wireSpacing);
                bounds = p.getBounds();
                ctx.dl.add((Object)hp, (AGeom)p, Color.orange, "pin", true);
            } else {
                long r = ctx.wireSpacing;
                APoint2D c = new APoint2D(x, y);
                if (left) {
                    c.moveBy(-r / 2L, 0L);
                } else {
                    c.moveBy(r / 2L, 0L);
                }
                ACircle wc = new ACircle(c, r / 2L);
                bounds = wc.getBounds();
                ctx.dl.add((Object)hp, (AGeom)wc, Color.BLUE, "pin", true);
            }
            SchemView.this.hierPinTemplateToRect.put(hp, bounds);
            return bounds;
        }

        protected ARect getDeviceDimensions(DevicePath path, Context ctx) {
            Integer pins = ctx.childToNumPins.get(path);
            if (pins == null) {
                pins = 4;
            }
            if (pins % 2 == 1) {
                Integer n = pins;
                Integer n2 = pins = Integer.valueOf(pins + 1);
            }
            Integer pinsOnSide = pins / 2;
            long h = ctx.worldTextSize * (long)(pinsOnSide * 2);
            long w = h / 2L;
            return new ARect(0L, 0L, w, h);
        }

        protected void deriveNetStats() {
            for (DevicePath child : SchemView.this.ctx.topPath.getChildren()) {
                for (PinTemplate pt : child.getLast().getTemplate().getPins()) {
                    Net templateNet;
                    if (pt.getName().contains("PAD")) {
                        ALog.logInfo((String)"");
                    }
                    if ((templateNet = NetMap.getParentNet((Device)child.getLast(), (Net)pt.getNet())) == null) continue;
                    SchemView.this.ctx.internalNet.add(templateNet);
                    SchemView.this.ctx.netToHierPortTemplate.add((Object)templateNet, (Object)new HierPinT(child, pt));
                    Net parentNet = NetMap.getParentNet((Device)SchemView.this.ctx.topPath.getLast(), (Net)templateNet);
                    if (parentNet == null || parentNet.isUnused()) continue;
                    SchemView.this.ctx.internalNetToExternalPin.put(templateNet, null);
                    for (PinTemplate topPt : SchemView.this.ctx.topPath.getLast().getTemplate().getPins()) {
                        if (!topPt.getNet().equals(templateNet)) continue;
                        SchemView.this.ctx.internalNetToExternalPin.put(templateNet, topPt);
                    }
                }
            }
            Integer idx = 1;
            for (Net templateNet : SchemView.this.ctx.topPath.getLast().getNets()) {
                LinkedList pinsOnNet = (LinkedList)SchemView.this.ctx.netToHierPortTemplate.get((Object)templateNet);
                if (pinsOnNet == null || !SchemView.this.ctx.internalNet.contains(templateNet) && pinsOnNet.size() < 1) continue;
                SchemView.this.ctx.activeNet.add(templateNet);
                SchemView.this.netToSlot.put(templateNet, idx);
                if (pinsOnNet.size() < 2) continue;
                Integer n = idx;
                Integer n2 = idx = Integer.valueOf(idx + 1);
            }
            SchemView.this.ctx.numNets = idx;
        }

        public class SchematicSorter
        implements Comparator<DevicePath> {
            Context ctx;

            public SchematicSorter(Context ctx) {
                this.ctx = ctx;
            }

            @Override
            public int compare(DevicePath dp0, DevicePath dp1) {
                int pins = this.ctx.childToNumPins.get(dp1) - this.ctx.childToNumPins.get(dp0);
                if (pins != 0) {
                    return pins;
                }
                AAlphaNumComp c = AAlphaNumComp.get();
                return c.compare((Object)dp0.toString(), (Object)dp1.toString());
            }
        }

        public class WireFlowSorter
        implements Comparator<SchemPinInfo> {
            @Override
            public int compare(SchemPinInfo r0, SchemPinInfo r1) {
                if (r0.getRect().left() < r1.getRect().left()) {
                    return -1;
                }
                if (r0.getRect().right() > r1.getRect().right()) {
                    return 1;
                }
                return 0;
            }
        }
    }

    class MyMouseMotionListener
    implements MouseMotionListener {
        MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            APoint2D wp = SchemView.this.ctx.xform.getWorldPt(new Point(e.getX(), e.getY()));
            SchemView.this.getObjectAt(wp);
            if (e.isShiftDown()) {
                SchemView.this.ctx.dl.drawPeepHole(SchemView.this.ctx.canvas, SchemView.this.ctx.g, new AScreenTransform(SchemView.this.ctx.xform), wp);
            }
        }
    }

    class MyMouseButtonListener
    implements MouseListener {
        MyMouseButtonListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            APoint2D wp = SchemView.this.ctx.xform.getWorldPt(new Point(e.getX(), e.getY()));
            Object o = SchemView.this.getObjectAt(wp);
            if (o instanceof DevicePath) {
                DevicePath dp = (DevicePath)o;
                ObjectLocator.locateDevicePath(dp, myId);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    class MyMouseWheelListener
    implements MouseWheelListener {
        MyMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            zooming = true;
            int clicks = e.getWheelRotation();
            if (clicks == 0) {
                return;
            }
            double factor = 1.0 + (double)(((Float)Settings.get((String)"UserPreferences", (String)"MouseWheelZoomSpeed", (Object)Float.valueOf(0.3f))).floatValue() / 10.0f);
            factor *= (double)clicks;
            ARect r = new ARect(SchemView.this.ctx.xform.getWorld());
            Point sp = new Point(e.getX(), e.getY());
            APoint2D wp = SchemView.this.ctx.xform.getWorldPt(sp);
            if (clicks < 0) {
                SchemView.this.ctx.xform.scale(0.9, wp);
            } else {
                r = SchemView.this.ctx.universe;
            }
            SchemView.this.ctx.zoom = r;
            SchemView.this.updateUI();
            zooming = false;
        }
    }

    class MyObjectLocatorListener
    implements ObjectLocator.ObjectLocatorListener {
        MyObjectLocatorListener() {
        }

        @Override
        public boolean locateDevicePath(DevicePath path, String callerId) {
            if (callerId.equals(myId)) {
                return false;
            }
            ARect r = SchemView.this.pathToRect.get(path);
            if (r != null) {
                r = new ARect(r);
                r.expand(1.5);
                SchemView.this.ctx.zoom = r;
            } else {
                SchemView.this.ctx.zoom = null;
            }
            SchemView.this.updateUI();
            return false;
        }

        @Override
        public boolean locateHierPort(HierPort hierPort, String callerId) {
            if (callerId.equals(myId)) {
                return false;
            }
            return false;
        }

        @Override
        public boolean locateHierNet(HierInst<Net> hierNet) {
            return false;
        }
    }

    class Context {
        Graphics2D g;
        DevicePath topPath;
        ARect universe = null;
        ARect zoom = null;
        ADisplayList dl = new ADisplayList();
        JComponent canvas;
        HashMap<DevicePath, Integer> childToNumPins = new HashMap();
        long worldTextSize = 100L;
        long interDeviceHSpace = this.worldTextSize * 16L;
        AScreenTransform xform = new AScreenTransform();
        AHashCollection<Net, APoint2D> netToPts = new AHashCollection();
        AHashCollection<Net, HierPinT> netToHierPortTemplate = new AHashCollection();
        AHashCollection<Net, APath> newToPaths = new AHashCollection();
        HashMap<Net, Integer> netToInternalPins = new HashMap();
        HashMap<Net, PinTemplate> internalNetToExternalPin = new HashMap();
        HashSet<Net> internalNet = new HashSet();
        LinkedList<Net> activeNet = new LinkedList();
        LinkedList<DevicePath> sortedChildren = new LinkedList();
        int numNets;
        long wireSpacing = 100L;
        long maxTopOfDevice = 0L;

        Context() {
        }

        public void resest() {
            SchemView.this.pathToRect.clear();
            SchemView.this.hierPinTemplateToRect.clear();
            this.netToPts.clear();
            this.netToHierPortTemplate.clear();
            this.netToInternalPins.clear();
            this.internalNet.clear();
            this.internalNetToExternalPin.clear();
        }
    }

    static class SchemPinInfo {
        boolean left;
        ARect rect;
        int sideIndex;

        SchemPinInfo() {
        }

        public int getSideIndex() {
            return this.sideIndex;
        }

        public void setSideIndex(int sideIndex) {
            this.sideIndex = sideIndex;
        }

        public boolean isLeft() {
            return this.left;
        }

        public void setLeft(boolean left) {
            this.left = left;
        }

        public ARect getRect() {
            return this.rect;
        }

        public void setRect(ARect rect) {
            this.rect = rect;
        }
    }
}

