/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinLabel;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.AVector;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;

public class ShowMeTheWay
extends MouseAdapter {
    protected DesignView2D mView;
    protected Db mDb;
    protected Design mDesign;
    protected Overlay mOverlay = null;
    protected Point mCursorLoc;
    protected Point mLastPoint = new Point();
    boolean mInvalidGraphicsErrorLogged = false;
    protected Renderer mRenderer = null;
    protected ArrayList<ShowMe> showMeList = new ArrayList();
    protected ArrayList<ShowMePair> showMePairList = new ArrayList();
    protected ArrayList<ShowMeArea> showMeAreaList = new ArrayList();

    public ShowMeTheWay(DesignView2D view) {
        this.mView = view;
        this.mDb = view.getDb();
        this.mDesign = Design.getDesign((Db)this.mDb, (boolean)false);
    }

    public Color getDefaultColor() {
        return this.mView.getColorizer().getColor(null, (ViewColorizer.Key)ViewColorizer.KShowMe).getColor();
    }

    public static void addSelectedPins() {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        s.getSelectedHierInsts(PinInstance.class).forEach(pinInst -> ShowMeTheWay.addHierPin(new HierPin((DevicePath)pinInst.first, (PinInstance)pinInst.second)));
    }

    public static void addHierPin(HierPin dpp) {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMe(dpp.getWorldLoc(), dpp.getPin().getName());
    }

    public static void addHierPort(DevicePath path, PortTemplate port) {
        String name = String.format("%s (%d)", port.getPinTemplate().getName(), port.getPortNum());
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMe(port.getWorldLoc(path), name);
    }

    public static void addHierNetPairs(Net n1, DevicePath path1, Net n2, DevicePath path2) {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        List dpps1 = NetMap.getConnectedDevicePathPorts((Net)n1, (DevicePath)path1);
        List dpps2 = NetMap.getConnectedDevicePathPorts((Net)n2, (DevicePath)path2);
        if (!dpps1.isEmpty() && !dpps2.isEmpty()) {
            HierPin dpp1 = (HierPin)dpps1.get(0);
            HierPin dpp2 = (HierPin)dpps2.get(0);
            smtw.addShowMePair(dpp1.getWorldLoc(), dpp2.getWorldLoc());
        }
    }

    public static void addHierTerm(DevicePath devPath, Term term) {
        IterableIterator pinLabelItr = PinLabel.get((Term)term);
        if (pinLabelItr.hasNext()) {
            pinLabelItr.forEach(ShowMeTheWay::addPinLabel);
        } else {
            ShowMeTheWay.addNet(term.getNet(), devPath);
        }
    }

    public static void addPinLabel(PinLabel pinLabel) {
        DevicePath relPath = pinLabel.getPinPath();
        PinTemplate pin = pinLabel.getPin();
        relPath.getAllFullPaths().forEach(fullPath -> pin.getPortTemplates().forEach(port -> ShowMeTheWay.addHierPort(fullPath, port)));
    }

    public static void addPinLabel(DevicePath devPath, PinLabel pinLabel) {
        DevicePath pinPath = pinLabel.getPinPath();
        if (devPath.getDeviceTemplate() != pinPath.getRoot()) {
            assert (false);
            return;
        }
        DevicePath relPath = new DevicePath(devPath, pinPath);
        PinTemplate pin = pinLabel.getPin();
        relPath.getAllFullPaths().forEach(fullPath -> pin.getPortTemplates().forEach(port -> ShowMeTheWay.addHierPort(fullPath, port)));
    }

    public static void addWireVertex(Wire w, APoint2D p) {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMe(p, w.getNet().getName());
    }

    public static void addWire(DevicePath path, Wire w) {
        APath p = w.getPath().transform(path.getTransform());
        APoint2D pt = p.getPoint(p.getPointCount() / 2);
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMe(pt, w.getNet().getName());
    }

    public static void addNet(Net n, DevicePath path) {
        List dpps = NetMap.getConnectedDevicePathPorts((Net)n, (DevicePath)path);
        for (HierPin dpp : dpps) {
            ShowMeTheWay.addHierPin(dpp);
        }
    }

    public static void addDevicePath(DevicePath dp) {
        if (dp == null) {
            return;
        }
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMe(dp.getOrigin(), dp.getLast().getName());
    }

    public static void addDevicePath(DevicePath dp, String text) {
        if (dp == null) {
            return;
        }
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMe(dp.getOrigin(), text);
    }

    public static boolean showMePopulated() {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        return !smtw.showMeList.isEmpty() || !smtw.showMePairList.isEmpty();
    }

    public static void clear() {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.clearShowMe();
    }

    public static void showMeArea(APoint2D p1, List<ARect> rs, String label, LineStyle ls, Color c) {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMeArea(p1, rs);
    }

    public static void showMeTwoPts(APoint2D p1, APoint2D p2, String label, LineStyle ls, Color c) {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMe(p1, label, ls, c);
        smtw.addShowMe(p2, label, ls, c);
    }

    public static void showMeAPt(APoint2D p1, String label, LineStyle ls, Color c) {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay smtw = view.getShowMeTheWay();
        smtw.addShowMe(p1, label, ls, c);
    }

    public void addShowMe(APoint2D p, String label) {
        this.addShowMe(p, label, LineStyle.Straight, null);
    }

    public void addShowMeArea(APoint2D p1, List<ARect> rs) {
        this.addShowMe(p1, "");
        this.showMeAreaList.add(new ShowMeArea(rs));
        if (this.mOverlay == null) {
            this.mOverlay = new Overlay();
            this.mView.addOverlay(this.mOverlay);
            this.mView.getCanvas().addMouseMotionListener(this);
        } else {
            this.rerender();
        }
    }

    public void addShowMePair(APoint2D p1, APoint2D p2) {
        ShowMe sm1 = new ShowMe();
        sm1.p = p1;
        sm1.label = "";
        sm1.lStyle = LineStyle.Straight;
        ShowMe sm2 = new ShowMe();
        sm2.p = p2;
        sm2.label = "";
        sm2.lStyle = LineStyle.Straight;
        this.showMePairList.add(new ShowMePair(sm1, sm2));
        if (this.mOverlay == null) {
            this.mOverlay = new Overlay();
            this.mView.addOverlay(this.mOverlay);
            this.mView.getCanvas().addMouseMotionListener(this);
        } else {
            this.rerender();
        }
    }

    public void addShowMe(APoint2D p, String label, LineStyle ls, Color c) {
        ShowMe sm = new ShowMe();
        sm.p = p;
        sm.label = label;
        sm.lStyle = ls;
        if (c != null) {
            sm.c = c;
        }
        this.showMeList.add(sm);
        if (this.mOverlay == null) {
            this.mOverlay = new Overlay();
            this.mView.addOverlay(this.mOverlay);
            this.mView.getCanvas().addMouseMotionListener(this);
        } else {
            this.rerender();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mCursorLoc = e.getPoint();
        if (!this.mLastPoint.equals(this.mCursorLoc)) {
            this.rerender();
        }
        this.mLastPoint.x = this.mCursorLoc.x;
        this.mLastPoint.y = this.mCursorLoc.y;
    }

    protected void rerender() {
        this.disposeRenderer();
        if (this.mOverlay != null) {
            this.mOverlay.repaint();
        }
    }

    public void clearShowMe() {
        this.showMeList.clear();
        this.showMePairList.clear();
        this.showMeAreaList.clear();
        if (this.mOverlay != null) {
            this.mView.getCanvas().removeMouseMotionListener(this);
            this.mView.removeOverlay(this.mOverlay);
            this.disposeRenderer();
            this.mOverlay = null;
            this.mView.getCanvas().repaint();
        }
    }

    protected void disposeRenderer() {
        if (this.mRenderer != null) {
            this.mRenderer.interrupt();
            this.mRenderer = null;
        }
    }

    protected Point getReferencePoint() {
        if (this.mCursorLoc != null) {
            return this.mCursorLoc;
        }
        Point lastKnownCursorloc = this.mView.getCanvas().getLastKnownMouseLoc();
        if (lastKnownCursorloc != null) {
            return lastKnownCursorloc;
        }
        Rectangle viewBounds = this.mView.getCanvas().getBounds();
        return new Point((int)viewBounds.getCenterX(), (int)viewBounds.getCenterY());
    }

    protected void drawSpringLine(int fromX, int fromY, int toX, int toY, Graphics2D g) {
        ALine l = new ALine((long)fromX, (long)fromY, (long)toX, (long)toY);
        int s = 5;
        double angle = l.getAngleInRadians();
        double x = fromX;
        double y = fromY;
        double dx = Math.cos(angle) * (double)s;
        double dy = Math.sin(angle) * (double)s;
        int length = (int)l.getLength();
        int steps = length / s;
        for (int i = 0; i < steps; ++i) {
            g.drawOval((int)x, (int)y, s, s * 2);
            x += dx;
            y += dy;
        }
    }

    public static void drawResistorLine(int fromX, int fromY, int toX, int toY, Graphics2D g) {
        ALine l = new ALine((long)fromX, (long)fromY, (long)toX, (long)toY);
        int length = (int)l.getLength();
        int s = 5;
        int h = 2;
        int steps = length / s;
        AffineTransform oldT = g.getTransform();
        AVector v = new AVector((long)fromX, (long)fromY, (long)toX, (long)toY);
        double angle = -v.angle() + 1.5707963267948966;
        AffineTransform t = new AffineTransform(oldT);
        t.translate(fromX, fromY);
        t.rotate(angle);
        g.setTransform(t);
        double x = 0.0;
        double y = 0.0;
        double dx = s;
        double dy = 0.0;
        for (int i = 0; i < steps; ++i) {
            g.drawLine((int)x, (int)y - h, (int)x, (int)y + h);
            x += dx;
            y += dy;
        }
        g.setTransform(oldT);
    }

    protected class Renderer
    implements Runnable {
        BufferedImage mImg = null;
        DesignCanvas2D.XForm mXForm = null;
        DesignView2D.BgProc mBgProc = null;
        boolean mInterrupt = false;
        protected final Stroke mDashStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
        protected final Font mTextFont = new Font("SansSerif", 0, 12);

        public Renderer() {
            this.mBgProc = ShowMeTheWay.this.mView.runBackgroundProc("Rendering ShowMeTheWay", this);
        }

        public boolean isAlive() {
            return ShowMeTheWay.this.mView.isAlive(this.mBgProc);
        }

        public void interrupt() {
            ShowMeTheWay.this.mView.interrupt(this.mBgProc);
            this.mInterrupt = true;
        }

        public boolean isUpToDate() {
            Dimension canvasSize = ShowMeTheWay.this.mView.getCanvas().getSize();
            return this.mImg != null && AUtil.equals((Object)this.mImg.getWidth(), (Object)canvasSize.width) && AUtil.equals((Object)this.mImg.getHeight(), (Object)canvasSize.height) && AUtil.equals((Object)this.mXForm, (Object)ShowMeTheWay.this.mView.getCanvas().getXForm());
        }

        public void paintOverlay(Optional<Graphics> optGraphics) {
            if (this.mInterrupt) {
                return;
            }
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(() -> this.paintOverlay(optGraphics));
            } else {
                Graphics graphics = optGraphics.orElseGet(ShowMeTheWay.this.mOverlay::getGraphics);
                graphics.drawImage(this.mImg, 0, 0, null);
                if (!optGraphics.isPresent()) {
                    graphics.dispose();
                }
            }
        }

        @Override
        public void run() {
            if (ShowMeTheWay.this.showMeList.isEmpty() && ShowMeTheWay.this.showMePairList.isEmpty() && ShowMeTheWay.this.showMeAreaList.isEmpty()) {
                return;
            }
            Dimension dim = ShowMeTheWay.this.mView.getCanvas().getSize();
            this.mXForm = ShowMeTheWay.this.mView.getCanvas().getXForm().copy();
            this.mImg = ShowMeTheWay.this.mView.getCanvas().getGraphicsConfiguration().createCompatibleImage(dim.width, dim.height, 3);
            Graphics graphics = this.mImg.getGraphics();
            if (!(graphics instanceof Graphics2D)) {
                if (!ShowMeTheWay.this.mInvalidGraphicsErrorLogged) {
                    ALog.logDebug((String)"ShowMeTheWay error: Image Graphics not Graphics2D.");
                    ShowMeTheWay.this.mInvalidGraphicsErrorLogged = true;
                }
                assert (false);
                return;
            }
            Graphics2D g = (Graphics2D)graphics;
            Color defaultColor = ShowMeTheWay.this.getDefaultColor();
            try {
                DesignCanvas2D.prepareGraphics(g);
                g.setFont(this.mTextFont);
                DesignView2D v2 = ShowMeTheWay.this.mView;
                DesignCanvas2D.XForm xform = v2.getCanvas().getXForm();
                boolean showText = ShowMeTheWay.this.showMeList.size() < 100;
                for (ShowMe sm : ShowMeTheWay.this.showMeList) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    Point p = xform.getScreenPt(sm.p);
                    Point c = ShowMeTheWay.this.getReferencePoint();
                    if (c == null) continue;
                    g.setColor(sm.c == null ? defaultColor : sm.c);
                    switch (sm.lStyle) {
                        case Resistor: {
                            ShowMeTheWay.drawResistorLine(p.x, p.y, c.x, c.y, g);
                            break;
                        }
                        case Circles: {
                            ShowMeTheWay.this.drawSpringLine(p.x, p.y, c.x, c.y, g);
                            break;
                        }
                        case Dashed: {
                            Stroke s = g.getStroke();
                            g.setStroke(this.mDashStroke);
                            g.drawLine(p.x, p.y, c.x, c.y);
                            g.setStroke(s);
                            break;
                        }
                        default: {
                            g.drawLine(p.x, p.y, c.x, c.y);
                        }
                    }
                    if (!showText) continue;
                    AffineTransform oldT = g.getTransform();
                    AVector v = new AVector((long)p.x, (long)p.y, (long)c.x, (long)c.y);
                    double angle = -v.angle() + 1.5707963267948966;
                    AffineTransform t = new AffineTransform(oldT);
                    t.translate(p.x, p.y);
                    t.rotate(angle);
                    g.setTransform(t);
                    g.setColor(Color.BLACK);
                    g.drawString(sm.label, 0, 0);
                    g.setTransform(oldT);
                }
                for (ShowMePair smpair : ShowMeTheWay.this.showMePairList) {
                    Point p1 = xform.getScreenPt(((ShowMe)smpair.first).p);
                    Point p2 = xform.getScreenPt(((ShowMe)smpair.second).p);
                    g.setColor(Color.blue);
                    g.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
                for (ShowMeArea smarea : ShowMeTheWay.this.showMeAreaList) {
                    if (ShowMeTheWay.this.mCursorLoc == null) continue;
                    g.setColor(Color.blue);
                    for (ARect ar : smarea.rs) {
                        Rectangle r = xform.getScreenRect(ar);
                        g.fillRect(r.x, r.y, r.width, r.height);
                    }
                }
            }
            catch (ConcurrentModificationException cme) {
                return;
            }
            if (!Thread.currentThread().isInterrupted()) {
                this.paintOverlay(Optional.empty());
            }
        }
    }

    public class Overlay
    extends JComponent {
        public Overlay() {
            this.setOpaque(false);
            this.setBackground(AColor.CLEAR);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (ShowMeTheWay.this.mRenderer == null || !ShowMeTheWay.this.mRenderer.isUpToDate()) {
                if (ShowMeTheWay.this.mRenderer != null) {
                    ShowMeTheWay.this.mRenderer.interrupt();
                }
                ShowMeTheWay.this.mRenderer = new Renderer();
            } else {
                ShowMeTheWay.this.mRenderer.interrupt();
            }
        }
    }

    protected class ShowMe {
        protected APoint2D p;
        protected String label;
        protected DbObject dbo;
        protected LineStyle lStyle = LineStyle.Straight;
        protected Color c;

        protected ShowMe() {
        }
    }

    public static enum LineStyle {
        Straight,
        Dashed,
        Circles,
        Resistor;

    }

    protected static class ShowMeArea {
        LinkedList<ARect> rs = new LinkedList();

        public ShowMeArea(List<ARect> rs) {
            this.rs.addAll(rs);
        }
    }

    protected static class ShowMePair
    extends APair<ShowMe, ShowMe> {
        public ShowMePair(ShowMe first, ShowMe second) {
            super((Object)first, (Object)second);
        }
    }
}

