/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.DevicePath;
import java.util.HashSet;
import java.util.LinkedList;

public class SubstrateTemplate
extends APair<Substrate, DeviceTemplate> {
    public static SubstrateTemplate create(Substrate s, DeviceTemplate t) {
        return new SubstrateTemplate((APair<Substrate, DeviceTemplate>)new APair((Object)s, (Object)t));
    }

    public SubstrateTemplate(APair<Substrate, DeviceTemplate> src) {
        super(src);
    }

    public static LinkedList<SubstrateTemplate> getSubstrateInstances(Db db, boolean unique, boolean onlyReferenced, DeviceTemplate.Type type) {
        Design design = Design.getDesign((Db)db);
        LinkedList<SubstrateTemplate> list = new LinkedList<SubstrateTemplate>();
        HashSet<Substrate> visited = new HashSet<Substrate>();
        for (DevicePath path : design.getDescendantDevices()) {
            if (!path.getLast().getIsSubstrate()) continue;
            Substrate s = path.getSubstrate();
            DeviceTemplate dt = path.getDeviceTemplate();
            if (type != null && dt.getType() != type || unique && visited.contains(s)) continue;
            list.add(SubstrateTemplate.create(s, dt));
            visited.add(s);
        }
        if (!onlyReferenced) {
            for (Substrate s : db.getObjects(Substrate.class)) {
                if (visited.contains(s)) continue;
                list.add(SubstrateTemplate.create(s, null));
            }
        }
        return list;
    }

    public DeviceTemplate.Type getTemplateType() {
        if (this.second != null) {
            return ((DeviceTemplate)this.second).getType();
        }
        return DeviceTemplate.Type.PACKAGE;
    }
}

