/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.google.common.base.Objects;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.ProcessingIterator;
import java.util.HashSet;
import java.util.LinkedHashSet;

public abstract class UnitDef {
    protected static final UnitDef[] PREDEF_UNITS = new UnitDef[]{new Distance("Micron stored in picometers", "micron", 1000000L, 3, 1000000L), new Distance("Micron stored in nanometers", "micron", 1000L, 3, 1000L)};
    protected static final Registry gDefaultRegistry = new Registry();
    protected String desc;
    protected String name;
    protected long internalPer;
    protected int displayDecimalPlaces;
    protected String knownUnitName;
    protected long internalPerKnown;

    public static Registry getRegistry() {
        return gDefaultRegistry;
    }

    public UnitDef(String desc, String name, long internalPer, int displayDecimalPlaces, String knownUnitName, long internalPerKnown) {
        this.desc = desc;
        this.name = name;
        this.internalPer = internalPer;
        this.displayDecimalPlaces = displayDecimalPlaces;
        this.knownUnitName = knownUnitName;
        this.internalPerKnown = internalPerKnown;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public long getInternalPer() {
        return this.internalPer;
    }

    public int getDisplayDecimalPlaces() {
        return this.displayDecimalPlaces;
    }

    public String getKnownUnitName() {
        return this.knownUnitName;
    }

    public long getInternalPerKnown() {
        return this.internalPerKnown;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.getDesc(), this.getName(), this.getInternalPer(), this.getDisplayDecimalPlaces(), this.getKnownUnitName(), this.getInternalPerKnown()});
    }

    public boolean equals(Object other) {
        if (!(other instanceof UnitDef)) {
            return false;
        }
        UnitDef o = (UnitDef)other;
        return Objects.equal((Object)this.desc, (Object)o.desc) && Objects.equal((Object)this.name, (Object)o.name) && this.internalPer == o.internalPer && Objects.equal((Object)this.knownUnitName, (Object)o.knownUnitName) && this.displayDecimalPlaces == o.displayDecimalPlaces && this.internalPerKnown == o.internalPerKnown;
    }

    public String toString() {
        return AUtil.toString((Object)this);
    }

    public boolean equiv(UnitDef other) {
        if (other == null) {
            return false;
        }
        return this.equiv(other.getClass(), other.getName(), other.getInternalPer(), other.getDisplayDecimalPlaces(), other.getKnownUnitName(), other.getInternalPerKnown());
    }

    public boolean equiv(Class<?> type, String name, long internalPer, int displayDecimalPlaces, String knownUnitName, long internalPerKnown) {
        return Objects.equal(type, this.getClass()) && Objects.equal((Object)name, (Object)this.getName()) && Objects.equal((Object)internalPer, (Object)this.getInternalPer()) && Objects.equal((Object)displayDecimalPlaces, (Object)this.getDisplayDecimalPlaces()) && Objects.equal((Object)knownUnitName, (Object)this.getKnownUnitName()) && Objects.equal((Object)internalPerKnown, (Object)this.getInternalPerKnown());
    }

    static {
        for (UnitDef ud : PREDEF_UNITS) {
            UnitDef.getRegistry().add(ud);
        }
    }

    public static class Distance
    extends UnitDef {
        public static final String KNOWN_UNIT = "micron";

        public Distance(String desc, String name, long internalPer, int displayDecimalPlaces, long internalPerMicron) {
            super(desc, name, internalPer, displayDecimalPlaces, KNOWN_UNIT, internalPerMicron);
        }
    }

    public static class Registry {
        protected HashSet<UnitDef> mDefinedUnits = new LinkedHashSet<UnitDef>();

        public <T extends UnitDef> T add(T ud) {
            T exist = this.lookup(ud);
            if (exist != null) {
                return exist;
            }
            this.mDefinedUnits.add(ud);
            return ud;
        }

        public <T extends UnitDef> Iterable<T> get(final Class<T> type) {
            return new ProcessingIterator<UnitDef, T>(this.mDefinedUnits.iterator()){

                protected T process(UnitDef ud) {
                    return type.isAssignableFrom(ud.getClass()) ? ud : null;
                }
            };
        }

        public <T extends UnitDef> T lookup(T ref) {
            Object res = this.lookup(ref.getClass(), ref.getName(), ref.getInternalPer(), ref.getDisplayDecimalPlaces(), ref.getKnownUnitName(), ref.getInternalPerKnown());
            return (T)res;
        }

        public <T extends UnitDef> T lookup(Class<T> type, String name, long internalPer, int displayDecimalPlaces, String knownUnitName, long internalPerKnown) {
            for (UnitDef ud : this.get(type)) {
                if (!ud.equiv(type, name, internalPer, displayDecimalPlaces, knownUnitName, internalPerKnown)) continue;
                return (T)ud;
            }
            return null;
        }
    }
}

