/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ACsvReader;
import com.sigrity.acl.AHashCollection;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Text;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.edaMgrs.HConnEngine;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.ATransform;
import com.sigrity.acl.optimizer.RoomFinder;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.acl.poly.PolyFactory;
import com.sigrity.acl.poly.SimplePoint;
import com.sigrity.acl.transformers.Rotater;
import com.sigrity.orbit.AbstractView;
import com.sigrity.orbit.BusView;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.LineUnCrosser;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitGridUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.ViaFanout;
import com.sigrity.orbit.automation.iocellplacement.DriverOptimizer;
import com.sigrity.orbit.automation.iocellplacement.DriverRespacer;
import com.sigrity.orbit.automation.router.BundleRoutePrep;
import com.sigrity.orbit.automation.router.RouterReportWriter;
import com.sigrity.orbit.cmd.NetCmd;
import com.sigrity.orbit.cmd.SelectionCmds;
import com.sigrity.orbit.export.CsvIo;
import com.sigrity.orbit.factory.CoreFactory;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.ui.DeviceUI;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.wb_route.LayerSelectorDlg;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.geom.AffineTransform;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class UserCommands {
    private static final String DEVICE_PATH_WARNING_MSG = "DevicePath '%s' does not exist";
    private static final String DEVICE_PAHT_ERROR_MSG = "'%s' is not a valid device path";

    private UserCommands() {
    }

    public static void SelectIOPadsForSelectedBumps() {
        LinkedList<HierPin> io1 = new LinkedList<HierPin>();
        Db db = OrbitApp.getCurDb();
        Selection s = Design.getSelection((Db)db);
        HashSet<HierPin> pins = new HashSet<HierPin>();
        for (PinInstance selPi : s.get(PinInstance.class)) {
            block1: for (DevicePath dp : s.getSelectedPaths((DbObject)selPi)) {
                HierPin hp = new HierPin(dp, selPi);
                if (hp.getSecond().getType() != PinTemplate.Type.BUMPPAD) continue;
                pins.add(hp);
                for (PinInstance pi : NetMap.getConnectedPorts((Net)hp.getNet(), (DevicePath)dp)) {
                    if (pi.getType() != PinTemplate.Type.IOPAD) continue;
                    io1.add(new HierPin(pi.getDevice().getADevicePath(), pi));
                    continue block1;
                }
            }
        }
        s.clear();
        for (HierPin hp : io1) {
            s.add((DevicePath)hp.getFirst(), (DbObject)hp.getDbObject());
        }
    }

    public static void showMe(long x, long y) {
        Design d = Design.getDesign((Db)OrbitApp.getCurDb());
        if (d == null) {
            return;
        }
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay showMe = v.getShowMeTheWay();
        showMe.addShowMe(new APoint2D(x, y), "look here");
        long rad = Design.micronToInternal((Db)d.getDb(), (double)100.0);
        v.getCanvas().zoomTo(x - rad, y - rad, x + rad, y + rad);
    }

    public static void showMe(String pathString) {
        Db curDb = OrbitApp.getCurDb();
        Design d = Design.getDesign((Db)curDb);
        if (d == null) {
            return;
        }
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        ShowMeTheWay showMe = v.getShowMeTheWay();
        Pattern pattern = Pattern.compile(pathString);
        if (pattern.matcher(Design.getDesignPath((Db)curDb).toString()).matches()) {
            showMe.addShowMe(new APoint2D(), "<Design>");
        }
        for (DevicePath path : d.getDescendantDevices()) {
            if (!pattern.matcher(path.toString()).matches()) continue;
            showMe.addShowMe(path.getOrigin(), path.getLast().getName());
        }
    }

    public static void clearShowMe() {
        ShowMeTheWay.clear();
    }

    public static void selectDevicesByName(String parentName, DeviceTemplate.Type deviceType, String instName, boolean add) {
        Db db = OrbitApp.getCurDb();
        Device p = null;
        for (Device d : db.getObjects(Device.class)) {
            String name = d.getName();
            if (name == null || !name.equals(parentName)) continue;
            p = d;
            break;
        }
        if (p == null) {
            return;
        }
        Selection s = Design.getSelection((Db)db);
        Pattern pattern = Pattern.compile(instName);
        for (Device d : p.getDescendantsOfType(deviceType, true)) {
            String name = d.getName();
            if (name == null || !pattern.matcher(name).find()) continue;
            if (add) {
                s.add((DbObject)d);
                continue;
            }
            s.remove((DbObject)d);
        }
    }

    public static void selectByName(String clazzName, String instName, boolean add) {
        Db db = OrbitApp.getCurDb();
        DbClass clazz = db.getDbClass(clazzName);
        if (clazz == null) {
            ALog.logWarn((String)("There are no " + clazzName + " in this design"));
            return;
        }
        Selection s = Design.getSelection((Db)db);
        Pattern pattern = Pattern.compile(instName);
        for (DbObject oC : clazz.getInstances()) {
            String name = (String)oC.getValue("name");
            if (name == null || !pattern.matcher(name).find()) continue;
            if (add) {
                s.add(oC);
                continue;
            }
            s.remove(oC);
        }
    }

    public static void selectDevice(String deviceKeyStr, boolean value) {
        Db db = OrbitApp.getCurDb();
        Selection s = Design.getSelection((Db)db);
        Device d = (Device)db.getByKeyStr(Device.class, deviceKeyStr);
        if (d == null) {
            ALog.logWarn((String)("Device " + deviceKeyStr + " does not exist."));
            return;
        }
        if (value) {
            s.add((DbObject)d);
        } else {
            s.remove((DbObject)d);
        }
    }

    public static void selectDevicesOfType(String parentName, DeviceTemplate.Type deviceType) {
        Db db = OrbitApp.getCurDb();
        Device p = Device.getADeviceByName((Db)db, (String)parentName);
        if (p == null) {
            ALog.logError((String)"There is no Device '%s'.", (Object[])new Object[]{parentName});
            return;
        }
        Selection ss = Design.getSelection((Db)db);
        for (Device d : p.getDescendantsOfType(deviceType, true)) {
            ss.add((DbObject)d);
        }
    }

    public static void moveDevice(String devicePathString, long x, long y) {
        UserCommands.moveDevice(devicePathString, x, y, null, null, false, false, false, false);
    }

    public static void moveDevice(String devicePathString, long x, long y, Float rotate, Boolean mirror, boolean smartAlign, boolean obsAvoidance, boolean dropCenter) {
        UserCommands.moveDevice(devicePathString, x, y, rotate, mirror, smartAlign, obsAvoidance, dropCenter, false, false, true);
    }

    public static void moveDevice(String devicePathString, long localX, long localY, Float rotate, Boolean mirror) {
        UserCommands.moveDevice(devicePathString, localX, localY, rotate, mirror, false, false, false, false, true, true);
    }

    public static void moveDevice(String devicePathString, long x, long y, Float rotate, Boolean mirror, boolean smartAlign, boolean obsAvoidance, boolean dropCenter, boolean dieOk) {
        UserCommands.moveDevice(devicePathString, x, y, rotate, mirror, smartAlign, obsAvoidance, dropCenter, dieOk, false, true);
    }

    public static void moveDevice(String devicePathString, long x, long y, Float rotate, Boolean mirror, boolean smartAlign, boolean obsAvoidance, boolean dropCenter, boolean dieOk, boolean localMove) {
        UserCommands.moveDevice(devicePathString, x, y, rotate, mirror, smartAlign, obsAvoidance, dropCenter, dieOk, localMove, true);
    }

    public static void moveDevice(String devicePathString, long x, long y, Float rotate, Boolean mirror, boolean smartAlign, boolean obsAvoidance, boolean dropCenter, boolean dieOk, boolean localMove, boolean allowHierarchyChange) {
        boolean myParentIsAPersonality;
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Device d = devicePath.getLast();
        if (d == null) {
            ALog.logWarn((String)"Device '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        if (d.getIsFixed()) {
            ALog.logWarn((String)("Device " + devicePathString + " is fixed"));
            return;
        }
        DevicePath parentPath = devicePath.getParent();
        Device devOldParent = parentPath.getLast();
        Object tmpltOldParent = devOldParent == null ? Design.getDesign((Db)db) : devOldParent.getTemplate();
        if (mirror != null && d.getMirror() != mirror.booleanValue()) {
            d.setFlipped(!d.getFlipped());
            d.setMirror(mirror.booleanValue());
        }
        if (rotate != null) {
            d.setRotate(rotate.floatValue());
        }
        if (localMove) {
            d.moveTo(x, y);
        } else {
            AffineTransform t = devicePath.getParent().getTransform();
            AffineTransform tI = ATransformUtil.inverse((AffineTransform)t);
            APoint2D p = new APoint2D(x, y);
            APoint2D o = p.transform(tI);
            d.moveTo(o.getX(), o.getY());
        }
        DevicePath newParentPath = devicePath.getParent();
        if (allowHierarchyChange) {
            newParentPath = Device.potentialNewSubstrateAt((DevicePath)devicePath, (boolean)dieOk);
        }
        Design tmpltNewParent = newParentPath == null ? tmpltOldParent : newParentPath.getDeviceTemplate();
        boolean bl = myParentIsAPersonality = tmpltOldParent.getType() == DeviceTemplate.Type.PERSONALITY;
        if (tmpltNewParent != tmpltOldParent && !myParentIsAPersonality) {
            d.setParent(newParentPath.getLast(), false);
            DbExplorerPanel.refreshAll();
            DevicePath newPath = new DevicePath(newParentPath, d);
            float myOldAbsRot = devicePath.getRot();
            boolean myOldAbsMirror = devicePath.getMirror();
            float newParentRot = newPath.getRot();
            boolean myParentMirror = newPath.getMirror();
            float deltaRot = newParentRot - myOldAbsRot;
            boolean deltaMirror = myOldAbsMirror != myParentMirror;
            d.setRotate(d.getRotate() - deltaRot);
            if (deltaMirror) {
                d.setMirror(!d.getMirror());
            }
            if (!localMove) {
                Device.reparentPosition((String)d.getKeyStr(), (String)newParentPath.toString(), (long)x, (long)y);
            }
            devicePath = newPath;
        } else {
            Device.checkContactOfSubstrateInstance((DevicePath)devicePath, (boolean)true);
        }
        if (smartAlign) {
            Device.alignMeToNeighborhood((DevicePath)devicePath);
        }
        if (dropCenter && newParentPath != null && newParentPath.getLast() != null) {
            RoomFinder.findCenter(devicePath);
        }
        if (dropCenter && newParentPath == null) {
            d.moveTo(0L, 0L);
        }
        if (!d.getIsPlaced()) {
            d.setIsPlaced(true);
            Device.scheduleManageAllUnplaceQs((Db)d.getDb());
        }
    }

    public static void flipDeviceInPlace(String devicePathString) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Device d = devicePath.getLast();
        ARect oldBounds = d.getBB();
        UserCommands.moveDevice(devicePathString, d.getLocX(), d.getLocY(), Float.valueOf(devicePath.getRot()), !d.getMirror(), false, false, false, true, false, false);
        ARect newBounds = d.getBB();
        APoint2D ds = new APoint2D(-(newBounds.centerX() - oldBounds.centerX()), -(newBounds.centerY() - oldBounds.centerY()));
        d.moveBy(ds);
        DbExplorerPanel.refreshAll();
    }

    public static void updateSubTempNamesOfSelected() {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (Device d : s.get(Device.class)) {
            d.getTemplate().setName(d.getName() + "_T");
            d.getSubstrate().setName(d.getName() + "_S");
        }
        OrbitIO.getApp().zoomFitCurrentView();
    }

    public static void ungroupSelected() {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (Device d : s.get(Device.class)) {
            DevicePath path = d.getADevicePath();
            Device.unGroup((DevicePath)path);
        }
        s.clear();
        OrbitIO.getApp().zoomFitCurrentView();
    }

    public static void unplaceUnFixed() {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        for (Device d : db.getObjects(Device.class)) {
            if (d.getIsFixed()) continue;
            d.setIsPlaced(false);
            ATransform t = new ATransform();
            t.setRotate(0.0f);
            t.setMirror(false);
            d.setTransform(t);
        }
        Device.manageAllUnplaceQs();
        design.binAllDevices();
    }

    public static void unplaceSelected() {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        int fixed = 0;
        for (Device d : db.getObjects(Device.class)) {
            if (!s.contains((DbObject)d)) continue;
            if (d.getIsFixed()) {
                ++fixed;
                continue;
            }
            d.setIsPlaced(false);
            ATransform t = new ATransform();
            t.setRotate(0.0f);
            t.setMirror(false);
            d.setTransform(t);
        }
        if (fixed > 0) {
            ALog.flogWarn((String)"Cannot unplace %d devices because of fixed.", (Object[])new Object[]{fixed});
        }
        Device.manageAllUnplaceQs();
        design.binAllDevices();
        OrbitIO.getApp().zoomFitCurrentView();
    }

    public static void unselectAll() {
        Db db = OrbitApp.getCurDb();
        Selection s = Selection.getCurrentSelectionForDb((Db)db);
        if (s.getCountTotal() == 0L) {
            return;
        }
        for (Device d : db.getObjects(Device.class)) {
            s.remove((DbObject)d);
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void fixSelectedDevices(boolean fix) {
        Db db = OrbitApp.getCurDb();
        Selection s = Design.getSelection((Db)db);
        for (Device d : s.get(Device.class)) {
            if (!fix) {
                d.setIsFixed(false);
                continue;
            }
            if (!d.getIsPlaced()) continue;
            d.setIsFixed(fix);
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void renameDevice(String oldName, String newName) {
        Db db = OrbitApp.getCurDb();
        Device d = Device.getADeviceByName((Db)db, (String)oldName);
        if (d != null) {
            d.setName(newName);
            d.setShortName(newName);
        }
    }

    public static void selectByTemplateName(String templateName) {
        Db db = OrbitApp.getCurDb();
        Pattern pattern = Pattern.compile(templateName);
        Selection s = Design.getSelection((Db)db);
        for (Device d : db.getObjects(Device.class)) {
            DeviceTemplate template = d.getTemplate();
            String thisName = template.getName();
            if (pattern.matcher(thisName).find()) {
                s.add((DbObject)d);
                continue;
            }
            s.remove((DbObject)d);
        }
    }

    public static void setDeviceTypeOfSelected(DeviceTemplate.Type t) {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (Device d : db.getObjects(Device.class)) {
            if (!s.contains((DbObject)d)) continue;
            DeviceTemplate template = d.getTemplate();
            template.setType(t);
        }
    }

    public static void rotate(String deviceKeyStr, int angle) {
        Db db = OrbitApp.getCurDb();
        Device d = (Device)db.getByKeyStr(Device.class, deviceKeyStr);
        if (d != null) {
            Rotater.orient90(d, angle);
        }
    }

    public static void bestRotate(String deviceKeyStr) {
        Db db = OrbitApp.getCurDb();
        Device d = (Device)db.getByKeyStr(Device.class, deviceKeyStr);
        if (d != null) {
            Rotater.bestRotate(d);
        }
    }

    public static void removeConnections() {
        Db db = OrbitApp.getCurDb();
        Connection.removeAll((Db)db);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void createConnections() {
        Db db = OrbitApp.getCurDb();
        HConnEngine ce = new HConnEngine(db);
        ce.createConnections();
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void connectIOToCore() {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        Device d = null;
        int i = 0;
        for (Device selDev : s.get(Device.class)) {
            if (d == null) {
                d = selDev;
            }
            ++i;
        }
        if (i != 1) {
            ALog.logError((String)(i + " device were selected. Please select one and only one device."));
            return;
        }
        String corePath = d.getADevicePath().toString();
        String pinPrefix = "macpad_";
        String netPrefix = "net_";
        for (PinInstance p : s.get(PinInstance.class)) {
            Object netName;
            DevicePath pdp = p.getDevice().getADevicePath();
            Net net = p.getNet();
            String pinName = p.getName();
            if (net.isUnused()) {
                netName = netPrefix + pinName;
            } else {
                Net topNet = NetMap.getTopmostNet((Net)net, (DevicePath)pdp);
                netName = topNet.getName();
            }
            NetCmd.connect((String)pdp.toString(), (String)pinName, (String)corePath, (String)(pinPrefix + pinName), (String)netName);
        }
    }

    public static void unselectAllConnections() {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (Connection c : db.getObjects(Connection.class)) {
            s.remove((DbObject)c);
        }
    }

    public static void selectConnectionOfSelectedPorts(boolean both) {
        Db db = OrbitApp.getCurDb();
        Selection s = Design.getSelection((Db)db);
        for (Connection c : db.getObjects(Connection.class)) {
            PinInstance portA = c.getPortA();
            PinInstance portB = c.getPortB();
            boolean selectThisOne = false;
            if (both) {
                selectThisOne = s.contains((DbObject)portA) && s.contains((DbObject)portB);
            } else {
                boolean bl = selectThisOne = s.contains((DbObject)portA) || s.contains((DbObject)portB);
            }
            if (!selectThisOne) continue;
            s.add((DbObject)c);
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void fixSelectedPorts(boolean fix) {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        for (PinInstance p : s.get(PinInstance.class)) {
            p.fixed(fix);
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void selectPortsOf(String devKey) {
        Db db = OrbitApp.getCurDb();
        Device device = (Device)db.getByKeyStr(Device.class, devKey);
        UserCommands.selectPortsOf(device);
    }

    public static void selectPortsOf(Device device) {
        if (device == null) {
            return;
        }
        Db db = device.getDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        IterableIterator ports = device.getPins();
        while (ports.hasNext()) {
            PinInstance port = (PinInstance)ports.next();
            s.add((DbObject)port);
        }
        for (Device child : device.getChildren()) {
            UserCommands.selectPortsOf(child);
        }
    }

    public static void promotePackage(String devicePathString) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate dt = devicePath.getDeviceTemplate();
        Substrate newSub = Substrate.create((Db)db, (String)"synpackage", (boolean)true);
        newSub.setSourceType(DeviceTemplate.SourceType.USER);
        dt.setType(DeviceTemplate.Type.PACKAGE);
        newSub.createDefaultLayers(DeviceTemplate.Type.PACKAGE);
        dt.setSubstrate(newSub);
        for (PinTemplate pt : dt.getPins()) {
            pt.setType(PinTemplate.Type.BALLPAD);
            for (LayerShape ls : pt.getLayerShapes()) {
                ls.setLayer(newSub.getBottomLayer());
            }
        }
        PersonalityUI.assignBallsToPersonalities(devicePathString);
    }

    public static void selectPinsOfSelectedDevices() {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (DbObject o : s.getAll()) {
            if (!(o instanceof Device)) continue;
            Device d = (Device)o;
            IterableIterator ports = d.getPins();
            while (ports.hasNext()) {
                PinInstance port = (PinInstance)ports.next();
                s.add((DbObject)port);
            }
        }
    }

    public static void selectPinsOfSelectedNetsAndDevices() {
        Selection s = Design.getSelection((Db)OrbitApp.getCurDb());
        for (Device d : s.get(Device.class)) {
            IterableIterator ports = d.getPins();
            while (ports.hasNext()) {
                PinInstance port = (PinInstance)ports.next();
                Net net = port.getNet();
                if (!s.contains((DbObject)net)) continue;
                s.add((DbObject)port);
            }
        }
    }

    public static void selectBallPads(String deviceKey, boolean selected) {
        UserCommands.selectPads(deviceKey, DeviceTemplate.Type.PACKAGE, PinTemplate.Type.BALLPAD, selected);
    }

    public static void selectWirebondPads(String deviceKey, boolean selected) {
        UserCommands.selectPads(deviceKey, DeviceTemplate.Type.DIE, PinTemplate.Type.WIREBONDPAD, selected);
    }

    public static void selectBumpPads(String deviceKey, boolean selected) {
        UserCommands.selectPads(deviceKey, DeviceTemplate.Type.DIE, PinTemplate.Type.BUMPPAD, selected);
    }

    protected static void selectPads(String deviceKey, DeviceTemplate.Type devType, PinTemplate.Type padType, boolean selected) {
        Db db = OrbitApp.getCurDb();
        Device device = (Device)db.getByKeyStr(Device.class, deviceKey);
        if (device == null || device.getTemplate().getType() != devType) {
            return;
        }
        Selection s = Design.getSelection((Db)db);
        List meAndDescendants = device.meAndDescendants();
        for (Device d : meAndDescendants) {
            for (PinInstance port : d.getPins()) {
                PinTemplate dtp = port.getPinTemplate();
                if (dtp.getType() != padType) continue;
                if (selected) {
                    s.add((DbObject)port);
                    continue;
                }
                s.remove((DbObject)port);
            }
        }
    }

    public static void selectConnectionByNet(String netName) {
        Pattern pattern = Pattern.compile(netName);
        Db db = OrbitApp.getCurDb();
        Selection s = Design.getSelection((Db)db);
        for (Connection c : db.getObjects(Connection.class)) {
            PinInstance port = c.getPortA();
            Net net = port.getNet();
            String myName = net.getName();
            if (pattern.matcher(myName).find()) {
                s.add((DbObject)c);
                continue;
            }
            s.remove((DbObject)c);
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void deleteNetsWithPattern(String netName) {
        Db db = OrbitApp.getCurDb();
        Pattern pattern = Pattern.compile(netName);
        HashSet<Net> toBeDeleted = new HashSet<Net>();
        for (Net n : db.getObjects(Net.class)) {
            String name = n.getName();
            if (name == null || !pattern.matcher(name).find()) continue;
            toBeDeleted.add(n);
        }
        ALog.logInfo((String)("Deleting " + toBeDeleted.size() + " nets"));
        for (Net n : toBeDeleted) {
            n.deleteFromDb();
        }
    }

    public static void selectNet(String netName) {
        Db db = OrbitApp.getCurDb();
        Pattern pattern = Pattern.compile(netName);
        Selection s = Design.getSelection((Db)db);
        for (Net n : db.getObjects(Net.class)) {
            String name = n.getName();
            if (name == null || !pattern.matcher(name).find()) continue;
            s.add((DbObject)n);
        }
        for (Connection c : db.getObjects(Connection.class)) {
            PinInstance p = c.getPortA();
            Net net = p.getNet();
            String name = net.getName();
            if (name != null && pattern.matcher(name).find()) {
                s.add((DbObject)c);
                s.add((DbObject)p);
            }
            if ((name = (net = (p = c.getPortB()).getNet()).getName()) == null || !pattern.matcher(name).find()) continue;
            s.add((DbObject)c);
            s.add((DbObject)p);
        }
    }

    public static void makePersonalityParent(String pName) {
        Db db = OrbitApp.getCurDb();
        for (Personality p : db.getObjects(Personality.class)) {
            if (!p.getName().equals(pName)) continue;
            p.createParent(null);
        }
    }

    public static void addNetsToParent(String childPathString, String expression, String prefix) {
        Db db = OrbitApp.getCurDb();
        DevicePath childPath = DevicePath.fromString((Db)db, (String)childPathString);
        if (childPath != null) {
            DevicePath parentPath = childPath.getParent();
            DeviceTemplate pt = parentPath.getDeviceTemplate();
            for (Net n : childPath.getLast().getTemplate().getNets()) {
                String eLower = expression.toLowerCase();
                if (!n.getName().toLowerCase().contains(eLower)) continue;
                Net.create((DeviceTemplate)pt, (String)(prefix + n.getName()));
            }
        }
    }

    public static void postUPDRead() {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        design.binAllDevices();
        ArrayList<Substrate> subFound = new ArrayList<Substrate>();
        ArrayList<Device> candidates = new ArrayList<Device>();
        for (Device d : db.getObjects(Device.class)) {
            if (d.getTemplate().getType() != DeviceTemplate.Type.PACKAGE) continue;
            candidates.add(d);
            if (!subFound.contains(d.getSubstrate())) {
                subFound.add(d.getSubstrate());
                continue;
            }
            String name = d.getName() + "Sub";
            Substrate cloneSubstrate = Substrate.create((Db)db, (String)name);
            d.getTemplate().setSubstrate(cloneSubstrate);
        }
    }

    public static void instatiateDevice(String name, String templateKeyStr) {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        DeviceTemplate dt = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKeyStr);
        if (dt == null) {
            ALog.logError((String)"Unable to find template with key '%s'.", (Object[])new Object[]{templateKeyStr});
            assert (false);
            return;
        }
        Device d = Device.create((String)name, (DeviceTemplate)dt, (DeviceTemplate)design);
        d.moveTo(0L, 0L);
        d.setIsPlaced(false);
        Device.manageAllUnplaceQs();
        design.binAllDevices();
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void setPlacementGrid(String devicePathString, double x, double y) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logInfo((String)(devicePathString + " is not a device"));
            return;
        }
        Unit unit = Design.getUnit((Db)db);
        Device device = devicePath.getLast();
        Substrate s = device.getSubstrate();
        AGrid g = new AGrid();
        long dx = unit.fromUser(x);
        long dy = unit.fromUser(y);
        g.setDelta(dx, dy);
        ARect srcBounds = device.getTemplate().getBounds(true).getBounds();
        g.setOrigin(srcBounds.left(), srcBounds.bottom());
        NamedGrid ng = NamedGrid.get((Substrate)s, (String)"Device Grid");
        if (ng == null) {
            NamedGrid.create((Substrate)s, (String)"Device Grid", (AGrid)g);
        } else {
            ng.setGrid(g);
        }
    }

    public static void addLayer(String devicePathString, String layerName) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Device device = devicePath.getLast();
        Substrate s = device.getSubstrate();
        Layer.create((Substrate)s, (String)layerName);
    }

    public static void makeDiffPairs(String devicePathString, String pSuffix, String nSuffix) {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Selection selection = design.getCurSelection();
        Device device = devicePath.getLast();
        DeviceTemplate t = device.getTemplate();
        AHashCollection hc = new AHashCollection();
        for (Net n : t.getNets()) {
            String baseName;
            String name = n.getName();
            if (name.endsWith(pSuffix)) {
                baseName = name.substring(0, name.lastIndexOf(pSuffix));
                hc.add((Object)baseName, (Object)n);
            }
            if (!name.endsWith(nSuffix)) continue;
            baseName = name.substring(0, name.lastIndexOf(nSuffix));
            hc.add((Object)baseName, (Object)n);
        }
        for (String baseName : hc.keySet()) {
            LinkedList nets = (LinkedList)hc.get((Object)baseName);
            if (nets.size() != 2) continue;
            for (Net n : nets) {
                Personality netPersonality = Personality.getOrCreate((DeviceTemplate)t, (Personality.Type)Personality.Type.NET, (String)baseName, newPers -> {
                    newPers.setColor(AUtil.colorFromString((String)Personality.nextColor()));
                    Constraint.getOrCreate((DbObject)newPers, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH, (Object)true);
                });
                n.assignToPersonality(netPersonality, null);
                selection.add((DbObject)n);
                for (PinInstance dp : n.getPinInstances()) {
                    selection.add((DbObject)dp);
                }
            }
        }
    }

    public static void removeZeroWidthPads(String devicePathString) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePathString);
        for (DevicePath child : devicePath.getDescendants()) {
            ArrayList<PinInstance> toBeRemoved = new ArrayList<PinInstance>();
            for (PinInstance dp : child.getLast().getPins()) {
                PinTemplate dtp = dp.getPinTemplate();
                if (dtp.getBounds().width() != 0L && dtp.getBounds().height() != 0L) continue;
                toBeRemoved.add(dp);
            }
            for (PinInstance dp : toBeRemoved) {
                dp.deleteFromDb();
            }
        }
    }

    public static void flipSideOfSelectedDevices() {
        Selection s = Design.getSelection((Db)OrbitApp.getCurDb());
        for (Device d : s.get(Device.class)) {
            if (d.isOnBottomSide()) {
                d.placeOnTopSide();
                continue;
            }
            d.placeOnBottomSide();
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void movePadsToLayer(String devicePathString, String fromLayerName, String toLayerName) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Device device = devicePath.getLast();
        Substrate s = device.getSubstrate();
        Layer fromLayer = null;
        if (!fromLayerName.isEmpty() && (fromLayer = s.getLayer(fromLayerName)) == null) {
            ALog.logError((String)(fromLayerName + " is not a layer"));
            return;
        }
        Layer toLayer = null;
        if (!toLayerName.isEmpty() && (toLayer = s.getLayer(toLayerName)) == null) {
            ALog.logError((String)(toLayerName + " is not a layer"));
            return;
        }
        for (DevicePath child : devicePath.getDescendants()) {
            for (PinInstance dp : child.getLast().getPins()) {
                PinTemplate dtp = dp.getPinTemplate();
                dtp.moveLayerShape(fromLayer, toLayer);
            }
        }
    }

    public static void diffPairReport(String devicePathString, String fileName, String layerName) {
        Layer layer;
        Db db = OrbitApp.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Device device = devicePath.getLast();
        Substrate s = device.getSubstrate();
        Layer layer2 = layer = layerName.isEmpty() ? null : s.getLayer(layerName);
        if (!layerName.isEmpty() && layer == null) {
            ALog.logInfo((String)(layerName + " is not a layer"));
            return;
        }
        ArrayList<Personality> diffPairs = new ArrayList<Personality>();
        for (Net net : device.getNets()) {
            Boolean matchLength;
            Personality p = net.getPersonality();
            if (p == null || (matchLength = (Boolean)Constraint.getValue((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH)) == null || !matchLength.booleanValue() || diffPairs.contains(p)) continue;
            diffPairs.add(p);
        }
        long skewSum = 0L;
        int skews = 0;
        Collections.sort(diffPairs);
        for (Personality personality : diffPairs) {
            ArrayList netsInPersonality = new ArrayList();
            ArrayList lengthsOfNetsInPersonality = new ArrayList();
            personality.getObjects().filter(hi -> ((DevicePath)hi.first).equals((Object)devicePath)).forEach(hi -> {
                Net n = (Net)hi.second;
                netsInPersonality.add(n);
                long l = 0L;
                PinInstance dpLast = null;
                for (PinInstance dp : NetMap.getConnectedPorts((Net)n, (DevicePath)devicePath)) {
                    if (!dp.hasShapeOnLayer(layer)) continue;
                    if (dpLast == null) {
                        dpLast = dp;
                        continue;
                    }
                    Wire w = Wire.connects((PinInstance)dp, (PinInstance)dpLast);
                    if (w != null) {
                        l += w.getLength();
                        continue;
                    }
                    l += dp.getLoc().distance(dpLast.getLoc());
                }
                lengthsOfNetsInPersonality.add(l);
            });
            long skew = Math.abs((Long)lengthsOfNetsInPersonality.get(0) - (Long)lengthsOfNetsInPersonality.get(1));
            double skewUser = unit.toUser(skew);
            skewSum += skew;
            ++skews;
            ALog.logInfo((String)(personality.getName() + " skew " + skewUser));
        }
        if (skews > 0) {
            ALog.logInfo((String)("Avg. skew of " + skews + " diff pairs is " + unit.toUser(skewSum / (long)skews)));
        }
    }

    public static void removeNetsOnSelectedPins() {
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        for (PinInstance dp : s.get(PinInstance.class)) {
            dp.setNet(dp.getDeviceTemplate().getNetUnused());
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void importPinProperties(String devicePathString, String fileName) {
        Db db = OrbitApp.getCurDb();
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePathString);
        if (dp == null) {
            ALog.logError((String)(devicePathString + " does not exist"));
            return;
        }
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            parser2.setDataSepExpression(",");
            CSVDocument doc = parser2.parse(fileName);
            int changed = 0;
            String[] attr = doc.getAttributeNames();
            String netNameColumn = attr[0].replace(" ", "");
            DeviceTemplate devTemp = dp.getDeviceTemplate();
            for (int i = 0; i < doc.getItemCount(); ++i) {
                String netName = doc.getItemValue(i, netNameColumn);
                if (netName == null || netName.isEmpty()) continue;
                Net n = devTemp.getNet(netName);
                if (n == null) {
                    ALog.logInfo((String)("Net " + netName + " does not exist on " + devicePathString));
                    continue;
                }
                for (HierInst hpt : NetMap.getConnectedHierPorts((DevicePath)dp, (Net)n)) {
                    if (hpt.getPath().getLast() != dp.getLast()) continue;
                    PinTemplate pinTemplate = ((PortTemplate)hpt.second).getPinTemplate();
                    boolean thisOneChanged = false;
                    for (int j = 1; j < attr.length; ++j) {
                        String propName = attr[j].replaceAll(" ", "");
                        String pVal = doc.getItemValue(i, propName);
                        String curVal = (String)pinTemplate.getValue(propName);
                        if ((curVal != null || pVal.isEmpty()) && (curVal == null || curVal.equals(pVal))) continue;
                        pinTemplate.setValue(propName, (Object)pVal);
                        thisOneChanged = true;
                    }
                    if (!thisOneChanged) continue;
                    ++changed;
                }
            }
            ALog.logInfo((String)(changed + " pins have changed properties"));
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.flogError((String)"Error when parsing csv document '%s'.", (Object[])new Object[]{fileName});
        }
    }

    public static void readConstraints(String devicePathString, String fileName) {
        Db db = OrbitApp.getCurDb();
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePathString);
        DeviceTemplate devTemp = dp.getDeviceTemplate();
        Personality mainP = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.NET, (String)"main", newPers -> newPers.setColor(Personality.getPersonality((DeviceTemplate)dp.getDeviceTemplate(), (Personality.Type)Personality.Type.RDL, (String)"main").map(Personality::getColor).orElseGet(() -> AUtil.colorFromString((String)Personality.nextColor()))));
        dp.getLast().getTemplate().getNets().stream().filter(n -> !n.isUnused()).forEach(n -> n.assignToPersonality(mainP, dp));
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            parser2.setDataSepExpression(",|\\s+");
            CSVDocument doc = parser2.parse(fileName);
            for (int i = 0; i < doc.getItemCount(); ++i) {
                String nName = doc.getItemValue(i, "net");
                String pName = doc.getItemValue(i, "personality");
                Personality p = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.NET, (String)pName, newP -> newP.setColor(AUtil.colorFromString((String)Personality.nextColor())));
                Color netPColor = p.getColor();
                Net net = Net.get((DeviceTemplate)dp.getLast().getTemplate(), (String)nName);
                if (net == null) continue;
                net.assignToPersonality(p, dp);
                List dpps = NetMap.getConnectedDevicePathPorts((Net)net, (DevicePath)dp);
                for (HierPin dpp : dpps) {
                    if (dpp.getPinTemplate().getType() != PinTemplate.Type.IOPAD) continue;
                    Personality pRDL = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.RDL, (String)pName, newP -> newP.setColor(netPColor));
                    dpp.getPin().assignToRouteDefinition(pRDL);
                }
            }
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.flogError((String)"Error while parsing the csv file '%s'.", (Object[])new Object[]{fileName});
        }
    }

    public static void centerDeviceOnParent(String child, String parent) {
        Db db = OrbitApp.getCurDb();
        DevicePath childPath = DevicePath.fromString((Db)db, (String)child);
        if (childPath == null) {
            ALog.logWarn((String)(child + " is not a valid path"));
            return;
        }
        DevicePath parentPath = DevicePath.fromString((Db)db, (String)parent);
        if (parentPath == null) {
            ALog.logWarn((String)(parent + " is not a valid path"));
            return;
        }
        APoint2D cParent = parentPath.getLast().getWorldLoc(parentPath);
        UserCommands.moveDevice(child, cParent.getX(), cParent.getY(), Float.valueOf(0.0f), false, false, false, true);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void createGeomOnLayer(String devicePathString, String fromLayerName, String toLayerlayerName) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        if (toLayerlayerName.isEmpty() || fromLayerName.isEmpty()) {
            return;
        }
        Device die = devicePath.getLast();
        Substrate s = die.getSubstrate();
        Layer toLayer = s.getLayer(toLayerlayerName);
        if (toLayer == null) {
            ALog.logError((String)"'%s' is not a layer on '%s'", (Object[])new Object[]{toLayerlayerName, s});
            return;
        }
        Layer fromLayer = s.getLayer(fromLayerName);
        if (fromLayer == null) {
            ALog.logError((String)"'%s' is not a layer on '%s'", (Object[])new Object[]{fromLayerName, s});
            return;
        }
        Selection selection = Design.getSelection((Db)db);
        block0: for (DevicePath child : devicePath.getDescendants()) {
            Device device = child.getLast();
            DeviceTemplate deviceTemplate = device.getTemplate();
            if (deviceTemplate.getType() != DeviceTemplate.Type.PAD) continue;
            HashSet ioPorts = new HashSet(deviceTemplate.getIOPorts());
            for (PinInstance dp : child.getLast().getPins()) {
                PinTemplate dtp = dp.getPinTemplate();
                if (!ioPorts.contains(dtp)) continue;
                PortTemplate portTemplate = dtp.getFirstPortTemplate();
                PadTemplate padTemplate = portTemplate.getPadTemplate();
                ARect rl = portTemplate.getBounds(fromLayer);
                if (rl == null) continue;
                ARect newR = new ARect(-rl.width() / 2L, 0L, rl.width() / 2L, Design.micronToInternal((Db)db, (double)1.0));
                LayerShape.create((Db)db, (Layer)toLayer, (DbObject)padTemplate, (AGeom)newR);
                selection.add(child, (DbObject)dp);
                continue block0;
            }
        }
    }

    public static void createIOPadName(String devicePathString) {
        int numPorts = 0;
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        for (DevicePath child : devicePath.getDescendants()) {
            Device device = child.getLast();
            DeviceTemplate deviceTemplate = device.getTemplate();
            HashSet ioPorts = new HashSet(deviceTemplate.getIOPorts());
            for (PinInstance dp : child.getLast().getPins()) {
                PinTemplate dtp = dp.getPinTemplate();
                if (!ioPorts.contains(dtp)) continue;
                Net currentNet = dp.getNet();
                Net topNet = NetMap.getNetAt((Net)currentNet, (DevicePath)child, (DeviceTemplate)devicePath.getFirst().getTemplate());
                ALog.logInfo((String)(numPorts + " " + child.getString() + " " + dp.getName() + " " + topNet.getName()));
                ++numPorts;
            }
        }
    }

    public static void repair() {
        Db db = OrbitApp.getCurDb();
        for (PinInstance dp : AUtil.linkedList((Iterator)db.getObjects(PinInstance.class))) {
            if (dp.getPinTemplate() != null) continue;
            dp.deleteFromDb();
        }
    }

    public static void setBounds(String path, long x0, long y0, long x1, long y1) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)path);
        if (devicePath == null) {
            return;
        }
        Device d = devicePath.getLast();
        DeviceTemplate dt = d.getTemplate();
        ARect r = new ARect(x0, y0, x1, y1);
        dt.setBounds((AGeom)r);
    }

    public static void selectLargestePortOfIOPad(String start) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)start);
        if (devicePath == null) {
            return;
        }
        Db db = OrbitApp.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection selection = design.getCurSelection();
        for (DevicePath child : devicePath.getDescendants()) {
            DeviceTemplate dt;
            DeviceTemplate.PortShapeArea psa;
            if (child.getLast().getType() != DeviceTemplate.Type.PAD || (psa = (dt = child.getLast().getTemplate()).getPortWithLargestGeometry(null)) == null) continue;
            PinTemplate dtp = psa.getPort();
            PinInstance dp = child.getLast().getAssociatedPinInstance(dtp);
            selection.add((DbObject)dp);
        }
    }

    public static void SetPortToUnused() {
        Db db = OrbitApp.getCurDb();
        Selection s = Design.getSelection((Db)db);
        for (PinInstance p : s.get(PinInstance.class)) {
            p.setNet(p.getDeviceTemplate().getNetUnused());
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void mapBumpsToDie1(String dp) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)dp);
        if (devicePath == null) {
            return;
        }
        Substrate s = devicePath.getSubstrate();
        DevicePath pathToDie = devicePath.pathToParent(s);
        DeviceTemplate dieTemplate = pathToDie.getFirst().getTemplate();
        int numSet = 0;
        for (DevicePath child : pathToDie.getDescendants()) {
            Device device = child.getLast();
            DeviceTemplate t = device.getTemplate();
            for (PinInstance pi : device.getPins()) {
                Net net;
                PinTemplate pt = pi.getPinTemplate();
                if (pt.getType() != PinTemplate.Type.BUMPPAD && t.getType() != DeviceTemplate.Type.BUMP && t.getType() != DeviceTemplate.Type.COVER || (net = NetMap.getNetAt((Net)pi.getNet(), (DevicePath)child, (DeviceTemplate)dieTemplate)).getDeviceTemplate() == dieTemplate) continue;
                String name = pt.getName();
                NetMap.mapThroughPath((DevicePath)child, (PinInstance)pi, (String)name);
                pi.setNetSetterType(PinInstance.NetSetterType.INTERACTIVE_USER);
                ++numSet;
            }
        }
        ALog.logInfo((String)("Mapped " + numSet + " nets " + pathToDie.getFirst().getName()));
    }

    public static void removeAllVias() {
        ArrayList<PinTemplate> toBeRemoved = new ArrayList<PinTemplate>();
        for (PinTemplate pinTemplate : OrbitApp.getCurDb().getObjects(PinTemplate.class)) {
            if (!pinTemplate.getType().equals((Object)PinTemplate.Type.CONTACT) && !pinTemplate.getName().contains("IOVia")) continue;
            toBeRemoved.add(pinTemplate);
        }
        for (PinTemplate via : toBeRemoved) {
            via.deleteFromDb();
        }
    }

    public static void removeDevicesNothingOn(String layerMatch) {
        Db db = OrbitApp.getCurDb();
        int count = 0;
        Pattern pattern = Pattern.compile(layerMatch);
        ArrayList<DeviceTemplate> toBeRemoved = new ArrayList<DeviceTemplate>();
        for (DeviceTemplate dt : db.getObjects(DeviceTemplate.class)) {
            boolean foundLayer = false;
            block1: for (PinTemplate pt : dt.getPins()) {
                for (LayerShape ls : pt.getLayerShapes()) {
                    String layerName = ls.getLayer().getName();
                    if (!pattern.matcher(layerName).matches()) continue;
                    foundLayer = true;
                    continue block1;
                }
            }
            if (foundLayer) continue;
            toBeRemoved.add(dt);
        }
        ArrayList<Device> toBeRemovedDevices = new ArrayList<Device>();
        for (DeviceTemplate dt : toBeRemoved) {
            for (Device d : dt.getDeviceInstances()) {
                toBeRemovedDevices.add(d);
            }
        }
        for (Device d : toBeRemovedDevices) {
            if (d.getIsSubstrate()) continue;
            d.deleteFromDb(false, false);
            ++count;
        }
        ALog.logInfo((String)("Removed " + count + " devices"));
    }

    public static void removeDevicesWithName(String instName) {
        Db db = OrbitApp.getCurDb();
        int count = 0;
        Pattern pattern = Pattern.compile(instName);
        ArrayList<Device> toBeRemoved = new ArrayList<Device>();
        for (Device d : db.getObjects(Device.class)) {
            String name = d.getName();
            if (name == null || !pattern.matcher(name).matches()) continue;
            toBeRemoved.add(d);
        }
        for (Device d : toBeRemoved) {
            d.deleteFromDb(false, false);
            ++count;
        }
        ALog.logInfo((String)("Removed " + count + " devices"));
    }

    public static void deviceShorted() {
        Db db = OrbitApp.getCurDb();
        for (DeviceTemplate dt : db.getObjects(DeviceTemplate.class)) {
            HashSet<Net> nets = new HashSet<Net>();
            HashSet<Net> shortedNets = new HashSet<Net>();
            boolean deviceShorted = false;
            for (PinTemplate pt : dt.getPins()) {
                Net n = pt.getNet();
                if (!n.isUnused() && nets.contains(n)) {
                    shortedNets.add(n);
                    deviceShorted = true;
                    continue;
                }
                nets.add(n);
            }
            if (!deviceShorted) continue;
            ALog.logInfo((String)("DeviceTemplate " + dt.getName() + "has shorted nets"));
            for (Net n : shortedNets) {
                ALog.logInfo((String)n.getName());
            }
        }
    }

    public static void makeNetNamesGenericOnLowestLevel() {
        Db db = OrbitApp.getCurDb();
        for (DeviceTemplate deviceTemplate : db.getObjects(DeviceTemplate.class)) {
            if (deviceTemplate.childCount() != 0) continue;
            for (PinTemplate pinTemplate : deviceTemplate.getPins()) {
                Net currentNetOnPort = pinTemplate.getNet();
                if (currentNetOnPort == deviceTemplate.getNetUnused()) continue;
                String requestedName = pinTemplate.getName();
                if (pinTemplate.getNet().getName().equals(requestedName)) continue;
                Net currentNetOnTemplateUsingName = deviceTemplate.getNet(requestedName);
                if (currentNetOnTemplateUsingName == null) {
                    ALog.logInfo((String)(deviceTemplate.getName() + " pin " + pinTemplate.getName() + " changed from " + pinTemplate.getNet().getName() + " to " + requestedName));
                    currentNetOnPort.setName(requestedName);
                    continue;
                }
                ALog.logInfo((String)(deviceTemplate.getName() + " pin " + pinTemplate.getName() + " moved " + pinTemplate.getNet().getName() + " to " + requestedName));
                pinTemplate.setNet(currentNetOnTemplateUsingName);
            }
        }
    }

    public static void setPinType(String substrateName, String deviceTemplateName, String pinName, PinTemplate.Type type) {
        Db db = OrbitApp.getCurDb();
        Substrate s = Substrate.getSubstrate((Db)db, (String)substrateName);
        if (s == null) {
            ALog.logWarn((String)("Substrate " + substrateName + " not found"));
            return;
        }
        DeviceTemplate t = DeviceTemplate.get((Db)db, (String)substrateName, (String)deviceTemplateName);
        if (t == null) {
            ALog.logWarn((String)("Device Template  " + deviceTemplateName + " not found"));
            return;
        }
        PinTemplate pt = t.getPinByName(pinName);
        if (pt == null) {
            ALog.logWarn((String)("Pin Template  " + pinName + " not found"));
            return;
        }
        ALog.logInfo((String)("Pin " + pinName + " being changed from " + pt.getType().toString() + " to " + type.toString()));
        pt.setType(type);
    }

    public static void setPinType(String devicePathString, String pinName, PinTemplate.Type type) {
        Db db = OrbitApp.getCurDb();
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePathString);
        if (dp == null) {
            ALog.logWarn((String)("Device Path " + dp + " is not a valid DevicePath"));
            return;
        }
        DeviceTemplate t = dp.getLast().getTemplate();
        PinTemplate pt = t.getPinByName(pinName);
        if (pt == null) {
            ALog.logWarn((String)("Pin Template  " + pinName + " not found"));
            return;
        }
        ALog.logInfo((String)("Pin " + pinName + " being changed from " + pt.getType().toString() + " to " + type.toString()));
        pt.setType(type);
    }

    public static void replaceMyTemplate(String devicePathString, String newTemplateName) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)(devicePathString + " is not a valid device path"));
            return;
        }
        Device device = devicePath.getLast();
        DeviceTemplate newTemplate = DeviceTemplate.getDeviceTemplate((Substrate)device.getSubstrate(), (String)newTemplateName);
        if (newTemplate == null) {
            ALog.logWarn((String)(newTemplateName + " is not a valid template"));
            return;
        }
        device.replaceTemplate(newTemplate);
    }

    public static boolean doesTemplateHaveLayer(DeviceTemplate dt, String layerName) {
        for (PinTemplate pinTemplate : dt.getPins()) {
            for (PortTemplate portTemplate : pinTemplate.getPortTemplates()) {
                PadTemplate padTemplate = portTemplate.getPadTemplate();
                for (LayerShape layerShape : padTemplate.getLayerShapes()) {
                    String thisLayerName = layerShape.getLayer().getName();
                    if (!thisLayerName.equals(layerName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void addObstacle(String devicePath) {
        DevicePath dp = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePath);
        if (dp == null) {
            return;
        }
        Device device = dp.getLast();
        DeviceTemplate dt = device.getTemplate();
        String lName = "TOP";
        Db db = OrbitApp.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        Unit.Distance unit = currentDesign.getUnit();
        long diameter = unit.fromUser(6000.0);
        ARect parentRect = dt.getBB();
        Substrate s = dt.getSubstrate();
        Layer l = Layer.get((Db)OrbitApp.getCurDb(), (Substrate)s, (String)lName);
        long x = parentRect.left() + diameter / 2L;
        long y = parentRect.bottom() + diameter / 2L;
        ACircle c0 = new ACircle(x, y, diameter / 2L);
        Metal.create((Net)dt.getNetUnused(), (Layer)l, (AGeom)c0);
        Obstacle o0 = Obstacle.create((DeviceTemplate)dt, (Obstacle.ObstacleType)Obstacle.ObstacleType.Placement);
        LayerShape.create((Layer)l, (DbObject)o0, (AGeom)c0);
        x = parentRect.right() - diameter / 2L;
        y = parentRect.bottom() + diameter / 2L;
        ACircle c1 = new ACircle(x, y, diameter / 2L);
        Metal.create((Net)dt.getNetUnused(), (Layer)l, (AGeom)c1);
        Obstacle o1 = Obstacle.create((DeviceTemplate)dt, (Obstacle.ObstacleType)Obstacle.ObstacleType.Placement);
        LayerShape.create((Layer)l, (DbObject)o1, (AGeom)c1);
        x = parentRect.left() + diameter / 2L;
        y = parentRect.top() - diameter / 2L;
        ACircle c2 = new ACircle(x, y, diameter / 2L);
        Metal.create((Net)dt.getNetUnused(), (Layer)l, (AGeom)c2);
        Obstacle o2 = Obstacle.create((DeviceTemplate)dt, (Obstacle.ObstacleType)Obstacle.ObstacleType.Placement);
        LayerShape.create((Layer)l, (DbObject)o2, (AGeom)c2);
        x = parentRect.right() - diameter / 2L;
        y = parentRect.top() - diameter / 2L;
        ACircle c3 = new ACircle(x, y, diameter / 2L);
        Metal.create((Net)dt.getNetUnused(), (Layer)l, (AGeom)c3);
        Obstacle o3 = Obstacle.create((DeviceTemplate)dt, (Obstacle.ObstacleType)Obstacle.ObstacleType.Placement);
        LayerShape.create((Layer)l, (DbObject)o3, (AGeom)c3);
        dt.invalidateAll2DIndices();
    }

    public static void busView(String devicePath) {
        DevicePath dp = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePath);
        if (dp == null) {
            return;
        }
        BusView.showBusView();
    }

    public static void markDevicesWithZeroAreaOnLayer(String pathString, String layerName) {
        Db db = OrbitApp.getCurDb();
        DevicePath path = DevicePath.fromString((Db)db, (String)pathString);
        for (DevicePath dp : path.getDescendants()) {
            DeviceTemplate dt = dp.getLast().getTemplate();
            for (PinTemplate pinTemplate : dt.getPins()) {
                for (PortTemplate portTemplate : pinTemplate.getPortTemplates()) {
                    PadTemplate padTemplate = portTemplate.getPadTemplate();
                    for (LayerShape layerShape : padTemplate.getLayerShapes()) {
                        ARect r;
                        String thisLayerName = layerShape.getLayer().getName();
                        if (!thisLayerName.equals(layerName) || (r = layerShape.getBounds()).getArea() != 0.0) continue;
                        Long l = Design.micronToInternal((Db)db, (double)10.0);
                        layerShape.setGeom((AGeom)new ARect(-l.longValue(), -l.longValue(), l.longValue(), l.longValue()));
                        ALog.logInfo((String)(dp.getString() + "  " + pinTemplate.getName()));
                    }
                }
            }
        }
    }

    public static void mapToCore(String devicePathString) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePathString);
        if (devicePath == null) {
            ALog.flogError((String)"%s does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        CoreFactory cf = new CoreFactory(devicePathString);
        int count = 0;
        for (DevicePath child : AUtil.linkedList((Iterator)devicePath.pathToLowestDie().getDescendants())) {
            if (cf.pathInCore(child)) {
                ALog.logInfo((String)("Doing something special with " + child.toString()));
                continue;
            }
            for (PinInstance pi : child.getLast().getPins()) {
                PinTemplate pt = pi.getPinTemplate();
                Net currentTopNet = NetMap.getTopmostNet((Net)pt.getNet(), (DevicePath)child);
                String currentNetName = currentTopNet.getName();
                if (pt.getUserFunction().contains("to_core")) {
                    cf.connectToCore(child.toString(), pt.getName(), "CORE_" + currentNetName, "NET_" + currentNetName, PinTemplate.Direction.OUT);
                    ++count;
                    continue;
                }
                if (!pt.getUserFunction().contains("from_core")) continue;
                cf.connectToCore(child.toString(), pt.getName(), "CORE_" + currentNetName, "NET_" + currentNetName, PinTemplate.Direction.IN);
                ++count;
            }
        }
        ALog.logInfo((String)(count + " Connections made to the core"));
    }

    public static void shortNets(String devicePathString, String fromNet, String toNet) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate dt = devicePath.getLast().getTemplate();
        Net from = dt.getNet(fromNet);
        if (from == null) {
            ALog.logError((String)(fromNet + " Does not exist"));
            return;
        }
        Net to = dt.getNet(toNet);
        if (to == null) {
            ALog.logError((String)(toNet + " Does not exist"));
            return;
        }
        from.moveContents(to);
    }

    public static void moveRelative(String devicePath, double dx, double dy) {
        Unit unit = OrbitIO.getCurView().getUnit();
        long wdx = unit.fromUser(dx);
        long wdy = unit.fromUser(dy);
        DevicePath p = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePath);
        if (p == null) {
            ALog.logError((String)"Unable to find specified device.");
            return;
        }
        APoint2D origin = p.getOrigin();
        origin.moveBy(wdx, wdy);
        UserCommands.moveDevice(devicePath, origin.getX(), origin.getY());
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void devicePortInfo(String devicePath) {
        APolygon test = new APolygon();
        test.addPoint(0L, 0L);
        test.addPoint(100L, 0L);
        test.addPoint(100L, 100L);
        test.addPoint(0L, 100L);
        test.moveBy(100L, 100L);
        ALog.logInfo((String)("" + test.getArea()));
        DevicePath p = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePath);
        if (p == null) {
            ALog.logError((String)"Unable to find specified device.");
            return;
        }
        Device d = p.getLast();
        DeviceTemplate t = d.getTemplate();
        for (PinTemplate pt : t.getPins()) {
            for (PortTemplate port : pt.getPortTemplates()) {
                for (LayerShape ls : port.getLayerShapes()) {
                    ALog.logInfo((String)("Layer " + ls.getLayer().getName() + " " + ls.getGeom().toString() + " " + ls.getGeom().getArea()));
                }
                APair info = port.getLargestGeom(null);
                ALog.logInfo((String)("Largest " + ((LayerShape)info.first).getLayer().getName() + " " + (Double)info.second));
            }
        }
    }

    public static void registerIOViewListener() {
        class MyIOViewListener
        implements IOView.ExternalListener {
            MyIOViewListener() {
            }

            @Override
            public void interfaceChangedHierarchy(DevicePath intrface, DevicePath oldParent, DevicePath newParent) {
                ALog.logInfo((String)("Moved " + intrface.toString() + " from " + oldParent.toString() + " to " + newParent.toString()));
            }

            @Override
            public void interfaceDecorated(DevicePath path) {
                int numDevices = path.getLast().getTemplate().childCount();
                ALog.logInfo((String)(path.toString() + " has just been decorated and has " + numDevices + " devices"));
            }
        }
        MyIOViewListener mine = new MyIOViewListener();
        IOView.theIOView.addListener(mine);
        Device die = IOView.theIOView.getRootDevicePath().getLast();
        if (die != null) {
            Substrate s = die.getSubstrate();
            s.setValue("IOView.ShowTopLevelNetIcon", (Object)true);
            s.setValue("IOView.DisplayPinsInTechnologyOrder", (Object)true);
        }
    }

    public static void interfacePropertySetter(String fileName) {
        FileReader fr;
        Db db = OrbitApp.getCurDb();
        try {
            fr = new FileReader(fileName);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error opening input file '%s'.", (Object[])new Object[]{fileName});
            return;
        }
        CsvIo.CsvIn csvReader = new CsvIo.CsvIn(fr);
        String[] header = csvReader.readLine();
        String[] line = csvReader.readLine();
        while (line != null) {
            if (line.length != 1 || line[0].trim().length() != 0) {
                DevicePath dp = DevicePath.fromString((Db)db, (String)line[0]);
                if (dp == null) {
                    ALog.logInfo((String)(line[0] + " is not a device"));
                } else {
                    dp.getLast().setValue(header[1], (Object)line[1]);
                    dp.getLast().setValue(header[2], (Object)line[2]);
                    ALog.logInfo((String)(dp.getString() + " " + dp.getLast().getValue(header[1]) + " " + dp.getLast().getValue(header[2])));
                }
            }
            line = csvReader.readLine();
        }
        try {
            fr.close();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error closing file", (Object[])new Object[0]);
        }
    }

    public static void synthesizePinPersonalities(String devicePathString) {
        DevicePath parentPath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePathString);
        if (parentPath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate devTemp = parentPath.getDeviceTemplate();
        Personality.resetColor();
        for (DevicePath devicePath : parentPath.getDescendants()) {
            if (devicePath.getLast().getTemplate() != devTemp) continue;
            for (PinInstance pi : devicePath.getLast().getPins()) {
                Personality p;
                Net top = NetMap.getTopmostNet((Net)pi.getNet(), (DevicePath)devicePath);
                if (top.isUnused()) continue;
                String name = top.getName();
                String lowerName = name.toLowerCase();
                if (lowerName.startsWith("gnd") || lowerName.startsWith("ground") || lowerName.startsWith("vs")) {
                    p = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT, (String)name, per -> per.setColor(Color.black));
                    pi.assignToPersonality(p);
                    continue;
                }
                if (lowerName.startsWith("vd")) {
                    p = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT, (String)name, per -> {
                        int hashcode = name.hashCode();
                        Color c = AUtil.colorFromString((String)Personality.colorFromHash((int)hashcode));
                        per.setColor(c);
                    });
                    pi.assignToPersonality(p);
                    continue;
                }
                Personality signalPersonality = Personality.getOrCreate((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT, (String)"signal", per -> per.setColor(Color.blue));
                pi.assignToPersonality(signalPersonality);
            }
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void importIBMNetList(String fileName, String devicePathToPackage) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePathToPackage);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathToPackage});
            return;
        }
        HashMap<CallSite, PinTemplate> nameToPt = new HashMap<CallSite, PinTemplate>();
        for (DevicePath child : devicePath.getDescendants(true)) {
            for (PinTemplate pt : child.getDeviceTemplate().getPins()) {
                nameToPt.put((CallSite)((Object)(child.getLast().getName() + pt.getName())), pt);
            }
        }
        Device thePackage = devicePath.getLast();
        DeviceTemplate thePackageTemplate = thePackage.getTemplate();
        ACsvReader csvReader = new ACsvReader();
        if (!csvReader.openFile(fileName)) {
            csvReader.close();
            return;
        }
        int lineCount = 0;
        for (String[] row : csvReader.getRows()) {
            if (++lineCount == 1) continue;
            boolean first = true;
            String netName = "";
            Net packageNet = null;
            for (String cell : row) {
                if (first) {
                    netName = cell;
                    first = false;
                    packageNet = thePackageTemplate.getNet(netName);
                    if (packageNet != null) continue;
                    packageNet = Net.create((DeviceTemplate)thePackageTemplate, (String)netName);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(cell, " ");
                while (st.hasMoreTokens()) {
                    String devicePin = st.nextToken();
                    int dotPos = devicePin.indexOf(".");
                    if (dotPos <= 0) {
                        ALog.logInfo((String)("Invalid DevicePin Name" + devicePin));
                        continue;
                    }
                    String device = devicePin.substring(0, dotPos);
                    String pin = devicePin.substring(dotPos + 1);
                    if (device.isEmpty()) {
                        ALog.logInfo((String)("Invalid DevicePin Name" + devicePin));
                        continue;
                    }
                    if (pin.isEmpty()) {
                        ALog.logInfo((String)("Invalid DevicePin Name" + devicePin));
                        continue;
                    }
                    Device theDevice = null;
                    for (Device d : db.getObjects(Device.class)) {
                        if (!d.getName().equalsIgnoreCase(device)) continue;
                        theDevice = d;
                        break;
                    }
                    if (theDevice == null) {
                        ALog.logInfo((String)(device + " does not exist"));
                        continue;
                    }
                    PinTemplate pt = (PinTemplate)nameToPt.get(theDevice.getName() + pin);
                    if (pt == null) {
                        ALog.logInfo((String)("Invalid Pin Name " + pin));
                        continue;
                    }
                    Net deviceNet = pt.getNet();
                    if (deviceNet.isUnused()) {
                        String deviceNetName = pin;
                        deviceNet = Net.create((DeviceTemplate)theDevice.getTemplate(), (String)deviceNetName);
                    }
                    if (!theDevice.equals(thePackage)) {
                        pt.setNet(deviceNet);
                        NetMap.mapChildNet((Device)theDevice, (Net)deviceNet, (Net)packageNet);
                        continue;
                    }
                    pt.setNet(packageNet);
                }
            }
        }
        csvReader.close();
    }

    public static void setAllToSynthesized() {
        Db db = OrbitApp.getCurDb();
        for (Device d : db.getObjects(Device.class)) {
            d.setSynthesized(true);
        }
    }

    public static void setPinsToUnused(String devicePathString) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Substrate start = devicePath.getSubstrate();
        for (DevicePath child : devicePath.getDescendants()) {
            if (!child.getSubstrate().equals((Object)start)) continue;
            DeviceTemplate t = child.getLast().getTemplate();
            Net unused = t.getNet("NetUnused");
            if (unused == null) {
                unused = Net.create((DeviceTemplate)t, (String)"NetUnused");
            }
            for (PinTemplate pt : AUtil.hashSet((Iterator)t.getPins())) {
                pt.setNet(unused);
            }
        }
    }

    public static void createPowerNets(String devicePathString, int minSize, String name) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitApp.getCurDb(), (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate dt = devicePath.getLast().getTemplate();
        Personality powerP = Personality.getOrCreate((DeviceTemplate)dt, (Personality.Type)Personality.Type.NET, (String)name);
        Constraint.getOrCreate((DbObject)powerP, (Constraint.Descriptor)Constraint.IS_POWER, (Object)true);
        for (Net n : dt.getNets()) {
            int count = NetMap.getConnectedDevicePathPortsCount((Net)n, (DevicePath)devicePath, (int)minSize);
            if (count < minSize) continue;
            n.assignToPersonality(powerP, devicePath);
        }
    }

    public static void writeRouteReport() {
        RouterReportWriter rrw = new RouterReportWriter();
        rrw.setMode(RouterReportWriter.ReportMode.Regression);
        rrw.write();
    }

    public static void getMateName(String devicePathString, String netName) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate deviceTemplate = devicePath.getLast().getTemplate();
        Net n = deviceTemplate.getNet(netName);
        if (n != null) {
            Net mate = Net.getDiffPairMate((Net)n, (DevicePath)devicePath);
            if (mate == null) {
                ALog.logInfo((String)(netName + " has no mate"));
            } else {
                ALog.logInfo((String)mate.getName());
            }
        }
    }

    public static void bundleRouteFixedSide() {
        BundleRoutePrep.prepareForRouting(OrbitApp.getCurDb(), true);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void bundleRouteFreeSide() {
        BundleRoutePrep.prepareForRouting(OrbitApp.getCurDb(), false);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void bundleSelEditLayers() {
        Db curDb = OrbitApp.getCurDb();
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Object b : Selection.getCurrentSelectionForDb((Db)curDb).get(Bundle.class)) {
            bundles.add((Bundle)b);
        }
        if (bundles.isEmpty()) {
            return;
        }
        DeviceTemplate dt = ((Bundle)bundles.get(0)).getTemplate();
        for (Bundle b : bundles) {
            DeviceTemplate t = b.getTemplate();
            if (dt == t) continue;
            ALog.logWarn((String)"Edit bundles layer in different device templates");
            return;
        }
        HashSet<Layer> preSelected = new HashSet<Layer>();
        preSelected.addAll(((Bundle)bundles.get(0)).getLayers());
        LayerSelectorDlg lsd = LayerSelectorDlg.showMe(OrbitIO.getCurView(), dt.getSubstrate(), preSelected);
        if (lsd.getUserOked()) {
            try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)curDb, (String)"Edit Layers Selected");){
                boolean canAutoAssignColor = lsd.getSelected().size() == 1;
                Color layerColor = null;
                if (canAutoAssignColor) {
                    for (Layer l2 : lsd.getSelected()) {
                        layerColor = l2.getColor();
                    }
                    canAutoAssignColor &= layerColor != null;
                }
                for (Bundle b : bundles) {
                    b.clearLayers();
                    lsd.getSelected().forEach(l -> b.addLayer(l));
                    if (!canAutoAssignColor) continue;
                    b.setColor(layerColor);
                }
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static void changeBoundsBy(String devicePathString, double uDxLeft, double uDyBottom, double uDxRight, double uDyTop) {
        Db db = OrbitApp.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate deviceTemplate = devicePath.getLast().getTemplate();
        ARect current = deviceTemplate.getBB();
        long l = unit.fromUser(uDxLeft);
        long b = unit.fromUser(uDyBottom);
        long r = unit.fromUser(uDxRight);
        long t = unit.fromUser(uDyTop);
        current.setBounds(current.left() + l, current.bottom() + b, current.right() + r, current.top() + t);
        deviceTemplate.setBounds((AGeom)current);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void synFloorplans(String devicePathString) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Personality ioPersonality = Personality.getPersonality((DeviceTemplate)devicePath.getDeviceTemplate(), (Personality.Type)Personality.Type.PORT, (String)"signal").orElse(null);
        DeviceTemplate template = devicePath.getDeviceTemplate();
        for (DevicePath child : devicePath.getChildren()) {
            String name;
            boolean exist;
            if (!child.getLast().getType().equals((Object)DeviceTemplate.Type.MACRO) || (exist = Interface.findOneNamed((Db)db, (String)(name = child.getLast().getName())) != null)) continue;
            Interface parent = Interface.create((Db)db, (String)name, null, (int)43, (boolean)true);
            Floorplan fp = parent.getFloorplan(template, true);
            for (PinInstance pi : child.getLast().getPins()) {
                fp.addPin(StoredPath.get((DevicePath)child), pi);
            }
            if (ioPersonality == null) continue;
            PersonalityMap.create((Personality)ioPersonality, (DevicePath)devicePath, (DbObject)fp);
        }
    }

    public static void import2ColumnNetList(String filePath, String devicePathString) throws CSVDOMParser.CSVDOMException {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        HashMap<String, HierPin> pins = new HashMap<String, HierPin>();
        for (DevicePath descendent : devicePath.getDescendants()) {
            if (descendent.getSubstrate() != devicePath.getSubstrate()) continue;
            for (PinInstance pi : descendent.getLast().getPins()) {
                pins.put(pi.getName(), new HierPin(descendent, pi));
            }
        }
        CSVDOMParser parser2 = new CSVDOMParser(true, null);
        parser2.setDataSepExpression(",|\\s+");
        CSVDocument doc = parser2.parse(filePath);
        int count = 0;
        int newCount = 0;
        HashSet<String> pinNames = new HashSet<String>();
        HashSet<String> netNames = new HashSet<String>();
        for (int i = 0; i < doc.getItemCount(); ++i) {
            String nName = doc.getItemValue(i, "net");
            String pName = doc.getItemValue(i, "pin");
            if (pinNames.contains(pName)) {
                ALog.logWarn((String)("Pin " + pName + " found multiple times, ignoring"));
                continue;
            }
            pinNames.add(pName);
            if (netNames.contains(nName)) {
                ALog.logWarn((String)("Net " + nName + " found multiple times, ignoring"));
                continue;
            }
            netNames.add(nName);
            HierPin hp = (HierPin)pins.get(pName);
            if (hp != null) {
                pins.remove(pName);
                DevicePath pathToMapThrough = new DevicePath((DevicePath)hp.first);
                while (pathToMapThrough.getFirst().getTemplate().getType() != DeviceTemplate.Type.DIE) {
                    pathToMapThrough.removeFirst();
                }
                Net currentNet = NetMap.getNetAt((Net)((PinInstance)hp.second).getNet(), (DevicePath)((DevicePath)hp.first), (DeviceTemplate)devicePath.getLast().getTemplate());
                ((PinInstance)hp.second).getPinTemplate().mapNetUpPath(pathToMapThrough, devicePath.getLast().getTemplate(), nName);
                Net newNet = NetMap.getNetAt((Net)((PinInstance)hp.second).getNet(), (DevicePath)((DevicePath)hp.first), (DeviceTemplate)devicePath.getLast().getTemplate());
                if (currentNet != newNet) {
                    ++newCount;
                }
                ++count;
                continue;
            }
            ALog.logWarn((String)("Pin " + pName + " not found"));
        }
        ALog.logInfo((String)(count + " nets read, " + newCount + " nets changed."));
        Net.deleteImmaterialNets((Db)db, (boolean)false);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void import2ColumnNetListSimple(String filePath, String devicePathString) throws CSVDOMParser.CSVDOMException {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        CSVDOMParser parser2 = new CSVDOMParser(true, null);
        parser2.setDataSepExpression(",|\\s+");
        CSVDocument doc = parser2.parse(filePath);
        HashSet<String> pinNames = new HashSet<String>();
        HashSet<String> netNames = new HashSet<String>();
        for (int i = 0; i < doc.getItemCount(); ++i) {
            String nName = doc.getItemValue(i, "net");
            String pName = doc.getItemValue(i, "pin");
            if (pinNames.contains(pName)) {
                ALog.logWarn((String)("Pin " + pName + " found multiple times, ignoring"));
                continue;
            }
            pinNames.add(pName);
            if (netNames.contains(nName)) {
                ALog.logWarn((String)("Net " + nName + " found multiple times, ignoring"));
                continue;
            }
            netNames.add(nName);
            PinTemplate pt = devicePath.getDeviceTemplate().getPinByName(pName);
            if (pt != null) {
                Net n = devicePath.getDeviceTemplate().getNet(nName);
                if (n == null) {
                    n = devicePath.getDeviceTemplate().createNet(nName);
                }
                pt.setNet(n);
                continue;
            }
            ALog.logWarn((String)("Pin " + pName + " not found"));
        }
        Net.deleteImmaterialNets((Db)db, (boolean)false);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void moveShapesFromTo(String devicePathString, String fromLayer, String toLayer) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Substrate s = devicePath.getSubstrate();
        Layer from = s.getLayer(fromLayer);
        Layer to = s.getLayer(toLayer);
        if (from == null || to == null) {
            return;
        }
        for (PadTemplate pt : db.getObjects(PadTemplate.class)) {
            for (LayerShape ls : AUtil.arrayList((Iterator)pt.getLayerShapes(from))) {
                ls.setLayer(to);
            }
        }
    }

    public static void openSchemView(String devicePathString) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        AbstractView.create(null, OrbitIO.getCurView(), devicePathString);
    }

    public static void renameNets(String devicePathString, String prefix) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate dt = devicePath.getDeviceTemplate();
        for (Net n : dt.getNets()) {
            if (n.isUnused()) continue;
            n.setName(prefix + n.getName());
        }
    }

    public static void deleteUnplacedDevices() {
        Db db = OrbitApp.getCurDb();
        HashSet<Device> unplaced = new HashSet<Device>();
        for (Device d : db.getObjects(Device.class)) {
            if (d.getIsPlaced()) continue;
            unplaced.add(d);
        }
        for (Device d : unplaced) {
            d.deleteFromDb();
        }
    }

    public static void setBoundsToPinExtents(String pathName) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)pathName);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{pathName});
            return;
        }
        DeviceTemplate dt = devicePath.getDeviceTemplate();
        ARect r = new ARect();
        for (PinTemplate pt : dt.getPins()) {
            r.expand(pt.getLoc());
            ShowMeTheWay.addNet(pt.getNet(), devicePath);
        }
        dt.setBounds((AGeom)r);
    }

    public static void keepImportantLayers(String pathName) {
        Db db = OrbitApp.getCurDb();
        LinkedList<String> importantLayers = new LinkedList<String>();
        importantLayers.add("M8");
        importantLayers.add("M6");
        importantLayers.add("AP");
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)pathName);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{pathName});
            return;
        }
        Substrate s = devicePath.getSubstrate();
        for (Layer l : AUtil.linkedList((Iterator)s.getLayers())) {
            if (importantLayers.contains(l.getName())) continue;
            l.deleteFromDb(true);
        }
    }

    public static void exportPins(String devicePathString, String fileName) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate top = devicePath.getDeviceTemplate();
        try (FileWriter fw = new FileWriter(fileName);){
            Object buffer = "";
            buffer = "designW = " + top.getBB().width() / 1000L + ";\n";
            fw.write((String)buffer);
            buffer = "designH = " + top.getBB().height() / 1000L + ";\n";
            fw.write((String)buffer);
            buffer = "designX = " + top.getBB().left() / 1000L + ";\n";
            fw.write((String)buffer);
            buffer = "designY = " + top.getBB().bottom() / 1000L + ";\n";
            fw.write((String)buffer);
            fw.write("deriveWindowBounds ();");
            for (DevicePath desc : devicePath.getDescendants()) {
                DevicePath relPath = devicePath.getRelativePath(desc);
                ARect r = relPath.getBB();
                if (r != null) {
                    buffer = "ctx.strokeStyle = \"#00DD00\";\n";
                    fw.write((String)buffer);
                    buffer = "drawRect(" + r.getLL().getX() / 1000L + ", " + r.getLL().getY() / 1000L + "," + r.width() / 1000L + "," + r.height() / 1000L + ");\n";
                    fw.write((String)buffer);
                }
                buffer = "ctx.fillStyle = \"#00FF00\";\n";
                fw.write((String)buffer);
                DeviceTemplate dt = desc.getDeviceTemplate();
                for (PinTemplate pt : dt.getPins()) {
                    ARect rp = pt.getBounds();
                    rp = rp.transform(relPath.getTransform()).getBounds();
                    buffer = "fillRect(" + rp.getLL().getX() / 1000L + ", " + rp.getLL().getY() / 1000L + "," + rp.width() / 1000L + "," + rp.height() / 1000L + ");\n";
                    fw.write((String)buffer);
                }
            }
            fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void pfrect(PolyFactory pF, long xlo, long ylo, long xsize, long ysize, boolean positive) {
        PolyFactory.PolyFlow flow = PolyFactory.PolyFlow.CCW;
        PolyFactory.PolySense sense = positive ? PolyFactory.PolySense.POSITIVE : PolyFactory.PolySense.NEGATIVE;
        pF.beginPolygon(sense, flow);
        pF.addPoint(xlo, ylo);
        pF.addPoint(xlo + xsize, ylo);
        pF.addPoint(xlo + xsize, ylo + ysize);
        pF.addPoint(xlo, ylo + ysize);
        pF.endPolygon();
    }

    public static void buildPlane(String devicePathString, String layer, String net) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate dt = devicePath.getDeviceTemplate();
        Substrate s = dt.getSubstrate();
        Layer l = s.getLayer(layer);
        if (l == null) {
            ALog.logWarn((String)"Layer %s does not exist", (Object[])new Object[]{layer});
            return;
        }
        Net n = dt.getNet(net);
        if (n == null) {
            ALog.logWarn((String)"Net %s does not exit", (Object[])new Object[]{net});
            return;
        }
        ARect r = dt.getBB();
        PolyFactory pf = new PolyFactory();
        UserCommands.pfrect(pf, r.left(), r.bottom(), r.width(), r.height(), true);
        for (PinTemplate pt : dt.getPins()) {
            ARect b = pt.getBounds();
            UserCommands.pfrect(pf, b.left(), b.bottom(), b.width(), b.height(), false);
        }
        pf.flatten(PolyFactory.KeepDepth.ODD, PolyFactory.KeepZeroWidth.NONE);
        pf.fragment();
        pf.beginExtract();
        SimplePoint p = new SimplePoint();
        while (pf.getNextPolygon(PolyFactory.PolyFlow.CW)) {
            APolygon outer = new APolygon();
            while (pf.getNextPoint(p)) {
                outer.addPoint(p.x(), p.y());
            }
            Metal.create((Net)n, (Layer)l, (AGeom)outer);
        }
    }

    public static void smartPinSelect() {
        Db db = OrbitApp.getCurDb();
        ArrayList<HierPin> fromPins = new ArrayList<HierPin>();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        s.getSelectedHierInsts(PinInstance.class);
        for (PinInstance o : s.get(PinInstance.class)) {
            for (DevicePath dpath : s.getSelectedPaths((DbObject)o)) {
                fromPins.add(new HierPin(dpath, o));
            }
        }
        Selection.clearSelection();
        for (HierPin hp : fromPins) {
            Substrate substrate = hp.getSubstrate();
            for (HierInst hpt : NetMap.getConnectedHierPins((DevicePath)((DevicePath)hp.first), (Net)((PinInstance)hp.second).getNet())) {
                if (((PinTemplate)hpt.second).getSubstrate() == substrate) continue;
                PinInstance pi = PinInstance.getPinInstance((Device)hpt.getPath().getLast(), (PinTemplate)((PinTemplate)hpt.second));
                s.add((DbObject)pi);
            }
        }
    }

    public static void exportConnections(String fileName) {
        Db db = OrbitApp.getCurDb();
        try (FileWriter fw = new FileWriter(fileName);){
            for (Connection c : db.getObjects(Connection.class)) {
                ALine l = c.getLine();
                String commaLine = l.getP0().getX() + "," + l.getP0().getY() + "," + l.getP1().getX() + "," + l.getP1().getY() + "\n";
                fw.write(commaLine);
            }
            fw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void promoteIOViewInterfaceNames(String diePathName) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)diePathName);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{diePathName});
            return;
        }
        HashSet<Device> interfaces = new HashSet<Device>();
        for (Device child : devicePath.getDeviceTemplate().getChildren()) {
            if (child.getType() != DeviceTemplate.Type.PERSONALITY) continue;
            interfaces.add(child);
        }
    }

    public static void swapIODrivers(Device driver1, Device driver2, DevicePath diePath, String originLoc) {
        if (driver1.getIsFixed()) {
            ALog.logWarn((String)("Cannot swap fixed driver '" + driver1.getName() + "'"));
            return;
        }
        if (driver2.getIsFixed()) {
            ALog.logWarn((String)("Cannot swap fixed driver '" + driver2.getName() + "'"));
            return;
        }
        APoint2D loc1 = driver1.getLoc(diePath, originLoc);
        APoint2D loc2 = driver2.getLoc(diePath, originLoc);
        AGeomUtil.CompassDir side1 = driver1.driverSide(diePath, originLoc);
        long stable1 = driver1.driverStableCoordOffset(diePath, side1, originLoc);
        AGeomUtil.CompassDir side2 = driver2.driverSide(diePath, originLoc);
        long stable2 = driver2.driverStableCoordOffset(diePath, side2, originLoc);
        loc2 = driver1.adjustDriverLocationForStableCoordOffset(diePath, side2, originLoc, loc2, stable1);
        loc1 = driver2.adjustDriverLocationForStableCoordOffset(diePath, side1, originLoc, loc1, stable2);
        String side = driver1.getSide();
        boolean mirror = driver1.getMirror();
        float rotDelta = Device.rotationDelta((AGeomUtil.CompassDir)side2, (AGeomUtil.CompassDir)side1);
        DevicePath dp = diePath.withChild(driver2);
        if (dp.getMirror() && (double)rotDelta != 0.0) {
            rotDelta = -rotDelta;
        }
        float rot2 = dp.getRot() + rotDelta;
        rotDelta = Device.rotationDelta((AGeomUtil.CompassDir)side1, (AGeomUtil.CompassDir)side2);
        dp = diePath.withChild(driver1);
        if (dp.getMirror() && (double)rotDelta != 0.0) {
            rotDelta = -rotDelta;
        }
        float rot1 = dp.getRot() + rotDelta;
        driver1.setPosition(diePath, loc2, originLoc, rot1, driver2.getMirror());
        driver1.setSide(driver2.getSide());
        driver2.setPosition(diePath, loc1, originLoc, rot2, mirror);
        driver2.setSide(side);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void alignIODrivers(Device refDevice, DevicePath refDevicePath, Device movingDriver, DevicePath movingDriverPath, String originLoc) {
        UserCommands.alignIODriver(refDevice, refDevicePath, null, movingDriver, movingDriverPath, originLoc);
    }

    private static AGeomUtil.CompassDir calcNewSide(Device refDevice, DevicePath refDevicePath, AGeomUtil.CompassDir refSide, APoint2D loc1, String originLoc, Device movingDriver, DevicePath movingDriverPath, AGeomUtil.CompassDir origSide) {
        boolean left;
        ARect refBounds = refDevice.getWorldBound(refDevicePath);
        DevicePath movingDriverDiePath = movingDriverPath.pathToLowestOfType(DeviceTemplate.Type.DIE);
        DevicePath pth = movingDriverDiePath.getParent();
        ARect movingDriverDieBounds = movingDriverDiePath.getLast().getWorldBound(pth);
        AGeomUtil.CompassDir ans = origSide;
        boolean above = movingDriverDieBounds.bottom() > refBounds.top();
        boolean below = movingDriverDieBounds.top() < refBounds.bottom();
        boolean right = movingDriverDieBounds.left() > refBounds.right();
        boolean bl = left = movingDriverDieBounds.right() < refBounds.left();
        if (above && (right || left) || below && (right || left) || refBounds.contains((AGeom)movingDriverDieBounds) || movingDriverDieBounds.contains((AGeom)refBounds)) {
            ans = movingDriver.driverSideNearLoc(movingDriverPath, originLoc, loc1, refSide == AGeomUtil.CompassDir.N || refSide == AGeomUtil.CompassDir.S);
        } else if (above) {
            ans = AGeomUtil.CompassDir.S;
        } else if (below) {
            ans = AGeomUtil.CompassDir.N;
        } else if (right) {
            ans = AGeomUtil.CompassDir.W;
        } else if (left) {
            ans = AGeomUtil.CompassDir.E;
        }
        return ans;
    }

    private static AGeomUtil.CompassDir calcNewSide(APoint2D refLoc, DevicePath movingDriverPath) {
        DevicePath movingDriverDiePath = movingDriverPath.pathToLowestOfType(DeviceTemplate.Type.DIE);
        DevicePath pth = movingDriverDiePath.getParent();
        ARect movingDriverDieBounds = movingDriverDiePath.getLast().getWorldBound(pth);
        return movingDriverDieBounds.closestSide(refLoc);
    }

    public static boolean alignIODriver(Device refDevice, DevicePath refDevicePath, HierPin alignPin, Device movingDriver, DevicePath movingDriverPath, String originLoc) {
        long newX;
        long newY;
        if (originLoc.equals("IOpad center")) {
            APoint2D snappedPosition;
            APoint2D loc1 = null;
            AGeomUtil.CompassDir side1 = AGeomUtil.CompassDir.N;
            if (alignPin == null) {
                loc1 = refDevice.getLoc(refDevicePath, originLoc);
            }
            if (alignPin != null && refDevicePath == null) {
                loc1 = alignPin.getWorldLoc();
            } else {
                DevicePath pinPath = refDevicePath.withChild(refDevice);
                if (alignPin != null) {
                    loc1 = alignPin.getWorldLoc();
                    side1 = ((PinInstance)alignPin.second).getSide(pinPath);
                }
            }
            if (loc1 == null) {
                return false;
            }
            APoint2D loc2 = movingDriver.getLoc(movingDriverPath, originLoc);
            if (alignPin == null) {
                side1 = refDevice.driverSide(refDevicePath, originLoc);
            }
            AGeomUtil.CompassDir side2 = movingDriver.driverSide(movingDriverPath, originLoc);
            AGeomUtil.CompassDir newSide2 = refDevice != null ? UserCommands.calcNewSide(refDevice, refDevicePath, side1, loc1, originLoc, movingDriver, movingDriverPath, side2) : UserCommands.calcNewSide(loc1, movingDriverPath);
            long stable2 = movingDriver.driverStableCoordOffset(movingDriverPath, side2, originLoc);
            loc2 = movingDriver.adjustDriverLocationForStableCoordOffset(movingDriverPath, newSide2, originLoc, loc1, stable2);
            float rotDelta = Device.rotationDelta((AGeomUtil.CompassDir)side2, (AGeomUtil.CompassDir)newSide2);
            DevicePath dp = movingDriverPath.copy();
            if (dp.getLast() != movingDriver) {
                dp.add(movingDriver);
            }
            if ((snappedPosition = OrbitGridUtil.getSnapWorld((HierInst)new HierInst(dp, (DbObject)movingDriver), (APoint2D)loc2)) == null) {
                snappedPosition = loc2;
            }
            if (dp.getMirror()) {
                rotDelta = (float)(360.0 - (double)rotDelta);
            }
            movingDriver.setPosition(movingDriverPath, snappedPosition, originLoc, dp.getRot() + rotDelta, dp.getMirror());
            if (side2 != newSide2 && movingDriver.getSide() != null) {
                movingDriver.setSide("");
            }
            movingDriver.setIsPlaced(true);
            OrbitIO.getApp().refreshCurrentView(false);
            return true;
        }
        APoint2D refLoc = refDevice.getWorldLoc(refDevicePath);
        APoint2D loc = movingDriver.getWorldLoc(movingDriverPath);
        DevicePath driverDiePath = movingDriverPath.pathToLowestDie();
        Device driverDie = driverDiePath.getDevice();
        driverDiePath = driverDiePath.parentPath();
        ARect driverDieBounds = driverDie.getWorldBound(driverDiePath);
        AGeomUtil.CompassDir driverSide = movingDriver.driverSide(movingDriverPath, originLoc);
        long driverStableOffset = movingDriver.driverStableCoordOffset(movingDriverPath, driverSide, originLoc);
        AGeomUtil.CompassDir refDriverSide = refDevice.driverSide(refDevicePath, originLoc);
        switch (refDriverSide) {
            case N: {
                newY = driverDieBounds.top() - driverStableOffset;
                newX = refLoc.getX();
                break;
            }
            case S: {
                newY = driverDieBounds.bottom() + driverStableOffset;
                newX = refLoc.getX();
                break;
            }
            case E: {
                newX = driverDieBounds.right() - driverStableOffset;
                newY = refLoc.getY();
                break;
            }
            default: {
                newX = driverDieBounds.left() + driverStableOffset;
                newY = refLoc.getY();
            }
        }
        long deltaX = loc.getX() - newX;
        long deltaY = loc.getY() - newY;
        loc = movingDriver.getLoc();
        float rotDelta = Device.rotationDelta((AGeomUtil.CompassDir)driverSide, (AGeomUtil.CompassDir)refDriverSide);
        movingDriver.setLoc(new APoint2D(loc.getX() - deltaX, loc.getY() - deltaY));
        if ((double)rotDelta != 0.0) {
            movingDriver.setRotate(movingDriver.getRotate() + rotDelta);
        }
        return true;
    }

    public static void alignIODriversWithConnected(Device refDriver, String originLoc) {
        Db db = refDriver.getDb();
        Selection selection = Design.getSelection((Db)db);
        Selection.SelSet selSet = selection.getSelSet(db.getDbClass(Device.class));
        for (APair thePair : selSet.getElements()) {
            if (!(thePair.second instanceof Device)) continue;
            Device device = (Device)thePair.second;
            List connectedDrivers = device.getSameNetDrivers((DevicePath)thePair.first);
            for (Device curDevice : connectedDrivers) {
                curDevice.getAllPaths().forEach(dp -> UserCommands.alignIODrivers(device, (DevicePath)thePair.first, curDevice, dp.getParent(), originLoc));
            }
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static List<DevicePath> addConnectedDevicePathsToList(DevicePath refDevicePath, DbObject deviceOrPin, List<DevicePath> pathList) {
        List ans = pathList;
        if (ans == null) {
            ans = new LinkedList<DevicePath>();
        }
        if (deviceOrPin instanceof Device) {
            ans = ((Device)deviceOrPin).addConnectedDiesToList(refDevicePath, ans);
        } else if (deviceOrPin instanceof PinInstance) {
            ans = ((PinInstance)deviceOrPin).addConnectedPackagesToList(refDevicePath, ans);
        }
        return ans;
    }

    public static List<DevicePath> addDriversAndPackagesConnectedToSelected(Db db, List<DevicePath> pathList) {
        Selection selection = Design.getSelection((Db)db);
        Selection.SelSet selSet = selection.getSelSet(db.getDbClass(Device.class));
        List<DevicePath> ans = null;
        for (APair thePair : selSet.getElements()) {
            ans = UserCommands.addConnectedDevicePathsToList((DevicePath)thePair.first, (DbObject)thePair.second, ans);
        }
        selSet = selection.getSelSet(db.getDbClass(PinInstance.class));
        for (APair thePair : selSet.getElements()) {
            ans = UserCommands.addConnectedDevicePathsToList((DevicePath)thePair.first, (DbObject)thePair.second, ans);
        }
        return ans;
    }

    public static List<String> getDriversAndPackagesConnectedToSelected(Db db) {
        List<DevicePath> paths = UserCommands.addDriversAndPackagesConnectedToSelected(db, null);
        LinkedList<String> ans = new LinkedList<String>();
        for (DevicePath devPath : paths) {
            ans.add(DevicePath.getUserDisplayName((DevicePath)devPath));
        }
        if (ans.size() > 1) {
            ans.sort((Comparator<String>)AAlphaNumComp.get());
        }
        return ans;
    }

    public static void alignSelectedTo(Db db, String devPathStr) {
        UserCommands.alignSelectedTo(db, devPathStr, false);
    }

    public static void alignSelectedTo(Db db, String devPathStr, boolean doReschedule) {
        boolean connectionsNeedToUpdate = true;
        DevicePath referenceDevicePath = DevicePath.fromEscapedString((Db)db, (String)devPathStr);
        Device last = referenceDevicePath.getLast();
        if (last.isPackage()) {
            UserCommands.rescheduleBumpOrBalls(db);
        } else if (!doReschedule) {
            UserCommands.alignToDie(db, referenceDevicePath);
        } else {
            UserCommands.reorderAndRepositionDriversToReschedule(db, referenceDevicePath);
            connectionsNeedToUpdate = false;
        }
        if (connectionsNeedToUpdate) {
            HConnEngine ce = new HConnEngine(db);
            ce.createConnections();
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    static int fixedCount(Set<Connection> connections, DevicePath referenceDevicePath) {
        int ans = 0;
        for (Connection connection : connections) {
            if (connection == null) break;
            HierPin driverEnd = connection.getDriverEnd(referenceDevicePath);
            if (driverEnd == null || !driverEnd.getDbObject().getDevice().getIsFixed()) continue;
            ++ans;
        }
        return ans;
    }

    public static void alignSelectedToBumpsOrBalls(Db db, String devPathStr, long worldX, long worldY) {
        Connection connection;
        DevicePath referenceDevicePath = DevicePath.fromEscapedString((Db)db, (String)devPathStr);
        Selection selection = Design.getSelection((Db)db);
        Set connections = selection.connectionsOfDriversBallsOrBumps();
        if ((connections = Selection.filterConnectionsIncludeDriverNear((Set)connections, (long)worldX, (long)worldY, (DevicePath)referenceDevicePath)).isEmpty()) {
            return;
        }
        LinkedList<DevicePath> paths = new LinkedList<DevicePath>();
        boolean allInsideBounds = true;
        int numFixed = UserCommands.fixedCount(connections, referenceDevicePath);
        if (numFixed > 0) {
            ALog.logWarn((String)"%d selected devices are fixed. This command cannot be used with fixed devices.", (Object[])new Object[]{numFixed});
            return;
        }
        Iterator iterator = connections.iterator();
        while (iterator.hasNext() && (connection = (Connection)iterator.next()) != null) {
            HierPin driverEnd = connection.getDriverEnd(referenceDevicePath);
            HierPin alignToEnd = connection.getNonDriverEnd(referenceDevicePath);
            if (driverEnd == null || alignToEnd == null || !connection.hasEndOnDieOrPackage(referenceDevicePath) || !UserCommands.alignIODriver(null, null, alignToEnd, driverEnd.getDbObject().getDevice(), driverEnd.getPath(), "IOpad center")) continue;
            paths.add(driverEnd.getPath().copy());
            allInsideBounds &= driverEnd.getDbObject().getDevice().driverInsideParentDie(driverEnd.getPath());
        }
        if (!allInsideBounds) {
            UserCommands.putDriversInsideDieBounds(paths);
        }
    }

    private static void alignToDie(Db db, DevicePath referenceDevicePath) {
        boolean allInsideBounds = true;
        String originLoc = "IOpad center";
        LinkedList<DevicePath> paths = new LinkedList<DevicePath>();
        LinkedList<Object> removeFromSelection = new LinkedList<Object>();
        Selection selection = Design.getSelection((Db)db);
        Selection.SelSet selSet = selection.getSelSet(db.getDbClass(Device.class));
        for (APair aPair : selSet.getElements()) {
            if (!(aPair.second instanceof Device)) continue;
            Device device = (Device)aPair.second;
            DevicePath fullPath = ((DevicePath)aPair.first).withChild(device);
            DevicePath alignTo = fullPath.getSameNetDriver(referenceDevicePath);
            HierPin alignPin = null;
            if (alignTo == null) {
                alignPin = fullPath.getConnectedPin(referenceDevicePath, DeviceTemplate.Type.DIE);
                if (alignPin == null) {
                    removeFromSelection.add(fullPath);
                    continue;
                }
                alignTo = ((DevicePath)alignPin.first).copy();
            }
            if (alignTo != null) {
                Device alignToDevice = alignTo.removeLast();
                if (UserCommands.alignIODriver(alignToDevice, alignTo, alignPin, (Device)aPair.second, (DevicePath)aPair.first, "IOpad center")) {
                    paths.add(fullPath);
                    allInsideBounds &= ((Device)aPair.second).driverInsideParentDie((DevicePath)aPair.first);
                    continue;
                }
                removeFromSelection.add(fullPath);
                continue;
            }
            removeFromSelection.add(fullPath);
        }
        for (DevicePath devicePath : removeFromSelection) {
            selection.remove((DbObject)devicePath.getLast());
        }
        if (!allInsideBounds) {
            UserCommands.putDriversInsideDieBounds(paths);
        }
        selSet = selection.getSelSet(db.getDbClass(PinInstance.class));
        ArrayList packagePins = new ArrayList();
        ArrayList<APoint2D> arrayList = new ArrayList<APoint2D>();
        ArrayList<Net> nets = new ArrayList<Net>();
        for (APair thePair : selSet.getElements()) {
            if (!(thePair.second instanceof PinInstance)) continue;
            HierPin pin = new HierPin((DevicePath)thePair.first, (PinInstance)thePair.second);
            HierInst hierDriver = Device.getClosestDriverOnDie((DevicePath)referenceDevicePath, (DevicePath)((DevicePath)thePair.first), (Net)((PinInstance)thePair.second).getNet(), (APoint2D)pin.getWorldLoc());
            if (hierDriver == null) continue;
            packagePins.add(pin);
            arrayList.add(((Device)hierDriver.second).getLoc((DevicePath)hierDriver.first, originLoc));
            nets.add(pin.getTopMostNet());
        }
        if (packagePins.size() > 1) {
            LineUnCrosser lu = new LineUnCrosser();
            packagePins = lu.uncross(arrayList, packagePins, p -> p, q -> q.getWorldLoc());
            int i = 0;
            for (HierPin pin : packagePins) {
                NetMap.mapThroughPath((DevicePath)pin.getPath(), (PinInstance)pin.getPin(), (String)((Net)nets.get(i++)).getName());
            }
        }
    }

    private static void reorderAndRepositionDriversToReschedule(Db db, DevicePath refPath) {
        Selection selection = Design.getSelection((Db)db);
        Set connections = selection.connectionsOfDriversBallsOrBumps();
        if (connections.size() <= 1) {
            return;
        }
        DriverOptimizer optimizer = DriverOptimizer.create(db, connections, refPath);
        optimizer.action();
        optimizer.report();
        DriverRespacer respacer = new DriverRespacer();
        List<HierInst<Device>> drivers = optimizer.getOptimizedDrivers().stream().map(dp -> HierInst.create((DevicePath)dp, (DbObject)dp.getDevice())).collect(Collectors.toList());
        respacer.setRefDriver(((HierInst)drivers.get(0)).getPath());
        respacer.processAll(drivers);
    }

    private static void rescheduleBumpOrBalls(Db db) {
        Selection selection = Design.getSelection((Db)db);
        Set connections = selection.connectionsOfDriversBallsOrBumps();
        if (connections.size() <= 1) {
            return;
        }
        String originLoc = "IOpad center";
        ArrayList fixedPoints = new ArrayList();
        ArrayList fixedPins = new ArrayList();
        ArrayList packagePins = new ArrayList();
        ArrayList nets = new ArrayList();
        MutableInteger ignoring = MutableInteger.create((int)0);
        connections.stream().sorted().forEach(connection -> {
            HierPin hPinA = connection.getDPPA();
            HierPin hPinB = connection.getDPPB();
            if (hPinA.getDbObject().getDevice().isDriver()) {
                fixedPoints.add(hPinA.getDbObject().getDevice().getLoc(hPinA.getPath(), originLoc));
                fixedPins.add(hPinA.getDbObject().getDevice().getHierPin(hPinA.getPath(), originLoc));
                packagePins.add(hPinB);
                nets.add(hPinB.getTopMostNet());
            } else if (hPinB.getDbObject().getDevice().isDriver()) {
                fixedPoints.add(hPinB.getDbObject().getDevice().getLoc(hPinB.getPath(), originLoc));
                fixedPins.add(hPinB.getDbObject().getDevice().getHierPin(hPinB.getPath(), originLoc));
                packagePins.add(hPinA);
                nets.add(hPinA.getTopMostNet());
            } else {
                ignoring.set(ignoring.get() + 1);
            }
        });
        if (ignoring.get() > 0) {
            ALog.logInfo((String)(ignoring.get() + " connections are ignored."));
        }
        if (!fixedPoints.isEmpty()) {
            ALog.logInfo((String)(fixedPoints.size() + " connections are optimized to reduce crossings."));
        }
        LineUnCrosser lu = new LineUnCrosser();
        ArrayList ansPackagePins = lu.uncross(fixedPoints, packagePins, p -> p, q -> q.getWorldLoc());
        for (int i = 0; i < ansPackagePins.size(); ++i) {
            HierPin pin = (HierPin)ansPackagePins.get(i);
            Net net = (Net)nets.get(i);
            NetMap.mapThroughPath((DevicePath)pin.getPath(), (PinInstance)pin.getPin(), (String)net.getName());
        }
    }

    public static void putDriversInsideDieBounds(List<DevicePath> driverPaths) {
        String originLoc = "IOpad center";
        for (AGeomUtil.CompassDir side : AGeomUtil.CompassDir.values()) {
            LinkedList<DevicePath> curPaths = new LinkedList<DevicePath>();
            LinkedList<DevicePath> outsideBoundsPaths = new LinkedList<DevicePath>();
            ARect curBounds = null;
            DevicePath parentPath = null;
            for (DevicePath cur : driverPaths) {
                if (cur.getLast().driverSide(cur, originLoc) != side) continue;
                curPaths.add(cur);
                ARect aRect = curBounds = curBounds == null ? cur.getBB() : curBounds.expandBy(cur.getBB());
                if (parentPath != null) continue;
                parentPath = cur.getParent();
            }
            if (parentPath == null) continue;
            DevicePath diePath = parentPath.pathToLowestOfType(DeviceTemplate.Type.DIE);
            ARect dieBB = diePath.getBB();
            for (DevicePath cur : driverPaths) {
                if (dieBB.inOrOnRect(cur.getBB())) continue;
                outsideBoundsPaths.add(cur);
            }
            APoint2D delta = new APoint2D();
            if (side == AGeomUtil.CompassDir.E || side == AGeomUtil.CompassDir.W) {
                if (curBounds.right() > dieBB.right()) {
                    delta.setX(dieBB.right() - curBounds.right());
                } else if (curBounds.left() < dieBB.left()) {
                    delta.setX(dieBB.left() - curBounds.left());
                }
                if (curBounds.top() > dieBB.top()) {
                    delta.setY(dieBB.top() - curBounds.top());
                    UserCommands.moveBy(parentPath, outsideBoundsPaths, delta);
                    continue;
                }
                if (curBounds.bottom() < dieBB.bottom()) {
                    delta.setY(dieBB.bottom() - curBounds.bottom());
                    UserCommands.moveBy(parentPath, outsideBoundsPaths, delta);
                    continue;
                }
                if (delta.getX() == 0L) continue;
                UserCommands.moveBy(parentPath, outsideBoundsPaths, delta);
                continue;
            }
            if (side != AGeomUtil.CompassDir.N && side != AGeomUtil.CompassDir.S) continue;
            if (curBounds.top() > dieBB.top()) {
                delta.setY(dieBB.top() - curBounds.top());
            } else if (curBounds.bottom() < dieBB.bottom()) {
                delta.setY(dieBB.bottom() - curBounds.bottom());
            }
            if (curBounds.right() > dieBB.right()) {
                delta.setX(dieBB.right() - curBounds.right());
                UserCommands.moveBy(parentPath, outsideBoundsPaths, delta);
                continue;
            }
            if (curBounds.left() < dieBB.left()) {
                delta.setX(dieBB.left() - curBounds.left());
                UserCommands.moveBy(parentPath, outsideBoundsPaths, delta);
                continue;
            }
            if (delta.getY() == 0L) continue;
            UserCommands.moveBy(parentPath, outsideBoundsPaths, delta);
        }
    }

    public static void moveBy(DevicePath parentPath, List<DevicePath> driverPaths, APoint2D delta) {
        for (DevicePath cur : driverPaths) {
            cur.getLast().moveBy(parentPath, delta);
        }
    }

    public static void alignSelected(Db db, boolean commonX, String alignReferenceStr, long refX, long refY) {
        Device device;
        Selection selection = Design.getSelection((Db)db);
        APoint2D refPoint = new APoint2D(refX, refY);
        HierInst refDevice = selection.getClosestDevice(refPoint, false);
        ARect bounds = ((Device)refDevice.getDbObject()).getWorldBound(refDevice.getPath());
        long refCoord = 0L;
        DeviceUI.ActionAlign.ALIGN_DIR alignCmd = DeviceUI.ActionAlign.ALIGN_DIR.valueFromCommand(alignReferenceStr);
        if (alignCmd == null) {
            ALog.logError((Throwable)new UnsupportedOperationException(), (String)"Unsupport align action '%s'", (Object[])new Object[]{alignReferenceStr});
            return;
        }
        refCoord = commonX ? (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.PIN_CENTER ? ((Device)refDevice.getDbObject()).getLoc(refDevice.getPath(), "IOpad center").getX() : (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.RIGHT ? bounds.right() : (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.LEFT ? bounds.left() : (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.ORIGIN ? ((Device)refDevice.getDbObject()).getWorldLoc(refDevice.getPath()).getX() : bounds.center().getX())))) : (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.PIN_CENTER ? ((Device)refDevice.getDbObject()).getLoc(refDevice.getPath(), "IOpad center").getY() : (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.TOP ? bounds.top() : (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.BOTTOM ? bounds.bottom() : (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.ORIGIN ? ((Device)refDevice.getDbObject()).getWorldLoc(refDevice.getPath()).getY() : bounds.center().getY()))));
        LinkedList<HierInst> listToAlign = new LinkedList<HierInst>();
        int numFixed = 0;
        for (HierInst hierDevice : selection.closestTo(refPoint)) {
            if (!(hierDevice.second instanceof Device)) continue;
            device = (Device)hierDevice.second;
            if (hierDevice.getDbObject() == device && hierDevice.getPath() == refDevice.getPath()) continue;
            if (device.getIsFixed()) {
                ++numFixed;
                continue;
            }
            listToAlign.add(hierDevice);
        }
        if (numFixed > 0) {
            ALog.logWarn((String)(numFixed + " selected devices are fixed. This command cannot be used with fixed devices."));
            return;
        }
        for (HierInst hierDevice : listToAlign) {
            device = (Device)hierDevice.second;
            APoint2D worldLoc = device.getWorldLoc(hierDevice.getPath());
            bounds = device.getWorldBound(hierDevice.getPath());
            if (commonX) {
                if (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.PIN_CENTER) {
                    worldLoc.setX(worldLoc.getX() - (device.getLoc(hierDevice.getPath(), "IOpad center").getX() - refCoord));
                } else if (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.RIGHT) {
                    worldLoc.setX(worldLoc.getX() - (bounds.right() - refCoord));
                } else if (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.LEFT) {
                    worldLoc.setX(worldLoc.getX() - (bounds.left() - refCoord));
                } else if (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.ORIGIN) {
                    worldLoc.setX(worldLoc.getX() - (device.getWorldLoc(hierDevice.getPath()).getX() - refCoord));
                } else {
                    worldLoc.setX(worldLoc.getX() - (bounds.center().getX() - refCoord));
                }
            } else if (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.PIN_CENTER) {
                worldLoc.setY(worldLoc.getY() - (device.getLoc(hierDevice.getPath(), "IOpad center").getY() - refCoord));
            } else if (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.TOP) {
                worldLoc.setY(worldLoc.getY() - (bounds.top() - refCoord));
            } else if (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.BOTTOM) {
                worldLoc.setY(worldLoc.getY() - (bounds.bottom() - refCoord));
            } else if (alignCmd == DeviceUI.ActionAlign.ALIGN_DIR.ORIGIN) {
                worldLoc.setY(worldLoc.getY() - (device.getWorldLoc(hierDevice.getPath()).getY() - refCoord));
            } else {
                worldLoc.setY(worldLoc.getY() - (bounds.center().getY() - refCoord));
            }
            DevicePath dp = ((DevicePath)hierDevice.first).withChild((Device)hierDevice.second);
            Device.setPos((DevicePath)dp, (APoint2D)worldLoc, (float)dp.getRot(), (boolean)dp.getMirror());
        }
        if (listToAlign.isEmpty()) {
            ALog.logInfo((String)("Could not align any selected devices to " + ((Device)refDevice.getDbObject()).getName() + ". This command works with devices at the same level of the hierarchy."));
        } else {
            ALog.logInfo((String)(listToAlign.size() + " device(s) aligned to " + ((Device)refDevice.getDbObject()).getName() + "."));
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void swapIODrivers(Db db, String driver1KeyStr, String driver2KeyStr, String diePath, String originLoc) {
        UserCommands.swapIODrivers((Device)db.getByKeyStr(Device.class, driver1KeyStr), (Device)db.getByKeyStr(Device.class, driver2KeyStr), DevicePath.fromEscapedString((Db)db, (String)diePath), originLoc);
    }

    public static void alignIODrivers(Db db, String refDriverKeyStr, String refDriverPath, String driverKeyStr, String driverPath, String originLoc) {
        UserCommands.alignIODrivers((Device)db.getByKeyStr(Device.class, refDriverKeyStr), DevicePath.fromEscapedString((Db)db, (String)refDriverPath), (Device)db.getByKeyStr(Device.class, driverKeyStr), DevicePath.fromEscapedString((Db)db, (String)driverPath), originLoc);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void alignIODriversWithConnected(Db db, String refDriverKeyStr, String originLoc) {
        UserCommands.alignIODriversWithConnected((Device)db.getByKeyStr(Device.class, refDriverKeyStr), originLoc);
    }

    public static void spaceSelectedIODrivers(Db db, String refDriverKeyStr, String refDriverPathStr, long spacing, boolean xAsRef) {
        Device refDriver = (Device)db.getByKeyStr(Device.class, refDriverKeyStr);
        DevicePath refDriverPath = DevicePath.fromEscapedString((Db)db, (String)refDriverPathStr);
        LinkedList<HierInst<Device>> drivers = new LinkedList<HierInst<Device>>();
        Selection selection = Design.getDesign((Db)db).getCurSelection();
        Selection.SelSet selSet = selection.getSelSet(db.getDbClass(Device.class));
        selSet.getElements().stream().filter(pair -> pair.second instanceof Device).filter(pair -> pair.second != refDriver).filter(pair -> ((DevicePath)pair.first).pathToSubstrate().equals((Object)refDriverPath.pathToSubstrate())).forEach(pair -> {
            DevicePath dPath = (DevicePath)pair.first;
            Device device = (Device)pair.second;
            drivers.add(HierInst.create((DevicePath)dPath.withChild(device), (DbObject)device));
        });
        refDriverPath.add(refDriver);
        DriverRespacer respacer = new DriverRespacer(refDriverPath);
        respacer.setDefaultSpacing(spacing);
        respacer.setReadSavedConstraints(false);
        respacer.process(drivers, xAsRef);
    }

    public static void createFanoutsForSelected(Db db, boolean includeUnassignedPins, boolean includeAllSameNetPins, String startLayerKeyStr, String endLayerKeyStr, String bumpKeyStr, String viaDirectionStr, long lineWidth, long pinViaSpace, long minChannelSpace) {
        Bundle.rollbackBundles((Db)db);
        ViaFanout.createFanouts(db, includeUnassignedPins, includeAllSameNetPins, startLayerKeyStr, endLayerKeyStr, bumpKeyStr, viaDirectionStr, lineWidth, pinViaSpace, minChannelSpace);
        Bundle.fixUpBundles((Db)db);
    }

    public static void selectDriversConnectedToSelectedConnections(Db db, String diePathStr) {
        DevicePath diePath = DevicePath.fromEscapedString((Db)db, (String)diePathStr);
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        SelectionCmds.selectDriversConnectedToSelectedConnections((Selection)s, (Selection)s, (DevicePath)diePath);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void makeCoil(String dieStrPath, String name) {
        Db db = OrbitApp.getCurDb();
        DevicePath diePath = DevicePath.fromEscapedString((Db)db, (String)dieStrPath);
        Substrate s = diePath.getSubstrate();
        DeviceTemplate dt = DeviceTemplate.create((Substrate)s, (String)name, (boolean)true);
        dt.setType(DeviceTemplate.Type.DIE);
        dt.setIsSynthesized(true);
        PinTemplate pinTemplate = PinTemplate.create((Net)dt.getNetUnused(), (String)"port1");
        PadTemplate padTemplate = PadTemplate.create((Db)db, (Substrate)s, (String)"p");
        pinTemplate.setType(PinTemplate.Type.BUMPPAD);
        for (Metal m : diePath.getDeviceTemplate().getMetals()) {
            LayerShape.create((Layer)m.getLayer(), (DbObject)padTemplate, (AGeom)m.getGeom());
        }
        pinTemplate.setPadTemplate(padTemplate);
        Device.create((String)name, (DeviceTemplate)dt, (DeviceTemplate)diePath.getParent().getDeviceTemplate());
    }

    public static void makeSlice(String devicePathString, double yUser, double edgeXUser, double dxUser, String bumpName) {
        Db db = OrbitApp.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        DevicePath devicePath = DevicePath.fromEscapedString((Db)OrbitApp.getCurDb(), (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate dt = devicePath.getDeviceTemplate();
        DeviceTemplate bumpTemplate = DeviceTemplate.getDeviceTemplate((Substrate)dt.getSubstrate(), (String)bumpName);
        if (bumpTemplate == null) {
            ALog.logWarn((String)"Bump '%s' does not exist", (Object[])new Object[]{bumpName});
            return;
        }
        long y = unit.fromUser(yUser);
        long edgeX = unit.fromUser(edgeXUser);
        long dx = unit.fromUser(dxUser);
        ARect r = dt.getBB();
        int suffix = 0;
        for (long x = r.left() + edgeX; x <= r.right() - edgeX; x += dx) {
            String name = "bump" + suffix;
            Device d = Device.get((Db)db, (String)name, (DeviceTemplate)dt);
            while (d != null) {
                name = "bump" + ++suffix;
                d = Device.get((Db)db, (String)name, (DeviceTemplate)dt);
            }
            d = Device.create((String)name, (DeviceTemplate)bumpTemplate, (DeviceTemplate)dt);
            d.setLoc(new APoint2D(x, y));
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void addText(String text, String devicePathString, double hu, double xu, double yu) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromEscapedString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        Unit unit = Design.getUnit((Db)db);
        DeviceTemplate dt = devicePath.getDeviceTemplate();
        long height = unit.fromUser(hu);
        long x = unit.fromUser(xu);
        long y = unit.fromUser(yu);
        Text t = Text.create((DbObject)dt, (String)text);
        t.setHeight(height);
        t.setLoc(new APoint2D(x, y));
        t.setLayer(dt.getSubstrate().getTopLayer());
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void channelCap(double utw, double utt, double utp) {
        UserCommands.channelCap(453.3, utw, utt, utp);
    }

    public static void replaceAllInstancesOfAWithB(String devicePathStringA, String devicePathStringB) {
        DevicePath devicePathA = DevicePath.fromEscapedString((Db)OrbitApp.getCurDb(), (String)devicePathStringA);
        if (devicePathA == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathStringA});
            return;
        }
        DevicePath devicePathB = DevicePath.fromEscapedString((Db)OrbitApp.getCurDb(), (String)devicePathStringB);
        if (devicePathB == null) {
            ALog.logWarn((String)DEVICE_PATH_WARNING_MSG, (Object[])new Object[]{devicePathStringB});
            return;
        }
        devicePathA.getDeviceTemplate().replaceWith(devicePathB.getDeviceTemplate());
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void channelCap(double udist, double utw, double utt, double utp) {
        Db db = OrbitApp.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        long dist = unit.fromUser(udist);
        long tw = unit.fromUser(utw);
        long tt = unit.fromUser(utt);
        long tp = unit.fromUser(utp);
        for (int i = 1; i < 100; ++i) {
            long req = tw * (long)i + (long)(i - 1) * tt + 2L * tp;
            if (req <= dist) continue;
            int most = i - 1;
            if (i == 0) {
                long oneWire = tw * 1L + 2L * tp;
                double userOneWire = unit.toUser(oneWire);
                ALog.logInfo((String)("0 wires can be in the channel, 1 wire will require " + Double.toString(userOneWire)));
                continue;
            }
            ALog.logInfo((String)(most + " wires can be in the channel."));
            if (most > 1) {
                long needed = tw * (long)most + (long)(most - 1) * tt + 2L * tp;
                long excess = dist - needed;
                long add = excess / (long)(most - 1);
                double newTT = Math.floor(unit.toUser(tt + add));
                ALog.logInfo((String)("The trace to trace can be expanded to " + newTT));
            }
            return;
        }
    }

    public static void normalizeRectangularPort(PortTemplate portTemplate) {
        ARect oldRect = portTemplate.getBounds();
        portTemplate.setLoc(new APoint2D(oldRect.center()));
        oldRect.moveCenterTo(new APoint2D(0L, 0L));
        for (LayerShape oldLs : AUtil.linkedList((Iterator)portTemplate.getPadTemplate().getLayerShapes())) {
            oldLs.setGeom((AGeom)oldRect);
        }
    }

    public static void synthesizePorts(String devicePathString) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        for (DevicePath child : devicePath.getDescendants()) {
            child.getDeviceTemplate().invalidateAll2DIndices();
            for (PinInstance dp : child.getLast().getPins()) {
                PinTemplate pinTemplate = dp.getPinTemplate();
                if (pinTemplate.getName().endsWith("_TX")) {
                    ALog.logInfo((String)pinTemplate.getName());
                }
                block2: for (PortTemplate portTemplate : pinTemplate.getPortTemplates()) {
                    PadTemplate padTemplate = portTemplate.getPadTemplate();
                    LinkedList<LayerShape> seenLayerShapes = new LinkedList<LayerShape>();
                    for (LayerShape ls : padTemplate.getLayerShapes()) {
                        boolean unique = true;
                        int lsCount = 0;
                        for (LayerShape seen : padTemplate.getLayerShapes()) {
                            if (seen.equals(ls)) continue;
                            ++lsCount;
                            if (!ls.getBounds().inOrOnRect(seen.getBounds())) continue;
                            unique = false;
                            break;
                        }
                        seenLayerShapes.add(ls);
                        if (!unique || lsCount < 1) continue;
                        PortTemplate newPortTemplate = PortTemplate.create((PinTemplate)pinTemplate);
                        PadTemplate newPadTemplate = PadTemplate.create((Db)db, (Substrate)pinTemplate.getSubstrate());
                        newPortTemplate.setPadTemplate(newPadTemplate);
                        newPortTemplate.setLoc(portTemplate.getLoc());
                        newPortTemplate.setMirror(portTemplate.getMirror());
                        newPortTemplate.setRotate(portTemplate.getRotate());
                        LayerShape.create((Layer)ls.getLayer(), (DbObject)newPadTemplate, (AGeom)ls.getGeom().copy());
                        ls.deleteFromDb();
                        ALog.logInfo((String)("Pin " + pinTemplate.getName() + " is adding a port"));
                        UserCommands.normalizeRectangularPort(portTemplate);
                        UserCommands.normalizeRectangularPort(newPortTemplate);
                        continue block2;
                    }
                }
            }
        }
    }

    public static void mapCreateAndMapUp(DevicePath a) {
        for (Net n : a.getLast().getNets()) {
            if (!NetMap.isMappable((Net)n)) continue;
            NetMap.mapThroughPath((DevicePath)a, (Net)n);
            Device top = a.getFirst();
            DeviceTemplate parent = top.getParent();
            Net netParent = parent.getNet(n.getName());
            Net netChild = top.getTemplate().getNet(n.getName());
            if (netParent == null) {
                netParent = Net.create((DeviceTemplate)parent, (String)n.getName());
            }
            NetMap.mapChildNet((Device)top, (Net)netChild, (Net)netParent);
        }
    }

    public static List<HierInst<Net>> connectionsBetween(DevicePath a, DevicePath b) {
        ALog.logInfo((String)(a.toString() + " " + b.toString()));
        DeviceTemplate dtA = a.getDeviceTemplate();
        LinkedList<HierInst<Net>> nets = new LinkedList<HierInst<Net>>();
        for (Net net : dtA.getNets()) {
            HierInst fromNet = new HierInst(a, (DbObject)net);
            HierInst connected = NetMap.getNetOnDevice((HierInst)fromNet, (DevicePath)b);
            if (connected == null) continue;
            nets.add((HierInst<Net>)connected);
        }
        Collections.sort(nets);
        for (HierInst hierInst : nets) {
            ALog.logInfo((String)("   " + ((Net)hierInst.getDbObject()).getName()));
        }
        return nets;
    }

    public static void determineIntersubstateConnections(String devicePathString) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logError((String)DEVICE_PAHT_ERROR_MSG, (Object[])new Object[]{devicePathString});
            return;
        }
        ArrayList<DevicePath> sorted = new ArrayList<DevicePath>();
        for (DevicePath dp : devicePath.getChildren()) {
            if (dp.isEmpty() || !dp.getLast().getIsSubstrate()) continue;
            sorted.add(dp);
        }
        Collections.sort(sorted);
        ArrayList<Net> allCommonTop = new ArrayList<Net>();
        for (int i = 0; i < sorted.size() - 1; ++i) {
            DevicePath a = (DevicePath)sorted.get(i);
            for (int j = i + 1; j < sorted.size(); ++j) {
                DevicePath b = (DevicePath)sorted.get(j);
                List<HierInst<Net>> inCommon = UserCommands.connectionsBetween(a, b);
                for (HierInst<Net> hn : inCommon) {
                    Net topNet = NetMap.getTopmostNet((Net)((Net)hn.second), (DevicePath)((DevicePath)hn.first));
                    if (allCommonTop.contains(topNet)) continue;
                    allCommonTop.add(topNet);
                }
            }
        }
        ALog.logInfo((String)("There are " + allCommonTop.size() + " nets between all substrates"));
        for (DevicePath p : sorted) {
            for (int i = 0; i < allCommonTop.size(); ++i) {
                PinTemplate pt = p.getDeviceTemplate().getPinByName("via" + i);
                Net thisNet = p.getDeviceTemplate().getNet(((Net)allCommonTop.get(i)).getName());
                if (thisNet == null) {
                    thisNet = p.getDeviceTemplate().createNet(((Net)allCommonTop.get(i)).getName());
                }
                pt.setNet(thisNet);
            }
        }
    }

    public static void spreadDevices(String devicePathString, boolean spread, int depth) {
        Db db = OrbitApp.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logInfo((String)(devicePathString + " is not a device"));
            return;
        }
        boolean first = true;
        LinkedList<Device> sorted = new LinkedList<Device>();
        for (DevicePath dp : devicePath.getDescendants()) {
            if (dp.isEmpty() || dp.size() > depth || !dp.getLast().getIsSubstrate()) continue;
            sorted.add(dp.getLast());
        }
        Collections.sort(sorted, new Device.ZSorter());
        Collections.reverse(sorted);
        if (spread) {
            long dx = 0L;
            for (Device d : sorted) {
                Long exist;
                if (!d.getIsSubstrate() || (exist = (Long)d.getValue("spread.dx")) != null && exist != 0L) continue;
                if (!first) {
                    d.setValue("spread.dx", (Object)dx);
                    d.moveBy(dx, 0L);
                    dx += d.getBB().width();
                    continue;
                }
                first = false;
                dx = d.getBB().width();
            }
        } else {
            for (Device d : sorted) {
                Long dx;
                if (!d.getIsSubstrate() || (dx = (Long)d.getValue("spread.dx")) == null || dx == 0L) continue;
                d.moveBy(-dx.longValue(), 0L);
                d.setValue("spread.dx", (Object)0L);
            }
        }
        OrbitIO.getApp().zoomFitCurrentView();
    }

    public static void zoomTo(ARect worldRect) {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        DesignCanvas2D canvas = view.getCanvas();
        EventQueue.invokeLater(() -> canvas.zoomTo(worldRect));
    }

    public static void zoomFit() {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        DesignCanvas2D canvas = view.getCanvas();
        EventQueue.invokeLater(() -> canvas.zoomFit());
    }

    public static void zoom(double factor, APoint2D about) {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        DesignCanvas2D canvas = view.getCanvas();
        EventQueue.invokeLater(() -> canvas.scale(factor, about));
    }

    public static class DPSorter
    implements Comparator<HierPort> {
        @Override
        public int compare(HierPort p0, HierPort p1) {
            APoint2D pt0 = p0.getWorldLoc();
            APoint2D pt1 = p1.getWorldLoc();
            return pt0.compareTo(pt1);
        }
    }
}

