/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairFinder;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.PinSpreadOptimizer;
import com.sigrity.orbit.automation.router.InteractiveBundleCreator;
import com.sigrity.orbit.ui.AutoBundleDlg;
import com.sigrity.orbit.ui.FixedFreePinSelection;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.util.PinUtil;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;

public class AutoBundleEngine {
    public static final String fldInstruction = "autobundle.instruction";
    protected LinkedHashMap<Long, PortPairOpt.ClusterClass> mClusterMap = new LinkedHashMap();
    protected HashSet<PinInstance> markedPins = new HashSet();
    protected LinkedList<Instruction> instructions = new LinkedList();

    public void add(int order, boolean allowSteal, String wWidth, String wClr, String fromPath, String toPath, String from, String to, String hints) {
        this.instructions.add(new Instruction(order, allowSteal, wWidth, wClr, fromPath, toPath, from, to, hints, this.instructions.size()));
    }

    public LinkedList<Instruction> getInstructions() {
        return this.instructions;
    }

    public void init() {
        PortPairOpt ppo = PortPairOpt.getActive(OrbitIO.getCurDb());
        if (ppo == null) {
            ppo = new PortPairOpt();
        }
        ppo.clear();
        HashSet<DevicePath> freeCandidates = new HashSet<DevicePath>();
        for (Instruction instruction : this.getInstructions()) {
            DevicePath dp = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)instruction.toPath);
            if (dp == null) continue;
            freeCandidates.add(dp);
        }
        for (DevicePath dp : freeCandidates) {
            Substrate s = dp.getSubstrate();
            for (DevicePath child : dp.getChildren()) {
                if (child.getSubstrate() != s) continue;
                for (PinInstance pi : child.getDevice().getPins()) {
                    PinUtil.setBigIntValue((PinInstance)pi, (String)fldInstruction, (BigInteger)BigInteger.ZERO);
                }
            }
        }
    }

    public void go() {
        LinkedList<APair<Long, PortPairOpt.ClusterClass>> clusterList = new LinkedList<APair<Long, PortPairOpt.ClusterClass>>();
        this.init();
        Db db = OrbitIO.getCurDb();
        if (this.getInstructions().size() == 0) {
            ALog.logInfo((String)"Nothing to bundle");
            return;
        }
        this.markedPins.clear();
        for (Instruction instruction : this.getInstructions()) {
            DevicePath fromPath = DevicePath.fromString((Db)db, (String)instruction.fromPath);
            DeviceTemplate fromTemplate = fromPath.getDeviceTemplate();
            DevicePath toPath = DevicePath.fromString((Db)db, (String)instruction.toPath);
            DeviceTemplate toTemplate = toPath.getDeviceTemplate();
            Interface iFace = Interface.getOrCreate((Db)db, (String)instruction.fromInterface);
            Floorplan floorplan = iFace.getFloorplan(fromTemplate, false);
            Bundle curBundle = Bundle.getBundle((Db)db, (String)floorplan.getMyInterface().toStringPath(), (DeviceTemplate)toTemplate);
            if (curBundle != null) {
                Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.removeFloorplanPins (curDb(), \"%s\")", (Object[])new Object[]{curBundle.getKeyStr()});
                Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.commandSetFreePinsToUnused (\"%s\")", (Object[])new Object[]{curBundle.getKeyStr()});
                Cp.exec((String)"Bundle.deleteFromDb (curDb(), \"%s\")", (Object[])new Object[]{curBundle.getKeyStr()});
            } else {
                Floorplan fp = iFace.getFloorplan(toTemplate, false);
                if (fp != null) {
                    Cp.exec((String)"fp = (Floorplan) OrbitIO.getCurDb().getDbClass(\"Floorplan\").getInstanceByKeyStr(\"%s\");", (Object[])new Object[]{fp.getKeyStr()});
                    Cp.exec((String)"fp.removePins(%b);", (Object[])new Object[]{true});
                }
            }
            OrbitIO.getCurDesign().getCurSelection().clear();
            FixedFreePinSelection.selectPortsOnFloorplan(floorplan, fromPath);
            AGeom geom = floorplan.getHull(fromPath, false);
            APoint2D avgLoc = geom.getBounds().center();
            PortPairOpt.OptimizerAlgo optAlgo = this.decodeOptAlgo(instruction.hints);
            FixedFreePinSelection.retrieveSelectedPathObjectsOnA(true);
            this.markSelectedPins(instruction.id);
            OrbitIO.getCurDesign().getCurSelection().clear();
            Personality freePersonality = null;
            if (!instruction.toPersonality.equals("Any")) {
                freePersonality = PersonalityUI.getOrMakePersonality(Personality.Type.PORT, toTemplate, instruction.toPersonality);
            }
            FixedFreePinSelection.selectPortOnPersonality(toPath, freePersonality);
            String preferredOctant = this.decodeToSide(instruction.hints);
            if (preferredOctant != null) {
                this.removeWrongSidePins(preferredOctant);
            }
            FixedFreePinSelection.retrieveSelectedPathObjectsOnB(true);
            this.markSelectedPins(instruction.id);
            Interface iFaceTo = Interface.getOrCreate((Db)db, (String)instruction.fromInterface);
            long extraPins = this.decodeExtraPins(instruction.hints);
            long diffPairs = floorplan.getMyInterface().getNumDiffPairs(floorplan, fromPath).size();
            String diffPairAlgo = this.decodeDiffPair(instruction.hints);
            clusterList.add((APair<Long, PortPairOpt.ClusterClass>)new APair((Object)instruction.id, (Object)new PortPairOpt.ClusterClass(iFaceTo, avgLoc, floorplan.getIOs().size(), extraPins, diffPairs, preferredOctant, instruction.order, diffPairAlgo, optAlgo)));
        }
        this.setOptimizerAlgo(clusterList);
        this.createClusterMap(clusterList);
        this.doOptimize();
        this.clearMarkedPins();
        for (Instruction instruction : this.getInstructions()) {
            String bundle = this.getHintValue(instruction.hints, "bundle");
            if (bundle == null || !bundle.equals("true")) continue;
            ALog.logInfo((String)("Bundling " + instruction.fromInterface + "..."));
            this.autoBundle(instruction);
        }
        this.instructions.clear();
    }

    protected void setOptimizerAlgo(LinkedList<APair<Long, PortPairOpt.ClusterClass>> clusterList) {
        if (clusterList == null) {
            return;
        }
        for (APair aPair : clusterList) {
            Long curInst = (Long)aPair.first;
            PortPairOpt.ClusterClass cluster = (PortPairOpt.ClusterClass)aPair.second;
            String side = cluster.getSide();
            int numOccur = 0;
            for (APair aPair2 : clusterList) {
                Long curInst1 = (Long)aPair2.first;
                PortPairOpt.ClusterClass cluster1 = (PortPairOpt.ClusterClass)aPair2.second;
                String side1 = cluster1.getSide();
                if (curInst.equals(curInst1) || !side.equals(side1)) continue;
                ++numOccur;
                break;
            }
            if (numOccur != 0) continue;
            ((PortPairOpt.ClusterClass)aPair.second).setOptAlgo(PortPairOpt.OptimizerAlgo.CLOSESTPIN);
        }
    }

    protected void createClusterMap(LinkedList<APair<Long, PortPairOpt.ClusterClass>> list) {
        this.mClusterMap.clear();
        for (APair aPair : list) {
            PortPairOpt.ClusterClass c = (PortPairOpt.ClusterClass)aPair.second;
            Interface intf = c.getInterface();
            APoint2D avgLoc = c.getAvgLoc();
            long signalPins = c.getSignalPins();
            long extraPins = c.getExtraPins();
            long diffPairs = c.getDiffPairs();
            String side = c.getSide();
            PortPairOpt.OptimizerAlgo optAlgo = c.getOptimizerAlgo();
            String diffPairAlgo = c.getDiffPairAlgo();
            int order = c.getOrder();
            PortPairOpt.ClusterClass newClass = new PortPairOpt.ClusterClass(intf, avgLoc, signalPins, extraPins, diffPairs, side, order, diffPairAlgo, optAlgo);
            this.mClusterMap.put((Long)aPair.first, newClass);
        }
    }

    protected LinkedList<APoint2D> getEndPoints(Instruction instruction, InteractiveBundleCreator ibr) {
        LinkedList<APoint2D> list = new LinkedList<APoint2D>();
        Db db = OrbitIO.getCurDb();
        String escapeSide = this.decodeFromSide(instruction.hints);
        ARect fromRectWorld = ibr.getFromRect();
        ARect toRectWorld = ibr.getToRect();
        if (fromRectWorld == null || toRectWorld == null) {
            return list;
        }
        DevicePath fromPath = DevicePath.fromString((Db)db, (String)instruction.fromPath);
        ARect fromDeviceWorldRect = fromPath.getLocalBB();
        Bundle bundle = ibr.getBundle();
        long traceWidth = bundle.getWireWidth();
        APoint2D p0 = new APoint2D();
        APoint2D p1 = new APoint2D();
        APoint2D p2 = new APoint2D();
        APoint2D p3 = new APoint2D();
        if (escapeSide.equals(AutoBundleDlg.EscapeSides.S.name())) {
            p0.setX(fromRectWorld.centerX());
            p0.setY(fromDeviceWorldRect.bottom() - traceWidth);
            p1.setX(p0.getX());
            p1.setY(p0.getY() - traceWidth * 10L);
            p2.setX(toRectWorld.centerX());
            p2.setY(toRectWorld.top() + traceWidth * 10L);
            p3.setX(p2.getX());
            p3.setY(toRectWorld.top() + traceWidth);
        } else if (escapeSide.equals(AutoBundleDlg.EscapeSides.E.name())) {
            p0.setX(fromDeviceWorldRect.right() + traceWidth);
            p0.setY(fromRectWorld.centerY());
            p1.setX(p0.getX() + traceWidth * 10L);
            p1.setY(p0.getY());
            p2.setX(toRectWorld.left() - traceWidth * 10L);
            p2.setY(toRectWorld.centerY());
            p3.setX(toRectWorld.left() + traceWidth);
            p3.setY(toRectWorld.centerY());
        } else if (escapeSide.equals(AutoBundleDlg.EscapeSides.N.name())) {
            p0.setX(fromRectWorld.centerX());
            p0.setY(fromDeviceWorldRect.top() + traceWidth);
            p1.setX(p0.getX());
            p1.setY(p0.getY() + traceWidth * 10L);
            p2.setX(toRectWorld.centerX());
            p2.setY(toRectWorld.bottom() - traceWidth * 10L);
            p3.setX(p2.getX());
            p3.setY(toRectWorld.bottom() - traceWidth);
        } else if (escapeSide.equals(AutoBundleDlg.EscapeSides.W.name())) {
            p0.setX(fromDeviceWorldRect.left() - traceWidth);
            p0.setY(fromRectWorld.centerY());
            p1.setX(p0.getX() - traceWidth * 10L);
            p1.setY(p0.getY());
            p2.setX(toRectWorld.right() + traceWidth * 10L);
            p2.setY(toRectWorld.centerY());
            p3.setX(toRectWorld.right() + traceWidth);
            p3.setY(toRectWorld.centerY());
        } else {
            p0.setX(fromRectWorld.centerX());
            p0.setY(fromDeviceWorldRect.top() + traceWidth);
            p1.setX(p0.getX());
            p1.setY(p0.getY() + traceWidth * 10L);
            p2.setX(toRectWorld.centerX());
            p2.setY(toRectWorld.bottom() - traceWidth * 10L);
            p3.setX(p2.getX());
            p3.setY(toRectWorld.bottom() - traceWidth);
        }
        list.add(p0);
        list.add(p1);
        list.add(p2);
        list.add(p3);
        return list;
    }

    protected void autoBundle(Instruction instruction) {
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        DevicePath fromPath = DevicePath.fromString((Db)db, (String)instruction.fromPath);
        DeviceTemplate fromTemplate = fromPath.getDeviceTemplate();
        Interface intrface = Interface.getOrCreate((Db)db, (String)instruction.fromInterface);
        Floorplan fromFloorplan = intrface.getFloorplan(fromTemplate, false);
        DevicePath toPath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)instruction.toPath);
        DeviceTemplate toTemplate = toPath.getDeviceTemplate();
        Floorplan toFloorplan = intrface.getFloorplan(toTemplate, false);
        UserCommands.unselectAll();
        OrbitIO.getCurDesign().getCurSelection().clear();
        FixedFreePinSelection.selectPortsOnFloorplan(fromFloorplan, fromPath);
        FixedFreePinSelection.retrieveSelectedPathObjectsOnA();
        OrbitIO.getCurDesign().getCurSelection().clear();
        FixedFreePinSelection.selectPortsOnFloorplan(toFloorplan, toPath);
        FixedFreePinSelection.retrieveSelectedPathObjectsOnB();
        OrbitIO.getApp().refreshCurrentView(true);
        InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
        long wWidth = unit.fromUserString(instruction.wireWidth);
        long wClr = unit.fromUserString(instruction.wireClr);
        if (wWidth <= 0L) {
            wWidth = unit.fromUserString("20");
        }
        if (wClr <= 0L) {
            wClr = unit.fromUserString("20");
        }
        ibr.setConstraints(wWidth, wClr, "FortyFive");
        ibr.setOptimizeFreeEndFlag(true);
        ibr.setColorHint(intrface.getColor());
        ibr.setNameHint(intrface.toStringPath());
        ibr.setInterfaceHint(intrface);
        ibr.setSpreadAlgo(this.decodeSpreadAlgo(instruction.hints));
        ibr.setSpreadPins(this.decodeExtraPins(instruction.hints));
        ibr.setOptAlgorithm(this.decodeDiffPair(instruction.hints));
        ibr.setSpreadUserData(toPath);
        ibr.start(null, "AutoCreate");
        Bundle bundle = ibr.getBundle();
        if (bundle != null) {
            String keyStr = bundle.getKeyStr();
            LinkedList<APoint2D> ps = this.getEndPoints(instruction, ibr);
            if (ps.size() > 0) {
                for (APoint2D p : ps) {
                    InteractiveBundleCreator.addSegment(keyStr, p.getX(), p.getY());
                }
                ibr.commit();
            } else {
                ibr.cancelCreatingBundle();
            }
        }
    }

    protected void removeWrongSidePins(String preferredOctant) {
        HashSet<PinInstance> toBeRemoved = new HashSet<PinInstance>();
        if (preferredOctant.equals("DEFAULT")) {
            return;
        }
        Selection s = OrbitIO.getCurDesign().getCurSelection();
        for (PinInstance pi : s.get(PinInstance.class)) {
            for (DevicePath dp : s.getSelectedPaths((DbObject)pi)) {
                HierPort hp = new HierPort(dp, pi.getPinTemplate().getFirstPortTemplate());
                int thisOct = hp.getSubstrateOctantOfPin();
                if (this.octantsMatch(thisOct, preferredOctant)) continue;
                toBeRemoved.add(pi);
            }
        }
        for (PinInstance pi : toBeRemoved) {
            s.remove((DbObject)pi);
        }
    }

    protected void clearMarkedPins() {
        for (PinInstance pi : this.markedPins) {
            PinUtil.setBigIntValue((PinInstance)pi, (String)fldInstruction, null);
        }
    }

    protected void markSelectedPins(long id) {
        Selection s = OrbitIO.getCurDesign().getCurSelection();
        for (PinInstance pi : s.get(PinInstance.class)) {
            BigInteger val = BigInteger.ZERO;
            val = val.setBit((int)id);
            BigInteger curVal = (BigInteger)pi.getValue(fldInstruction);
            if (curVal == null) {
                curVal = BigInteger.ZERO;
            }
            val = val.or(curVal);
            PinUtil.setBigIntValue((PinInstance)pi, (String)fldInstruction, (BigInteger)val);
            this.markedPins.add(pi);
        }
    }

    protected void doOptimize() {
        OrbitIO.getCurDesign().getCurSelection().clear();
        PortPairOpt ppo = PortPairOpt.getActive(OrbitIO.getCurDb());
        if (ppo == null) {
            ppo = new PortPairOpt();
        }
        ppo.setCanConnectFunction("sameInstruction");
        PortPairOpt.setRemoveNetMappingOnToSide(false);
        PortPairOpt.setTreatFromAsIndividuals(true);
        ppo.setUseOnlyUsedPortsOnFixedSide(false);
        ppo.setCreateFloorplansOnFreeSide(true);
        ppo.setExtraPinsMap(this.mClusterMap);
        ppo.setUseOnlyUnusedPortsOnFreeSide(!this.getInstructions().getFirst().allowSteal);
        ppo.setSortByInstruction(true);
        ppo.optimize(false);
    }

    protected boolean octantsMatch(int oct, String compass) {
        if (compass.equals("E")) {
            return oct == 0 || oct == 7;
        }
        if (compass.equals("N")) {
            return oct == 1 || oct == 2;
        }
        if (compass.equals("W")) {
            return oct == 3 || oct == 4;
        }
        if (compass.equals("S")) {
            return oct == 5 || oct == 6;
        }
        if (compass.equals("NE")) {
            return oct == 0 || oct == 1;
        }
        if (compass.equals("NW")) {
            return oct == 3 || oct == 2;
        }
        if (compass.equals("SW")) {
            return oct == 4 || oct == 5;
        }
        if (compass.equals("SE")) {
            return oct == 7 || oct == 6;
        }
        return false;
    }

    protected String getHintValue(String hintList, String hintName) {
        String[] hints = hintList.split(",");
        for (int i = 0; i < hints.length; ++i) {
            String hint = hints[i];
            int delimpos = hint.indexOf("=");
            if (delimpos < 0) continue;
            String hName = hint.substring(0, delimpos).trim();
            String hVal = hint.substring(delimpos + 1, hint.length()).trim();
            if (hName.compareToIgnoreCase(hintName) != 0) continue;
            return hVal;
        }
        return null;
    }

    protected PinSpreadOptimizer.PinSpreadAlgo decodeSpreadAlgo(String hintList) {
        String spreadAlgo = this.getHintValue(hintList, "spreadAlgo");
        PinSpreadOptimizer.PinSpreadAlgo psa = null;
        if (spreadAlgo != null) {
            psa = PinSpreadOptimizer.PinSpreadRegistry.getPinSpreadAlgo(spreadAlgo);
        }
        return psa;
    }

    protected PortPairOpt.OptimizerAlgo decodeOptAlgo(String hintList) {
        String opt = this.getHintValue(hintList, "optAlgo");
        PortPairOpt.OptimizerAlgo optAlgo = null;
        if (opt != null) {
            optAlgo = PortPairOpt.OptimizerAlgo.valueOf(opt);
        }
        return optAlgo;
    }

    protected long decodeExtraPins(String hintList) {
        long pinCount = 0L;
        String extraPins = this.getHintValue(hintList, "extraPins");
        if (extraPins != null) {
            pinCount = Long.parseLong(extraPins);
        }
        return pinCount;
    }

    protected String decodeDiffPair(String hintList) {
        String align = this.getHintValue(hintList, "diffPair");
        if (align == null) {
            align = DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), null, (String[])DiffPairFinder.CostFunctionCatalog);
        }
        return align;
    }

    protected String decodeFromSide(String hintList) {
        String fromSide = this.getHintValue(hintList, "prefFromSide");
        if (fromSide == null) {
            fromSide = this.getHintValue(hintList, "prefToSide");
        }
        return fromSide;
    }

    protected String decodeToSide(String hintList) {
        String toSide = this.getHintValue(hintList, "prefToSide");
        return toSide;
    }

    protected static class Instruction {
        protected final int order;
        protected final boolean allowSteal;
        protected final String wireWidth;
        protected final String wireClr;
        protected final String fromPath;
        protected final String toPath;
        protected final String fromInterface;
        protected final String toPersonality;
        protected final String hints;
        protected final long id;

        public Instruction(int order, boolean allowSteal, String wWidth, String wClr, String fromPath, String toPath, String fromInterface, String toPersonality, String hints, long id) {
            this.order = order;
            this.allowSteal = allowSteal;
            this.wireWidth = wWidth;
            this.wireClr = wClr;
            this.fromPath = fromPath;
            this.toPath = toPath;
            this.fromInterface = fromInterface;
            this.toPersonality = toPersonality;
            this.hints = hints;
            this.id = id;
        }
    }
}

