/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.google.common.collect.Lists;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AMinSpanTree;
import com.sigrity.acl.APair;
import com.sigrity.acl.MSTGraph;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.edaMgrs.HConnEngine;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierNet;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.BundleRakeUI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AutoBundleNetEngine {
    private static final boolean DEBUG = false;
    private String PIN_PROXIMITY = "1000";
    private String MIN_RAT_NETS = "8";
    private String AUTO_BUNDLENAME = "bundle";
    private String WIRE_WIDTH = "20";
    private String WIRE_CLEARANCE = "20";
    private String POWERNET_SIZE = "50";
    private boolean ALLOW_SAME_DEVICE = false;
    private boolean IGNORE_POWER_PIN = true;
    private boolean IGNORE_TOPMOSTNET_NAME = true;
    private boolean MUST_IN_INTERFACE = false;
    private String IGNORE_PIN_NAME_REGEX = "(power|pwr|ground|gnd|vcc|vss|vdd|GND|VCC|VSS|VDD|\\+\\d+v)(.*)";
    private int BUNDLE_PATH_DIR = 0;
    private boolean CORNER_DRILLOUT = false;
    private boolean OPT_FREE_END;
    private Selection mSelection = new Selection(OrbitIO.getCurDb());
    private List<HierPin> mPinFrom = new ArrayList<HierPin>();
    private List<HierPin> mPinTo = new ArrayList<HierPin>();

    public void setOptions(String PIN_PROXIMITY, String MIN_RAT_NETS, String AUTO_BUNDLENAME, String WIRE_WIDTH, String WIRE_CLEARANCE, String POWERNET_SIZE, boolean ALLOW_SAME_DEVICE, boolean IGNORE_POWER_PIN, boolean IGNORE_TOPMOSTNET_NAME, boolean MUST_IN_INTERFACE, String IGNORE_PIN_NAME_REGEX, int BUNDLE_PATH_DIR, boolean CORNER_DRILLOUT) {
        this.PIN_PROXIMITY = PIN_PROXIMITY;
        this.MIN_RAT_NETS = MIN_RAT_NETS;
        this.AUTO_BUNDLENAME = AUTO_BUNDLENAME;
        this.WIRE_WIDTH = WIRE_WIDTH;
        this.WIRE_CLEARANCE = WIRE_CLEARANCE;
        this.POWERNET_SIZE = POWERNET_SIZE;
        this.ALLOW_SAME_DEVICE = ALLOW_SAME_DEVICE;
        this.IGNORE_POWER_PIN = IGNORE_POWER_PIN;
        this.IGNORE_TOPMOSTNET_NAME = IGNORE_TOPMOSTNET_NAME;
        this.MUST_IN_INTERFACE = MUST_IN_INTERFACE;
        this.IGNORE_PIN_NAME_REGEX = IGNORE_PIN_NAME_REGEX;
        this.BUNDLE_PATH_DIR = BUNDLE_PATH_DIR;
        this.CORNER_DRILLOUT = CORNER_DRILLOUT;
    }

    public void setOptimizeFreeEnd(boolean flag) {
        this.OPT_FREE_END = flag;
    }

    protected boolean samePin(HierPin hpinA, HierPort hportB) {
        if (hpinA == null || hportB == null) {
            return false;
        }
        if (hpinA.getPinTemplate() != hportB.getPinTemplate()) {
            return false;
        }
        DevicePath dpA = hpinA.getPath();
        DevicePath dpB = hportB.getPath();
        return dpB.isEndOf(dpA);
    }

    public void expandBundleEndRegion(Device devA, ARect stRegion, long dPinProx) {
        ArrayList pinDevA = Lists.newArrayList((Iterator)devA.getPins().iterator());
        boolean improved = true;
        while (improved) {
            improved = false;
            DevicePath dpA = devA.getADevicePath();
            for (PinInstance pin : pinDevA) {
                APoint2D pt = pin.getPinTemplate().getFirstPortTemplate().getWorldLoc(dpA);
                if (stRegion.contains(pt) || stRegion.distance(pt) >= dPinProx) continue;
                improved = true;
                stRegion.expand(pt);
            }
        }
    }

    public void createBundle(List<HierPin> pinFrom, List<HierPin> pinTo) {
        if (pinFrom == null || pinTo == null || pinFrom.size() != pinTo.size() || pinTo.isEmpty()) {
            ALog.logWarn((String)"No bundle creation");
            return;
        }
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        long wWidth = unit.fromUserString(this.WIRE_WIDTH);
        long wClr = unit.fromUserString(this.WIRE_CLEARANCE);
        long dPinProx = unit.fromUserString(this.PIN_PROXIMITY);
        DevicePath lowestCommonPath = pinFrom.get(0).getPath().commonAnscestor(pinTo.get(0).getPath());
        DeviceTemplate lowestCommonDevT = lowestCommonPath.getDeviceTemplate();
        Bundle bundle = Bundle.createBundle((Db)db, (String)this.AUTO_BUNDLENAME, (String)lowestCommonDevT.getKeyStr());
        int n = pinFrom.size();
        ARect stRectWorld = null;
        ARect edRectWorld = null;
        int success = 0;
        for (int i = 0; i < n; ++i) {
            HierPin hpA = pinFrom.get(i);
            HierPin hpB = pinTo.get(i);
            PortTemplate portA = hpA.getSecond().getPinTemplate().getFirstPortTemplate();
            PortTemplate portB = hpB.getSecond().getPinTemplate().getFirstPortTemplate();
            SchedConn sc = new SchedConn();
            sc.setOwner((DbObject)bundle);
            sc.setPortA(((DevicePath)hpA.getFirst()).getRelativePathFromAnchor(lowestCommonDevT), portA);
            sc.setPortB(((DevicePath)hpB.getFirst()).getRelativePathFromAnchor(lowestCommonDevT), portB);
            if (!sc.isValidBoth()) continue;
            db.add((DbObject)sc);
            ++success;
            stRectWorld = sc.getHierPortA().getWorldBounds().expandBy(stRectWorld);
            edRectWorld = sc.getHierPortB().getWorldBounds().expandBy(edRectWorld);
        }
        if (success == 0 || stRectWorld == null || edRectWorld == null) {
            ALog.logWarn((String)"No bundle creation");
            return;
        }
        ARect stRegion = stRectWorld.copy();
        ARect edRegion = edRectWorld.copy();
        bundle.setNumWires(n);
        bundle.setWireClr(wClr);
        bundle.setWireWidth(wWidth);
        APath path = this.autoGetBundlePath(bundle, stRectWorld, edRectWorld, stRegion, edRegion, dPinProx);
        if (this.CORNER_DRILLOUT) {
            long padding = dPinProx;
            this.drilloutFromRegion(padding, path, stRectWorld, stRegion, true);
            this.drilloutFromRegion(padding, path, edRectWorld, edRegion, false);
        }
        path.setWidth(bundle.bundleWidth());
        bundle.setPath(path);
        this.doOptimize(bundle);
    }

    private void doOptimize(Bundle bundle) {
        bundle.getRakePattern(true);
        bundle.getRakePattern(false);
        Cp.exec((String)"%s.deriveBestPattern(curDb(), \"%s\")", (Object[])new Object[]{BundleRakeUI.class.getName(), bundle.getKeyStr()});
        if (this.OPT_FREE_END) {
            Cp.exec((String)"_ibr = com.sigrity.orbit.automation.router.InteractiveBundleCreator.show()", (Object[])new Object[0]);
            Cp.exec((String)"_ibr.optimizeFreeEnd(\"%s\")", (Object[])new Object[]{bundle.getKeyStr()});
            Cp.exec((String)"unset(\"_ibr\")", (Object[])new Object[0]);
        }
    }

    private void drilloutFromRegion(long farDist, APath path, ARect endRect, ARect regionRect, boolean isFixedSide) {
        APoint2D st = null;
        APoint2D ed = null;
        st = isFixedSide ? path.getFirstPoint() : path.getLastPoint();
        ALine[] ilines = new ALine[]{endRect.getTopLine(), endRect.getBottomLine(), endRect.getLeftLine(), endRect.getRightLine()};
        ALine[] olines = new ALine[]{regionRect.getTopLine(), regionRect.getBottomLine(), regionRect.getLeftLine(), regionRect.getRightLine()};
        long minDist = Long.MAX_VALUE;
        int minDir = 0;
        for (int i = 0; i < 4; ++i) {
            long d = ilines[i].distance(olines[i]);
            if (d >= minDist) continue;
            minDist = d;
            minDir = i;
        }
        ed = endRect.center();
        if (minDir == 0) {
            ed.setY(regionRect.top() + farDist / 2L);
        } else if (minDir == 1) {
            ed.setY(regionRect.bottom() - farDist / 2L);
        } else if (minDir == 2) {
            ed.setX(regionRect.left() - farDist / 2L);
        } else if (minDir == 3) {
            ed.setX(regionRect.right() + farDist / 2L);
        }
        if (st.equals((Object)ed)) {
            return;
        }
        ARect expand = regionRect.expandBy(farDist / 2L);
        APoint2D[] pts = new APoint2D[]{st, ed, expand.getLL(), expand.getLR(), expand.getUL(), expand.getUR()};
        LinkedList<Integer> Q = new LinkedList<Integer>();
        int n = pts.length;
        int[] from = new int[n];
        long[] dist = new long[n];
        for (int i = 0; i < n; ++i) {
            dist[i] = Long.MAX_VALUE;
        }
        dist[0] = 0L;
        Q.add(0);
        while (!Q.isEmpty()) {
            int u = (Integer)Q.poll();
            for (int i = 0; i < n; ++i) {
                long d;
                if (u == i || pts[u].getX() != pts[i].getX() && pts[u].getY() != pts[i].getY() || dist[u] + (d = pts[u].distance(pts[i])) >= dist[i]) continue;
                dist[i] = dist[u] + d;
                from[i] = u;
                Q.add(i);
            }
        }
        ArrayList<APoint2D> sp = new ArrayList<APoint2D>();
        int u = 1;
        while (u != 0) {
            sp.add(pts[u]);
            u = from[u];
        }
        ArrayList pathPt = path.getPointsArray();
        if (isFixedSide) {
            pathPt.addAll(0, sp);
        } else {
            Collections.reverse(sp);
            pathPt.addAll(sp);
        }
    }

    protected void insertMiddlePathInDeg45(APath path, APoint2D st, APoint2D ed) {
        if (path == null) {
            return;
        }
        if (st.getX() == ed.getX() || st.getY() == ed.getY()) {
            return;
        }
        long dx = ed.getX() - st.getX();
        long dy = ed.getY() - st.getY();
        if (Math.abs(dx) == Math.abs(dy)) {
            return;
        }
        APoint2D mid = st.copy();
        if (Math.abs(dx) > Math.abs(dy)) {
            mid.setY(mid.getY() + dy);
            mid.setX(mid.getX() + Math.abs(dy) * (long)(dx < 0L ? -1 : 1));
        } else {
            mid.setX(mid.getX() + dx);
            mid.setY(mid.getY() + Math.abs(dx) * (long)(dy < 0L ? -1 : 1));
        }
        path.addPoint(mid);
    }

    protected APath autoGetBundlePath(Bundle bundle, ARect stRectWorld, ARect edRectWorld, ARect stRegion, ARect edRegion, long dPinProx) {
        APoint2D ed;
        APath path = new APath();
        if (bundle == null || stRectWorld == null || edRectWorld == null) {
            return path;
        }
        double snapDirAngle = 90.0;
        double snapEPS = 0.001;
        long traceWidth = bundle.bundleWidth();
        APoint2D st = stRectWorld.center();
        double theta = st.getAngle(ed = edRectWorld.center());
        double snapAngle = AGeomUtil.normDeg((double)(Math.floor((theta + 45.0) / 90.0) * 90.0));
        if (Math.abs(snapAngle) < 0.001) {
            st.setX(stRegion.right() + dPinProx / 2L);
            ed.setX(edRegion.left() - dPinProx / 2L);
            APoint2D stHead = st.copy();
            APoint2D edHead = ed.copy();
            if (stHead.getX() + traceWidth * 2L < edHead.getX()) {
                stHead.setX(stHead.getX() + traceWidth * 2L);
            }
            if (edHead.getX() - traceWidth * 2L > stHead.getX()) {
                edHead.setX(edHead.getX() - traceWidth * 2L);
            }
            path.addPoint(st);
            path.addPoint(stHead);
            this.insertMiddlePathInDeg45(path, stHead, edHead);
            path.addPoint(edHead);
            path.addPoint(ed);
        } else if (Math.abs(snapAngle - 90.0) < 0.001) {
            st.setY(stRegion.top() + dPinProx / 2L);
            ed.setY(edRegion.bottom() - dPinProx / 2L);
            APoint2D stHead = st.copy();
            APoint2D edHead = ed.copy();
            if (stHead.getY() + traceWidth * 2L < edHead.getY()) {
                stHead.setY(stHead.getY() + traceWidth * 2L);
            }
            if (edHead.getY() - traceWidth * 2L > stHead.getY()) {
                edHead.setY(edHead.getY() - traceWidth * 2L);
            }
            path.addPoint(st);
            path.addPoint(stHead);
            this.insertMiddlePathInDeg45(path, stHead, edHead);
            path.addPoint(edHead);
            path.addPoint(ed);
        } else if (Math.abs(snapAngle - 180.0) < 0.001) {
            st.setX(stRegion.left() - dPinProx / 2L);
            ed.setX(edRegion.right() + dPinProx / 2L);
            APoint2D stHead = st.copy();
            APoint2D edHead = ed.copy();
            if (stHead.getX() - traceWidth * 2L > edHead.getX()) {
                stHead.setX(stHead.getX() - traceWidth * 2L);
            }
            if (edHead.getX() + traceWidth * 2L < stHead.getX()) {
                edHead.setX(edHead.getX() + traceWidth * 2L);
            }
            path.addPoint(st);
            path.addPoint(stHead);
            this.insertMiddlePathInDeg45(path, stHead, edHead);
            path.addPoint(edHead);
            path.addPoint(ed);
        } else if (Math.abs(snapAngle - 270.0) < 0.001) {
            st.setY(stRegion.bottom() - dPinProx / 2L);
            ed.setY(edRegion.top() + dPinProx / 2L);
            APoint2D stHead = st.copy();
            APoint2D edHead = ed.copy();
            if (stHead.getY() - traceWidth * 2L > edHead.getY()) {
                stHead.setY(stHead.getY() - traceWidth * 2L);
            }
            if (edHead.getY() + traceWidth * 2L < stHead.getY()) {
                edHead.setY(edHead.getY() + traceWidth * 2L);
            }
            path.addPoint(st);
            path.addPoint(stHead);
            this.insertMiddlePathInDeg45(path, stHead, edHead);
            path.addPoint(edHead);
            path.addPoint(ed);
        } else {
            assert (false);
            path.addPoint(stRectWorld.center());
            path.addPoint(edRectWorld.center());
        }
        path.removeRedundantPoints();
        return path;
    }

    public void addConnection(HierPin hpA, HierPin hpB, Set<HierPin> selPins, Set<APair<HierPin, HierPin>> connSet, List<APair<HierPin, HierPin>> connList) {
        if (!selPins.contains(hpA) && !selPins.contains(hpB)) {
            return;
        }
        APair c1 = new APair((Object)hpA, (Object)hpB);
        APair c2 = new APair((Object)hpB, (Object)hpA);
        if (!(HConnEngine.bundleConnected((HierPin)hpA, (HierPin)hpB) || connSet.contains(c1) || connSet.contains(c2))) {
            connSet.add((APair<HierPin, HierPin>)c1);
            connSet.add((APair<HierPin, HierPin>)c2);
            if (selPins.contains(c1.first)) {
                connList.add((APair<HierPin, HierPin>)c1);
            } else {
                connList.add((APair<HierPin, HierPin>)c2);
            }
        }
    }

    public ArrayList<APair<HierPin, HierPin>> findConnections(Db db, Set<HierPin> selPins, Set<Net> topNets) {
        HashSet connSet = new HashSet();
        ArrayList<APair<HierPin, HierPin>> connList = new ArrayList<APair<HierPin, HierPin>>();
        HConnEngine hce = new HConnEngine(db);
        HashSet designTopHierNets = new HashSet();
        OrbitApp.getCurDesign().getDescendantDevices().stream().forEach(dp -> hce.developTopMostNets(dp, (Set)designTopHierNets));
        Set topHierNets = designTopHierNets.stream().filter(p -> topNets.contains(p.second)).collect(Collectors.toSet());
        int assumePowerNetSize = Integer.parseInt(this.POWERNET_SIZE);
        for (HierNet hn : topHierNets) {
            Map sortedBySubstrate = hce.collectBySubstrate(hn);
            sortedBySubstrate.keySet().stream().forEach(k -> Collections.sort((List)sortedBySubstrate.get(k), new HConnEngine.HierPinSorter()));
            for (Map.Entry e : sortedBySubstrate.entrySet()) {
                List pins = (List)e.getValue();
                if (pins.size() < 2 || pins.size() < 2 || pins.size() >= assumePowerNetSize) continue;
                AMinSpanTree mst = new AMinSpanTree();
                MSTGraph g = mst.find(pins, HConnEngine::pinAndPathDistance);
                g.getEdges().stream().forEach(edge -> this.addConnection((HierPin)edge.getP0(), (HierPin)edge.getP1(), selPins, connSet, connList));
            }
            List pins = sortedBySubstrate.keySet().stream().filter(k -> ((HConnEngine.ListOfPins)sortedBySubstrate.get(k)).size() > 0).map(k -> (HierPin)((HConnEngine.ListOfPins)sortedBySubstrate.get(k)).get(0)).collect(Collectors.toList());
            if (pins.size() < 2 || pins.size() >= assumePowerNetSize) continue;
            AMinSpanTree mst = new AMinSpanTree();
            MSTGraph g = mst.find(pins, HConnEngine::pinAndPathDistance);
            g.getEdges().stream().forEach(edge -> this.addConnection((HierPin)edge.getP0(), (HierPin)edge.getP1(), selPins, connSet, connList));
        }
        return connList;
    }

    public ArrayList<APair<HierPin, HierPin>> findConnections(Set<HierPin> stPins, Set<HierPin> edPins) {
        ArrayList<HierPin> t;
        Net topnet;
        HashSet<APair<HierPin, HierPin>> connSet = new HashSet<APair<HierPin, HierPin>>();
        ArrayList<APair<HierPin, HierPin>> connList = new ArrayList<APair<HierPin, HierPin>>();
        HashMap<Net, ArrayList<HierPin>> stR = new HashMap<Net, ArrayList<HierPin>>();
        HashMap<Net, ArrayList<HierPin>> edR = new HashMap<Net, ArrayList<HierPin>>();
        int assumePowerNetSize = Integer.parseInt(this.POWERNET_SIZE);
        for (HierPin hierPin : stPins) {
            topnet = hierPin.getTopMostNet();
            t = (ArrayList<HierPin>)stR.get(topnet);
            if (t == null) {
                t = new ArrayList<HierPin>();
                stR.put(topnet, t);
            }
            t.add(hierPin);
        }
        for (HierPin hierPin : edPins) {
            topnet = hierPin.getTopMostNet();
            t = (ArrayList<HierPin>)edR.get(topnet);
            if (t == null) {
                t = new ArrayList<HierPin>();
                edR.put(topnet, t);
            }
            t.add(hierPin);
        }
        for (Map.Entry entry : stR.entrySet()) {
            Net topmostNet = (Net)entry.getKey();
            ArrayList a = (ArrayList)entry.getValue();
            ArrayList b = (ArrayList)edR.get(topmostNet);
            if (a == null || b == null || a.size() + b.size() < 2 || a.size() + b.size() >= assumePowerNetSize) continue;
            for (HierPin from : a) {
                for (HierPin to : b) {
                    this.addConnection(from, to, stPins, connSet, connList);
                }
            }
        }
        return connList;
    }

    public void addHierInst(HierInst<DbObject> hi) {
        this.mSelection.add(hi);
    }

    public void addFromHierInst(HierInst<PinInstance> hi) {
        this.mPinFrom.add(HierPin.forHPin(hi));
    }

    public void addToHierInst(HierInst<PinInstance> hi) {
        this.mPinTo.add(HierPin.forHPin(hi));
    }

    public int run() {
        Db db = OrbitIO.getCurDb();
        Pattern POWERPIN_NETNAME = Pattern.compile(this.IGNORE_PIN_NAME_REGEX);
        HashSet<HierPin> selPins = new HashSet<HierPin>();
        HashSet<Net> topNets = new HashSet<Net>();
        this.mSelection.getSelectedHierInsts(PinInstance.class).forEach(o -> {
            PinInstance pinA = (PinInstance)o.getDbObject();
            DevicePath dpath = o.getPath();
            PinTemplate pinTA = pinA.getPinTemplate();
            HierPin hpA = HierPin.forPinT((DevicePath)dpath, (PinTemplate)pinTA);
            Net topmostNet = NetMap.getTopmostNet((Net)pinTA.getNet(), (DevicePath)dpath);
            if (hpA.getWorldBounds() == null || this.IGNORE_POWER_PIN && hpA.isPower()) {
                return;
            }
            if (this.IGNORE_TOPMOSTNET_NAME && POWERPIN_NETNAME.matcher(topmostNet.getName()).matches()) {
                return;
            }
            topNets.add(topmostNet);
            selPins.add(hpA);
        });
        ArrayList<APair<HierPin, HierPin>> connList = this.findConnections(db, selPins, topNets);
        if (this.BUNDLE_PATH_DIR == 1) {
            for (APair<HierPin, HierPin> e : connList) {
                HierPin tmp = (HierPin)e.first;
                e.first = e.second;
                e.second = tmp;
            }
        }
        ALog.logInfo((String)"Load %d connection into Auto Bundle Engine", (Object[])new Object[]{connList.size()});
        return this.grouping(connList);
    }

    public int go() {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        this.mSelection = s.copy();
        return this.run();
    }

    public int go(String devFromKeyStr, String devToKeyStr) {
        Net topmostNet;
        HierPin hp;
        Db db = OrbitIO.getCurDb();
        Device devSt = (Device)db.getByKeyStr(Device.class, devFromKeyStr);
        Device devEd = (Device)db.getByKeyStr(Device.class, devToKeyStr);
        if (devSt == null || devEd == null) {
            ALog.logError((String)"Invalid arguments for auto-bundle engine");
            return 0;
        }
        Pattern POWERPIN_NETNAME = Pattern.compile(this.IGNORE_PIN_NAME_REGEX);
        HashSet<HierPin> stPins = new HashSet<HierPin>();
        HashSet<HierPin> edPins = new HashSet<HierPin>();
        DevicePath stDp = devSt.getADevicePath();
        DevicePath edDp = devEd.getADevicePath();
        for (PinInstance pin : devSt.getPins()) {
            hp = new HierPin(stDp, pin);
            if (hp.getWorldBounds() == null || this.IGNORE_POWER_PIN && hp.isPower()) continue;
            topmostNet = hp.getTopMostNet();
            if (this.IGNORE_TOPMOSTNET_NAME && POWERPIN_NETNAME.matcher(topmostNet.getName()).matches()) continue;
            stPins.add(hp);
        }
        for (PinInstance pin : devEd.getPins()) {
            hp = new HierPin(edDp, pin);
            if (hp.getWorldBounds() == null || this.IGNORE_POWER_PIN && hp.isPower()) continue;
            topmostNet = hp.getTopMostNet();
            if (this.IGNORE_TOPMOSTNET_NAME && POWERPIN_NETNAME.matcher(topmostNet.getName()).matches()) continue;
            edPins.add(hp);
        }
        ArrayList<APair<HierPin, HierPin>> connList = this.findConnections(stPins, edPins);
        ALog.logInfo((String)"Load %d connection into Auto Bundle Engine", (Object[])new Object[]{connList.size()});
        return this.grouping(connList);
    }

    public int runSingle() {
        this.createBundle(this.mPinFrom, this.mPinTo);
        return 1;
    }

    private int commit(List<EndGroup> egroups) {
        int creationCount = 0;
        for (EndGroup eg : egroups) {
            if (!this.MUST_IN_INTERFACE && eg.stRegion.intersects(eg.edRegion)) {
                ALog.logWarn((String)"Too close for groups: Ignore bundle creation %s %s", (Object[])new Object[]{eg.stRegion, eg.edRegion});
                continue;
            }
            ALog.logInfo((String)"Create a bundle with %d connections\n", (Object[])new Object[]{eg.size()});
            ++creationCount;
            this.createBundle(eg.stPins, eg.edPins);
        }
        if (creationCount == 0) {
            ALog.logInfo((String)"No bundle creation");
        }
        OrbitIO.getApp().refreshCurrentView(false);
        return creationCount;
    }

    private Interface getLowestInterface(HierPin hp) {
        Net net = hp.getNet();
        DevicePath devPath = hp.getPath();
        for (NetMap nm : NetMap.getConnectedNets((Net)net, (DevicePath)devPath)) {
            net = nm.getChildNet();
            Interface intf = Interface.findInterface((Db)net.getDb(), (Net)net);
            if (intf == null) continue;
            return intf;
        }
        return null;
    }

    private int grouping(ArrayList<APair<HierPin, HierPin>> connList) {
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        Unit.Distance unit = currentDesign.getUnit();
        long dPinProx = unit.fromUserString(this.PIN_PROXIMITY);
        int minRatNets = Integer.parseInt(this.MIN_RAT_NETS);
        LinkedList<EndGroup> egroups = new LinkedList<EndGroup>();
        if (this.MUST_IN_INTERFACE) {
            HashMap<Interface, ArrayList<APair<HierPin, HierPin>>> intfGroup = new HashMap<Interface, ArrayList<APair<HierPin, HierPin>>>();
            for (APair<HierPin, HierPin> aPair : connList) {
                Interface rIntf;
                Interface lIntf = this.getLowestInterface((HierPin)aPair.first);
                if (lIntf != (rIntf = this.getLowestInterface((HierPin)aPair.second)) || lIntf == null) continue;
                ArrayList<APair<HierPin, HierPin>> g = (ArrayList<APair<HierPin, HierPin>>)intfGroup.get(lIntf);
                if (g == null) {
                    g = new ArrayList<APair<HierPin, HierPin>>();
                    intfGroup.put(lIntf, g);
                }
                g.add(aPair);
            }
            for (Map.Entry entry : intfGroup.entrySet()) {
                EndGroup eg = new EndGroup();
                ArrayList g = (ArrayList)entry.getValue();
                APoint2D lbase = ((HierPin)((APair)g.get((int)0)).first).getWorldLoc();
                APoint2D rbase = ((HierPin)((APair)g.get((int)0)).second).getWorldLoc();
                egroups.add(eg);
                for (APair conn : g) {
                    long dist2;
                    APoint2D lpt = ((HierPin)conn.first).getWorldLoc();
                    APoint2D rpt = ((HierPin)conn.second).getWorldLoc();
                    long dist1 = Math.max(lbase.distance(lpt), rbase.distance(rpt));
                    if (dist1 < (dist2 = Math.max(lbase.distance(rpt), rbase.distance(lpt)))) {
                        eg.addConnection((HierPin)conn.first, (HierPin)conn.second);
                        continue;
                    }
                    eg.addConnection((HierPin)conn.second, (HierPin)conn.first);
                }
            }
            return this.commit(egroups);
        }
        for (APair<HierPin, HierPin> pin2 : connList) {
            EndGroup endGroup = new EndGroup();
            endGroup.addConnection((HierPin)pin2.getFirst(), (HierPin)pin2.getSecond());
            egroups.add(endGroup);
        }
        Collections.sort(egroups);
        boolean improved = true;
        while (improved) {
            improved = false;
            Iterator it = egroups.iterator();
            while (it.hasNext()) {
                EndGroup endGroup = (EndGroup)it.next();
                boolean join = false;
                for (EndGroup v : egroups) {
                    if (endGroup == v) continue;
                    int ret = v.joinable(dPinProx, endGroup);
                    if (ret == 1) {
                        endGroup.swapSide();
                    }
                    if (ret < 0) continue;
                    v.mergeEndGroup(endGroup);
                    join = true;
                    improved = true;
                    break;
                }
                if ((join || endGroup.size() >= minRatNets) && !join) continue;
                it.remove();
            }
        }
        return this.commit(egroups);
    }

    protected static class EndGroup
    implements Comparable<EndGroup> {
        protected ARect stRegion = null;
        protected ARect edRegion = null;
        protected ArrayList<HierPin> stPins = new ArrayList();
        protected ArrayList<HierPin> edPins = new ArrayList();

        public void addConnection(HierPin st, HierPin ed) {
            this.stPins.add(st);
            this.edPins.add(ed);
            this.stRegion = st.getWorldBounds().expandBy(this.stRegion);
            this.edRegion = ed.getWorldBounds().expandBy(this.edRegion);
        }

        static boolean groupDistanceSmallThan(ArrayList<HierPin> aPins, ArrayList<HierPin> bPins, long dist) {
            for (int i = 0; i < aPins.size(); ++i) {
                HierPin pi = aPins.get(i);
                for (int j = 0; j < bPins.size(); ++j) {
                    HierPin pj = bPins.get(j);
                    if (pi.getWorldLoc().distance(pj.getWorldLoc()) > dist) continue;
                    return true;
                }
            }
            return false;
        }

        static boolean endGroupDistanceSmallThan(EndGroup g1, EndGroup g2, boolean swap, long dist) {
            if (!swap) {
                return EndGroup.groupDistanceSmallThan(g1.stPins, g2.stPins, dist) && EndGroup.groupDistanceSmallThan(g1.edPins, g2.edPins, dist);
            }
            return EndGroup.groupDistanceSmallThan(g1.stPins, g2.edPins, dist) && EndGroup.groupDistanceSmallThan(g1.edPins, g2.stPins, dist);
        }

        public int joinable(long dist, EndGroup eg) {
            if (this.size() == 0) {
                return 0;
            }
            if (eg.size() == 0) {
                return -1;
            }
            Long d1 = eg.stRegion.distanceTo(this.stRegion);
            Long d2 = eg.edRegion.distanceTo(this.edRegion);
            if (!(d1 != null && d1 > dist || d2 != null && d2 > dist)) {
                if (EndGroup.endGroupDistanceSmallThan(this, eg, false, dist)) {
                    return 0;
                }
                return -1;
            }
            d1 = eg.stRegion.distanceTo(this.edRegion);
            d2 = eg.edRegion.distanceTo(this.stRegion);
            if (!(d1 != null && d1 > dist || d2 != null && d2 > dist)) {
                if (EndGroup.endGroupDistanceSmallThan(this, eg, true, dist)) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }

        public void mergeEndGroup(EndGroup eg) {
            if (eg.size() == 0) {
                return;
            }
            this.stRegion = eg.stRegion.expandBy(this.stRegion);
            this.edRegion = eg.edRegion.expandBy(this.edRegion);
            this.stPins.addAll(eg.stPins);
            this.edPins.addAll(eg.edPins);
        }

        public void swapSide() {
            ARect t1 = this.stRegion;
            this.stRegion = this.edRegion;
            this.edRegion = t1;
            ArrayList<HierPin> t2 = this.stPins;
            this.stPins = this.edPins;
            this.edPins = t2;
        }

        public int size() {
            return this.stPins.size();
        }

        @Override
        public int compareTo(EndGroup other) {
            int ret = this.stRegion.compareTo((AGeom)other.stRegion);
            if (ret != 0) {
                return ret;
            }
            return this.edRegion.compareTo((AGeom)other.edRegion);
        }
    }
}

