/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AutoBundleNetUI {
    public static final String DEFAULT_PIN_PROXIMITY = "1000";
    public static final String DEFAULT_MIN_RAT_NETS = "8";
    public static final String DEFAULT_AUTO_BUNDLENAME = "bundle";
    public static final String DEFAULT_WIRE_WIDTH = "20";
    public static final String DEFAULT_WIRE_CLEARANCE = "20";
    public static final String DEFAULT_POWERNET_SIZE = "50";
    public static final boolean DEFAULT_ALLOW_SAME_DEVICE = false;
    public static final boolean DEFAULT_IGNORE_POWER_PIN = true;
    public static final boolean DEFAULT_IGNORE_TOPMOSTNET_NAME = true;
    public static final boolean DEFAULT_MUST_IN_INTERFACE = false;
    public static final String DEFAULT_IGNORE_PIN_NAME_REGEX = "(power|pwr|ground|gnd|vcc|vss|vdd|GND|VCC|VSS|VDD|\\+\\d+v)(.*)";
    public static final int DEFUALT_BUNDLE_PATH_DIR = 0;
    public static final boolean DEFAULT_OPT_FREE_END = false;
    private static String PIN_PROXIMITY = "1000";
    private static String MIN_RAT_NETS = "8";
    private static String AUTO_BUNDLENAME = "bundle";
    private static String WIRE_WIDTH = "20";
    private static String WIRE_CLEARANCE = "20";
    private static String POWERNET_SIZE = "50";
    private static boolean ALLOW_SAME_DEVICE = false;
    private static boolean IGNORE_POWER_PIN = true;
    private static boolean IGNORE_TOPMOSTNET_NAME = true;
    private static boolean MUST_IN_INTERFACE = false;
    private static String IGNORE_PIN_NAME_REGEX = "(power|pwr|ground|gnd|vcc|vss|vdd|GND|VCC|VSS|VDD|\\+\\d+v)(.*)";
    private static int BUNDLE_PATH_DIR = 0;
    private static boolean CORNER_DRILLOUT = false;
    private static boolean OPT_FREE_END = false;
    private static JPanel mPreferencePanel = null;
    private static JTextField mIgnorePinNameRegex;
    private static JTextField mProximityField;
    private static JTextField mRatField;
    private static JTextField mClrField;
    private static JTextField mWidthField;
    private static JTextField mNameField;
    private static JTextField mPowerNetSizeField;
    private static JRadioButton mPathFromBtn;
    private static JRadioButton mPathToBtn;
    private static JCheckBox mSameDeviceCB;
    private static JCheckBox mIgnorePowerPinCB;
    private static JCheckBox mIgnoreTopmostNetNameCB;
    private static JCheckBox mMustInInterfaceCB;
    private static JCheckBox mOptimizeFreeEndCB;
    protected static ActionListener applySettingAction;
    protected static Action restoreSettingAction;
    protected static Action createBySelectionAction;
    protected static Action createByDesignAction;

    protected static JPanel createAutoBundlePanel() {
        if (mPreferencePanel != null) {
            return mPreferencePanel;
        }
        mPreferencePanel = new JPanel();
        GridBagManager l = new GridBagManager((Container)mPreferencePanel);
        mProximityField = new JTextField(10);
        mRatField = new JTextField(10);
        mRatField.setToolTipText("Minimum Connection Count");
        mSameDeviceCB = new JCheckBox("Allow on the same device");
        mIgnorePowerPinCB = new JCheckBox("Ignore power pin");
        mIgnoreTopmostNetNameCB = new JCheckBox("Ignore topmost net name");
        mMustInInterfaceCB = new JCheckBox("<html>Must be in the same interface<font color='gray'>(ignore connection count, pin proimity)</font>.</html>");
        mIgnorePinNameRegex = new JTextField(10);
        mPowerNetSizeField = new JTextField(10);
        l.push("Pin Group Options", (GridBagConstraints)GridBagManager.FILLALL);
        l.add("Minimum Count:", (Component)mRatField, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add("Pin Proximity:", (Component)mProximityField, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add("Connection Filter:", (Component)mSameDeviceCB, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.newline();
        l.indent();
        l.add((Component)mIgnorePowerPinCB, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.newline();
        l.indent();
        l.add((Component)mIgnoreTopmostNetNameCB, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.add((Component)mIgnorePinNameRegex, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.newline();
        l.add("Power Net Size:", (Component)mPowerNetSizeField, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add((Component)mMustInInterfaceCB, (GridBagConstraints)GridBagManager.LEFT.width(3));
        l.addFillX();
        l.addFillY();
        l.pop();
        l.newline();
        mClrField = new JTextField(10);
        mWidthField = new JTextField(10);
        mNameField = new JTextField(10);
        mPathFromBtn = new JRadioButton("Fixed");
        mPathToBtn = new JRadioButton("Free");
        mOptimizeFreeEndCB = new JCheckBox("Optimize Free End");
        ButtonGroup pathDirGroup = new ButtonGroup();
        pathDirGroup.add(mPathFromBtn);
        pathDirGroup.add(mPathToBtn);
        l.push("Bundle Options", (GridBagConstraints)GridBagManager.FILLX);
        l.add("Wire Width:", (Component)mWidthField, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add("Wire Clearance:", (Component)mClrField, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add("Prefix Name:", (Component)mNameField, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add("Path Direction:", (Component)mPathFromBtn, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.newline();
        l.indent();
        l.add((Component)mPathToBtn, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.add("selected pins", (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.newline();
        l.add("Optimization:", (Component)mOptimizeFreeEndCB);
        l.addFillX();
        l.newline();
        l.pop();
        l.newline();
        JButton restoreBtn = new JButton(restoreSettingAction);
        JButton createByPin = new JButton(createBySelectionAction);
        JButton createByDesign = new JButton(createByDesignAction);
        createByDesign.setEnabled(false);
        l.add((Component)restoreBtn, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        l.add((Component)createByPin, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)createByDesign, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        l.newline();
        AutoBundleNetUI.refreshUI();
        return mPreferencePanel;
    }

    public static JPanel createAutoBundlePanel(JDialog owner) {
        owner.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                AutoBundleNetUI.applyUI();
            }
        });
        return AutoBundleNetUI.createAutoBundlePanel();
    }

    public static void refreshUI() {
        mProximityField.setText(PIN_PROXIMITY);
        mRatField.setText(MIN_RAT_NETS);
        mNameField.setText(AUTO_BUNDLENAME);
        mWidthField.setText(WIRE_WIDTH);
        mClrField.setText(WIRE_CLEARANCE);
        mPowerNetSizeField.setText(POWERNET_SIZE);
        mSameDeviceCB.setSelected(ALLOW_SAME_DEVICE);
        mIgnorePowerPinCB.setSelected(IGNORE_POWER_PIN);
        mIgnoreTopmostNetNameCB.setSelected(IGNORE_TOPMOSTNET_NAME);
        mIgnorePinNameRegex.setEnabled(mIgnoreTopmostNetNameCB.isSelected());
        mIgnorePinNameRegex.setText(IGNORE_PIN_NAME_REGEX);
        if (BUNDLE_PATH_DIR == 0) {
            mPathFromBtn.setSelected(true);
        } else {
            mPathToBtn.setSelected(true);
        }
        mOptimizeFreeEndCB.setSelected(OPT_FREE_END);
        mPreferencePanel.revalidate();
        mPreferencePanel.repaint();
    }

    public static void applyUI() {
        if (mPreferencePanel == null) {
            AutoBundleNetUI.createAutoBundlePanel();
        }
        PIN_PROXIMITY = mProximityField.getText();
        MIN_RAT_NETS = mRatField.getText();
        AUTO_BUNDLENAME = mNameField.getText();
        WIRE_WIDTH = mWidthField.getText();
        WIRE_CLEARANCE = mClrField.getText();
        POWERNET_SIZE = mPowerNetSizeField.getText();
        ALLOW_SAME_DEVICE = mSameDeviceCB.isSelected();
        IGNORE_POWER_PIN = mIgnorePowerPinCB.isSelected();
        IGNORE_TOPMOSTNET_NAME = mIgnoreTopmostNetNameCB.isSelected();
        MUST_IN_INTERFACE = mMustInInterfaceCB.isSelected();
        if (mIgnoreTopmostNetNameCB.isSelected()) {
            IGNORE_PIN_NAME_REGEX = mIgnorePinNameRegex.getText();
        }
        BUNDLE_PATH_DIR = mPathFromBtn.isSelected() ? 0 : 1;
        OPT_FREE_END = mOptimizeFreeEndCB.isSelected();
    }

    public static int go() {
        AutoBundleNetUI.applyUI();
        DbHistory history = OrbitIO.getCurDb().getHistory();
        int result = 0;
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Auto Bundle on Selected Devices");){
            Cp.exec((String)"_autoBundleEngine = new com.sigrity.orbit.automation.AutoBundleNetEngine()", (Object[])new Object[0]);
            Cp.exec((String)"_autoBundleEngine.setOptions(\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", %b, %b, %b, %b, \"%s\", %d, %b)", (Object[])new Object[]{PIN_PROXIMITY, MIN_RAT_NETS, AUTO_BUNDLENAME, WIRE_WIDTH, WIRE_CLEARANCE, POWERNET_SIZE, ALLOW_SAME_DEVICE, IGNORE_POWER_PIN, IGNORE_TOPMOSTNET_NAME, MUST_IN_INTERFACE, IGNORE_PIN_NAME_REGEX, BUNDLE_PATH_DIR, CORNER_DRILLOUT});
            Cp.exec((String)"_autoBundleEngine.setOptimizeFreeEnd(%b)", (Object[])new Object[]{OPT_FREE_END});
            result = (Integer)Cp.exec((String)"_autoBundleEngine.go()", (Object[])new Object[0]);
        }
        return result;
    }

    public static int go(String devFromKeyStr, String devToKeyStr) {
        AutoBundleNetUI.applyUI();
        DbHistory history = OrbitIO.getCurDb().getHistory();
        int result = 0;
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Auto Bundle on Selected Devices");){
            Cp.exec((String)"_autoBundleEngine = new com.sigrity.orbit.automation.AutoBundleNetEngine()", (Object[])new Object[0]);
            Cp.exec((String)"_autoBundleEngine.setOptions(\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", %b, %b, %b, %b, \"%s\", %d, %b)", (Object[])new Object[]{PIN_PROXIMITY, MIN_RAT_NETS, AUTO_BUNDLENAME, WIRE_WIDTH, WIRE_CLEARANCE, POWERNET_SIZE, ALLOW_SAME_DEVICE, IGNORE_POWER_PIN, IGNORE_TOPMOSTNET_NAME, MUST_IN_INTERFACE, IGNORE_PIN_NAME_REGEX, BUNDLE_PATH_DIR, CORNER_DRILLOUT});
            Cp.exec((String)"_autoBundleEngine.setOptimizeFreeEnd(%b)", (Object[])new Object[]{OPT_FREE_END});
            result = (Integer)Cp.exec((String)"_autoBundleEngine.go(\"%s\", \"%s\")", (Object[])new Object[]{devFromKeyStr, devToKeyStr});
            Cp.exec((String)"unset(\"_autoBundleEngine\");", (Object[])new Object[0]);
        }
        return result;
    }

    public static int go(Selection selection) {
        AutoBundleNetUI.applyUI();
        DbHistory history = OrbitIO.getCurDb().getHistory();
        int result = 0;
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Auto Bundle on Selected Pins");){
            Cp.exec((String)"_autoBundleEngine = new com.sigrity.orbit.automation.AutoBundleNetEngine()", (Object[])new Object[0]);
            Cp.exec((String)"_autoBundleEngine.setOptions(\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", %b, %b, %b, %b, \"%s\", %d, %b)", (Object[])new Object[]{PIN_PROXIMITY, MIN_RAT_NETS, AUTO_BUNDLENAME, WIRE_WIDTH, WIRE_CLEARANCE, POWERNET_SIZE, ALLOW_SAME_DEVICE, IGNORE_POWER_PIN, IGNORE_TOPMOSTNET_NAME, MUST_IN_INTERFACE, IGNORE_PIN_NAME_REGEX, BUNDLE_PATH_DIR, CORNER_DRILLOUT});
            Cp.exec((String)"_autoBundleEngine.setOptimizeFreeEnd(%b)", (Object[])new Object[]{OPT_FREE_END});
            selection.getAllHierInsts().forEach(hi -> Cp.exec((String)"_autoBundleEngine.addHierInst(%s)", (Object[])new Object[]{hi.toCpString()}));
            result = (Integer)Cp.exec((String)"_autoBundleEngine.run()", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_autoBundleEngine\");", (Object[])new Object[0]);
        }
        return result;
    }

    public static int go(List<HierPin> pinFrom, List<HierPin> pinTo) {
        AutoBundleNetUI.applyUI();
        DbHistory history = OrbitIO.getCurDb().getHistory();
        int result = 0;
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Auto Bundle on Selected Pins");){
            Cp.exec((String)"_autoBundleEngine = new com.sigrity.orbit.automation.AutoBundleNetEngine()", (Object[])new Object[0]);
            Cp.exec((String)"_autoBundleEngine.setOptions(\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", %b, %b, %b, %b, \"%s\", %d, %b)", (Object[])new Object[]{PIN_PROXIMITY, MIN_RAT_NETS, AUTO_BUNDLENAME, WIRE_WIDTH, WIRE_CLEARANCE, POWERNET_SIZE, ALLOW_SAME_DEVICE, IGNORE_POWER_PIN, IGNORE_TOPMOSTNET_NAME, MUST_IN_INTERFACE, IGNORE_PIN_NAME_REGEX, BUNDLE_PATH_DIR, CORNER_DRILLOUT});
            Cp.exec((String)"_autoBundleEngine.setOptimizeFreeEnd(%b)", (Object[])new Object[]{OPT_FREE_END});
            for (HierPin hi : pinFrom) {
                Cp.exec((String)"_autoBundleEngine.addFromHierInst(%s)", (Object[])new Object[]{hi.toCpString()});
            }
            for (HierPin hi : pinTo) {
                Cp.exec((String)"_autoBundleEngine.addToHierInst(%s)", (Object[])new Object[]{hi.toCpString()});
            }
            result = (Integer)Cp.exec((String)"_autoBundleEngine.runSingle()", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_autoBundleEngine\");", (Object[])new Object[0]);
        }
        return result;
    }

    static {
        applySettingAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoBundleNetUI.applyUI();
            }
        };
        restoreSettingAction = new AbstractAction("Restore Defaults"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PIN_PROXIMITY = AutoBundleNetUI.DEFAULT_PIN_PROXIMITY;
                MIN_RAT_NETS = AutoBundleNetUI.DEFAULT_MIN_RAT_NETS;
                AUTO_BUNDLENAME = AutoBundleNetUI.DEFAULT_AUTO_BUNDLENAME;
                WIRE_WIDTH = "20";
                WIRE_CLEARANCE = "20";
                ALLOW_SAME_DEVICE = false;
                IGNORE_POWER_PIN = true;
                IGNORE_TOPMOSTNET_NAME = true;
                IGNORE_PIN_NAME_REGEX = AutoBundleNetUI.DEFAULT_IGNORE_PIN_NAME_REGEX;
                BUNDLE_PATH_DIR = 0;
                POWERNET_SIZE = AutoBundleNetUI.DEFAULT_POWERNET_SIZE;
                MUST_IN_INTERFACE = false;
                OPT_FREE_END = false;
                AutoBundleNetUI.refreshUI();
            }
        };
        createBySelectionAction = new AbstractAction("Create by selected pins", OrbitIcons.ROUTE_EDIT){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoBundleNetUI.go();
            }
        };
        createByDesignAction = new AbstractAction("Create by design", OrbitIcons.ROUTE_EDIT){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoBundleNetUI.go();
            }
        };
    }
}

