/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.AFile;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.NetClassifier;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.log.ASessionLogWriter;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.acl.topology.Binner;
import com.sigrity.acl.ui.log.ALogHelper;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.ViaFanout;
import com.sigrity.orbit.term.Bump2Term;
import com.sigrity.orbit.term.TermList;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

public class BumpFanout {
    private Db mDb = null;
    private BumpType mBumpType = null;
    private BumpAlignment mBumpPos = BumpAlignment.CENTER2CENTER;
    private Layer mStartLayer = null;
    private DeviceTemplate mDevT = null;
    private PadTemplate mPadT = null;
    private boolean mIncludeUnassignedPins = false;
    private boolean mIncludeAllInstances = true;
    private boolean mAutoGenNet = false;
    private boolean mMirror = false;
    private float mRotate = 0.0f;
    private int mTotal = 0;
    private int mNumNotOnStartLayer = 0;
    private FilterOp mShapeSizeFilterOp = FilterOp.GREATEREQ;
    private long mShapeWidthFilter = 0L;
    private long mShapeHeightFilter = 0L;
    private long mBumpBumpPitch = 0L;
    private APoint2D mRefWorldLoc = null;
    private String mRefTermPrefix = null;
    private String mRefTermFilePath = null;
    private NameGenerator mNameGenerator = new NameGenerator("BUMP", false);
    private Map<String, String> mReferTermMap = null;
    private final Map<Layer, Binner<PlacableBump>> mPlacedBumpMap = new HashMap<Layer, Binner<PlacableBump>>();
    private final Map<Net, PlaceRecord> mPlacedRecordMap = new HashMap<Net, PlaceRecord>();
    private final Set<String> mMsgLogged = new HashSet<String>();

    private void logUniqueWarn(String format, Object ... args) {
        String msg = String.format(format, args);
        if (this.mMsgLogged.contains(msg)) {
            return;
        }
        this.mMsgLogged.add(msg);
        ALog.flogWarn((String)format, (Object[])args);
    }

    public BumpFanout(Db db, String bumpTypeStr, String bumpTemplateKeyStr, String startLayerKeyStr) {
        this.mDb = db;
        this.mBumpType = BumpType.valueOf(bumpTypeStr);
        this.mStartLayer = (Layer)this.mDb.getByKeyStr(Layer.class, startLayerKeyStr);
        if (this.isBumpTypeDevice()) {
            this.mDevT = (DeviceTemplate)this.mDb.getByKeyStr(DeviceTemplate.class, bumpTemplateKeyStr);
            PinTemplate pin = this.mDevT == null ? null : this.mDevT.getPin1();
            this.mPadT = pin == null ? null : pin.getPadTemplate();
        } else if (this.isBumpTypePin()) {
            this.mPadT = (PadTemplate)this.mDb.getByKeyStr(PadTemplate.class, bumpTemplateKeyStr);
        }
    }

    public boolean isBumpTypeDevice() {
        return this.mBumpType == BumpType.DEVICE;
    }

    public boolean isBumpTypePin() {
        return this.mBumpType == BumpType.PIN;
    }

    public void setIncludeUnassignedPins(boolean includeUnassignedPins) {
        this.mIncludeUnassignedPins = includeUnassignedPins;
    }

    public void setIncludeAllInstances(boolean includeAllInstances) {
        this.mIncludeAllInstances = includeAllInstances;
    }

    public void setAutoGenNet(boolean autoGenNet) {
        this.mAutoGenNet = autoGenNet;
    }

    public void setMirror(boolean mirror) {
        this.mMirror = mirror;
    }

    public void setRotate(float rotate) {
        this.mRotate = rotate;
    }

    public void setNamePrefix(String namePrefix) {
        this.mNameGenerator.setBaseName(namePrefix);
    }

    public void setShapeSizeFilterOp(String op) {
        this.mShapeSizeFilterOp = FilterOp.getFilterOp(op);
    }

    public void setShapeWidthFilter(long shapeWidthFilter) {
        this.mShapeWidthFilter = shapeWidthFilter;
    }

    public void setShapeHeightFilter(long shapeHeightFilter) {
        this.mShapeHeightFilter = shapeHeightFilter;
    }

    public void setBumpAlignment(BumpAlignment pos) {
        this.mBumpPos = pos;
    }

    public void setMinBumpBumpPitch(long minPitch) {
        this.mBumpBumpPitch = minPitch;
    }

    public void setRefWorldLoc(APoint2D refWorldLoc) {
        this.mRefWorldLoc = refWorldLoc;
    }

    public void setRefTermNamePrefix(String prefix) {
        this.mRefTermPrefix = prefix;
    }

    public void setRefTermListFile(String filePath) {
        this.mRefTermFilePath = filePath;
    }

    private void checkRequiredField() {
        if (this.mDb == null) {
            throw new IllegalArgumentException("db is null");
        }
        if (this.mBumpType == null) {
            throw new IllegalArgumentException("bump type is null");
        }
        if (this.mStartLayer == null) {
            throw new IllegalArgumentException("start layer is null");
        }
        if (this.mPadT == null) {
            throw new IllegalArgumentException("pad template is null");
        }
    }

    public void createBump() {
        this.checkRequiredField();
        this.prepareReferTerms();
        List<ViaFanout.FanoutPin> pins = this.getPinsToFanout();
        Collections.sort(pins);
        this.preparePlacedBumpBinner(pins);
        if (this.mRefWorldLoc != null) {
            ALog.logInfo((String)"Reference point %s", (Object[])new Object[]{this.mRefWorldLoc.toString(Design.getUnit((Db)this.mDb))});
        }
        ALog.logInfo((String)"Process %d selected pins", (Object[])new Object[]{pins.size()});
        ArrayList<PlacableBump> bumpList = new ArrayList<PlacableBump>();
        for (ViaFanout.FanoutPin fPin : pins) {
            HierPin hPin = fPin.pin;
            DevicePath pathToPutViasOn = hPin.getPath().pathToSubstrate();
            if (pathToPutViasOn == null) {
                ++this.mNumNotOnStartLayer;
                continue;
            }
            for (APair<PortTemplate, LayerShape> shapePort : fPin.shapeList) {
                PlacableBump bump;
                if (((LayerShape)shapePort.getSecond()).getLayer() != this.mStartLayer) continue;
                PortTemplate portT = (PortTemplate)shapePort.getFirst();
                AffineTransform xForm = portT.getLocalTransform();
                xForm.preConcatenate(hPin.getPath().getTransform());
                AGeom worldGeom = ((LayerShape)shapePort.getSecond()).getGeom().transform(xForm);
                ARect bound = worldGeom.getBounds();
                if (!this.mShapeSizeFilterOp.check(bound.width(), this.mShapeWidthFilter) || !this.mShapeSizeFilterOp.check(bound.height(), this.mShapeHeightFilter) || (bump = this.getPlacableBump(worldGeom, hPin)) == null) continue;
                bumpList.add(bump);
            }
        }
        this.placeBumps(bumpList);
        this.reportStatus();
    }

    private void placeBumps(List<PlacableBump> bumpList) {
        this.determinatePlaceOrder(bumpList);
        for (PlacableBump bump : bumpList) {
            HierPin hPin = bump.mHPin;
            HierInst hierSubNet = NetMap.getSubstrateInstNet((Net)hPin.getNet(), (DevicePath)hPin.getPath(), (boolean)false);
            Net substrateNet = (Net)hierSubNet.getDbObject();
            PlaceRecord record = this.mPlacedRecordMap.computeIfAbsent(substrateNet, k -> new PlaceRecord((Net)hierSubNet.getDbObject(), hierSubNet.getPath()));
            ++record.total;
            if (!this.checkBumpConstraint(bump)) continue;
            APoint2D loc = bump.getBumpWorldLoc();
            for (Layer l : bump.getLayerInUse()) {
                Binner<PlacableBump> binner = this.mPlacedBumpMap.get(l);
                binner.insert((Object)bump, new ARect(loc, loc));
            }
            ++record.placed;
            bump.create();
            ++this.mTotal;
        }
    }

    private void prepareReferTerms() {
        if (this.mRefTermFilePath == null) {
            return;
        }
        if (!AFile.isFileReadable((String)this.mRefTermFilePath)) {
            ALog.logError((String)"Unable to read ter list file '%s'", (Object[])new Object[]{new File(this.mRefTermFilePath)});
            return;
        }
        File f = new File(this.mRefTermFilePath);
        this.mReferTermMap = new HashMap<String, String>();
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            CSVDocument csvDoc = parser2.parse(f.getPath());
            if (!parser2.validateHeader(TermList.CsvHeader.getHeader())) {
                ALog.logError((String)"Unexpected header in input file %s.", (Object[])new Object[]{f});
                ALog.logError((String)"Header should be %s", (Object[])new Object[]{Arrays.toString(TermList.CsvHeader.getHeader())});
                return;
            }
            for (int i = 0; i != csvDoc.getItemCount(); ++i) {
                this.prepareReferTerm(csvDoc, i);
            }
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Problems read term csv", (Object[])new Object[0]);
        }
    }

    private void prepareReferTerm(CSVDocument csvDoc, int index) {
        String termName = csvDoc.getItemValue(index, TermList.CsvHeader.TERM.getCsvAttributeName());
        if (termName == null || termName.isEmpty()) {
            return;
        }
        String netName = csvDoc.getItemValue(index, TermList.CsvHeader.NET.getCsvAttributeName());
        if (netName.isEmpty()) {
            netName = termName;
        }
        if (this.mReferTermMap.get(netName) != null) {
            ALog.flogError((String)"Illegal net-term mapping on row index %d, net %s, term %s. Please make one-to-one relationships.", (Object[])new Object[]{index, netName, termName});
            throw new IllegalStateException("Invalid refer term csv format");
        }
        this.mReferTermMap.put(netName, termName);
    }

    private String getTermName(Net substrateNet) {
        if (substrateNet == null || substrateNet.isNC()) {
            return null;
        }
        if (this.mReferTermMap != null) {
            String termName = this.mReferTermMap.get(substrateNet.getName());
            if (termName != null) {
                return termName;
            }
            return null;
        }
        if (this.mRefTermPrefix != null) {
            return this.mRefTermPrefix + substrateNet.getName();
        }
        return null;
    }

    private void preparePlacedBumpBinner(List<ViaFanout.FanoutPin> pins) {
        HashSet<DevicePath> used = new HashSet<DevicePath>();
        ARect worldBound = Design.getDesign((Db)this.mDb).getExtent();
        for (Layer l : this.mDb.getObjects(Layer.class)) {
            Binner binner = new Binner();
            binner.setWorld(worldBound);
            this.mPlacedBumpMap.put(l, (Binner<PlacableBump>)binner);
        }
        int placedBump = 0;
        for (ViaFanout.FanoutPin fPin : pins) {
            DevicePath placedPath = fPin.pin.getPath().pathToSubstrate();
            if (placedPath == null || !used.add(placedPath)) continue;
            for (DevicePath childPath : placedPath.getChildren()) {
                DeviceTemplate dt = childPath.getDeviceTemplate();
                if (dt.getType() != DeviceTemplate.Type.BUMP) continue;
                ARect rect = childPath.getBB().getBounds();
                PlacedBump bump = new PlacedBump(null, new HierPin(childPath, (PinTemplate)null), rect.center());
                for (Layer useLayer : new StreamIterableIterator(dt.getLayersInUse())) {
                    Binner<PlacableBump> binner = this.mPlacedBumpMap.get(useLayer);
                    binner.insert((Object)bump, rect);
                }
                ++placedBump;
            }
        }
        ALog.logDebug((String)"Load %d placed bump devices", (Object[])new Object[]{placedBump});
        if (used.size() > 1) {
            ALog.logWarn((String)"Please base on same substrate instance");
        }
    }

    private void determinatePlaceOrder(List<PlacableBump> bumps) {
        Collections.sort(bumps, (a, b) -> {
            long intervalB;
            long intervalA;
            int pB;
            Net netA = a.mHPin.getNet();
            Net netB = b.mHPin.getNet();
            int pA = BumpFanout.getNetPriority(netA, a.mHPin.getPath());
            if (pA != (pB = BumpFanout.getNetPriority(netB, b.mHPin.getPath()))) {
                return Integer.compare(pA, pB);
            }
            int c = Integer.compare(netA.getPinCount(), netB.getPinCount());
            if (c != 0) {
                return c;
            }
            APoint2D locA = a.getBumpWorldLoc();
            APoint2D locB = b.getBumpWorldLoc();
            if (this.mRefWorldLoc != null && (intervalA = locA.distance(this.mRefWorldLoc) / Math.max(this.mBumpBumpPitch / 100L, 1L)) != (intervalB = locB.distance(this.mRefWorldLoc) / Math.max(this.mBumpBumpPitch / 100L, 1L))) {
                return Long.compare(intervalA, intervalB);
            }
            if (this.mRefWorldLoc == null) {
                return 0;
            }
            ALine rayA = new ALine(this.mRefWorldLoc, locA);
            ALine rayB = new ALine(this.mRefWorldLoc, locB);
            return Double.compare(rayA.getAngleInRadians(), rayB.getAngleInRadians());
        });
    }

    private static int getNetPriority(Net net, DevicePath path) {
        Net.Use netUse;
        Net.Use use = netUse = NetClassifier.isPowerGroundNet((Net)net, (DevicePath)path) ? Net.Use.POWER : Net.Use.SIGNAL;
        if (netUse == Net.Use.POWER && NetClassifier.isGroundNet((Net)net, (DevicePath)path)) {
            netUse = Net.Use.GROUND;
        }
        if (net.getName().startsWith("NC") || net.isUnused()) {
            return 1000000;
        }
        if (netUse == Net.Use.SIGNAL) {
            return 0;
        }
        if (netUse == Net.Use.POWER) {
            return 1;
        }
        if (netUse == Net.Use.GROUND) {
            return 2;
        }
        return 1000000;
    }

    private List<ViaFanout.FanoutPin> getPinsToFanout() {
        return ViaFanout.getPinsToFanout(this.mDb, this.mIncludeUnassignedPins, true, this.mStartLayer.getKeyStr(), this.mIncludeAllInstances);
    }

    private PlacableBump getPlacableBump(AGeom worldGeom, HierPin hPin) {
        ARect relativeBumpBB = this.getRelativeBumpBB(worldGeom, hPin);
        APoint2D worldLoc = worldGeom.getBounds().center();
        if (this.isBumpTypeDevice()) {
            return new DeviceBump(relativeBumpBB, hPin, worldLoc);
        }
        if (this.isBumpTypePin()) {
            return new PadBump(relativeBumpBB, hPin, worldLoc);
        }
        return null;
    }

    private ARect getRelativeBumpBB(AGeom worldGeom, HierPin hPin) {
        ARect bumpBB = worldGeom.getBounds();
        DevicePath substratePath = hPin.getPath().pathToSubstrate();
        return bumpBB.transform(substratePath.getInverseTransform()).getBounds();
    }

    private boolean checkBumpConstraint(PlacableBump bump) {
        APoint2D loc = bump.getBumpWorldLoc();
        ARect inspectBound = new ARect(loc, loc).expandBy(this.mBumpBumpPitch);
        for (Layer l : bump.getLayerInUse()) {
            Binner<PlacableBump> binner = this.mPlacedBumpMap.get(l);
            for (PlacableBump b : binner.intersects(inspectBound)) {
                long dist = b.getBumpWorldLoc().distance(loc);
                if (dist >= this.mBumpBumpPitch) continue;
                return false;
            }
        }
        return true;
    }

    private void reportStatus() {
        if (this.mNumNotOnStartLayer > 0) {
            ALog.flogWarn((String)"%d bumps were not escaped because they have no geometry on the start layer.", (Object[])new Object[]{this.mNumNotOnStartLayer});
        }
        ArrayList<PlaceRecord> records = new ArrayList<PlaceRecord>(this.mPlacedRecordMap.values());
        records.sort((a, b) -> {
            int pb;
            int pa = BumpFanout.getNetPriority(a.net, a.path);
            if (pa != (pb = BumpFanout.getNetPriority(b.net, b.path))) {
                return Integer.compare(pa, pb);
            }
            if (a.total != b.total) {
                return Long.compare(b.total, a.total);
            }
            return Long.compare(b.placed, a.placed);
        });
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Total bumps: %d\n", this.mTotal));
        sb.append(String.format("Total nets: %d\n", records.size()));
        sb.append("\n");
        sb.append("Net without bumps:\n");
        for (PlaceRecord r : records) {
            if (r.placed != 0) continue;
            sb.append(String.format("\tNet '%s': %d / %d (%d%%) bumps\n", r.net.getName(), r.placed, r.total, r.placed * 100 / r.total));
        }
        sb.append("\n");
        sb.append("Net with bumps:\n");
        for (PlaceRecord r : records) {
            if (r.placed <= 0) continue;
            sb.append(String.format("\tNet '%s': %d / %d (%d%%) bumps\n", r.net.getName(), r.placed, r.total, r.placed * 100 / r.total));
        }
        ALog.logInfo((String)"Total bumps: %d, total nets: %d, %s", (Object[])new Object[]{this.mTotal, records.size(), ALogHelper.createTextElement("See more...", sb.toString())});
        File logFile = null;
        try (ASessionLogWriter writer = new ASessionLogWriter(this.mDb, this.getClass().getSimpleName());){
            logFile = writer.getFile();
            writer.println(sb.toString());
            ALog.logInfo((String)"See full report %s", (Object[])new Object[]{logFile});
        }
        catch (Exception e) {
            if (logFile != null) {
                ALog.flogWarn((String)"Cannot output report file %s", (Object[])new Object[]{logFile});
            }
            ALog.flogWarn((Throwable)e, (String)"Cannot output report file", (Object[])new Object[0]);
        }
    }

    private static class PlaceRecord {
        final Net net;
        final DevicePath path;
        int placed = 0;
        int total = 0;

        PlaceRecord(Net net, DevicePath path) {
            this.net = net;
            this.path = path;
        }
    }

    private class PadBump
    extends PlacableBump {
        public PadBump(ARect bumpBB, HierPin hPin, APoint2D worldLoc) {
            super(bumpBB, hPin, worldLoc);
        }

        @Override
        public APoint2D getBumpLoc() {
            return this.mBumpBB.center();
        }

        @Override
        public void create() {
            PinTemplate pinT = this.createPinTemplate();
            PinInstance pinInst = this.createPinInstance(pinT);
            BumpFanout.this.mPadT.getDb().add((DbObject)pinInst);
        }

        private PinTemplate createPinTemplate() {
            Net net = this.getNet(this.mHPin);
            PinTemplate pinT = PinTemplate.create((Net)net, (String)this.mHPin.getPin().getName());
            pinT.setPadTemplate(BumpFanout.this.mPadT);
            pinT.setType(PinTemplate.Type.BUMPPAD);
            pinT.setRotate(BumpFanout.this.mRotate);
            pinT.setMirror(BumpFanout.this.mMirror);
            pinT.setLoc(this.getBumpLoc());
            return pinT;
        }

        private PinInstance createPinInstance(PinTemplate pinT) {
            DevicePath packagePath = this.mHPin.getPackagePath();
            PinInstance dp = new PinInstance(BumpFanout.this.mNameGenerator.getBaseName() + this.mHPin.getPin().getName(), packagePath.getLast(), pinT);
            Personality p = this.mHPin.getPin().getPersonality();
            if (p != null) {
                dp.assignToPersonality(p);
            }
            return dp;
        }

        @Override
        protected IterableIterator<Layer> getLayerInUse() {
            return AIterableItr.itr((Collection)BumpFanout.this.mPadT.getLayers());
        }
    }

    private class DeviceBump
    extends PlacableBump {
        public DeviceBump(ARect bumpBB, HierPin hPin, APoint2D worldLoc) {
            super(bumpBB, hPin, worldLoc);
        }

        @Override
        public APoint2D getBumpLoc() {
            APoint2D bumpCenter = this.mBumpBB.center();
            if (BumpFanout.this.mBumpPos == BumpAlignment.CENTER2CENTER) {
                APoint2D c = BumpFanout.this.mDevT.getBB().center();
                AffineTransform xform = ATransformUtil.createTransform((double)0.0, (double)0.0, (float)BumpFanout.this.mRotate, (boolean)BumpFanout.this.mMirror);
                c = c.transform(xform);
                return bumpCenter.sub(c);
            }
            if (BumpFanout.this.mBumpPos == BumpAlignment.CENTER2ORIGIN) {
                APoint2D c = new APoint2D();
                AffineTransform xform = ATransformUtil.createTransform((double)0.0, (double)0.0, (float)BumpFanout.this.mRotate, (boolean)BumpFanout.this.mMirror);
                c = c.transform(xform);
                return bumpCenter.sub(c);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void create() {
            DevicePath dPath = this.mHPin.getPath();
            DeviceTemplate substrateTemplate = dPath.getSubstrateDeviceTemplate();
            String uniqueName = Device.getNextArrayName((DeviceTemplate)substrateTemplate, (NameGenerator)BumpFanout.this.mNameGenerator);
            Device newDevice = Device.create((Db)BumpFanout.this.mDb, (String)uniqueName, (DeviceTemplate)BumpFanout.this.mDevT, (DeviceTemplate)substrateTemplate);
            newDevice.setSynthesized(false);
            newDevice.setIsPlaced(true);
            newDevice.setLoc(this.getBumpLoc());
            newDevice.setRotate(BumpFanout.this.mRotate);
            newDevice.setMirror(BumpFanout.this.mMirror);
            for (Object pinT : BumpFanout.this.mDevT.getPins()) {
                if (!pinT.getNet().isUnused()) continue;
                Net net = Net.getOrCreate((DeviceTemplate)BumpFanout.this.mDevT, (String)pinT.getName());
                pinT.setNet(net);
            }
            Net substrateNet = this.getNet(this.mHPin);
            if (!substrateNet.isNC()) {
                String termName;
                for (Net bumpNet : BumpFanout.this.mDevT.getNets()) {
                    if (bumpNet.isUnused()) continue;
                    NetMap.mapChildNet((Device)newDevice, (Net)bumpNet, (Net)substrateNet);
                }
                if (!NetClassifier.isPowerGroundNet((Net)this.mHPin.getNet(), (DevicePath)this.mHPin.getPath()) && (termName = BumpFanout.this.getTermName(substrateNet)) != null) {
                    Bump2Term.execute(newDevice, termName);
                }
            }
        }

        @Override
        protected IterableIterator<Layer> getLayerInUse() {
            return new StreamIterableIterator(BumpFanout.this.mDevT.getLayersInUse());
        }
    }

    private class PlacedBump
    extends PlacableBump {
        public PlacedBump(ARect bumpBB, HierPin hPin, APoint2D worldLoc) {
            super(bumpBB, hPin, worldLoc);
        }

        @Override
        protected void create() {
            throw new IllegalStateException();
        }

        @Override
        protected APoint2D getBumpLoc() {
            throw new IllegalStateException();
        }

        @Override
        protected IterableIterator<Layer> getLayerInUse() {
            return new StreamIterableIterator(this.mHPin.getPath().getDeviceTemplate().getLayersInUse());
        }
    }

    private abstract class PlacableBump {
        protected final ARect mBumpBB;
        protected final HierPin mHPin;
        protected final APoint2D mWorldLoc;

        public PlacableBump(ARect bumpBB, HierPin hPin, APoint2D worldLoc) {
            this.mBumpBB = bumpBB;
            this.mHPin = hPin;
            this.mWorldLoc = worldLoc;
        }

        protected abstract void create();

        protected abstract APoint2D getBumpLoc();

        protected APoint2D getBumpWorldLoc() {
            return this.mWorldLoc;
        }

        protected Net getNet(HierPin hPin) {
            Net net;
            PinInstance pin = hPin.getPin();
            DevicePath associatedPath = hPin.getPath();
            DevicePath substratePath = associatedPath.pathToSubstrate();
            if (pin.getNet().isUnused() && BumpFanout.this.mAutoGenNet) {
                Net pinNet = Net.getOrCreate((DeviceTemplate)pin.getDeviceTemplate(), (String)pin.getName());
                pin.setNet(pinNet);
                Net.getOrCreate((DeviceTemplate)substratePath.getDeviceTemplate(), (String)pin.getName());
            }
            if ((net = NetMap.getNetAt((Net)pin.getNet(), (DevicePath)associatedPath, (DeviceTemplate)substratePath.getDeviceTemplate())).getDeviceTemplate() != substratePath.getDeviceTemplate()) {
                BumpFanout.this.logUniqueWarn("The bump for %s does not map to %s, NetUnused will be used.", pin.getName(), substratePath);
                net = substratePath.getDeviceTemplate().getNetUnused();
            }
            return net;
        }

        protected abstract IterableIterator<Layer> getLayerInUse();
    }

    public static enum BumpAlignment {
        CENTER2CENTER("Center to Center", "Align pad center to bump template center"),
        CENTER2ORIGIN("Center to Origin", "Align pad center to bump template origin");

        final String text;
        final String desc;

        private BumpAlignment(String text, String desc) {
            this.text = text;
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getUserText() {
            return this.text;
        }
    }

    public static enum FilterOp {
        LESSEQ("<=", (size, max) -> size <= max),
        GREATEREQ(">=", (size, min) -> size >= min);

        String op;
        BiPredicate<Long, Long> pred;

        public static FilterOp getFilterOp(String op) {
            for (FilterOp filterOp : FilterOp.values()) {
                if (!filterOp.op.equals(op)) continue;
                return filterOp;
            }
            throw new IllegalArgumentException(String.format("Operation '%s' is not supported.", op));
        }

        public boolean check(long size, long limit) {
            return this.pred.test(size, limit);
        }

        private FilterOp(String op, BiPredicate<Long, Long> pred) {
            this.op = op;
            this.pred = pred;
        }
    }

    public static enum BumpType {
        DEVICE,
        PIN;

    }
}

