/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Stopwatch;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.automation.BumpSignalPatternAlternateCol;
import com.sigrity.orbit.automation.BumpSignalPatternCheckerBoard;
import com.sigrity.orbit.automation.placement.PlaceableItem;
import com.sigrity.orbit.ui.PatternPlacementUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class BumpRatioOptimizer {
    protected static boolean registeredStandardPatterns = false;
    public int SIGNAL_PATTERN = 0;
    protected ARect bounds = null;
    protected long pitch;
    protected Device coverCell;
    protected List<PlaceableItem<DbObject>> bumps;
    protected List<RatioInstruction> instructions;
    protected List<PlaceableItem<DbObject>> signalBumps = new LinkedList<PlaceableItem<DbObject>>();
    protected List<PlaceableItem<DbObject>> powerBumps = new LinkedList<PlaceableItem<DbObject>>();
    protected List<PlaceableItem<DbObject>> groundBumps = new LinkedList<PlaceableItem<DbObject>>();
    protected List<PlaceableItem<DbObject>> nearCore = new LinkedList<PlaceableItem<DbObject>>();
    protected List<PlaceableItem<DbObject>> coreEdge = new LinkedList<PlaceableItem<DbObject>>();
    protected List<PlaceableItem<DbObject>> nearDie = new LinkedList<PlaceableItem<DbObject>>();
    protected List<PlaceableItem<DbObject>> dieEdge = new LinkedList<PlaceableItem<DbObject>>();
    protected List<ProximityGroup> nearSignalSet = new LinkedList<ProximityGroup>();
    protected List<ProximityGroup> nearPowerSet = new LinkedList<ProximityGroup>();
    protected List<Long> xs = new LinkedList<Long>();
    protected List<Long> ys = new LinkedList<Long>();
    protected int totalBumps;
    protected Random r = new Random(1L);
    protected int totalRandomPasses;
    protected long totalAccept = 0L;
    protected double latestScore;
    protected double bestCost;
    protected Map<PlaceableItem<DbObject>, APoint2D> bestPosition = Collections.emptyMap();
    public static double MUTATION_PERCENT = 0.2;
    public static double NUM_MUTATIONS = 1.0;
    public static double SIGNAL_SYM = 1.0;
    Set<APoint2D> field = new HashSet<APoint2D>();
    Set<APoint2D> fullField = new HashSet<APoint2D>();

    public void setDevice(Device d) {
        this.coverCell = d;
    }

    public List<PlaceableItem<DbObject>> getBumps() {
        return this.bumps;
    }

    public void setBumps(List<PlaceableItem<DbObject>> bumps) {
        this.bumps = bumps;
    }

    public void setBumpLocations(List<PlaceableItem<DbObject>> bumps) {
        for (PlaceableItem<DbObject> bump : bumps) {
            this.field.add(bump.getLoc());
            this.fullField.add(bump.getLoc());
        }
    }

    public List<RatioInstruction> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<RatioInstruction> instructions) {
        this.instructions = instructions;
    }

    public void setPitch(long minPitch) {
        this.pitch = minPitch;
    }

    protected double injectMutation(double perc) {
        int mutationNum = (int)Math.round((double)this.totalBumps * perc);
        for (int i = 0; i < mutationNum; ++i) {
            int ith = this.r.nextInt(this.totalBumps);
            int jth = this.r.nextInt(this.totalBumps);
            PlaceableItem<DbObject> bumpI = this.bumps.get(ith);
            PlaceableItem<DbObject> bumpJ = this.bumps.get(jth);
            this.swapLocation(bumpI, bumpJ);
        }
        return this.score();
    }

    protected void greedyPass(Set<PlaceableItem<DbObject>> locationFixedBumps) {
        this.latestScore = this.score();
        this.totalBumps = this.bumps.size();
        ArrayList<PlaceableItem<DbObject>> moveableBumps = new ArrayList<PlaceableItem<DbObject>>(this.bumps);
        moveableBumps.removeAll(locationFixedBumps);
        int numMoveableBumps = moveableBumps.size();
        boolean improved = true;
        while (improved) {
            improved = false;
            for (int i = 0; i < numMoveableBumps - 1; ++i) {
                for (int j = i + 1; j < numMoveableBumps; ++j) {
                    PlaceableItem<DbObject> bumpI = moveableBumps.get(i);
                    PlaceableItem<DbObject> bumpJ = moveableBumps.get(j);
                    this.swapLocation(bumpI, bumpJ);
                    double scoreAfter = this.score();
                    if (scoreAfter < this.latestScore) {
                        ++this.totalAccept;
                        this.latestScore = scoreAfter;
                        improved = true;
                        continue;
                    }
                    this.swapLocation(bumpI, bumpJ);
                }
            }
        }
    }

    private void swapLocation(PlaceableItem<DbObject> a, PlaceableItem<DbObject> b) {
        APoint2D temp = a.getLoc();
        a.place(b.getLoc());
        b.place(temp);
    }

    protected void greedyRandom() {
        ArrayList arrayBumps = this.bumps.stream().collect(Collectors.toCollection(ArrayList::new));
        this.latestScore = this.score();
        for (int pass = 0; pass < this.totalRandomPasses; ++pass) {
            int i = this.r.nextInt(this.totalBumps);
            int j = this.r.nextInt(this.totalBumps);
            PlaceableItem bumpI = (PlaceableItem)arrayBumps.get(i);
            PlaceableItem bumpJ = (PlaceableItem)arrayBumps.get(j);
            this.swapLocation(bumpI, bumpJ);
            double scoreAfter = this.score();
            if (scoreAfter < this.latestScore) {
                ++this.totalAccept;
                this.latestScore = scoreAfter;
                continue;
            }
            this.swapLocation(bumpI, bumpJ);
        }
    }

    protected void setDBToBest() {
        for (PlaceableItem<DbObject> d : this.bumps) {
            d.place(this.bestPosition.get(d));
        }
    }

    protected void savePotentialBest(double score) {
        if (score < this.bestCost) {
            this.bestCost = score;
            this.bestPosition = this.bumps.stream().collect(Collectors.toMap(Function.identity(), PlaceableItem::getLoc));
        }
    }

    protected Personality getPersonality(PlaceableItem<DbObject> bump, Device owner) {
        PinTemplate pinTemplate = bump.getConnectionPin();
        if (bump.getDbObject() instanceof PinTemplate) {
            PinInstance pi = owner.getPin(pinTemplate);
            return pi.getPersonality();
        }
        Device bumpDevice = (Device)bump.getDbObject();
        PinInstance pi = bumpDevice.getPin(pinTemplate);
        return pi.getPersonality();
    }

    protected void setupCatagories() {
        List personalities = this.bumps.stream().map(bump -> this.getPersonality((PlaceableItem<DbObject>)bump, this.coverCell)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        LinkedList<PlaceableItem<DbObject>> availBumps = new LinkedList<PlaceableItem<DbObject>>();
        for (PlaceableItem<DbObject> bump2 : this.bumps) {
            Personality bumpP = this.getPersonality(bump2, this.coverCell);
            if (bumpP != null && bumpP.getName().equals("signal")) {
                this.signalBumps.add(bump2);
                continue;
            }
            availBumps.add(bump2);
        }
        for (Personality p : personalities) {
            for (RatioInstruction instruction : this.instructions) {
                int num;
                if (!instruction.p.equals(p)) continue;
                ProximityGroup nearSignalGroup = null;
                ProximityGroup nearPowerGroup = null;
                if (instruction.type.equals((Object)BumpFactoryData.BumpBiasType.NEAR_SIGNAL)) {
                    nearSignalGroup = new ProximityGroup();
                    nearSignalGroup.p = p;
                    this.nearSignalSet.add(nearSignalGroup);
                }
                if (instruction.type.equals((Object)BumpFactoryData.BumpBiasType.NEAR_POWER)) {
                    nearPowerGroup = new ProximityGroup();
                    nearPowerGroup.p = p;
                    this.nearPowerSet.add(nearPowerGroup);
                }
                if ((num = instruction.created) <= 0) continue;
                LinkedList<PlaceableItem> notAvailable = new LinkedList<PlaceableItem>();
                for (PlaceableItem placeableItem : availBumps) {
                    Personality bumpP = this.getPersonality(placeableItem, this.coverCell);
                    if (!bumpP.equals(p)) continue;
                    notAvailable.add(placeableItem);
                    if (instruction.netUse.equals((Object)Net.Use.GROUND)) {
                        this.groundBumps.add(placeableItem);
                    }
                    if (instruction.netUse.equals((Object)Net.Use.POWER)) {
                        this.powerBumps.add(placeableItem);
                    }
                    if (instruction.type.equals((Object)BumpFactoryData.BumpBiasType.NEAR_SIGNAL)) {
                        nearSignalGroup.devices.add(placeableItem);
                    } else if (instruction.type.equals((Object)BumpFactoryData.BumpBiasType.NEAR_POWER)) {
                        nearPowerGroup.devices.add(placeableItem);
                    }
                    if (instruction.type.equals((Object)BumpFactoryData.BumpBiasType.CORE_EDGE)) {
                        this.coreEdge.add(placeableItem);
                    }
                    if (instruction.type.equals((Object)BumpFactoryData.BumpBiasType.TOWARD_CORE)) {
                        this.nearCore.add(placeableItem);
                    }
                    if (instruction.type.equals((Object)BumpFactoryData.BumpBiasType.DIE_EDGE)) {
                        this.dieEdge.add(placeableItem);
                    }
                    if (instruction.type.equals((Object)BumpFactoryData.BumpBiasType.TOWARD_DIE)) {
                        this.nearDie.add(placeableItem);
                    }
                    if (--num != 0) continue;
                    break;
                }
                availBumps.removeAll(notAvailable);
            }
        }
        this.xs = this.bumps.stream().map(bump -> bump.getLoc().getX()).distinct().sorted().collect(Collectors.toList());
        this.ys = this.bumps.stream().map(bump -> bump.getLoc().getY()).distinct().sorted().collect(Collectors.toList());
    }

    private APair<List<PlaceableItem<DbObject>>, List<APoint2D>> placeByMaxY(List<PlaceableItem<DbObject>> categoryGroup, Set<APoint2D> fieldPoints) {
        ArrayList fieldPointsArray = fieldPoints.stream().sorted((p1, p2) -> (int)(p2.getY() - p1.getY())).collect(Collectors.toCollection(ArrayList::new));
        int placed = Math.min(categoryGroup.size(), fieldPointsArray.size());
        List usedFieldPoints = fieldPointsArray.subList(0, placed);
        IntStream.range(0, placed).forEach(i -> {
            PlaceableItem bump = (PlaceableItem)categoryGroup.get(i);
            APoint2D point = (APoint2D)usedFieldPoints.get(i);
            bump.place(point);
        });
        return APair.create(categoryGroup.subList(0, placed), usedFieldPoints);
    }

    private APair<List<PlaceableItem<DbObject>>, List<APoint2D>> placeByMinY(List<PlaceableItem<DbObject>> categoryGroup, Set<APoint2D> fieldPoints) {
        ArrayList fieldPointsArray = fieldPoints.stream().sorted((p1, p2) -> (int)(p1.getY() - p2.getY())).collect(Collectors.toCollection(ArrayList::new));
        int placed = Math.min(categoryGroup.size(), fieldPointsArray.size());
        List usedFieldPoints = fieldPointsArray.subList(0, placed);
        IntStream.range(0, placed).forEach(i -> {
            PlaceableItem bump = (PlaceableItem)categoryGroup.get(i);
            APoint2D point = (APoint2D)usedFieldPoints.get(i);
            bump.place(point);
        });
        return APair.create(categoryGroup.subList(0, placed), usedFieldPoints);
    }

    private APair<List<PlaceableItem<DbObject>>, List<APoint2D>> placeSequentially(List<PlaceableItem<DbObject>> categoryGroup, Set<APoint2D> fieldPoints) {
        ArrayList fieldPointsArray = fieldPoints.stream().collect(Collectors.toCollection(ArrayList::new));
        int placed = Math.min(categoryGroup.size(), fieldPointsArray.size());
        List usedFieldPoints = fieldPointsArray.subList(0, placed);
        IntStream.range(0, placed).forEach(i -> {
            PlaceableItem bump = (PlaceableItem)categoryGroup.get(i);
            APoint2D point = (APoint2D)usedFieldPoints.get(i);
            bump.place(point);
        });
        return APair.create(categoryGroup.subList(0, placed), usedFieldPoints);
    }

    public void greedy() {
        OrbitApp.getCurDb().getHistory().setCompressEvents(true);
        this.setupCatagories();
        HashSet<PlaceableItem<DbObject>> toBePlaced = new HashSet<PlaceableItem<DbObject>>(this.bumps);
        this.placePGBumpsOfGeometricPerference(toBePlaced);
        LinkedList<PlaceableItem<DbObject>> signalsToPlace = new LinkedList<PlaceableItem<DbObject>>(this.signalBumps);
        SignalPatternSynthesis bsp1 = SignalPatternSynthesisRegistry.getSelected();
        bsp1.init();
        bsp1.setFullField(this.fullField);
        bsp1.setAvailField(this.field);
        bsp1.setToBePlaced(signalsToPlace);
        bsp1.go();
        Set<APoint2D> usedField = bsp1.getFieldPlaced();
        this.field.removeAll(usedField);
        ArrayList<PlaceableItem<DbObject>> sortedSignals = bsp1.getPlaced();
        toBePlaced.removeAll(sortedSignals);
        ALog.logInfo((String)(bsp1.name() + " Placed " + bsp1.getPlaced().size() + " signal bumps"));
        int placed = this.placeUnplacedSignalBumpsInSequentialOrder(toBePlaced, signalsToPlace, sortedSignals);
        if (placed > 0) {
            ALog.logWarn((String)(placed + " signal bumps placed randomly"));
        }
        placed = this.placePGBumpsOfNearSignal(sortedSignals, toBePlaced);
        ALog.logInfo((String)(placed + " Near signals placed"));
        placed = this.placePGBumpsOfNearPower(toBePlaced);
        ALog.logInfo((String)(placed + " Near power placed"));
        ArrayList<PlaceableItem<DbObject>> toBePlacedList = new ArrayList<PlaceableItem<DbObject>>(toBePlaced);
        ArrayList<APoint2D> fieldArray = new ArrayList<APoint2D>(this.field);
        IntStream.range(0, fieldArray.size()).forEach(i -> ((PlaceableItem)toBePlacedList.get(i)).place((APoint2D)fieldArray.get(i)));
        HashSet<PlaceableItem<DbObject>> locationFixedBumps = new HashSet<PlaceableItem<DbObject>>(this.signalBumps);
        this.greedyPass(locationFixedBumps);
        this.printStats();
        OrbitApp.getCurDb().getHistory().setCompressEvents(false);
    }

    private int placeUnplacedSignalBumpsInSequentialOrder(Set<PlaceableItem<DbObject>> toBePlaced, List<PlaceableItem<DbObject>> signalsToPlace, ArrayList<PlaceableItem<DbObject>> sortedSignals) {
        List notPlacedSignals = AUtil.diff(signalsToPlace, sortedSignals);
        APair<List<PlaceableItem<DbObject>>, List<APoint2D>> placedUnplacedSignals = this.placeSequentially(notPlacedSignals, this.field);
        toBePlaced.removeAll((Collection)placedUnplacedSignals.first);
        sortedSignals.addAll((Collection)placedUnplacedSignals.first);
        this.field.removeAll((Collection)placedUnplacedSignals.second);
        return ((List)placedUnplacedSignals.first).size();
    }

    private int placePGBumpsOfNearSignal(ArrayList<PlaceableItem<DbObject>> sortedSignals, Set<PlaceableItem<DbObject>> toBePlaced) {
        HashSet<PlaceableItem> marked = new HashSet<PlaceableItem>();
        int placed = 0;
        for (int i = 0; i < sortedSignals.size(); ++i) {
            PlaceableItem<DbObject> bump = sortedSignals.get(i);
            if (i % 2 == 0) {
                bump = sortedSignals.get(sortedSignals.size() - i - 1);
            }
            for (ProximityGroup pg : this.nearSignalSet) {
                Optional<APoint2D> best;
                PlaceableItem pgDevice = pg.devices.stream().filter(candidate -> !marked.contains(candidate)).findAny().orElse(null);
                if (pgDevice == null || !(best = this.findClosest(this.field, bump.getLoc())).isPresent()) continue;
                APoint2D bestPoint = best.get();
                marked.add(pgDevice);
                pgDevice.place(bestPoint);
                this.field.remove(bestPoint);
                toBePlaced.remove(pgDevice);
                ++placed;
            }
        }
        return placed;
    }

    private int placePGBumpsOfNearPower(Set<PlaceableItem<DbObject>> toBePlaced) {
        HashSet<PlaceableItem> marked = new HashSet<PlaceableItem>();
        int placed = 0;
        for (PlaceableItem<DbObject> bump : this.powerBumps) {
            for (ProximityGroup pg : this.nearPowerSet) {
                Optional<APoint2D> best;
                PlaceableItem pgDevice = pg.devices.stream().filter(candidate -> !marked.contains(candidate)).findAny().orElse(null);
                if (pgDevice == null || !(best = this.findClosest(this.field, bump.getLoc())).isPresent()) continue;
                APoint2D bestPoint = best.get();
                marked.add(pgDevice);
                pgDevice.place(bestPoint);
                this.field.remove(bestPoint);
                toBePlaced.remove(pgDevice);
                ++placed;
            }
        }
        return placed;
    }

    private void placePGBumpsOfGeometricPerference(Set<PlaceableItem<DbObject>> toBePlaced) {
        APair<List<PlaceableItem<DbObject>>, List<APoint2D>> placedOnCoreEdge = this.placeByMaxY(this.coreEdge, this.field);
        toBePlaced.removeAll((Collection)placedOnCoreEdge.first);
        this.field.removeAll((Collection)placedOnCoreEdge.second);
        APair<List<PlaceableItem<DbObject>>, List<APoint2D>> placedOnNearCore = this.placeByMaxY(this.nearCore, this.field);
        toBePlaced.removeAll((Collection)placedOnNearCore.first);
        this.field.removeAll((Collection)placedOnNearCore.second);
        APair<List<PlaceableItem<DbObject>>, List<APoint2D>> placedOnDieEdge = this.placeByMinY(this.dieEdge, this.field);
        toBePlaced.removeAll((Collection)placedOnDieEdge.first);
        this.field.removeAll((Collection)placedOnDieEdge.second);
        APair<List<PlaceableItem<DbObject>>, List<APoint2D>> placedOnNearDie = this.placeByMinY(this.nearDie, this.field);
        toBePlaced.removeAll((Collection)placedOnNearDie.first);
        this.field.removeAll((Collection)placedOnNearDie.second);
    }

    private Optional<APoint2D> findClosest(Collection<APoint2D> pts, APoint2D loc) {
        return pts.stream().min((a, b) -> Long.compare(a.distance(loc), b.distance(loc)));
    }

    public void optimize() {
        Stopwatch stopWatch = new Stopwatch();
        this.setupCatagories();
        this.totalBumps = this.bumps.size();
        this.r = new Random(1L);
        this.totalRandomPasses = this.totalBumps * this.totalBumps * 3;
        this.totalAccept = 0L;
        OrbitApp.getCurDb().getHistory().setCompressEvents(true);
        this.latestScore = this.score();
        this.bestCost = Double.MAX_VALUE;
        this.greedyPass(Collections.emptySet());
        this.savePotentialBest(this.latestScore);
        int i = 0;
        while ((double)i < NUM_MUTATIONS) {
            this.latestScore = this.injectMutation(MUTATION_PERCENT);
            this.greedyPass(Collections.emptySet());
            this.savePotentialBest(this.latestScore);
            this.printStats();
            ++i;
        }
        this.setDBToBest();
        stopWatch.stop();
        ALog.logInfo((String)("Optimization time: " + Stopwatch.formatTime((long)stopWatch.elapsed())));
        int greedyAccept = 0;
        PatternPlacementUI.updateProgress(true, 1.0, "Optimization done with " + this.totalAccept + greedyAccept + " improvements");
        OrbitApp.getCurDb().getHistory().setCompressEvents(false);
    }

    protected void printStats() {
        ALog.logInfo((String)"");
        for (ProximityGroup pg : this.nearSignalSet) {
            long worstDist = Long.MIN_VALUE;
            double total = 0.0;
            for (PlaceableItem<DbObject> bump : this.signalBumps) {
                OptionalLong minDist = pg.devices.stream().mapToLong(candidate -> Math.abs(candidate.getLoc().distance(bump.getLoc()))).min();
                if (!minDist.isPresent()) continue;
                long bestDist = minDist.getAsLong();
                if (bestDist > worstDist) {
                    worstDist = bestDist;
                }
                total += (double)bestDist;
            }
            if (worstDist == Long.MIN_VALUE || this.pitch == 0L) continue;
            ALog.logInfo((String)("Longest pitch between SIGNAL and " + pg.p.getName() + ": " + (double)worstDist / (double)this.pitch + " Avg: " + total / (double)this.signalBumps.size() / (double)this.pitch));
        }
        for (ProximityGroup pg : this.nearPowerSet) {
            Long worstDist = Long.MIN_VALUE;
            double total = 0.0;
            for (PlaceableItem<DbObject> bump : this.powerBumps) {
                OptionalLong minDist = pg.devices.stream().mapToLong(candidate -> Math.abs(candidate.getLoc().distance(bump.getLoc()))).min();
                if (!minDist.isPresent()) continue;
                long bestDist = minDist.getAsLong();
                if (bestDist > worstDist) {
                    worstDist = bestDist;
                }
                total += (double)bestDist;
            }
            if (worstDist == Long.MIN_VALUE || this.pitch == 0L) continue;
            ALog.logInfo((String)("Longest pitch between Power and " + pg.p.getName() + ": " + (double)worstDist.longValue() / (double)this.pitch + " Avg: " + total / (double)this.signalBumps.size() / (double)this.pitch));
        }
    }

    private double scoreNearSignalPGBump() {
        double score = 0.0;
        for (PlaceableItem<DbObject> bump : this.signalBumps) {
            APoint2D bumpLoc = bump.getLoc();
            for (ProximityGroup pg : this.nearSignalSet) {
                Optional<Long> minDist = pg.devices.stream().map(d -> d.getLoc().distance(bumpLoc)).min(Long::compare);
                if (!minDist.isPresent()) continue;
                score += (double)minDist.get().longValue();
            }
        }
        return score;
    }

    private double scoreNearPowerPGBump() {
        double score = 0.0;
        for (PlaceableItem<DbObject> bump : this.powerBumps) {
            APoint2D bumpLoc = bump.getLoc();
            for (ProximityGroup pg : this.nearPowerSet) {
                Optional<Long> minDist = pg.devices.stream().map(d -> d.getLoc().distance(bumpLoc)).min(Long::compare);
                if (!minDist.isPresent()) continue;
                score += (double)minDist.get().longValue();
            }
        }
        return score;
    }

    private double scoreNearCore() {
        long nearCoreFactor = this.nearCore.stream().mapToLong(bump -> bump.getLoc().getX()).sum();
        return -nearCoreFactor;
    }

    private double scoreCoreEdge() {
        long coreEdgeFactor = this.coreEdge.stream().mapToLong(bump -> bump.getLoc().getX() * 10L).sum();
        return -coreEdgeFactor;
    }

    private double scoreNearDie() {
        return this.nearDie.stream().mapToLong(bump -> bump.getLoc().getX()).sum();
    }

    private double scoreDieEdge() {
        return this.dieEdge.stream().mapToLong(bump -> bump.getLoc().getX() * 10L).sum();
    }

    private double scoreSignalBump() {
        return this.signalBumps.stream().mapToLong(bump -> (long)((double)bump.getLoc().getX() * 0.1)).sum();
    }

    protected double score() {
        double totalDist = 0.0;
        totalDist += this.scoreNearSignalPGBump();
        totalDist += this.scoreNearPowerPGBump();
        totalDist += this.scoreNearCore();
        totalDist += this.scoreCoreEdge();
        totalDist += this.scoreNearDie();
        totalDist += this.scoreDieEdge();
        return (totalDist += this.scoreSignalBump()) / (double)this.pitch;
    }

    SymStats calculateSignalSym() {
        HashMap<Long, Object> xToNum = new HashMap<Long, Object>();
        HashMap<Long, Object> yToNum = new HashMap<Long, Object>();
        for (PlaceableItem<DbObject> bump : this.signalBumps) {
            long x = bump.getLoc().getX();
            Object cur = (Integer)xToNum.get(x);
            if (cur == null) {
                cur = 0;
            }
            Integer n = cur;
            cur = (Integer)cur + 1;
            Integer n2 = cur;
            xToNum.put(x, cur);
        }
        double xTotal = 0.0;
        for (Long x : this.xs) {
            if (xToNum.get(x) == null) continue;
            xTotal += (double)((Integer)xToNum.get(x)).intValue();
        }
        double xavg = xTotal / (double)this.xs.size();
        xTotal = 0.0;
        for (Long x : this.xs) {
            double d = 0.0;
            d = xToNum.get(x) != null ? (double)((Integer)xToNum.get(x)).intValue() - xavg : -xavg;
            xTotal += d * d;
        }
        double xsDev = Math.sqrt(xTotal / (double)this.xs.size());
        for (PlaceableItem<DbObject> bump : this.signalBumps) {
            long y = bump.getLoc().getY();
            Object cur = (Integer)yToNum.get(y);
            if (cur == null) {
                cur = 0;
            }
            Integer n = cur;
            cur = (Integer)cur + 1;
            Integer n3 = cur;
            yToNum.put(y, cur);
        }
        double yTotal = 0.0;
        for (Long y : this.ys) {
            if (yToNum.get(y) == null) continue;
            yTotal += (double)((Integer)yToNum.get(y)).intValue();
        }
        double yavg = yTotal / (double)this.ys.size();
        yTotal = 0.0;
        for (Long y : this.ys) {
            double d = 0.0;
            d = yToNum.get(y) != null ? (double)((Integer)yToNum.get(y)).intValue() - yavg : -yavg;
            yTotal += d * d;
        }
        double ysDev = Math.sqrt(yTotal / (double)this.ys.size());
        SymStats ss = new SymStats();
        ss.xavg = xavg;
        ss.xsd = xsDev;
        ss.yavg = yavg;
        ss.ysd = ysDev;
        return ss;
    }

    double spreadCost(LinkedList<PlaceableItem<DbObject>> bumps) {
        HashMap<Long, Integer> xToNum = new HashMap<Long, Integer>();
        for (PlaceableItem placeableItem : bumps) {
            long x = placeableItem.getLoc().getX();
            Integer cur = (Integer)xToNum.get(x);
            if (cur == null) {
                cur = 0;
            }
            Integer n = cur;
            Integer n2 = cur = Integer.valueOf(cur + 1);
            xToNum.put(x, cur);
        }
        double spreadCost = 0.0;
        int clearRun = 0;
        for (Long x : this.xs) {
            Integer num = (Integer)xToNum.get(x);
            if (num != null && num != 0) {
                ++clearRun;
                continue;
            }
            spreadCost += (double)(clearRun * clearRun);
            clearRun = 0;
        }
        return spreadCost += (double)(clearRun * clearRun);
    }

    public static void registerStandardPatterns() {
        if (!registeredStandardPatterns) {
            SignalPatternSynthesisRegistry.add(new BumpSignalPatternCheckerBoard.BumpSignalPatternCheckerBoard1());
            SignalPatternSynthesisRegistry.add(new BumpSignalPatternCheckerBoard.BumpSignalPatternCheckerBoard0());
            SignalPatternSynthesisRegistry.add(new BumpSignalPatternAlternateCol.BumpSignalPatternAlternateCol0());
            SignalPatternSynthesisRegistry.add(new BumpSignalPatternAlternateCol.BumpSignalPatternAlternateCol1());
            registeredStandardPatterns = true;
        }
    }

    protected static class SymStats {
        double xavg;
        double xsd;
        double yavg;
        double ysd;

        protected SymStats() {
        }
    }

    protected class ProximityGroup {
        public List<PlaceableItem<DbObject>> devices = new LinkedList<PlaceableItem<DbObject>>();
        public Personality p;

        protected ProximityGroup() {
        }
    }

    public static class SignalPatternSynthesisRegistry {
        protected static List<SignalPatternSynthesis> registry = new LinkedList<SignalPatternSynthesis>();

        private SignalPatternSynthesisRegistry() {
        }

        public static void add(SignalPatternSynthesis sps) {
            registry.add(sps);
        }

        public static SignalPatternSynthesis getSelected() {
            return registry.get(0);
        }

        public static void setSelected(SignalPatternSynthesis sps) {
            registry.remove(sps);
            registry.add(0, sps);
        }

        public static List<SignalPatternSynthesis> getRegistryList() {
            return registry;
        }
    }

    public static interface SignalPatternSynthesis {
        public void init();

        public void go();

        public String name();

        public String description();

        public void setAvailField(Set<APoint2D> var1);

        public void setFullField(Set<APoint2D> var1);

        public void setToBePlaced(List<PlaceableItem<DbObject>> var1);

        public ArrayList<PlaceableItem<DbObject>> getPlaced();

        public Set<APoint2D> getFieldPlaced();
    }

    public static class RatioInstruction {
        public final String name;
        public final Net.Use netUse;
        public final boolean shorted;
        public final int ratio;
        public final BumpFactoryData.BumpBiasType type;
        public final boolean locked;
        public int created;
        public Personality p = null;

        public RatioInstruction(String name, Net.Use netUse, boolean shorted, int ratio, BumpFactoryData.BumpBiasType type, int created, boolean locked) {
            this.name = name;
            this.netUse = netUse;
            this.shorted = shorted;
            this.ratio = ratio;
            this.type = type;
            this.created = created;
            this.locked = locked;
        }
    }
}

