/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.automation.BumpRatioOptimizer;
import com.sigrity.orbit.automation.placement.PlaceableItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BumpSignalPatternAlternateCol
implements BumpRatioOptimizer.SignalPatternSynthesis {
    LinkedList<PlaceableItem<DbObject>> toBePlaced = new LinkedList();
    ArrayList<PlaceableItem<DbObject>> placed = new ArrayList();
    HashSet<APoint2D> field = new HashSet();
    HashSet<APoint2D> fullField = new HashSet();
    HashSet<APoint2D> usedField = new HashSet();
    int startCol;

    protected void setStartCol(int col) {
        this.startCol = col;
    }

    @Override
    public void init() {
        this.toBePlaced.clear();
        this.placed.clear();
        this.field.clear();
        this.fullField.clear();
        this.usedField.clear();
    }

    @Override
    public void go() {
        List xs = this.fullField.stream().map(APoint2D::getX).distinct().sorted().collect(Collectors.toList());
        int iteration = 0;
        while (!this.toBePlaced.isEmpty() && ++iteration != 3) {
            int sCol = iteration % 2 == 1 ? this.startCol : this.startCol + 1;
            for (int col = sCol; col < xs.size(); col += 2) {
                long x = (Long)xs.get(col);
                boolean foundOneOnThisCol = true;
                while (foundOneOnThisCol && !this.toBePlaced.isEmpty()) {
                    foundOneOnThisCol = false;
                    HashSet<APoint2D> toBeRemoved = new HashSet<APoint2D>();
                    for (APoint2D p : this.field) {
                        if (this.toBePlaced.isEmpty()) break;
                        if (p.getX() != x) continue;
                        PlaceableItem<DbObject> bump = this.toBePlaced.get(0);
                        bump.place(p);
                        this.placed.add(bump);
                        this.toBePlaced.remove(bump);
                        foundOneOnThisCol = true;
                        toBeRemoved.add(p);
                        this.usedField.add(p);
                    }
                    this.field.removeAll(toBeRemoved);
                }
            }
        }
    }

    @Override
    public String name() {
        return "Every Other Col 1";
    }

    @Override
    public String description() {
        return null;
    }

    @Override
    public void setFullField(Set<APoint2D> field) {
        this.fullField.addAll(field);
    }

    @Override
    public void setAvailField(Set<APoint2D> field) {
        this.field.addAll(field);
    }

    @Override
    public void setToBePlaced(List<PlaceableItem<DbObject>> toBePlaced) {
        this.toBePlaced.addAll(toBePlaced);
    }

    @Override
    public ArrayList<PlaceableItem<DbObject>> getPlaced() {
        return this.placed;
    }

    public HashSet<APoint2D> getFieldPlaced() {
        return this.usedField;
    }

    public static class BumpSignalPatternAlternateCol1
    extends BumpSignalPatternAlternateCol {
        @Override
        public String description() {
            return "Alternate rows starting at column 1";
        }

        @Override
        public String name() {
            return "Alternate Col 1";
        }

        @Override
        public void go() {
            this.setStartCol(1);
            super.go();
        }
    }

    public static class BumpSignalPatternAlternateCol0
    extends BumpSignalPatternAlternateCol {
        @Override
        public String description() {
            return "Alternate rows starting at column 0";
        }

        @Override
        public String name() {
            return "Alternate Col 0";
        }

        @Override
        public void go() {
            this.setStartCol(0);
            super.go();
        }
    }
}

