/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.automation.BumpRatioOptimizer;
import com.sigrity.orbit.automation.placement.PlaceableItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BumpSignalPatternCheckerBoard
implements BumpRatioOptimizer.SignalPatternSynthesis {
    LinkedList<PlaceableItem<DbObject>> toBePlaced = new LinkedList();
    ArrayList<PlaceableItem<DbObject>> placed = new ArrayList();
    HashSet<APoint2D> field = new HashSet();
    HashSet<APoint2D> fullField = new HashSet();
    HashSet<APoint2D> usedField = new HashSet();
    List<Long> ys = new LinkedList<Long>();
    List<Long> xs = new LinkedList<Long>();
    int startCol = 0;

    protected void setStartCol(int col) {
        this.startCol = col;
    }

    @Override
    public void init() {
        this.toBePlaced.clear();
        this.placed.clear();
        this.field.clear();
        this.fullField.clear();
        this.usedField.clear();
        this.xs.clear();
        this.ys.clear();
    }

    @Override
    public void go() {
        this.ys = this.fullField.stream().map(APoint2D::getY).distinct().sorted().collect(Collectors.toList());
        this.xs = this.fullField.stream().map(APoint2D::getX).distinct().sorted().collect(Collectors.toList());
        boolean stagger = this.isStagger();
        int rowIncr = stagger ? 4 : 2;
        for (int col = this.startCol; col < this.xs.size(); ++col) {
            int startRow;
            long x = this.xs.get(col);
            block1: for (int row = startRow = col % 2; row < this.ys.size() && !this.toBePlaced.isEmpty(); row += rowIncr) {
                long y = this.ys.get(row);
                for (APoint2D p : this.field) {
                    if (p.getY() != y || p.getX() != x) continue;
                    PlaceableItem<DbObject> bump = this.toBePlaced.get(0);
                    bump.place(p);
                    this.placed.add(bump);
                    this.toBePlaced.remove(bump);
                    this.field.remove(p);
                    this.usedField.add(p);
                    continue block1;
                }
            }
        }
    }

    protected boolean isStagger() {
        if (this.ys.size() < 2) {
            return false;
        }
        for (Long x : this.xs) {
            for (int i = 0; i < 2; ++i) {
                long y = this.ys.get(i);
                APoint2D p = new APoint2D(x.longValue(), y);
                if (this.fullField.contains(p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String name() {
        return "Checker Board";
    }

    @Override
    public String description() {
        return null;
    }

    @Override
    public void setFullField(Set<APoint2D> field) {
        this.fullField.addAll(field);
    }

    @Override
    public void setAvailField(Set<APoint2D> field) {
        this.field.addAll(field);
    }

    @Override
    public void setToBePlaced(List<PlaceableItem<DbObject>> toBePlaced) {
        this.toBePlaced.addAll(toBePlaced);
    }

    @Override
    public ArrayList<PlaceableItem<DbObject>> getPlaced() {
        return this.placed;
    }

    public HashSet<APoint2D> getFieldPlaced() {
        return this.usedField;
    }

    public static class BumpSignalPatternCheckerBoard1
    extends BumpSignalPatternCheckerBoard {
        @Override
        public String description() {
            return "Alternate rows and columns starting at row 1";
        }

        @Override
        public String name() {
            return "Checker Board 1";
        }

        @Override
        public void go() {
            this.setStartCol(1);
            super.go();
        }
    }

    public static class BumpSignalPatternCheckerBoard0
    extends BumpSignalPatternCheckerBoard {
        @Override
        public String description() {
            return "Alternate rows and columns starting at row 0";
        }

        @Override
        public String name() {
            return "Checker Board 0";
        }

        @Override
        public void go() {
            this.setStartCol(0);
            super.go();
        }
    }
}

