/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceMap;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ContactDeviceEngine {
    public static void allInOne(Db db) {
        ALog.logInfo((String)"Contact Device All-in-One Starting ...");
        ContactLayer.deleteInvalid((Db)db);
        HashSet<DeviceTemplate> done = new HashSet<DeviceTemplate>();
        for (Device dev : db.getObjects(Device.class).stream().collect(Collectors.toList())) {
            List c;
            if (done.contains(dev.getTemplate()) || (c = ContactDeviceEngine.recommendReference(db, dev, true, true, true).stream().filter(d -> d.getADevicePath().size() == 1).collect(Collectors.toList())).size() != 1) continue;
            Device referDev = (Device)c.get(0);
            DeviceMap dm = DeviceMap.create((Db)db, (String)dev.getTemplate().getKeyStr(), (String)referDev.getTemplate().getKeyStr(), (String)dev.getKeyStr());
            if (dm == null) continue;
            ALog.logInfo((String)"Contact Device %s -- %s", (Object[])new Object[]{dev.getTemplate().getName(), referDev.getTemplate().getName()});
            done.add(dev.getTemplate());
            ContactDeviceEngine.autoAlignDevice(dev, dm.getCopyDevice());
            ContactDeviceEngine.autoContactLayer(dm);
        }
        String checkFileName = System.getProperty("java.io.tmpdir") + "checkContactDevice.xml";
        Cp.exec((String)"unset(\"_portMapCheck\");", (Object[])new Object[0]);
        Cp.exec((String)"_portMapCheck = com.sigrity.orbit.inter_substrate_checks.PinMapCheck.executeChecking(%b, %b, %b, %b, %b, %b, %d);", (Object[])new Object[]{true, true, true, true, true, true, 0});
        Cp.exec((String)"_portMapCheck.exportResultXML(\"%s\")", (Object[])new Object[]{checkFileName});
        Cp.exec((String)"unset(\"_portMapCheck\");", (Object[])new Object[0]);
        ABrowserControl.displayFile((String)checkFileName);
    }

    public static APair<Layer, Layer> findContactLayer(Device deviceA, Device deviceB) {
        Layer mnlb;
        Layer mnla;
        Set s;
        Set la = null;
        Set lb = null;
        for (PinTemplate pt2 : deviceA.getTemplate().getPins().stream().filter(pt -> pt.getType() != PinTemplate.Type.VIA).collect(Collectors.toList())) {
            if (pt2.getPortTemplateCount() > 1L) continue;
            s = pt2.getPadTemplate().getLayers();
            if (la == null) {
                la = s;
                continue;
            }
            la.retainAll(s);
        }
        for (PinTemplate pt2 : deviceB.getTemplate().getPins().stream().filter(pt -> pt.getType() != PinTemplate.Type.VIA).collect(Collectors.toList())) {
            if (pt2.getPortTemplateCount() > 1L) continue;
            s = pt2.getPadTemplate().getLayers();
            if (lb == null) {
                lb = s;
                continue;
            }
            lb.retainAll(s);
        }
        if (la == null || la.size() == 0 || lb == null || lb.size() == 0) {
            return null;
        }
        if (la.size() == 1 && lb.size() == 1) {
            return new APair((Object)((Layer)la.iterator().next()), (Object)((Layer)lb.iterator().next()));
        }
        Layer mxla = mnla = (Layer)la.iterator().next();
        Layer mxlb = mnlb = (Layer)lb.iterator().next();
        for (Layer l : la) {
            if (l.getOrder() < mnla.getOrder()) {
                mnla = l;
            }
            if (l.getOrder() <= mxla.getOrder()) continue;
            mxla = l;
        }
        for (Layer l : lb) {
            if (l.getOrder() < mnlb.getOrder()) {
                mnlb = l;
            }
            if (l.getOrder() <= mxlb.getOrder()) continue;
            mxlb = l;
        }
        if (deviceA.getFlipped()) {
            mxla = mnla;
        }
        if (deviceB.getFlipped()) {
            mnlb = mxlb;
        }
        return new APair((Object)mxla, (Object)mnlb);
    }

    public static void autoContactLayer(DeviceMap dm) {
        String devicePathBStr;
        Device deviceA = dm.getCopyDevice().getAParentDevice();
        Device deviceB = dm.getCopyDevice();
        String devicePathAStr = deviceA.getADevicePath().toString();
        if (devicePathAStr.equals(devicePathBStr = deviceB.getADevicePath().toString())) {
            ALog.logError((String)"Cannot set a contact layer with the same devicePath. Need to choose two different devicePaths.");
            return;
        }
        APair<Layer, Layer> player = ContactDeviceEngine.findContactLayer(deviceA, deviceB);
        if (player == null) {
            ALog.logError((String)"Cannot find contact layers. Please check all pins on the common layer.");
            return;
        }
        Layer layerA = (Layer)player.first;
        Layer layerB = (Layer)player.second;
        String layerAName = layerA.getName();
        String layerBName = layerB.getName();
        ContactLayer cl = (ContactLayer)Cp.exec((String)"com.sigrity.acl.db.std.ContactLayer.create(curDb(), \"%s\", \"%s\", \"%s\", \"%s\");", (Object[])new Object[]{devicePathAStr, layerAName, devicePathBStr, layerBName});
        if (cl != null) {
            ALog.logInfo((String)"Auto Contact Layer (%s %s) - (%s %s)", (Object[])new Object[]{dm.getContact().getName(), layerA.getName(), dm.getReference().getName(), layerB.getName()});
        }
    }

    public static void autoDbContactLayer(Db db) {
        for (DeviceMap dm : db.getObjects(DeviceMap.class)) {
            Device copyDevice = dm.getCopyDevice();
            DevicePath copyDP = copyDevice.getADevicePath();
            DevicePath contactDP = copyDevice.getADevicePath();
            contactDP.removeLast();
            ContactLayer cl = ContactLayer.get((DevicePath)contactDP, (DevicePath)copyDP).stream().findFirst().orElse(null);
            if (cl != null) continue;
            ContactDeviceEngine.autoContactLayer(dm);
        }
    }

    public static boolean autoAlignDevice(Device contactDev, Device referDev) {
        long countB;
        long countA;
        int i;
        DeviceTemplate contactDT = contactDev.getTemplate();
        DeviceTemplate referDT = contactDev.getTemplate();
        ArrayList sa = new ArrayList();
        ArrayList sb = new ArrayList();
        contactDT.getPins().stream().filter(pt -> pt.getType() != PinTemplate.Type.VIA).forEach(pt -> sa.add(pt));
        referDT.getPins().stream().filter(pt -> pt.getType() != PinTemplate.Type.VIA).forEach(pt -> sb.add(pt));
        if (sa.size() < 2 || sa.size() != sb.size()) {
            return false;
        }
        Collections.sort(sa, (x, y) -> x.getName().compareTo(y.getName()));
        Collections.sort(sb, (x, y) -> x.getName().compareTo(y.getName()));
        for (int i2 = 0; i2 < sa.size(); ++i2) {
            if (((PinTemplate)sa.get(i2)).getName().equals(((PinTemplate)sb.get(i2)).getName())) continue;
            return false;
        }
        ArrayList<APair> pts = new ArrayList<APair>();
        for (i = 0; i < sa.size() && pts.size() < 2; ++i) {
            countA = ((PinTemplate)sa.get(i)).getPortTemplateCount();
            countB = ((PinTemplate)sb.get(i)).getPortTemplateCount();
            if (countA != 1L || countB != 1L) continue;
            pts.add(new APair((Object)((PinTemplate)sa.get(i)).getFirstPortTemplate(), (Object)((PinTemplate)sb.get(i)).getFirstPortTemplate()));
        }
        for (i = 0; i < sa.size(); ++i) {
            APoint2D pc;
            APoint2D pb;
            countA = ((PinTemplate)sa.get(i)).getPortTemplateCount();
            countB = ((PinTemplate)sb.get(i)).getPortTemplateCount();
            if (countA != 1L && countB != 1L) continue;
            APair p = new APair((Object)((PinTemplate)sa.get(i)).getFirstPortTemplate(), (Object)((PinTemplate)sb.get(i)).getFirstPortTemplate());
            APoint2D pa = ((PortTemplate)((APair)pts.get((int)0)).first).getLoc();
            if (APoint2D.isColinear((APoint2D)pa, (APoint2D)(pb = ((PortTemplate)((APair)pts.get((int)1)).first).getLoc()), (APoint2D)(pc = ((PortTemplate)p.first).getLoc()))) continue;
            pts.add(p);
            break;
        }
        Cp.exec((String)"_mountedDevice = new com.cadence.orbit.pi.systemLevelVerilog.align_device_footprint.AlignDeviceToFootprint.MovedDevice(\"%s\")", (Object[])new Object[]{referDev.getADevicePath().toString()});
        for (APair p : pts) {
            String portAGetByKeyStr = String.format("curDb().getByKeyStr(PortTemplate.class, \"%s\")", ((PortTemplate)p.first).getKeyStr());
            String portBGetByKeyStr = String.format("curDb().getByKeyStr(PortTemplate.class, \"%s\")", ((PortTemplate)p.second).getKeyStr());
            Cp.exec((String)"_mountedDevice.addContactedPortPair(\"%s\", %s, \"%s\", %s);", (Object[])new Object[]{referDev.getADevicePath().toString(), portBGetByKeyStr, contactDev.getADevicePath().toString(), portAGetByKeyStr});
        }
        Cp.exec((String)"_mountedDevice.moveDevice();", (Object[])new Object[0]);
        Cp.exec((String)"unset(\"_mountedDevice\");", (Object[])new Object[0]);
        OrbitIO.getApp().refreshCurrentView(false);
        return true;
    }

    public static boolean sizeMatchWithTolerance(ARect a, ARect b, double p) {
        assert (p >= 0.0 && p <= 1.0);
        long aw = a.width();
        long ah = a.height();
        long bw = b.width();
        long bh = b.height();
        if ((double)aw * (1.0 - p) <= (double)bw && (double)bw <= (double)aw * (1.0 + p) && (double)ah * (1.0 - p) <= (double)bh && (double)bh <= (double)ah * (1.0 + p)) {
            return true;
        }
        return (double)aw * (1.0 - p) <= (double)bh && (double)bh <= (double)aw * (1.0 + p) && (double)ah * (1.0 - p) <= (double)bw && (double)bw <= (double)ah * (1.0 + p);
    }

    public static boolean pinNameMatch(DeviceTemplate aDT, DeviceTemplate bDT) {
        HashSet sa = new HashSet();
        HashSet sb = new HashSet();
        aDT.getPins().stream().filter(pt -> pt.getType() != PinTemplate.Type.VIA).forEach(pt -> sa.add(pt.getName()));
        bDT.getPins().stream().filter(pt -> pt.getType() != PinTemplate.Type.VIA).forEach(pt -> sb.add(pt.getName()));
        if (sa.size() != sb.size()) {
            return false;
        }
        return sa.containsAll(sb);
    }

    public static boolean placeableType(DeviceTemplate.Type contactDesignType, DeviceTemplate.Type referDesignType) {
        if (contactDesignType == DeviceTemplate.Type.BOARD) {
            if (referDesignType == DeviceTemplate.Type.PACKAGE) {
                return true;
            }
            if (referDesignType == DeviceTemplate.Type.PACKAGEDDIE) {
                return true;
            }
        } else if (contactDesignType == DeviceTemplate.Type.PACKAGE ? referDesignType == DeviceTemplate.Type.DIE : contactDesignType == DeviceTemplate.Type.DIE && referDesignType == DeviceTemplate.Type.INTERPOSER) {
            return true;
        }
        return false;
    }

    public static List<Device> recommendReference(Db db, Device contactDev, boolean checkBoundingBox, boolean checkDeviceTemplateName, boolean checkPinName) {
        ArrayList<Device> ret = new ArrayList<Device>();
        DeviceTemplate contactDT = contactDev.getTemplate();
        ARect contactBB = contactDT.getBB();
        DevicePath contactDP = contactDev.getADevicePath();
        for (DeviceTemplate refDT : db.getObjects(DeviceTemplate.class)) {
            if (refDT.equals(contactDT) || refDT.getAnInstance() == null || checkDeviceTemplateName && !refDT.getName().equals(contactDT.getName())) continue;
            ARect refBB = refDT.getBB();
            if (checkBoundingBox && !ContactDeviceEngine.sizeMatchWithTolerance(contactBB, refBB, 0.05) || checkPinName && !ContactDeviceEngine.pinNameMatch(contactDT, refDT)) continue;
            for (Device d : refDT.getDeviceInstances()) {
                if (contactDP.getFirst() == d.getADevicePath().getFirst() || d.getADevicePath().size() > 1 || !ContactDeviceEngine.placeableType(contactDP.getFirst().getTemplate().getType(), refDT.getType())) continue;
                ret.add(d);
            }
        }
        return ret;
    }

    public static class UnicornAPI {
        private static FileWriter createCSVFile(String filePath) {
            FileWriter fileWriter;
            try {
                fileWriter = new FileWriter(new File(filePath));
            }
            catch (IOException e) {
                ALog.logError((String)("Can not open " + filePath + " for writing"));
                return null;
            }
            return fileWriter;
        }

        private static void closeCSVFile(FileWriter fileWriter, String filePath) {
            try {
                fileWriter.close();
                ALog.logInfo((String)("Wrote to CSV file: " + filePath));
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)"Problems when closing", (Object[])new Object[0]);
                return;
            }
        }

        public static void writeTopDeivceTemplateCSV(String filePath) {
            Db db = OrbitIO.getCurDb();
            if (db == null) {
                ALog.logError((String)"No database is open");
                return;
            }
            FileWriter fileWriter = UnicornAPI.createCSVFile(filePath);
            if (fileWriter == null) {
                return;
            }
            try {
                fileWriter.write("device_name,template_name,substrate_name,template_key\n");
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
            Design design = OrbitIO.getCurDesign();
            Stream devs = design.getChildren().stream();
            devs.forEach(dev -> {
                try {
                    fileWriter.write(String.format("%s,%s,%s,%s\n", dev.getName(), dev.getTemplate().getName(), dev.getSubstrate().getName(), dev.getTemplate().getKeyStr()));
                }
                catch (IOException e) {
                    ALog.logError((Throwable)e);
                }
            });
            UnicornAPI.closeCSVFile(fileWriter, filePath);
        }
    }

    public static class ContactDeviceCSVManager {
        public static String[] getHeader() {
            return new String[]{"ContactDevice", "ReferDevice", "ContactLayer", "ReferLayer"};
        }

        public static CSVDocument openCSVFile(String filePath) {
            CSVDocument doc;
            ALog.logInfo((String)"Open CSV %s ...", (Object[])new Object[]{filePath});
            try {
                CSVDOMParser parser2 = new CSVDOMParser(true, null);
                parser2.setDataSepExpression(",");
                doc = parser2.parse(filePath);
            }
            catch (CSVDOMParser.CSVDOMException e) {
                ALog.logDebug((Throwable)e);
                ALog.logError((String)("Problems reading " + filePath));
                return null;
            }
            ALog.logInfo((String)"Read Contact Devices CSV from: %s", (Object[])new Object[]{filePath});
            return doc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void importContactDeviceList(Db db, String filePath, boolean clean) {
            CSVDocument csv = ContactDeviceCSVManager.openCSVFile(filePath);
            if (db == null) {
                ALog.logError((String)"Cannot add contact devices, no current database.");
                return;
            }
            if (csv == null) {
                ALog.logError((String)"Cannot add contact devices, no csv file");
                return;
            }
            db.setHistoryEnabled(false);
            db.setListenersEnabled(false);
            try {
                if (clean) {
                    DeviceMap.deleteAll((Db)db);
                }
                String[] header = csv.getAttributeNames();
                for (int i = 0; i < csv.getItemCount(); ++i) {
                    Device referDev;
                    DeviceMap dm;
                    String contactDTKeyStr = csv.getItemValue(i, header[0]);
                    String referDTKeyStr = csv.getItemValue(i, header[1]);
                    String contactLayerStr = csv.getItemValue(i, header[2]);
                    String referLayerStr = csv.getItemValue(i, header[3]);
                    DeviceTemplate referDT = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, referDTKeyStr);
                    if (referDT == null) {
                        ALog.logInfo((String)"Could not create contact map, item %d: %s,%s,%s,%s. No reference device template found.", (Object[])new Object[]{i + 1, contactDTKeyStr, referDTKeyStr, contactLayerStr, referLayerStr});
                    }
                    if ((dm = DeviceMap.create((Db)db, (String)contactDTKeyStr, (String)referDTKeyStr, (String)(referDev = referDT.getAnInstance()).getKeyStr())) == null) {
                        ALog.logInfo((String)"Could not create contact map, item %d: %s,%s,%s,%s.", (Object[])new Object[]{i + 1, contactDTKeyStr, referDTKeyStr, contactLayerStr, referLayerStr});
                        continue;
                    }
                    Device deviceA = dm.getCopyDevice().getAParentDevice();
                    Device deviceB = dm.getCopyDevice();
                    String devicePathAStr = deviceA.getADevicePath().toString();
                    String devicePathBStr = deviceB.getADevicePath().toString();
                    String layerAName = contactLayerStr;
                    String layerBName = referLayerStr;
                    ContactLayer cl = (ContactLayer)Cp.exec((String)"com.sigrity.acl.db.std.ContactLayer.create(curDb(), \"%s\", \"%s\", \"%s\", \"%s\");", (Object[])new Object[]{devicePathAStr, layerAName, devicePathBStr, layerBName});
                    if (cl != null) continue;
                    ALog.logInfo((String)"Cannot create contact layer, item %d: %s,%s,%s,%s", (Object[])new Object[]{i + 1, contactDTKeyStr, referDTKeyStr, contactLayerStr, referLayerStr});
                }
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Unexpected exception during data load.", (Object[])new Object[0]);
            }
            finally {
                db.setListenersEnabled(true);
                db.setHistoryEnabled(true);
            }
        }

        public static void exportContactDeviceList(Db db, String filePath) {
            File file = new File(filePath);
            try (FileWriter fileWriter = new FileWriter(file);){
                String header = StringUtils.join((Object[])ContactDeviceCSVManager.getHeader(), (String)",");
                fileWriter.write(header);
                fileWriter.write("\n");
                DbClass contactDeviceClass = db.getDbClass("DeviceMap");
                if (contactDeviceClass != null) {
                    for (DeviceMap dm : AUtil.linkedList((Iterator)db.getObjects(DeviceMap.class))) {
                        StringBuilder sb = new StringBuilder();
                        DevicePath copyDP = dm.getCopyDevice().getADevicePath();
                        DevicePath contactDP = dm.getCopyDevice().getADevicePath();
                        contactDP.removeLast();
                        ContactLayer cl = ContactLayer.get((DevicePath)contactDP, (DevicePath)copyDP).stream().findFirst().orElse(null);
                        sb.append(dm.getContact().getKeyStr());
                        sb.append(",");
                        sb.append(dm.getReference().getKeyStr());
                        if (cl != null) {
                            sb.append(",");
                            sb.append(cl.getContactLayerA().getName());
                            sb.append(",");
                            sb.append(cl.getContactLayerB().getName());
                        } else {
                            sb.append(",");
                            sb.append(",");
                        }
                        fileWriter.write(sb.toString());
                        fileWriter.write("\n");
                    }
                }
            }
            catch (IOException e) {
                ALog.logError((String)"Something wrong during writting %s", (Object[])new Object[]{filePath});
                return;
            }
        }
    }
}

