/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceMap;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.ContactDeviceEngine;
import com.sigrity.orbit.ui.EditContactLayerUI;
import com.sigrity.orbit.ui.PinMapGeneratorUI;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ContactDeviceUI {
    static ContactDeviceDialog mContactDeviceDialog = null;

    public static void showUI() {
        if (mContactDeviceDialog != null) {
            mContactDeviceDialog.dispose();
        }
        mContactDeviceDialog = new ContactDeviceDialog(OrbitIO.getCurDb(), OrbitIO.getMainWindow());
        mContactDeviceDialog.setVisible(true);
    }

    public static void showUI(DevicePath devicePath) {
        ContactDeviceUI.showUI();
    }

    public static class AutoDbContactLayerAction
    extends AbstractAction {
        public AutoDbContactLayerAction() {
            this.putValue("Name", "Auto Contact Layer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"%s.autoDbContactLayer(curDb())", (Object[])new Object[]{AReflection.getJavaClassName(ContactDeviceEngine.class)});
            if (mContactDeviceDialog != null) {
                mContactDeviceDialog.showCardPanel("CardContact");
            }
        }
    }

    public static class AllInOneContactDeviceAction
    extends AbstractAction {
        public AllInOneContactDeviceAction(Db db) {
            this.putValue("Name", "All-in-One Contact Device and Check");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"%s.allInOne(curDb())", (Object[])new Object[]{AReflection.getJavaClassName(ContactDeviceEngine.class)});
            if (mContactDeviceDialog != null) {
                mContactDeviceDialog.showCardPanel("CardContact");
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ExportContactDeviceCSVAction
    extends AbstractAction {
        public ExportContactDeviceCSVAction(Db db) {
            this.putValue("Name", "Export Contact Device CSV");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setDialogTitle("Export Contact Device CSV");
            fc.setFileFilter((FileFilter)AFileFilter.CSV);
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            Cp.exec((String)"%s.ContactDeviceCSVManager.exportContactDeviceList(curDb(), %s)", (Object[])new Object[]{AReflection.getJavaClassName(ContactDeviceEngine.class), Cp.getFileAsArgument((File)file)});
        }
    }

    public static class ImportContactDeviceCSVAction
    extends AbstractAction {
        public ImportContactDeviceCSVAction(Db db) {
            this.putValue("Name", "Import Contact Device CSV");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setDialogTitle("Import Contact Device CSV");
            fc.setFileFilter((FileFilter)AFileFilter.CSV);
            JPanel pnlOpts = new JPanel();
            GridBagManager gbm = GridBagManager.layout((Container)pnlOpts);
            JCheckBox cbAppend = (JCheckBox)gbm.addNl((Component)new JCheckBox("Remove all current contact device"));
            gbm.addFillY();
            cbAppend.setToolTipText("<html>");
            fc.setAccessory((JComponent)pnlOpts);
            if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            Cp.exec((String)"%s.ContactDeviceCSVManager.importContactDeviceList(curDb(), %s, %b)", (Object[])new Object[]{AReflection.getJavaClassName(ContactDeviceEngine.class), Cp.getFileAsArgument((File)file), cbAppend.isSelected()});
            if (mContactDeviceDialog != null) {
                mContactDeviceDialog.showCardPanel("CardContact");
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ContactDeviceModel
    extends AbstractTableModel {
        protected String[] mColumnNames = new String[]{"Device Template", "Reference Template", "Reference Device"};
        protected LinkedList<DeviceMap> mDevRows = new LinkedList();
        protected Db mDb;
        final int DEV_COLUMN = 0;
        final int REFERENCE_COLUMN = 1;
        final int REFERDEVICE_COLUMN = 2;

        public void buildTable(Db db) {
            this.mDb = db;
            this.mDevRows.clear();
            for (DeviceMap dm : this.mDb.getObjects(DeviceMap.class)) {
                this.mDevRows.add(dm);
            }
            Collections.sort(this.mDevRows, new RowComparator());
        }

        @Override
        public int getColumnCount() {
            return this.mColumnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.mColumnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.mDevRows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        public DeviceMap getRow(int index) {
            if (index >= 0 && index < this.getRowCount()) {
                return this.mDevRows.get(index);
            }
            return null;
        }

        public List<DeviceMap> getRows() {
            return this.mDevRows;
        }

        public String displayDeviceTemplateName(DeviceTemplate dt) {
            if (dt.getSubstrate() == null) {
                return dt.getName();
            }
            return String.format("%s (%s)", dt.getName(), dt.getSubstrate().getName());
        }

        public String displayDeviceName(Device dev) {
            String s = dev.getTemplate() == null ? "" : " (" + dev.getTemplate().getName() + ")";
            String t = dev.getADevicePath() + s;
            return t;
        }

        public class ContactDeviceRowRenderer
        extends DefaultTableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                Device dev;
                super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
                DeviceMap dat = ContactDeviceModel.this.getRow(row);
                DeviceTemplate dt = dat.getContact();
                this.setIcon(null);
                this.setText(null);
                this.setForeground(Color.black);
                this.setBackground(Color.white);
                this.setToolTipText("");
                if (isSelected) {
                    this.setBackground(Color.orange);
                }
                if (column == 0) {
                    this.setIcon(DbExplorerPanel.getIconForTemplate(dt));
                    this.setText(ContactDeviceModel.this.displayDeviceTemplateName(dt));
                } else if (column == 1) {
                    DeviceTemplate contact = dat.getReference();
                    if (contact != null) {
                        this.setIcon(DbExplorerPanel.getIconForTemplate(contact));
                        this.setText(ContactDeviceModel.this.displayDeviceTemplateName(contact));
                    }
                } else if (column == 2 && (dev = dat.getReferDevice()) != null) {
                    this.setIcon(DbExplorerPanel.getIconForDevice(dev));
                    this.setText(ContactDeviceModel.this.displayDeviceName(dev));
                }
                return this;
            }
        }

        public class RowComparator
        implements Comparator<DeviceMap> {
            @Override
            public int compare(DeviceMap o1, DeviceMap o2) {
                AAlphaNumComp cmp = AAlphaNumComp.get();
                return cmp.compare((Object)o1.getContact(), (Object)o2.getReference());
            }
        }
    }

    public static class InstallContactDeviceModel
    extends AbstractTableModel {
        protected String[] mColumnNames = new String[]{"Devicce", "Reference", "Recommend", "Auto Align"};
        protected LinkedList<RowData> mDevRows = new LinkedList();
        protected Db mDb;
        protected FindContactDeviceRule mFcdr = new FindContactDeviceRule();
        final int DEVT_COLUMN = 0;
        final int REFERENCE_COLUMN = 1;
        final int RECOMMEND_COLUMN = 2;
        final int ALIGN_COLUMN = 3;

        public int countRecommendChange() {
            int ret = 0;
            for (RowData r : this.mDevRows) {
                Optional ftRecommend;
                if (r.contact != null || !(ftRecommend = ContactDeviceEngine.recommendReference(this.mDb, r.dev, this.mFcdr.checkBoundingBox, this.mFcdr.checkDeviceTemplateName, this.mFcdr.checkPinName).stream().findFirst()).isPresent()) continue;
                ++ret;
            }
            return ret;
        }

        public void setFindContactDeviceRule(FindContactDeviceRule fcdr) {
            this.mFcdr = fcdr;
        }

        public void buildTable(Db db) {
            this.mDb = db;
            this.mDevRows.clear();
            for (Device dev : this.mDb.getObjects(Device.class)) {
                DeviceTemplate dt = dev.getTemplate();
                DeviceMap dm = DeviceMap.get((DeviceTemplate)dt).stream().findFirst().orElse(null);
                Device referenceDev = dm == null ? null : dm.getReferDevice();
                this.mDevRows.add(new RowData(dev, referenceDev, false));
            }
            Collections.sort(this.mDevRows, new RowComparator());
        }

        public void fillWithRecommend() {
            for (RowData r : this.mDevRows) {
                Device ref;
                Optional ftRecommend;
                if (r.contact != null || !(ftRecommend = ContactDeviceEngine.recommendReference(this.mDb, r.dev, this.mFcdr.checkBoundingBox, this.mFcdr.checkDeviceTemplateName, this.mFcdr.checkPinName).stream().findFirst()).isPresent()) continue;
                r.contact = ref = (Device)ftRecommend.get();
            }
        }

        public void commit() {
            Cp.exec((String)"DeviceMap.deleteAll(curDb())", (Object[])new Object[0]);
            HashSet<DeviceTemplate> done = new HashSet<DeviceTemplate>();
            for (RowData rowDat : this.mDevRows) {
                DeviceTemplate contactDT;
                if (rowDat.dev == null || rowDat.contact == null || done.contains(contactDT = rowDat.dev.getTemplate())) continue;
                done.add(contactDT);
                DeviceTemplate referenceDT = rowDat.contact.getTemplate();
                if (contactDT == null || referenceDT == null) continue;
                Cp.exec((String)"DeviceMap.create(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{contactDT.getKeyStr(), referenceDT.getKeyStr(), rowDat.contact.getKeyStr()});
            }
            OrbitIO.getApp().refreshCurrentView();
        }

        @Override
        public int getColumnCount() {
            return this.mColumnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.mColumnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.mDevRows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1 || col == 2;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            boolean dataChanged = false;
            if (col == 1 || col == 2) {
                Device val = (Device)value;
                RowData dat = this.getRow(row);
                DeviceTemplate dt = dat.dev.getTemplate();
                for (RowData rowDat : this.getRows()) {
                    if (!rowDat.dev.getTemplate().equals(dt)) continue;
                    rowDat.contact = val;
                    dataChanged = true;
                }
            }
            if (dataChanged) {
                this.fireTableDataChanged();
            }
        }

        public RowData getRow(int index) {
            if (index >= 0 && index < this.getRowCount()) {
                return this.mDevRows.get(index);
            }
            return null;
        }

        public List<RowData> getRows() {
            return this.mDevRows;
        }

        public String displayDeviceName(Device dev) {
            String s = dev.getTemplate() == null ? "" : " (" + dev.getTemplate().getName() + ")";
            String t = dev.getADevicePath() + s;
            return t;
        }

        public class InstallContactDeviceRowRenderer
        extends DefaultTableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
                RowData dat = InstallContactDeviceModel.this.getRow(row);
                Device dev = dat.dev;
                this.setIcon(null);
                this.setText(null);
                this.setForeground(Color.black);
                this.setBackground(Color.white);
                this.setToolTipText("");
                if (isSelected) {
                    this.setBackground(Color.orange);
                }
                if (column == 0) {
                    this.setIcon(DbExplorerPanel.getIconForDevice(dev));
                    this.setText(InstallContactDeviceModel.this.displayDeviceName(dev));
                } else if (column == 1) {
                    Device contact = dat.contact;
                    if (contact != null) {
                        this.setIcon(DbExplorerPanel.getIconForDevice(contact));
                        this.setText(InstallContactDeviceModel.this.displayDeviceName(contact));
                    }
                } else if (column == 2) {
                    Optional ftRecommend = ContactDeviceEngine.recommendReference(InstallContactDeviceModel.this.mDb, dat.dev, InstallContactDeviceModel.this.mFcdr.checkBoundingBox, InstallContactDeviceModel.this.mFcdr.checkDeviceTemplateName, InstallContactDeviceModel.this.mFcdr.checkPinName).stream().findFirst();
                    if (ftRecommend.isPresent()) {
                        Device ref = (Device)ftRecommend.get();
                        this.setText(InstallContactDeviceModel.this.displayDeviceName(ref));
                    }
                } else if (column == 3) {
                    // empty if block
                }
                return this;
            }
        }

        public class CheckBoxRenderer
        extends JCheckBox
        implements TableCellRenderer {
            CheckBoxRenderer() {
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                RowData dat = InstallContactDeviceModel.this.getRow(row);
                boolean align = dat.align;
                this.setSelected(align);
                return this;
            }
        }

        public class TableButtonMouseListener
        extends MouseAdapter {
            protected JTable table;

            public TableButtonMouseListener(JTable table) {
                this.table = table;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    int row = e.getY() / this.table.getRowHeight();
                    if (row >= InstallContactDeviceModel.this.getRowCount()) {
                        return;
                    }
                    TableColumnModel columnModel = this.table.getColumnModel();
                    int column = columnModel.getColumnIndexAtX(e.getX());
                    RowData dat = InstallContactDeviceModel.this.getRow(row);
                    if (column == 3) {
                        dat.align = !dat.align;
                    } else if (column == 1 || column == 2) {
                        // empty if block
                    }
                    this.table.revalidate();
                    this.table.repaint();
                }
            }
        }

        public class DevTComboBoxEditor
        extends DefaultCellEditor {
            JTable table;
            DefaultComboBoxModel<DevComboItem> model;
            Device defaultVal;

            public DevTComboBoxEditor(JTable table) {
                super(new JComboBox());
                JComboBox cb = (JComboBox)this.getComponent();
                cb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DevTComboBoxEditor.this.stopCellEditing();
                    }
                });
                this.model = (DefaultComboBoxModel)cb.getModel();
                this.table = table;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
                RowData dat = InstallContactDeviceModel.this.getRow(rowIndex);
                ArrayList<Device> a = new ArrayList<Device>();
                if (colIndex == 1) {
                    this.defaultVal = dat.contact;
                    for (Device dev : InstallContactDeviceModel.this.mDb.getObjects(Device.class)) {
                        if (dev.equals(dat.dev)) continue;
                        a.add(dev);
                    }
                } else if (colIndex == 2) {
                    this.defaultVal = dat.contact;
                    for (Device dev : ContactDeviceEngine.recommendReference(InstallContactDeviceModel.this.mDb, dat.dev, InstallContactDeviceModel.this.mFcdr.checkBoundingBox, InstallContactDeviceModel.this.mFcdr.checkDeviceTemplateName, InstallContactDeviceModel.this.mFcdr.checkPinName)) {
                        a.add(dev);
                    }
                }
                Collections.sort(a, new DeviceComparator());
                this.model.removeAllElements();
                this.model.addElement(new DevComboItem(null));
                for (Device dev : a) {
                    this.model.addElement(new DevComboItem(dev));
                }
                return super.getTableCellEditorComponent(table, value, isSelected, rowIndex, colIndex);
            }

            @Override
            public Object getCellEditorValue() {
                JComboBox cb = (JComboBox)this.getComponent();
                DevComboItem item = (DevComboItem)cb.getSelectedItem();
                if (item == null) {
                    return this.defaultVal;
                }
                return item.get();
            }

            class DeviceComparator
            implements Comparator<Device> {
                DeviceComparator() {
                }

                @Override
                public int compare(Device o1, Device o2) {
                    AAlphaNumComp cmp = AAlphaNumComp.get();
                    return cmp.compare((Object)o1.getADevicePath(), (Object)o2.getADevicePath());
                }
            }

            class DevComboItem {
                Device data;

                public DevComboItem(Device dev) {
                    this.data = dev;
                }

                public Device get() {
                    return this.data;
                }

                public String toString() {
                    if (this.data == null) {
                        return "";
                    }
                    DeviceTemplate dt = this.data.getTemplate();
                    return this.data.getADevicePath() + (String)(dt == null ? "" : " (" + dt.getName() + ")");
                }
            }
        }

        public class RowComparator
        implements Comparator<RowData> {
            @Override
            public int compare(RowData o1, RowData o2) {
                AAlphaNumComp cmp = AAlphaNumComp.get();
                return cmp.compare((Object)o1.dev.getADevicePath(), (Object)o2.dev.getADevicePath());
            }
        }

        public class RowData {
            Device dev;
            Device contact;
            boolean align;

            RowData(Device t, Device c, boolean a) {
                this.dev = t;
                this.contact = c;
                this.align = a;
            }
        }
    }

    public static class ContactDeviceDialog
    extends DbDialog {
        protected JPanel mSettingPanel;
        protected JPanel mConfirmPanel;
        protected JPanel mContactPanel;
        protected JPanel mControlPanel;
        protected JPanel mCardsPanel;
        protected JCheckBox mBoundingBoxCB;
        protected JCheckBox mDevTNameCB;
        protected JCheckBox mPinNameCB;
        protected JTable mConfirmTable;
        protected JTable mContactTable;
        protected InstallContactDeviceModel mConfirmModel;
        protected ContactDeviceModel mContactModel;
        static final String CONFIRMPANEL = "CardConfirm";
        static final String CONTACTPANEL = "CardContact";
        protected Dimension mButtonDim = new Dimension(100, 24);
        protected Dimension mTableButtonDim = new Dimension(160, 24);

        public ContactDeviceDialog(Db db, Window owner) {
            super(db, (Component)owner);
            this.mConfirmPanel = this.createConfirmPanel();
            this.mContactPanel = this.createContactPanel();
            Dimension minDim = new Dimension(600, 600);
            this.mSettingPanel.setMinimumSize(minDim);
            this.mConfirmPanel.setMinimumSize(minDim);
            this.mContactPanel.setMinimumSize(minDim);
            this.mCardsPanel = new JPanel(new CardLayout());
            this.mCardsPanel.add((Component)this.mConfirmPanel, CONFIRMPANEL);
            this.mCardsPanel.add((Component)this.mContactPanel, CONTACTPANEL);
            this.showCardPanel(CONTACTPANEL);
            this.setTitle("Contact Device Engine");
            this.setSize(800, 650);
            this.setLayout(new BorderLayout());
            this.add(this.mCardsPanel, "Center");
        }

        public void showCardPanel(String cardName) {
            CardLayout cl = (CardLayout)this.mCardsPanel.getLayout();
            if (cardName.equals(CONFIRMPANEL)) {
                this.mConfirmModel.buildTable(this.getDb());
                this.mConfirmTable.revalidate();
                this.mConfirmTable.repaint();
            } else if (cardName.equals(CONTACTPANEL)) {
                this.refreshControlPanel(null);
                this.mContactModel.buildTable(this.getDb());
                this.mContactTable.revalidate();
                this.mContactTable.repaint();
            }
            cl.show(this.mCardsPanel, cardName);
            this.revalidate();
            this.repaint();
        }

        protected JPanel createSettingPanel() {
            JPanel panel = new JPanel();
            GridBagManager gbm = new GridBagManager((Container)panel);
            ActionListener changeAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindContactDeviceRule fcdr = new FindContactDeviceRule();
                    fcdr.checkBoundingBox = mBoundingBoxCB.isSelected();
                    fcdr.checkDeviceTemplateName = mDevTNameCB.isSelected();
                    fcdr.checkPinName = mPinNameCB.isSelected();
                    mConfirmModel.setFindContactDeviceRule(fcdr);
                    mConfirmTable.revalidate();
                    mConfirmTable.repaint();
                }
            };
            this.mBoundingBoxCB = new JCheckBox("Bounding Box", true);
            this.mBoundingBoxCB.addActionListener(changeAction);
            this.mDevTNameCB = new JCheckBox("Device Template Name", true);
            this.mDevTNameCB.addActionListener(changeAction);
            this.mPinNameCB = new JCheckBox("Pin Name", true);
            this.mPinNameCB.addActionListener(changeAction);
            gbm.pushFillX("Match Option");
            gbm.addNl((Component)this.mBoundingBoxCB, (GridBagConstraints)GridBagManager.LEFT);
            gbm.addNl((Component)this.mDevTNameCB, (GridBagConstraints)GridBagManager.LEFT);
            gbm.addNl((Component)this.mPinNameCB, (GridBagConstraints)GridBagManager.LEFT);
            gbm.pop();
            gbm.newline();
            gbm.addFillAll();
            return panel;
        }

        protected JPanel createConfirmPanel() {
            JPanel panel = new JPanel();
            GridBagManager gbm = new GridBagManager((Container)panel);
            this.mConfirmTable = new JTable();
            this.mConfirmModel = new InstallContactDeviceModel();
            this.mConfirmTable.setModel(this.mConfirmModel);
            TableColumn col = this.mConfirmTable.getColumnModel().getColumn(this.mConfirmModel.DEVT_COLUMN);
            col.setIdentifier(this.mConfirmModel.DEVT_COLUMN);
            col.setResizable(true);
            col = this.mConfirmTable.getColumnModel().getColumn(this.mConfirmModel.REFERENCE_COLUMN);
            col.setIdentifier(this.mConfirmModel.REFERENCE_COLUMN);
            col.setResizable(true);
            InstallContactDeviceModel installContactDeviceModel = this.mConfirmModel;
            Objects.requireNonNull(installContactDeviceModel);
            col.setCellEditor(installContactDeviceModel.new InstallContactDeviceModel.DevTComboBoxEditor(this.mConfirmTable));
            col = this.mConfirmTable.getColumnModel().getColumn(this.mConfirmModel.RECOMMEND_COLUMN);
            col.setIdentifier(this.mConfirmModel.RECOMMEND_COLUMN);
            col.setResizable(true);
            InstallContactDeviceModel installContactDeviceModel2 = this.mConfirmModel;
            Objects.requireNonNull(installContactDeviceModel2);
            col.setCellEditor(installContactDeviceModel2.new InstallContactDeviceModel.DevTComboBoxEditor(this.mConfirmTable));
            this.mConfirmTable.setDefaultRenderer(Object.class, this.mConfirmModel.new InstallContactDeviceModel.InstallContactDeviceRowRenderer());
            this.mConfirmTable.getColumnModel().getColumn(this.mConfirmModel.ALIGN_COLUMN).setCellRenderer(this.mConfirmModel.new InstallContactDeviceModel.CheckBoxRenderer());
            InstallContactDeviceModel installContactDeviceModel3 = this.mConfirmModel;
            Objects.requireNonNull(installContactDeviceModel3);
            this.mConfirmTable.addMouseListener(installContactDeviceModel3.new InstallContactDeviceModel.TableButtonMouseListener(this.mConfirmTable));
            gbm.pushFill("Confirm Table");
            this.mSettingPanel = this.createSettingPanel();
            JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.mConfirmTable), this.mSettingPanel);
            splitPane.setOneTouchExpandable(true);
            splitPane.setDividerLocation(450);
            gbm.add((Component)splitPane, (GridBagConstraints)GridBagManager.FILLALL);
            gbm.pop();
            gbm.newline();
            JButton nextButton = new JButton("Finish");
            JButton cancelButton = new JButton("Cancel");
            JButton recommendButton = new JButton("Recommend");
            nextButton.setPreferredSize(this.mButtonDim);
            nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mConfirmModel.commit();
                    this.showCardPanel(ContactDeviceDialog.CONTACTPANEL);
                }
            });
            cancelButton.setPreferredSize(this.mButtonDim);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.showCardPanel(ContactDeviceDialog.CONTACTPANEL);
                }
            });
            recommendButton.setPreferredSize(this.mButtonDim);
            recommendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int change = mConfirmModel.countRecommendChange();
                    String title = "Recommend Contact Device";
                    if (change == 0) {
                        JOptionPane.showMessageDialog(null, "No results found.");
                    } else {
                        String text = String.format("Add %d new contact device(s)?", change);
                        if (JOptionPane.showConfirmDialog(null, text, title, 0) == 0) {
                            mConfirmModel.fillWithRecommend();
                            mConfirmTable.revalidate();
                            mConfirmTable.repaint();
                        }
                    }
                }
            });
            JPanel confirmBtnPanel = new JPanel(new FlowLayout(2));
            confirmBtnPanel.add(recommendButton);
            confirmBtnPanel.add(cancelButton);
            confirmBtnPanel.add(nextButton);
            gbm.add((Component)confirmBtnPanel, (GridBagConstraints)GridBagManager.FILLX);
            gbm.newline();
            return panel;
        }

        protected JPanel createContactPanel() {
            JPanel panel = new JPanel();
            GridBagManager gbm = new GridBagManager((Container)panel);
            this.mContactTable = new JTable();
            this.mContactModel = new ContactDeviceModel();
            this.mContactTable.setModel(this.mContactModel);
            this.mContactTable.setSelectionMode(0);
            this.mContactTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int[] selectIndex = mContactTable.getSelectedRows();
                    DeviceMap dm = null;
                    if (selectIndex.length == 1) {
                        dm = mContactModel.getRow(selectIndex[0]);
                    }
                    this.refreshControlPanel(dm);
                    this.revalidate();
                    this.repaint();
                }
            });
            this.mControlPanel = new JPanel();
            this.refreshControlPanel(null);
            int columnWidth = 10;
            TableColumn col = this.mContactTable.getColumnModel().getColumn(this.mContactModel.DEV_COLUMN);
            col.setPreferredWidth(20 * columnWidth);
            col.setIdentifier(this.mContactModel.DEV_COLUMN);
            col.setResizable(true);
            this.mContactTable.setDefaultRenderer(Object.class, this.mContactModel.new ContactDeviceModel.ContactDeviceRowRenderer());
            gbm.pushFill("Contact Table");
            JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.mContactTable), this.mControlPanel);
            splitPane.setOneTouchExpandable(true);
            splitPane.setDividerLocation(450);
            gbm.add((Component)splitPane, (GridBagConstraints)GridBagManager.FILLALL);
            gbm.pop();
            gbm.newline();
            JButton contactLayerButton = new JButton("Edit Contact Layer");
            contactLayerButton.setPreferredSize(this.mTableButtonDim);
            contactLayerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditContactLayerUI.showUI();
                }
            });
            JButton checkPortMapButton = new JButton("Check Port Mapping");
            checkPortMapButton.setPreferredSize(this.mTableButtonDim);
            checkPortMapButton.addActionListener(e -> PinMapGeneratorUI.showUI(OrbitIO.getMainWindow()));
            JButton autoContactLayerButton = new JButton(new AutoDbContactLayerAction());
            JPanel tableBtnPanel = new JPanel(new FlowLayout(2));
            tableBtnPanel.add(contactLayerButton);
            tableBtnPanel.add(checkPortMapButton);
            tableBtnPanel.add(autoContactLayerButton);
            gbm.add((Component)tableBtnPanel, (GridBagConstraints)GridBagManager.FILLX);
            gbm.newline();
            JButton nextButton = new JButton("Properties");
            JButton autoButton = new JButton(new AllInOneContactDeviceAction(this.mDb));
            JButton deleteButton = new JButton("Delete");
            JButton importButton = new JButton(new ImportContactDeviceCSVAction(this.mDb));
            JButton exportButton = new JButton(new ExportContactDeviceCSVAction(this.mDb));
            nextButton.setPreferredSize(this.mButtonDim);
            nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.showCardPanel(ContactDeviceDialog.CONFIRMPANEL);
                }
            });
            deleteButton.setPreferredSize(this.mButtonDim);
            deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (JOptionPane.showConfirmDialog(null, "Do you really delete all contact device mapping before export configuration?", "Delete all Contact Device Mapping", 0) == 0) {
                        Cp.exec((String)"com.sigrity.acl.db.std.DeviceMap.deleteAll(curDb())", (Object[])new Object[0]);
                        Cp.exec((String)"com.sigrity.acl.db.std.ContactLayer.deleteInvalid(curDb())", (Object[])new Object[0]);
                        this.showCardPanel(ContactDeviceDialog.CONTACTPANEL);
                        OrbitIO.getApp().refreshCurrentView();
                    }
                }
            });
            autoButton.setPreferredSize(this.mButtonDim);
            autoButton.setText("All-in-One");
            importButton.setPreferredSize(this.mButtonDim);
            importButton.setText("Import");
            exportButton.setPreferredSize(this.mButtonDim);
            exportButton.setText("Export");
            JPanel confirmBtnPanel = new JPanel(new FlowLayout(2));
            confirmBtnPanel.add(autoButton);
            confirmBtnPanel.add(deleteButton);
            confirmBtnPanel.add(importButton);
            confirmBtnPanel.add(exportButton);
            confirmBtnPanel.add(nextButton);
            gbm.add((Component)confirmBtnPanel, (GridBagConstraints)GridBagManager.FILLX);
            gbm.newline();
            return panel;
        }

        protected void refreshControlPanel(final DeviceMap dm) {
            this.mControlPanel.removeAll();
            GridBagManager gbm = new GridBagManager((Container)this.mControlPanel);
            if (dm == null) {
                return;
            }
            DevicePath copyDP = dm.getCopyDevice().getADevicePath();
            DevicePath contactDP = dm.getCopyDevice().getADevicePath();
            contactDP.removeLast();
            ContactLayer cl = ContactLayer.get((DevicePath)contactDP, (DevicePath)copyDP).stream().findFirst().orElse(null);
            JButton autoAlignButton = new JButton("Auto Align");
            autoAlignButton.setPreferredSize(this.mTableButtonDim);
            autoAlignButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Device d = dm.getContact().getDeviceInstances().stream().findFirst().orElse(null);
                    ContactDeviceEngine.autoAlignDevice(d, dm.getCopyDevice());
                }
            });
            JButton autoLayerButton = new JButton("Auto Contact Layer");
            autoLayerButton.setPreferredSize(this.mTableButtonDim);
            autoLayerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContactDeviceEngine.autoContactLayer(dm);
                    this.refreshControlPanel(dm);
                }
            });
            JButton deleteItemButton = new JButton("Delete this");
            deleteItemButton.setPreferredSize(this.mTableButtonDim);
            deleteItemButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean delete = (Boolean)Cp.exec((String)"com.sigrity.acl.db.std.DeviceMap.delete(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{dm.getContact().getKeyStr(), dm.getReference().getKeyStr()});
                    ALog.logDebug((String)"Test delete %b", (Object[])new Object[]{delete});
                    this.showCardPanel(ContactDeviceDialog.CONTACTPANEL);
                }
            });
            gbm.pushFillX("Info.");
            gbm.addNl("Device Template:");
            JTextField devField = new JTextField(this.mContactModel.displayDeviceTemplateName(dm.getContact()), 20);
            devField.setEditable(false);
            gbm.addNl((Component)devField, (GridBagConstraints)GridBagManager.LEFT);
            gbm.addNl("Layer (for Contact Device):");
            JTextField devLayerField = new JTextField(cl == null ? "" : cl.getContactLayerA().getName(), 20);
            devLayerField.setEditable(false);
            gbm.addNl((Component)devLayerField, (GridBagConstraints)GridBagManager.LEFT);
            gbm.addNl("Reference Template:");
            JTextField refField = new JTextField(this.mContactModel.displayDeviceTemplateName(dm.getReference()), 20);
            refField.setEditable(false);
            gbm.addNl((Component)refField, (GridBagConstraints)GridBagManager.LEFT);
            gbm.addNl("Layer (for Reference Device):");
            JTextField refLayerField = new JTextField(cl == null ? "" : cl.getContactLayerB().getName(), 20);
            refLayerField.setEditable(false);
            gbm.addNl((Component)refLayerField, (GridBagConstraints)GridBagManager.LEFT);
            gbm.pop();
            gbm.newline();
            gbm.pushFillX("Item Editor");
            gbm.addNl((Component)autoAlignButton);
            gbm.addNl((Component)autoLayerButton);
            gbm.addNl((Component)deleteItemButton);
            gbm.pop();
            gbm.newline();
            gbm.addFillAll();
        }
    }

    public static class FindContactDeviceRule {
        boolean checkBoundingBox = true;
        boolean checkDeviceTemplateName = true;
        boolean checkPinName = true;
    }
}

