/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class DevicePinMappingTable {
    protected DevicePath parent;
    protected List<DevicePath> interestingChildren = new ArrayList<DevicePath>();
    protected List<HierPort> interestingPort = new ArrayList<HierPort>();
    protected FileWriter mFileWriter;
    protected String mFileName;
    protected int mNumDeviceName;
    private static final Comparator<PinInstance> ALPHA_NUMERIC_ORDER = (p1, p2) -> {
        AAlphaNumComp c = AAlphaNumComp.get();
        return c.compare((Object)p1.getName(), (Object)p2.getName());
    };

    public DevicePinMappingTable(DevicePath devicePath) {
        this.parent = devicePath;
    }

    public void addChildOfInterest(DevicePath dp) {
        if (this.interestingChildren.contains(dp)) {
            return;
        }
        this.interestingChildren.add(dp);
    }

    public void generateCSV(String fileName, boolean exportSeparateDeviceName) {
        this.mFileName = fileName;
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        try {
            this.mFileWriter = new FileWriter(file);
        }
        catch (IOException e) {
            ALog.logError((String)"Can not open %s", (Object[])new Object[]{fileName});
            return;
        }
        this.setInterestingPort();
        this.writeHeader(exportSeparateDeviceName);
        for (HierPort hPort : this.interestingPort) {
            DevicePath dp = (DevicePath)hPort.first;
            PinInstance pin = hPort.getPin();
            DevicePath groupPath = new DevicePath();
            DevicePath devicePath = new DevicePath();
            DevicePath rotPath = new DevicePath();
            for (Device d : dp) {
                DeviceTemplate.Type type = d.getDeviceType();
                rotPath.add(d);
                if (type == DeviceTemplate.Type.GROUP) {
                    groupPath.add(d);
                    continue;
                }
                if (type != DeviceTemplate.Type.DIE && type != DeviceTemplate.Type.INTERPOSER) continue;
                devicePath.add(d);
                rotPath.clear();
            }
            this.writeCSV(groupPath.getString().replaceFirst("/", "") + ",");
            if (!exportSeparateDeviceName) {
                this.writeCSV(devicePath.getString().replaceFirst("/", "") + ",");
            } else {
                for (int i = 0; i != this.mNumDeviceName; ++i) {
                    if (i < devicePath.size()) {
                        this.writeCSV(devicePath.get(i).getName() + ",");
                        continue;
                    }
                    this.writeCSV(",");
                }
            }
            if (pin.getDeviceTemplate().getType() != DeviceTemplate.Type.BUMP) {
                this.writeCSV(pin.getName() + ",");
            } else {
                this.writeCSV(pin.getDevice().getName() + ",");
            }
            PadTemplate padT = pin.getPadTemplate();
            this.writeCSV(padT.getName() + ",");
            float rotation = ((PortTemplate)hPort.second).getAggregateRotate(rotPath);
            this.writeCSV(rotation + ",");
            APoint2D loc = pin.getWorldLoc(dp);
            String xCoord = OrbitIO.getCurView().getUnit().toUserStr(loc.getX()).replace(",", "");
            String yCoord = OrbitIO.getCurView().getUnit().toUserStr(loc.getY()).replace(",", "");
            this.writeCSV(xCoord + ",");
            this.writeCSV(yCoord + ",");
            HierInst hierNet = NetMap.getTop((DevicePath)dp, (Net)pin.getNet());
            Net n = (Net)hierNet.getDbObject();
            Device d = hierNet.getPath().getDevice();
            n.getPinInstances(d).stream().sorted(ALPHA_NUMERIC_ORDER).forEach(p -> {
                if (p.getType() == PinTemplate.Type.BALLPAD) {
                    this.writeCSV(p.getName() + " ");
                }
            });
            this.writeCSV(",");
            if (n.getDeviceTemplate().getType() == DeviceTemplate.Type.PACKAGE) {
                this.writeCSV(n.getName());
            }
            this.writeCSV(", \n");
        }
        try {
            this.mFileWriter.close();
        }
        catch (IOException e) {
            ALog.logError((String)"Can not close file %s.", (Object[])new Object[]{fileName});
            return;
        }
        ALog.logInfo((String)"Export Device Pin Mapping table to %s.", (Object[])new Object[]{fileName});
    }

    private void writeHeader(boolean exportSeparateDeviceName) {
        ArrayList<Object> mHeader = new ArrayList<Object>();
        mHeader.add("Group Name");
        if (!exportSeparateDeviceName) {
            mHeader.add("Device Name");
        } else {
            for (int i = 1; i <= this.mNumDeviceName; ++i) {
                mHeader.add("Device Name " + i);
            }
        }
        mHeader.add("Pin Number");
        mHeader.add("Padstack");
        mHeader.add("Rotation");
        mHeader.add("X COORD");
        mHeader.add("Y COORD");
        mHeader.add("Ball Number");
        mHeader.add("Ball Net Name");
        for (String string : mHeader) {
            this.writeCSV(string + ",");
        }
        this.writeCSV("\n");
    }

    private void setInterestingPort() {
        for (DevicePath dp : this.interestingChildren) {
            Device device = dp.getLast();
            device.getPins().stream().filter(pin -> pin.getPinTemplate().getType() == PinTemplate.Type.BUMPPAD || pin.getPinTemplate().getType() == PinTemplate.Type.WIREBONDPAD).sorted(ALPHA_NUMERIC_ORDER).forEach(pin -> {
                int count = 0;
                for (Device d : dp) {
                    DeviceTemplate.Type type = d.getDeviceType();
                    if (type != DeviceTemplate.Type.DIE && type != DeviceTemplate.Type.INTERPOSER) continue;
                    ++count;
                }
                this.mNumDeviceName = count > this.mNumDeviceName ? count : this.mNumDeviceName;
                pin.getPinTemplate().getPortTemplates().stream().forEach(port -> this.interestingPort.add(new HierPort(dp, port)));
            });
        }
    }

    protected void writeCSV(String s) {
        try {
            this.mFileWriter.write(s);
        }
        catch (IOException e) {
            ALog.logError((String)"Can not write to %s.", (Object[])new Object[]{this.mFileName});
        }
    }
}

