/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.Personalities;
import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;

public class DistributeNets {
    private DistributeNets() {
    }

    public static void go(String devicePathString, String nets, String styleStr, String whichPins) {
        HierPort hp;
        Db db = OrbitIO.getCurDb();
        Design design = Design.getDesign((Db)db);
        DevicePath startPath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (startPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        DISTRIBUTE_STYLE style = DISTRIBUTE_STYLE.fromKeyStr(styleStr);
        if (style == null) {
            ALog.logError((String)"Invalid style '%s' for distributing nets.", (Object[])new Object[]{styleStr});
            return;
        }
        DISTRIBUTE_SOURCE source = DISTRIBUTE_SOURCE.fromKeyStr(whichPins);
        if (source == null) {
            ALog.logError((String)"Invalid source '%s' for distributing nets.", (Object[])new Object[]{whichPins});
            return;
        }
        Substrate subst = startPath.getDevice().getSubstrate();
        DeviceTemplate dt = startPath.getDeviceTemplate();
        Selection s = design.getCurSelection();
        HashSet<HierPin> selectedPins = new HashSet<HierPin>();
        for (Object pi : s.get(PinInstance.class)) {
            for (Object dpath : s.getSelectedPaths((DbObject)pi)) {
                selectedPins.add(new HierPin((DevicePath)dpath, (PinInstance)pi));
            }
        }
        LinkedList<HierPort> hPorts = new LinkedList<HierPort>();
        for (DevicePath path : startPath.getDescendants(true)) {
            if (path.getDevice().getSubstrate() != subst) continue;
            for (PinInstance pin : path.getLast().getPins()) {
                Object n;
                HierPin hp2 = new HierPin(path, pin);
                if (source == DISTRIBUTE_SOURCE.UNCONNECTED ? (n = NetMap.getTopmostNet((Net)pin.getNet(), (DevicePath)path)).getDeviceTemplate() != dt : source == DISTRIBUTE_SOURCE.SELECTED && !selectedPins.contains(hp2)) continue;
                n = pin.getPinTemplate().getPortTemplates().iterator();
                while (n.hasNext()) {
                    PortTemplate pt = (PortTemplate)n.next();
                    hPorts.add(new HierPort(path, pt));
                }
            }
        }
        Collections.sort(hPorts);
        HierPort[][] matrix = HierPort.matrixPorts(hPorts, null);
        HierPin netArray = nets.split(",");
        int numNets = ((String[])netArray).length;
        if (numNets == 0) {
            return;
        }
        int netIdx = 0;
        for (Object net : netArray) {
            net = net.trim();
            Color c = null;
            Optional pPortOption = Personality.getPersonality((DeviceTemplate)dt, (Personality.Type)Personality.Type.PORT, (String)net);
            if (!pPortOption.isPresent()) {
                pPortOption = Personality.create((DeviceTemplate)dt, (Personality.Type)Personality.Type.PORT, (String)net);
            } else {
                c = ((Personality)pPortOption.get()).getColor();
            }
            Optional pNetOption = Personality.getPersonality((DeviceTemplate)dt, (Personality.Type)Personality.Type.NET, (String)net);
            if (!pNetOption.isPresent()) {
                pNetOption = Personality.create((DeviceTemplate)dt, (Personality.Type)Personality.Type.NET, (String)net);
            } else {
                c = ((Personality)pNetOption.get()).getColor();
            }
            assert (pPortOption.isPresent());
            assert (pNetOption.isPresent());
            if (c == null) {
                c = Personalities.getDefaultPersonalityColor((Personality)((Personality)pPortOption.get()));
            }
            ((Personality)pPortOption.get()).setColor(c);
            ((Personality)pNetOption.get()).setColor(c);
            Constraint.getOrCreate((DbObject)((DbObject)pNetOption.get()), (Constraint.Descriptor)Constraint.IS_POWER, (Object)true);
        }
        if (style == DISTRIBUTE_STYLE.VERTICAL) {
            for (int rowIdx = 0; rowIdx < matrix.length; ++rowIdx) {
                HierPort[] col = matrix[rowIdx];
                netIdx = 0;
                for (int colIdx = 0; colIdx < col.length; ++colIdx) {
                    HierPort hp3 = col[colIdx];
                    if (hp3 != null) {
                        Object netName = netArray[netIdx];
                        netName = netName.trim();
                        DistributeNets.setNet(hp3, (String)netName, dt);
                    }
                    if (++netIdx < numNets) continue;
                    netIdx = 0;
                }
            }
        } else if (style == DISTRIBUTE_STYLE.HORIZONTAL) {
            for (int rowIdx = 0; rowIdx < matrix.length; ++rowIdx) {
                HierPort[] col = matrix[rowIdx];
                Object netName = netArray[netIdx];
                netName = netName.trim();
                for (int colIdx = 0; colIdx < col.length; ++colIdx) {
                    hp = col[colIdx];
                    if (hp == null) continue;
                    DistributeNets.setNet(hp, (String)netName, dt);
                }
                if (++netIdx < numNets) continue;
                netIdx = 0;
            }
        } else {
            int startIdx = 0;
            for (int rowIdx = 0; rowIdx < matrix.length; ++rowIdx) {
                HierPort[] col = matrix[rowIdx];
                netIdx = startIdx;
                for (int colIdx = 0; colIdx < col.length; ++colIdx) {
                    hp = col[colIdx];
                    if (hp == null) continue;
                    Object netName = netArray[netIdx];
                    netName = netName.trim();
                    DistributeNets.setNet(hp, (String)netName, dt);
                    if (++netIdx < numNets) continue;
                    netIdx = 0;
                }
                if (++startIdx < numNets) continue;
                startIdx = 0;
            }
        }
        ALog.logInfo((String)"There are %d pins being changed", (Object[])new Object[]{hPorts.size()});
    }

    protected static void setNet(HierPort hp, String netName, DeviceTemplate dt) {
        Optional p = Personality.getPersonality((DeviceTemplate)dt, (Personality.Type)Personality.Type.PORT, (String)netName);
        if (p.isPresent()) {
            Device device = ((DevicePath)hp.first).getLast();
            DevicePath relPath = ((DevicePath)hp.first).getRelativePathFromAnchor(dt);
            PinInstance pi = device.getPin(((PortTemplate)hp.second).getPinTemplate());
            pi.unAssignFromPersonality();
            PersonalityMap.create((Personality)((Personality)p.get()), (DevicePath)relPath, (DbObject)pi);
        }
        if ((p = Personality.getPersonality((DeviceTemplate)dt, (Personality.Type)Personality.Type.NET, (String)netName)).isPresent()) {
            Net n = dt.getNet(netName);
            if (n == null) {
                n = dt.createNet(netName);
            }
            n.assignToPersonality((Personality)p.get());
        }
        DeviceTemplate thisTemplate = ((DevicePath)hp.first).getDeviceTemplate();
        Net n = ((PortTemplate)hp.second).getPinTemplate().getNet();
        DevicePath relPath = ((DevicePath)hp.first).getRelativePathFromAnchor(dt);
        if (thisTemplate.hasExactlyOneDeviceInstance()) {
            n = thisTemplate.getNet(netName);
            if (n == null) {
                n = thisTemplate.createNet(netName);
            }
            ((PortTemplate)hp.second).getPinTemplate().setNet(n);
            NetMap.mapToRoot((DevicePath)relPath, (Net)n, (String)netName);
        } else if (n.isUnused()) {
            String newNetName = "net";
            n = thisTemplate.getNet(newNetName);
            if (n == null) {
                n = thisTemplate.createNet(newNetName);
            } else if (AUtil.moreThanOne((Iterator)n.getDescendantContents())) {
                n = thisTemplate.createNet(newNetName, true);
            }
            ((PortTemplate)hp.second).getPinTemplate().setNet(n);
            NetMap.mapToRoot((DevicePath)relPath, (Net)n, (String)netName);
        } else {
            NetMap.mapToRoot((DevicePath)relPath, (Net)n, (String)netName);
        }
    }

    public static enum DISTRIBUTE_SOURCE {
        SELECTED("selected"),
        UNCONNECTED("nonet");

        private final String key;

        private DISTRIBUTE_SOURCE(String key) {
            this.key = key;
        }

        public String getKeyStr() {
            return this.key;
        }

        static DISTRIBUTE_SOURCE fromKeyStr(String keyStr) {
            for (DISTRIBUTE_SOURCE style : DISTRIBUTE_SOURCE.values()) {
                if (!style.getKeyStr().equals(keyStr)) continue;
                return style;
            }
            return null;
        }
    }

    public static enum DISTRIBUTE_STYLE {
        HORIZONTAL("horizontal"),
        VERTICAL("vertical"),
        CHECKERBOARD("checkerboard");

        private final String key;

        private DISTRIBUTE_STYLE(String key) {
            this.key = key;
        }

        public String getKeyStr() {
            return this.key;
        }

        static DISTRIBUTE_STYLE fromKeyStr(String keyStr) {
            for (DISTRIBUTE_STYLE style : DISTRIBUTE_STYLE.values()) {
                if (!style.getKeyStr().equals(keyStr)) continue;
                return style;
            }
            return null;
        }
    }
}

