/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.topology.Binner;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DevicePathPortPair;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.router.SingleLayerRouter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;

public class FanOutFactory {
    protected ArrayList<DevicePathPortPair> mCandidates = new ArrayList();
    protected PadTemplate mPadTemplate;
    protected Layer mObstacleLayer;
    protected Layer mRouteLayer;
    protected AGeom mGeom;
    protected ACircle mCircle;
    protected DevicePath mParent;
    protected long mMinDist;
    protected long mMaxDist;
    protected long mClr;
    protected boolean mOrthoOnly = false;
    protected Db mDb;
    protected ArrayList<Layer> mAvoidLayerList;
    protected Binner<AGeom> mBinner = new Binner();
    protected ArrayList<AGeom> mObstacles = new ArrayList();
    protected HashMap<AGeom, Net> mGeomToNet = new HashMap();
    protected ArrayList<APath> mPaths = new ArrayList();

    public void loadCandidates(ArrayList<DevicePathPortPair> candidates) {
        this.mCandidates = candidates;
    }

    public void setParent(DevicePath parent) {
        this.mParent = parent;
        this.mDb = parent.getLast().getDb();
    }

    public void setRouteLayer(Layer l) {
        this.mRouteLayer = l;
    }

    public void setMaxSearchRad(long d) {
        this.mMaxDist = d;
    }

    public void setMinDist(long d) {
        this.mMinDist = d;
    }

    public void setOrthoOnly(boolean oo) {
        this.mOrthoOnly = oo;
    }

    public void setClr(long clr) {
        this.mClr = clr;
    }

    public void setAvoidList(ArrayList<Layer> avoidLayerList) {
        this.mAvoidLayerList = avoidLayerList;
    }

    public void setPadTemplate(PadTemplate pt) {
        this.mPadTemplate = pt;
    }

    protected void createBinner() {
        Iterator<Layer> iterator = this.mPadTemplate.getLayerShapes().iterator();
        if (iterator.hasNext()) {
            LayerShape layerShape = (LayerShape)iterator.next();
            this.mObstacleLayer = layerShape.getLayer();
            this.mGeom = layerShape.getGeom();
            this.mCircle = (ACircle)this.mGeom;
        }
        this.mBinner.setWorld(this.mParent.getBB());
        for (DevicePath dp : this.mParent.getDescendants()) {
            Device d = dp.getLast();
            for (PinInstance dport : d.getPins()) {
                HierPin dpp = new HierPin(dp, dport);
                this.addThisPortToObstacles(dpp, this.mObstacleLayer);
            }
        }
        if (this.mAvoidLayerList != null) {
            for (Layer avoidLayer : this.mAvoidLayerList) {
                Substrate s = avoidLayer.getSubstrate();
                DevicePath p = s.getADevicePathUsing();
                for (DevicePath dp : p.getDescendants()) {
                    Device d = dp.getLast();
                    for (PinInstance dport : d.getPins()) {
                        HierPin dpp = new HierPin(dp, dport);
                        this.addThisPortToObstacles(dpp, avoidLayer);
                    }
                }
            }
        }
    }

    public void addThisPortToObstacles(HierPin dpp, Layer avoid) {
        AGeom s = dpp.getPin().getWorldShapeOnLayer(dpp.getPath(), avoid);
        if (s != null) {
            this.mObstacles.add(s);
            this.mGeomToNet.put(s, dpp.getNet());
            this.mBinner.insert((Object)s, s.getBounds());
        }
    }

    public void addPathBetweenBallAndVia(HierPin ball, HierPin via) {
        APoint2D pBall = ball.getWorldLoc();
        APoint2D pVia = via.getWorldLoc();
        APath p = new APath();
        p.addPoint(pBall);
        p.addPoint(pVia);
        this.mPaths.add(p);
    }

    public void go(String baseName) {
        this.createBinner();
        int total = 0;
        int success = 0;
        for (DevicePathPortPair dpp : this.mCandidates) {
            APoint2D offset;
            PinInstance secondaryPort = null;
            PinInstance primaryPort = dpp.getDPPA().getPin();
            if (dpp.getDPPB() != null) {
                secondaryPort = dpp.getDPPB().getPin();
            }
            Net net = primaryPort.getNet();
            SingleLayerRouter.updateProgress(false, (double)(++total) / (double)this.mCandidates.size(), "");
            Personality p = primaryPort.getPersonality();
            APoint2D fromPortWorldLoc = primaryPort.getWorldLoc(this.mParent);
            APoint2D gravity = null;
            if (secondaryPort != null) {
                DevicePath gravitydp = secondaryPort.getDevice().getADevicePath();
                gravity = secondaryPort.getWorldLoc(gravitydp);
            }
            if ((offset = this.findValidLocation(net, fromPortWorldLoc, this.mMinDist, this.mMaxDist, gravity)) == null) continue;
            String name = baseName + ++success;
            PinTemplate dtp = PinTemplate.create((Net)primaryPort.getNet(), (String)name);
            dtp.setPadTemplate(this.mPadTemplate);
            PinInstance newDP = PinInstance.create((Db)this.mDb, (String)name, (Device)this.mParent.getLast(), (PinTemplate)dtp);
            APoint2D fromPortLocalLoc = new APoint2D(primaryPort.getLoc());
            APoint2D toPortLocalLoc = new APoint2D(fromPortLocalLoc.add(offset));
            dtp.setLoc(toPortLocalLoc);
            if (offset.getX() != 0L || offset.getY() != 0L) {
                APath path = new APath(this.mCircle.getR() * 2L, new APoint2D[]{fromPortLocalLoc, toPortLocalLoc});
                Wire w = Wire.create((Net)primaryPort.getNet(), (Layer)this.mRouteLayer, (APath)path);
                w.setPinA(StoredPath.get((DeviceTemplate)dtp.getDeviceTemplate()), dtp);
                w.setPinB(StoredPath.get((DeviceTemplate)primaryPort.getPinTemplate().getDeviceTemplate()), primaryPort.getPinTemplate());
            }
            HierPin ballDpp = new HierPin(this.mParent, primaryPort);
            HierPin viaDpp = new HierPin(this.mParent, newDP);
            this.addPathBetweenBallAndVia(ballDpp, viaDpp);
            this.addThisPortToObstacles(viaDpp, this.mObstacleLayer);
            if (p == null) continue;
            newDP.assignToPersonality(p);
        }
        SingleLayerRouter.updateProgress(true, 100.0, success + " of " + total + " vias created");
    }

    protected boolean canIPlaceHere(Net net, APoint2D start, ACircle c) {
        ARect bb = this.mParent.getBB();
        APoint2D pt = c.getC();
        if (pt.getX() - bb.left() < this.mClr + c.getR()) {
            return false;
        }
        if (bb.right() - pt.getX() < this.mClr + c.getR()) {
            return false;
        }
        if (pt.getY() - bb.bottom() < this.mClr + c.getR()) {
            return false;
        }
        if (bb.top() - pt.getY() < this.mClr + c.getR()) {
            return false;
        }
        for (AGeom candidate : this.mBinner.intersects(c.getBounds())) {
            Long d;
            ALine l;
            if (!net.isUnused() && this.mGeomToNet.get(candidate).getName().equals(net.getName())) continue;
            if (candidate instanceof ACircle) {
                ACircle otherC = (ACircle)candidate;
                l = new ALine(c.getC(), otherC.getC());
                d = l.getLength();
                d = d - c.getR();
                if ((d = Long.valueOf(d - otherC.getR())) >= this.mClr) continue;
                return false;
            }
            if (candidate instanceof ARect) {
                ARect otherR = (ARect)candidate;
                l = new ALine(c.getC(), otherR.center());
                d = l.getLength();
                d = d - c.getR();
                if ((d = Long.valueOf(d - Math.min(otherR.width() / 2L, otherR.height() / 2L))) >= this.mClr) continue;
                return false;
            }
            if (candidate instanceof APolygon) {
                APolygon otherP = (APolygon)candidate;
                l = AGeomUtil.minSpan((APoint2D)c.getC(), (APolygon)otherP);
                if (l == null) {
                    return false;
                }
                d = l.getLength();
                if ((d = Long.valueOf(d - c.getR())) >= this.mClr) continue;
                return false;
            }
            if (!AclInfo.getDebugMode()) continue;
            ALog.logDebug((Throwable)new UnsupportedOperationException(), (String)"Unsupport operation: '%s'", (Object[])new Object[]{candidate.getName()});
        }
        return true;
    }

    protected APoint2D findValidLocation(Net net, APoint2D start, long minDist, long maxDist, APoint2D gravity) {
        int alphaSteps = this.mOrthoOnly ? 4 : 8;
        int rSteps = 10;
        ArrayList<APoint2D> candidateLoc = new ArrayList<APoint2D>();
        APoint2D center = this.mParent.getBB().center();
        long dist = this.mMinDist;
        long deltaDist = (this.mMaxDist - this.mMinDist) / (long)rSteps;
        for (int i = 0; i < rSteps; ++i) {
            for (int r = 0; r < alphaSteps; ++r) {
                double alpha = 360.0 / (double)alphaSteps * (double)r;
                long y = (long)((double)dist * Math.sin(Math.toRadians(alpha)));
                long x = (long)((double)dist * Math.cos(Math.toRadians(alpha)));
                APoint2D ds = new APoint2D(x, y);
                APoint2D loc = new APoint2D(start.add(ds));
                candidateLoc.add(loc);
                if (i == 0) break;
            }
            if (deltaDist == 0L) break;
            dist += deltaDist;
        }
        if (gravity == null) {
            Collections.sort(candidateLoc, new AgainstTheGrainSorter(center, start));
        } else {
            Collections.sort(candidateLoc, new AgainstTheGrainSorter(gravity, start));
        }
        for (APoint2D loc : candidateLoc) {
            ACircle c = this.mCircle.copy();
            c.moveBy(loc.getX(), loc.getY());
            boolean status = this.canIPlaceHere(net, start, c);
            if (!status) continue;
            return loc.sub(start);
        }
        return null;
    }

    @Deprecated
    public static void doBumpPadsForFC(String substrateName, String personalityName) {
        Db db = OrbitIO.getCurDb();
        Substrate s = Substrate.getSubstrate((Db)db, (String)substrateName);
        if (s == null) {
            return;
        }
        Personality p = Personality.getPersonality((Substrate)s, (Personality.Type)Personality.Type.FC, (String)personalityName);
        if (p == null) {
            return;
        }
        FanOutFactory.doBumpPadsForFC(s, p);
    }

    public static void doBumpPadsForFC(Substrate s, Personality p) {
        Db db = s.getDb();
        long searchRad = Design.micronToInternal((Db)db, (double)1000.0);
        String viaRouteLayerName = null;
        String bumpLayerName = null;
        String bumpContactLayerName = null;
        Constraint c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BUMP_VIA_DIAMETER);
        if (c == null) {
            return;
        }
        long size = (Long)c.getValue();
        c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BUMP_VIA_MIN_DISTANCE_FROM_BUMP);
        if (c == null) {
            return;
        }
        long minDist = (Long)c.getValue();
        c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BUMP_VIA_CLEAR);
        if (c == null) {
            return;
        }
        long clr = (Long)c.getValue();
        Constraint l = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BUMP_CONTACT_LAYER);
        if (l != null) {
            bumpContactLayerName = ((Layer)l.getValue()).getName();
        }
        if ((l = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_LAYER)) != null) {
            viaRouteLayerName = ((Layer)l.getValue()).getName();
        }
        Layer viaRouteLayer = s.getLayer(viaRouteLayerName);
        Layer bumpLayer = s.getLayer(bumpLayerName);
        Layer bumpContactLayer = s.getLayer(bumpContactLayerName);
        FanOutFactory fof = new FanOutFactory();
        ArrayList<DevicePathPortPair> dpList = new ArrayList<DevicePathPortPair>();
        DevicePath parentPath = s.getADevicePathUsing();
        for (PinInstance bump : PinInstance.getRoutePins((Personality)p)) {
            DevicePath bumpPath = bump.getDevice().getADevicePath();
            Substrate dieSub = bumpPath.getSubstrate();
            Layer topLayer = dieSub.getBottomLayer();
            PinInstance contact = null;
            if (contact == null) continue;
            dpList.add(new DevicePathPortPair(new HierPin(bumpPath, contact), null));
        }
        if (bumpContactLayer.equals(viaRouteLayer)) {
            return;
        }
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)s, (String)"viaToBump");
        ACircle cPad = new ACircle(0L, 0L, size / 2L);
        LayerShape.create((Db)db, (Layer)bumpContactLayer, (DbObject)pt, (AGeom)cPad);
        LayerShape.create((Db)db, (Layer)viaRouteLayer, (DbObject)pt, (AGeom)cPad);
        Collections.sort(dpList, new BallPadSort(parentPath));
        fof.setRouteLayer(bumpContactLayer);
        fof.setMaxSearchRad(searchRad);
        fof.setMinDist(minDist);
        fof.loadCandidates(dpList);
        fof.setPadTemplate(pt);
        fof.setParent(parentPath);
        fof.setClr(clr);
        fof.go("viaToBump");
    }

    public static void doDevTemplatesBumpPadsForFC(String devTempKeyStr, String personalityName) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        if (devTemp == null) {
            return;
        }
        Optional p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.FC, (String)personalityName);
        if (p.isPresent()) {
            FanOutFactory.doBumpPadsForFC(devTemp.getSubstrate(), (Personality)p.get());
        }
    }

    public static void doBallPadsForFC(Substrate s, Personality p) {
        Db db = s.getDb();
        long searchRad = Design.micronToInternal((Db)db, (double)1000.0);
        String viaTopLayerString = null;
        String ballLayerString = null;
        Constraint c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.VIA_DIAMETER);
        if (c == null) {
            return;
        }
        long size = (Long)c.getValue();
        c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.VIA_MIN_DISTANCE_FROM_BALL);
        if (c == null) {
            return;
        }
        long minDist = (Long)c.getValue();
        c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.VIA_MAX_DISTANCE_FROM_BALL);
        if (c != null) {
            searchRad = (Long)c.getValue();
        }
        if ((c = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.VIA_CLEAR)) == null) {
            return;
        }
        long clr = (Long)c.getValue();
        Constraint l = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.ROUTE_LAYER);
        if (l != null) {
            viaTopLayerString = ((Layer)l.getValue()).getName();
        }
        if ((l = Constraint.getConstraint((Db)db, (DbObject)p, (Constraint.Descriptor)Constraint.BALL_LAYER)) != null) {
            ballLayerString = ((Layer)l.getValue()).getName();
        }
        Layer viaTopLayer = s.getLayer(viaTopLayerString);
        Layer ballLayer = s.getLayer(ballLayerString);
        FanOutFactory fof = new FanOutFactory();
        ArrayList<DevicePathPortPair> dpList = new ArrayList<DevicePathPortPair>();
        DevicePath parentPath = s.getADevicePathUsing();
        for (PinInstance bump : PinInstance.getRoutePins((Personality)p)) {
            DevicePath bumpPath = bump.getDevice().getADevicePath();
            for (PinInstance candidate : NetMap.getConnectedPorts((Net)bump.getNet(), (DevicePath)bumpPath)) {
                PinTemplate dtp = candidate.getPinTemplate();
                if (dtp.getDeviceTemplate() != parentPath.getDeviceTemplate() || dtp.getType() != PinTemplate.Type.BALLPAD) continue;
                dpList.add(new DevicePathPortPair(new HierPin(bumpPath, candidate), new HierPin(bumpPath, bump)));
            }
        }
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)s, (String)"via");
        ACircle cPad = new ACircle(0L, 0L, size / 2L);
        LayerShape.create((Db)db, (Layer)ballLayer, (DbObject)pt, (AGeom)cPad);
        LayerShape.create((Db)db, (Layer)viaTopLayer, (DbObject)pt, (AGeom)cPad);
        Collections.sort(dpList, new BallPadSort(parentPath));
        fof.setRouteLayer(ballLayer);
        fof.setMaxSearchRad(searchRad);
        fof.setMinDist(minDist);
        fof.loadCandidates(dpList);
        fof.setPadTemplate(pt);
        fof.setParent(parentPath);
        fof.setClr(clr);
        fof.go("viaToBall");
    }

    @Deprecated
    public static void doBallPadsForFC(String substrateName, String personalityName) {
        Db db = OrbitIO.getCurDb();
        Substrate s = Substrate.getSubstrate((Db)db, (String)substrateName);
        if (s == null) {
            return;
        }
        Personality p = Personality.getPersonality((Substrate)s, (Personality.Type)Personality.Type.FC, (String)personalityName);
        if (p == null) {
            return;
        }
        FanOutFactory.doBallPadsForFC(s, p);
    }

    public static void doDevTemplatesBallPadsForFC(String devTempKeyStr, String personalityName) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        if (devTemp == null) {
            return;
        }
        Optional p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.FC, (String)personalityName);
        if (p.isPresent()) {
            FanOutFactory.doBallPadsForFC(devTemp.getSubstrate(), (Personality)p.get());
        }
    }

    public static void doBallPadsForFCOfNet(String substrateName, String personalityName, String netName) {
        Db db = OrbitIO.getCurDb();
        Substrate s = Substrate.getSubstrate((Db)db, (String)substrateName);
        long searchRad = Design.micronToInternal((Db)db, (double)1000.0);
        String viaTopLayerString = null;
        String ballLayerString = null;
        if (s == null) {
            return;
        }
        for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
            Constraint c;
            Optional p = Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.FC, (String)personalityName);
            if (!p.isPresent() || (c = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.VIA_DIAMETER)) == null) continue;
            long size = (Long)c.getValue();
            c = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.VIA_MIN_DISTANCE_FROM_BALL);
            if (c == null) continue;
            long minDist = (Long)c.getValue();
            c = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.VIA_MAX_DISTANCE_FROM_BALL);
            if (c != null) {
                searchRad = (Long)c.getValue();
            }
            if ((c = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.VIA_CLEAR)) == null) continue;
            long clr = (Long)c.getValue();
            Constraint l = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.ROUTE_LAYER);
            if (l != null) {
                viaTopLayerString = ((Layer)l.getValue()).getName();
            }
            if ((l = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.BALL_LAYER)) != null) {
                ballLayerString = ((Layer)l.getValue()).getName();
            }
            Layer viaTopLayer = s.getLayer(viaTopLayerString);
            Layer ballLayer = s.getLayer(ballLayerString);
            FanOutFactory fof = new FanOutFactory();
            ArrayList<DevicePathPortPair> dpList = new ArrayList<DevicePathPortPair>();
            boolean determinedParent = false;
            DevicePath parentPath = s.getADevicePathUsing();
            Net n = null;
            DeviceTemplate dt = parentPath.getDeviceTemplate();
            n = netName.equals("NetUnused") ? dt.getNetUnused() : dt.getNet(netName);
            if (n == null) continue;
            for (PinInstance dp : parentPath.getLast().getPinsForNet(n)) {
                PinTemplate dtp = dp.getPinTemplate();
                if (dtp.getType() != PinTemplate.Type.BALLPAD) continue;
                dpList.add(new DevicePathPortPair(new HierPin(parentPath, dp), null));
            }
            PadTemplate pt = PadTemplate.create((Db)db, (Substrate)s, (String)"via");
            ACircle cPad = new ACircle(0L, 0L, size / 2L);
            LayerShape.create((Db)db, (Layer)ballLayer, (DbObject)pt, (AGeom)cPad);
            LayerShape.create((Db)db, (Layer)viaTopLayer, (DbObject)pt, (AGeom)cPad);
            Collections.sort(dpList, new BallPadSort(parentPath));
            fof.setRouteLayer(ballLayer);
            fof.setMaxSearchRad(searchRad);
            fof.setMinDist(minDist);
            fof.loadCandidates(dpList);
            fof.setPadTemplate(pt);
            fof.setParent(parentPath);
            fof.setClr(clr);
            fof.go("viaToBall");
        }
    }

    public static void doDevTemplatesBallPadsForWB(String devTempKeyStr, String personalityName) {
        Optional p;
        Db db = OrbitIO.getCurDb();
        DeviceTemplate devTemp = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        long size = Design.micronToInternal((Db)db, (double)100.0);
        long searchRad = Design.micronToInternal((Db)db, (double)1000.0);
        long minDist = 0L;
        long clr = Design.micronToInternal((Db)db, (double)50.0);
        String viaTopLayer = null;
        String ballLayer = null;
        if (devTemp != null && (p = Personality.getPersonalities((DeviceTemplate)devTemp, (String)personalityName).findFirst()).isPresent()) {
            Constraint l;
            Constraint c = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.VIA_DIAMETER);
            if (c != null) {
                size = (Long)c.getValue();
            }
            if ((c = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.VIA_MIN_DISTANCE_FROM_BALL)) != null) {
                minDist = (Long)c.getValue();
            }
            if ((c = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.VIA_CLEAR)) != null) {
                clr = (Long)c.getValue();
            }
            if ((l = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.BONDFINGER_LAYER)) != null) {
                viaTopLayer = ((Layer)l.getValue()).getName();
            } else {
                l = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.ROUTE_LAYER);
                if (l != null) {
                    viaTopLayer = ((Layer)l.getValue()).getName();
                }
            }
            l = Constraint.getConstraint((Db)db, (DbObject)((DbObject)p.get()), (Constraint.Descriptor)Constraint.BALL_LAYER);
            if (l != null) {
                ballLayer = ((Layer)l.getValue()).getName();
            }
        }
        FanOutFactory.doBallPads(devTemp.getSubstrate(), viaTopLayer, ballLayer, size, minDist, searchRad, clr, false);
    }

    public static void doBallPads(Substrate s, String viaTopLayer, String routeLayer, long size, long minDist, long searchRad, long clr, boolean orthoOnly) {
        Layer l = s.getLayer(viaTopLayer);
        ArrayList<Layer> singleAvoidLayer = new ArrayList<Layer>();
        singleAvoidLayer.add(l);
        FanOutFactory.doBallPads(singleAvoidLayer, s.getLayer(routeLayer), l, size, minDist, searchRad, clr, orthoOnly);
    }

    public static void doBallPads(ArrayList<Layer> avoidLayerList, Layer fromLayer, Layer toLayer, long size, long minDist, long searchRad, long clr, boolean orthoOnly) {
        FanOutFactory fof = new FanOutFactory();
        Db db = OrbitIO.getCurDb();
        ArrayList<DevicePathPortPair> dpList = new ArrayList<DevicePathPortPair>();
        boolean determinedParent = false;
        Substrate s = fromLayer.getSubstrate();
        DevicePath parentPath = s.getADevicePathUsing();
        for (PinInstance dp : parentPath.getLast().getPins()) {
            PinTemplate dtp = dp.getPinTemplate();
            if (dtp.getType() != PinTemplate.Type.BALLPAD) continue;
            dpList.add(new DevicePathPortPair(new HierPin(parentPath, dp), null));
        }
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)s, (String)"via");
        ACircle cPad = new ACircle(0L, 0L, size / 2L);
        LayerShape.create((Db)db, (Layer)toLayer, (DbObject)pt, (AGeom)cPad);
        Collections.sort(dpList, new BallPadSort(parentPath));
        fof.setRouteLayer(fromLayer);
        fof.setMaxSearchRad(searchRad);
        fof.setMinDist(minDist);
        fof.loadCandidates(dpList);
        fof.setPadTemplate(pt);
        fof.setParent(parentPath);
        fof.setClr(clr);
        fof.setAvoidList(avoidLayerList);
        fof.setOrthoOnly(orthoOnly);
        fof.go("viaToBall");
    }

    public static class BallPadSort
    implements Comparator<DevicePathPortPair> {
        final DevicePath mPackagePath;
        final APoint2D mCenter;

        public BallPadSort(DevicePath path) {
            this.mPackagePath = path;
            this.mCenter = this.mPackagePath.getBB().center();
        }

        @Override
        public int compare(DevicePathPortPair o1, DevicePathPortPair o2) {
            APoint2D p1 = o1.getDPPA().getPin().getWorldLoc(this.mPackagePath);
            APoint2D p2 = o2.getDPPA().getPin().getWorldLoc(this.mPackagePath);
            long d1 = p1.distance(this.mCenter);
            long d2 = p2.distance(this.mCenter);
            return Long.compare(d1, d2);
        }
    }

    public static class ShadowSorter
    implements Comparator<APoint2D> {
        APoint2D start;
        APoint2D gravity;
        boolean useX;

        public ShadowSorter(APoint2D gravity, APoint2D start) {
            this.gravity = gravity;
            this.start = start;
            this.useX = Math.abs(start.xDistance(gravity)) < Math.abs(start.yDistance(gravity));
        }

        @Override
        public int compare(APoint2D o1, APoint2D o2) {
            long dx1 = Math.abs(this.gravity.xDistance(o1));
            long dx2 = Math.abs(this.gravity.xDistance(o2));
            long dy1 = Math.abs(this.gravity.yDistance(o1));
            long dy2 = Math.abs(this.gravity.yDistance(o2));
            if (this.useX) {
                if (dx1 < dx2) {
                    return -1;
                }
                if (dx2 < dx1) {
                    return 1;
                }
                if (dy1 < dy2) {
                    return -1;
                }
                if (dy2 < dy1) {
                    return 1;
                }
                return 0;
            }
            if (dy1 < dy2) {
                return -1;
            }
            if (dy2 < dy1) {
                return 1;
            }
            if (dx1 < dx2) {
                return -1;
            }
            if (dx2 < dx1) {
                return 1;
            }
            return 0;
        }
    }

    public static class AgainstTheGrainSorter
    implements Comparator<APoint2D> {
        APoint2D c;
        APoint2D p0;

        public AgainstTheGrainSorter(APoint2D c, APoint2D p0) {
            this.c = c;
            this.p0 = p0;
        }

        @Override
        public int compare(APoint2D o1, APoint2D o2) {
            double c2;
            long l2;
            long v1 = this.p0.distance(o1);
            long v2 = this.p0.distance(o2);
            long l1 = v1 + this.c.distance(o1) / 2L;
            if (l1 < (l2 = v2 + this.c.distance(o2) / 2L)) {
                return -1;
            }
            if (l2 < l1) {
                return 1;
            }
            double c1 = AGeomUtil.againstTheGrainCost((APoint2D)this.c, (APoint2D)this.p0, (APoint2D)o1);
            if (c1 < (c2 = AGeomUtil.againstTheGrainCost((APoint2D)this.c, (APoint2D)this.p0, (APoint2D)o2))) {
                return -1;
            }
            if (c2 < c1) {
                return 1;
            }
            return 0;
        }
    }
}

