/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.optimizer.genetic.GeneticFinishingFunction;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizerBroker;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.connOpt.GeneticConnectionOptimizer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class GenericConnectionOptimizer
implements GeneticFinishingFunction {
    private List<DevicePath> mDPs;
    private boolean mGreedy;
    private boolean mByTime;
    private long mStoppingNumber;
    private int mMaxPopulation;
    private GeneticConnectionOptimizer mGCO;
    private Integer mS = 0;
    protected List<PersName2DPPList> mMap = new ArrayList<PersName2DPPList>();

    public static void opt2(String diePath, String packagePath, boolean greedy, long seconds, int maxPop) {
        GenericConnectionOptimizer gco = new GenericConnectionOptimizer();
        if (greedy) {
            gco.setup2(diePath, packagePath, true, true, 0L, 0);
            gco.optimize();
        } else {
            gco = new GenericConnectionOptimizer();
            gco.setup2(diePath, packagePath, false, true, seconds, maxPop);
            gco.optimize();
            GenericConnectionOptimizer.updateConnections(gco);
            UserCommands.createConnections();
        }
    }

    public void setup2(String fromS, String toS, boolean greedy, boolean byTime, long stoppingNumber, int maxPopulation) {
        if (!this.init(fromS, toS)) {
            return;
        }
        this.mGreedy = greedy;
        this.mByTime = byTime;
        this.mStoppingNumber = stoppingNumber;
        this.mMaxPopulation = maxPopulation;
    }

    public List<String> commonPersonalities() {
        ArrayList<String> personalities = new ArrayList<String>();
        ArrayList<String> fromP = this.getPersonalitiesOfDevicePath(this.mDPs.get(0));
        for (String fp : fromP) {
            if (!this.devicePathHasPersonality(this.mDPs.get(1), fp)) continue;
            personalities.add(fp);
        }
        Collections.sort(personalities);
        this.commonColorizor(personalities);
        return personalities;
    }

    protected void commonColorizor(ArrayList<String> common) {
        AColor.resetColor();
        for (String pName : common) {
            DeviceTemplate t0 = this.mDPs.get(0).getDeviceTemplate();
            Optional p0 = Personality.getPersonality((DeviceTemplate)t0, (Personality.Type)Personality.Type.PORT, (String)pName);
            DeviceTemplate t1 = this.mDPs.get(1).getDeviceTemplate();
            Optional p1 = Personality.getPersonality((DeviceTemplate)t1, (Personality.Type)Personality.Type.PORT, (String)pName);
            Color c = AColor.nextColor();
            if (p0.isPresent()) {
                ((Personality)p0.get()).setColor(c);
            }
            if (!p1.isPresent()) continue;
            ((Personality)p1.get()).setColor(c);
        }
    }

    public Color getCommonColor(String pName) {
        DeviceTemplate t0 = this.mDPs.get(0).getDeviceTemplate();
        Optional p0 = Personality.getPersonality((DeviceTemplate)t0, (Personality.Type)Personality.Type.PORT, (String)pName);
        return p0.isPresent() ? ((Personality)p0.get()).getColor() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void optimize() {
        List<String> common = this.commonPersonalities();
        this.optimize(common);
        if (!this.mGreedy) {
            try {
                Integer n = this.mS;
                synchronized (n) {
                    this.mS.wait();
                }
            }
            catch (InterruptedException e) {
                ALog.logError((Throwable)e);
            }
        }
    }

    protected void removeFixedNets(List<String> personalities) {
        for (String s : personalities) {
            ArrayList<HierPin> fromDPP = this.getDPPOf(this.mDPs.get(0), s);
            ArrayList<HierPin> toDPP = this.getDPPOf(this.mDPs.get(1), s);
            ArrayList<HierPin> toBeRemovedA = new ArrayList<HierPin>();
            ArrayList<HierPin> toBeRemovedB = new ArrayList<HierPin>();
            for (HierPin packagedpp : toDPP) {
                if (!packagedpp.getPin().fixed()) continue;
                Net nTop = packagedpp.getTopMostNet();
                toBeRemovedB.add(packagedpp);
                for (HierPin dppdie : fromDPP) {
                    if (dppdie.getTopMostNet() != nTop) continue;
                    toBeRemovedA.add(dppdie);
                }
            }
            for (HierPin dpp : toBeRemovedA) {
                this.removeDPP(this.mDPs.get(0), s, dpp);
            }
            for (HierPin dpp : toBeRemovedB) {
                this.removeDPP(this.mDPs.get(1), s, dpp);
            }
        }
    }

    protected void clearToNets() {
    }

    public Double optimize(List<String> personalities) {
        if (personalities.isEmpty()) {
            ALog.logWarn((String)"There are no defined pin personalities in common.");
            return null;
        }
        this.removeFixedNets(personalities);
        if (this.mGreedy) {
            ArrayList<HierPin> from = new ArrayList<HierPin>();
            ArrayList<HierPin> to = new ArrayList<HierPin>();
            for (String s : personalities) {
                to.clear();
                from.clear();
                ArrayList<HierPin> fromDPP = this.getDPPOf(this.mDPs.get(0), s);
                ArrayList<HierPin> toDPP = this.getDPPOf(this.mDPs.get(1), s);
                for (HierPin hierPin : fromDPP) {
                    from.add(hierPin);
                }
                for (HierPin hierPin : toDPP) {
                    to.add(hierPin);
                }
                Net unused = this.mDPs.get(1).getDeviceTemplate().getNetUnused();
                for (HierPin dpp3 : to) {
                    dpp3.getPin().setNet(unused);
                }
                PortPairOpt portPairOpt = new PortPairOpt();
                Collections.sort(from);
                Collections.sort(to);
                portPairOpt.setAPorts(from);
                portPairOpt.setBPorts(to);
                portPairOpt.setFilter(false);
                portPairOpt.assign();
            }
            return null;
        }
        GeneticConnectionOptimizer.theGCO = this.mGCO = new GeneticConnectionOptimizer();
        ArrayList<HierPin> from = new ArrayList<HierPin>();
        ArrayList<HierPin> to = new ArrayList<HierPin>();
        for (String s : personalities) {
            ArrayList<HierPin> thisFrom = this.getDPPOf(this.mDPs.get(0), s);
            ArrayList<HierPin> thisTo = this.getDPPOf(this.mDPs.get(1), s);
            from.addAll(thisFrom);
            to.addAll(thisTo);
        }
        this.mGCO.setASet(from);
        this.mGCO.setBSet(to);
        Double score = this.mGCO.scoreCurrent();
        Net unused = this.mDPs.get(1).getDeviceTemplate().getNetUnused();
        for (HierPin dpp : to) {
            dpp.getPin().setNet(unused);
        }
        this.mGCO.startScore = score;
        GeneticOptimizerBroker.addFinishingFunction(OrbitIO.getCurDb().toString(), this);
        this.mGCO.optimizeGenetically(this.mByTime, this.mStoppingNumber, this.mMaxPopulation);
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGeneticOptimizationFinished() {
        Integer n = this.mS;
        synchronized (n) {
            this.mS.notify();
        }
    }

    protected static void updateConnections(GenericConnectionOptimizer co) {
        Double score;
        ArrayList<APair<HierPin, HierPin>> created = co.mGCO.getConnected();
        NameGenerator ng = new NameGenerator("NewNet");
        for (APair<HierPin, HierPin> pair : created) {
            DevicePath stopPathA = ((HierPin)pair.first).getPath().pathToParent(new DevicePath(co.mDPs.get(0).getFirst()));
            String netName = null;
            if (((HierPin)pair.first).getNet().isUnused()) {
                netName = Net.findAUniqueNetName((NameGenerator)ng);
                NetMap.mapThroughPath((DevicePath)stopPathA, (PinTemplate)((HierPin)pair.first).getPinTemplate(), (String)netName);
            } else {
                NetMap.mapThroughPath((DevicePath)stopPathA, (Net)((HierPin)pair.first).getNet());
                netName = NetMap.getTopmostNet((Net)((HierPin)pair.first).getNet(), (DevicePath)stopPathA).getName();
            }
            DevicePath stopPathB = ((HierPin)pair.second).getPath().pathToParent(co.mDPs.get(1));
            NetMap.mapThroughPath((DevicePath)stopPathB, (PinTemplate)((HierPin)pair.second).getPinTemplate(), (String)netName);
        }
        OrbitIO.getApp().refreshCurrentView(false);
        GeneticConnectionOptimizer.theGCO.endScore = score = GeneticConnectionOptimizer.theGCO.scoreCurrent();
    }

    public boolean init(String dp1, String dp2) {
        Db db = OrbitIO.getCurDb();
        DevicePath thisdp1 = DevicePath.fromString((Db)db, (String)dp1);
        DevicePath thisdp2 = DevicePath.fromString((Db)db, (String)dp2);
        if (thisdp1 == null) {
            ALog.logWarn((String)(dp1 + " is not a device"));
            return false;
        }
        if (thisdp2 == null) {
            ALog.logWarn((String)(dp2 + " is not a device"));
            return false;
        }
        ArrayList<DevicePath> dps = new ArrayList<DevicePath>();
        dps.add(thisdp1);
        dps.add(thisdp2);
        this.init(dps);
        return true;
    }

    public void init(List<DevicePath> dps) {
        this.mDPs = dps;
        this.createEquivPersonalities();
    }

    protected void createEquivPersonalities() {
        for (DevicePath dp : this.mDPs) {
            for (DevicePath dpChild : dp.getDescendants()) {
                for (PinInstance dport : dpChild.getLast().getPins()) {
                    HierPin dpp = new HierPin(dpChild, dport);
                    PersonalityMap.getPersonalities((Personality.Type)Personality.Type.PORT, (DbObject)dport, (DevicePath)dpChild).forEach(persMap -> this.addPort(persMap.getPersonality().getName(), dpp));
                }
            }
        }
    }

    protected void addPort(String pName, HierPin dpp) {
        DevicePath substratePathofIncoming = dpp.getPath().pathToSubstrate();
        PersName2DPPList pBlock = null;
        for (PersName2DPPList p : this.mMap) {
            if (!p.persName.equals(pName)) continue;
            pBlock = p;
            break;
        }
        if (pBlock == null) {
            pBlock = new PersName2DPPList();
            pBlock.persName = pName;
            this.mMap.add(pBlock);
        }
        DevicePath2PortList dpBlock = null;
        for (DevicePath2PortList dPath : pBlock.dpList) {
            if (!dPath.dp.sameAs(substratePathofIncoming)) continue;
            dpBlock = dPath;
            break;
        }
        if (dpBlock == null) {
            dpBlock = new DevicePath2PortList();
            dpBlock.dp = substratePathofIncoming;
            pBlock.dpList.add(dpBlock);
        }
        if (!dpBlock.portList.contains(dpp)) {
            dpBlock.portList.add(dpp);
        }
    }

    protected ArrayList<String> getPersonalitiesOfDevicePath(DevicePath dp) {
        ArrayList<String> ret = new ArrayList<String>();
        for (PersName2DPPList p : this.mMap) {
            for (DevicePath2PortList dPath : p.dpList) {
                if (!dPath.dp.sameAs(dp) || ret.contains(p.persName)) continue;
                ret.add(p.persName);
            }
        }
        return ret;
    }

    protected boolean devicePathHasPersonality(DevicePath dp, String pName) {
        for (PersName2DPPList p : this.mMap) {
            if (!p.persName.equals(pName)) continue;
            for (DevicePath2PortList dPath : p.dpList) {
                if (!dPath.dp.sameAs(dp)) continue;
                return true;
            }
        }
        return false;
    }

    protected void removeDPP(DevicePath dp, String pName, HierPin dpp) {
        for (PersName2DPPList p : this.mMap) {
            if (!p.persName.equals(pName)) continue;
            for (DevicePath2PortList dPath : p.dpList) {
                if (!dPath.dp.sameAs(dp)) continue;
                dPath.portList.remove(dpp);
            }
        }
    }

    protected ArrayList<HierPin> getDPPOf(DevicePath dp, String pName) {
        ArrayList<HierPin> ret = new ArrayList<HierPin>();
        for (PersName2DPPList p : this.mMap) {
            if (!p.persName.equals(pName)) continue;
            for (DevicePath2PortList dPath : p.dpList) {
                if (!dPath.dp.sameAs(dp)) continue;
                return dPath.portList;
            }
        }
        return ret;
    }

    protected static class PersName2DPPList {
        String persName;
        List<DevicePath2PortList> dpList = new ArrayList<DevicePath2PortList>();

        protected PersName2DPPList() {
        }
    }

    protected static class DevicePath2PortList {
        DevicePath dp;
        ArrayList<HierPin> portList = new ArrayList();

        protected DevicePath2PortList() {
        }
    }
}

