/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.PortPair;
import com.sigrity.orbit.automation.PortZoneTable;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NetTable {
    protected static final int IMGWIDTH = 400;
    protected static final int IMGHEIGHT = 400;
    protected static final String IMGNAME = "netmap.png";
    protected ArrayList<Net> nets = new ArrayList();
    protected ArrayList<Net> mToBeConnectedNets = new ArrayList();
    protected ArrayList<Net> mConnectedNets = new ArrayList();
    protected DevicePath parent;
    protected HashMap<Net, OwnerPorts> netToOwnerPorts = new HashMap();
    protected ArrayList<DevicePath> interestingChildren = new ArrayList();
    protected long mID = 0L;
    protected ArrayList<PortPair> mBestConnects = null;
    protected HashMap<Personality, PortZoneTable> mPersonalityPinTable = null;
    protected HashMap<Personality, ArrayList<PinInstance>> mPersonalityPins = null;
    protected HashMap<PinInstance, ARect> mPinSize = null;
    DesignView2D mDv2d = null;
    FileWriter fwriter;
    protected Document mXmlDoc;
    protected Element mRoot;
    protected Element mInterestingChildren;
    protected Element mPersonalities;
    protected boolean collectAllPersonalityPinsAtOnce = false;

    public void setParent(DevicePath parent) {
        this.parent = parent;
    }

    public void addChildOfInterest(DevicePath dp) {
        if (this.interestingChildren.contains(dp)) {
            return;
        }
        this.interestingChildren.add(dp);
        for (DevicePath childPath : dp.getDescendants()) {
            Device p = childPath.getLast();
            for (PinInstance port : p.getPins()) {
                Net portNet = port.getNet();
                Net n = NetMap.getTopmostNet((Net)portNet, (DevicePath)childPath);
                if (n.isUnused()) continue;
                this.addNet(dp, n, new HierPin(childPath, port));
            }
        }
    }

    public void doneWithInterestingChildren() {
        this.addStatic(this.parent);
        this.groupNets();
    }

    protected void removeWireEndPortsOnNetOfDevice(DevicePath path, Net n) {
        PortsOnNetForDevice pon = this.getPortsOnNetForDevice(path, n);
        if (pon == null) {
            return;
        }
        ArrayList<HierPin> toBeRemoved = new ArrayList<HierPin>();
        for (HierPin dpp : pon.dpp) {
            PinInstance p = dpp.getPin();
            if (p.getType() != PinTemplate.Type.WIREEND) continue;
            toBeRemoved.add(dpp);
        }
        for (HierPin rem : toBeRemoved) {
            pon.dpp.remove(rem);
        }
    }

    protected void removeWireEndPorts() {
        for (Net n : this.nets) {
            this.removeWireEndPortsOnNetOfDevice(this.parent, n);
            for (DevicePath child : this.interestingChildren) {
                this.removeWireEndPortsOnNetOfDevice(child, n);
            }
        }
    }

    public boolean generateHTML(String fileName, boolean producePicture) {
        if (fileName == null) {
            return false;
        }
        this.removeWireEndPorts();
        File file = new File(fileName);
        try {
            this.fwriter = new FileWriter(file);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)("Can not open " + fileName + " for reading"), (Object[])new Object[0]);
            return false;
        }
        this.mID = 0L;
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        StringBuilder netDeclare = new StringBuilder();
        try {
            if (producePicture) {
                File out;
                File in = new File(AApp.getInstallDir(), "oem/javascript/excanvas.js");
                if (!AUtil.copy((File)in, (File)(out = new File(file.getParent(), "excanvas.js")))) {
                    ALog.logError((String)"Error copying '%s' to '%s'.", (Object[])new Object[]{in, out});
                }
                String uniqueName = file.getParent() + File.separator + IMGNAME;
                OrbitIO.getApp().snapShotCurrentView(uniqueName, "");
            }
            this.mDv2d = (DesignView2D)OrbitIO.getCurView();
            this.fwriter.write("<html>\n");
            this.emitHTMLPrelude(this.fwriter, producePicture);
            this.fwriter.write("\t<center>\n");
            this.fwriter.write("\t<br>");
            if (producePicture) {
                this.fwriter.write("<img src=\"netmap.png\">");
            }
            this.fwriter.write("\t<table border=\"1\">\n");
            this.fwriter.write("\t\t<tr>\n");
            this.fwriter.write("\t\t<th>\n");
            this.fwriter.write("\t\t\t" + this.parent.getString());
            this.fwriter.write("\t\t</th>\n");
            for (DevicePath child : this.interestingChildren) {
                this.fwriter.write("\t\t<th>\n");
                this.fwriter.write("\t\t\t" + child.getString());
                this.fwriter.write("\t\t</th>\n");
            }
            this.fwriter.write("\t\t<th>\n");
            this.fwriter.write("\t\t\tLength (in " + unit.getUserName() + ")");
            this.fwriter.write("\t\t</th>\n");
            this.fwriter.write("\t\t</tr>\n");
            Collections.sort(this.nets, new NetSorter());
            for (Net n : this.nets) {
                int i;
                this.fwriter.write("\t\t<tr>\n");
                PortsOnNetForDevice ponp = this.getPortsOnNetForDevice(this.parent, n);
                if (ponp == null || ponp.dpp.isEmpty()) {
                    Net nParent = this.getParentNet(n);
                    if (nParent == null) {
                        this.fwriter.write("\t\t<td>\n\t\t\t&nbsp;");
                    } else {
                        this.fwriter.write("\t\t<td><b>" + nParent.getName() + "</b>\n");
                    }
                } else {
                    Net nt = ponp.dpp.get(0).getNet();
                    Net myNet = NetMap.getTopmostNet((Net)nt, (DevicePath)ponp.dpp.get(0).getPath());
                    Color c = this.getBgColor(ponp.dpp);
                    this.fwriter.write("\t\t<td bgcolor=" + AColor.formatColor((Color)c, (boolean)false) + ">\n");
                    this.addHTMLNetInfo(fileName, this.fwriter, myNet, ponp.dpp, producePicture, this.getTitleColor(c));
                    if (producePicture) {
                        if (netDeclare.length() > 0) {
                            netDeclare.append("\t, ");
                        }
                        netDeclare.append(this.getNetDeclare(myNet, ponp.dpp));
                    }
                }
                this.fwriter.write("\t\t</td>\n");
                for (DevicePath child : this.interestingChildren) {
                    PortsOnNetForDevice pon = this.getPortsOnNetForDevice(child, n);
                    if (pon != null) {
                        i = 0;
                        if (i < pon.dpp.size()) {
                            HierPin hierPin = pon.dpp.get(i);
                            Net myNet = NetMap.getTopmostNet((Net)hierPin.getNet(), (DevicePath)hierPin.getPath());
                            Color c = this.getBgColor(pon.dpp);
                            this.fwriter.write("\t\t<td bgcolor=" + AColor.formatColor((Color)c, (boolean)false) + ">\n");
                            this.addHTMLNetInfo(fileName, this.fwriter, myNet, pon.dpp, producePicture, this.getTitleColor(c));
                            if (producePicture) {
                                if (netDeclare.length() > 0) {
                                    netDeclare.append("\t, ");
                                }
                                netDeclare.append(this.getNetDeclare(myNet, pon.dpp));
                            }
                        }
                    } else {
                        this.fwriter.write("\t\t<td>\n");
                        this.fwriter.write("\t\t\t&nbsp;\n");
                    }
                    this.fwriter.write("\t\t</td>\n");
                }
                this.fwriter.write("\t\t<td>\n");
                long length = 0L;
                ArrayList<HierPin> dpList = this.getNetLength(n);
                for (i = 0; dpList != null && i < dpList.size() - 1; ++i) {
                    HierPin dpI = dpList.get(i);
                    HierPin dpJ = dpList.get(i + 1);
                    length += dpI.getWorldLoc().distance(dpJ.getWorldLoc());
                }
                this.fwriter.write("\t\t\t" + unit.toUserStr(length) + " \n");
                this.fwriter.write("\t\t</td>\n");
                this.fwriter.write("\t\t</tr>\n");
            }
            this.fwriter.write("\t</table>\n");
            if (producePicture) {
                this.emitNetDeclare(netDeclare.toString());
            }
            this.fwriter.write("</body></html>\n");
            this.fwriter.close();
        }
        catch (IOException e) {
            ALog.logError((String)"Can not write to %s : %s .", (Object[])new Object[]{fileName, e.getMessage()});
            return false;
        }
        return true;
    }

    public boolean generateCSV(String fileName) {
        if (fileName == null) {
            return false;
        }
        this.removeWireEndPorts();
        File file = new File(fileName);
        try {
            this.fwriter = new FileWriter(file);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)("Can not open " + fileName + " for reading"), (Object[])new Object[0]);
            return false;
        }
        this.mID = 0L;
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        try {
            this.fwriter.write(this.parent.getString() + ",");
            this.mDv2d = (DesignView2D)OrbitIO.getCurView();
            for (DevicePath child : this.interestingChildren) {
                this.fwriter.write(child.getString() + ",");
            }
            this.fwriter.write("Length (in " + unit.getUserName() + ")");
            this.fwriter.write("\n");
            Collections.sort(this.nets, new NetSorter());
            for (Net n : this.nets) {
                int i;
                PortsOnNetForDevice ponp = this.getPortsOnNetForDevice(this.parent, n);
                if (ponp == null || ponp.dpp.isEmpty()) {
                    Net nParent = this.getParentNet(n);
                    if (nParent == null) {
                        this.fwriter.write(" ,");
                    } else {
                        this.fwriter.write(nParent.getName() + ",");
                    }
                } else {
                    Net nt = ponp.dpp.get(0).getNet();
                    Net myNet = NetMap.getTopmostNet((Net)nt, (DevicePath)ponp.dpp.get(0).getPath());
                    this.fwriter.write(myNet.getName() + ",");
                }
                for (DevicePath child : this.interestingChildren) {
                    PortsOnNetForDevice pon = this.getPortsOnNetForDevice(child, n);
                    if (pon != null) {
                        i = 0;
                        if (i < pon.dpp.size()) {
                            HierPin hierPin = pon.dpp.get(i);
                            for (HierPin dpp : pon.dpp) {
                                Net myNet = NetMap.getTopmostNet((Net)hierPin.getNet(), (DevicePath)hierPin.getPath());
                                if (dpp.getPath().getLast().equals(child.getLast())) {
                                    this.fwriter.write(myNet.getName() + "->" + dpp.getPin().getName() + " ");
                                    continue;
                                }
                                this.fwriter.write(myNet.getName() + "->" + dpp.getPath().getLast().toString() + "@" + dpp.getPin().getName() + " ");
                            }
                        }
                        this.fwriter.write(",");
                        continue;
                    }
                    this.fwriter.write(" ,");
                }
                long length = 0L;
                ArrayList<HierPin> dpList = this.getNetLength(n);
                for (i = 0; dpList != null && i < dpList.size() - 1; ++i) {
                    HierPin dpI = dpList.get(i);
                    HierPin dpJ = dpList.get(i + 1);
                    length += dpI.getWorldLoc().distance(dpJ.getWorldLoc());
                }
                String l = unit.toUserStr(length);
                l = l.replace(",", "");
                this.fwriter.write(l + "\n");
            }
            this.fwriter.close();
        }
        catch (IOException e) {
            ALog.logError((String)"Can not write to %s : %s .", (Object[])new Object[]{fileName, e.getMessage()});
            return false;
        }
        return true;
    }

    protected boolean cellHasMultipleLocalNets(ArrayList<HierPin> dpps) {
        Net substrateNet = null;
        for (HierPin dpp : dpps) {
            DevicePath substratePath = dpp.getPath();
            Substrate substrate = substratePath.getSubstrate();
            substratePath = substratePath.pathToParent(substrate);
            substratePath.removeFirst();
            Net n = NetMap.getTopmostNet((Net)dpp.getNet(), (DevicePath)substratePath);
            if (substrateNet == null) {
                substrateNet = n;
                continue;
            }
            if (n == substrateNet) continue;
            return true;
        }
        return false;
    }

    private Color getBgColor(ArrayList<HierPin> dpps) {
        int sum = 0;
        for (HierPin dpp : dpps) {
            Personality p = dpp.getPin().getPersonality();
            if (p == null) continue;
            int c = p.getColor().getRGB();
            if (sum == 0) {
                sum = c;
                continue;
            }
            sum += c;
            sum /= 2;
        }
        if (sum == 0) {
            sum = Color.white.getRGB();
        }
        return new Color(sum);
    }

    private Color getTitleColor(Color bgColor) {
        return new Color(bgColor.getRGB() ^ Color.white.getRGB());
    }

    private String getNetDeclare(Net net, ArrayList<HierPin> dpps) {
        DesignCanvas2D.XForm screenForm = this.mDv2d.getCanvas().getXForm();
        long index = 0L;
        ArrayList<PinInstance> ps = new ArrayList<PinInstance>();
        for (HierPin dpp : dpps) {
            PinInstance p = dpp.getPin();
            ps.add(p);
        }
        StringBuilder s = new StringBuilder();
        Collections.sort(ps, (o1, o2) -> {
            APoint2D pt1 = o1.getWorldLoc(o1.getDevice().getADevicePath());
            APoint2D pt2 = o2.getWorldLoc(o2.getDevice().getADevicePath());
            if (pt1.getY() < pt2.getY() || pt1.getY() == pt2.getY() && pt1.getX() < pt2.getX()) {
                return -1;
            }
            if (pt1.getY() > pt2.getY() || pt1.getY() == pt2.getY() && pt1.getX() > pt2.getX()) {
                return 1;
            }
            return 0;
        });
        for (PinInstance p : ps) {
            APoint2D pt2d = p.getWorldLoc(p.getDevice().getADevicePath());
            Point pt = screenForm.getScreenPt(pt2d);
            if (index > 0L) {
                s.append(String.format(", %d, %d", (int)pt.getX(), (int)pt.getY()));
            } else {
                s.append(String.format("'%s', new Array(", net.getKeyStr()));
                s.append(String.format("%d, %d", (int)pt.getX(), (int)pt.getY()));
            }
            if (++index % 10L != 0L) continue;
            s.append("\n\t\t");
        }
        if (index > 0L) {
            s.append(")\n");
        }
        return s.toString();
    }

    private void emitNetDeclare(String netDeclare) throws IOException {
        this.fwriter.write("<script language='javascript'> var nets = new Hash(\n");
        this.fwriter.write(netDeclare);
        this.fwriter.write("); </script>\n");
    }

    private void emitHTMLPrelude(FileWriter fwriter, boolean producePicture) {
        try {
            Object s = "<head><style type='text/css'>\na.popup\n{\n    position: relative;\n    z-index: 0;\n}\na.popup:hover\n{\n    background-color: transparent;\n    z-index: 50;\n}\na.popup span\n{\n    position: absolute;\n    background-color: lightyellow;\n    padding: 5px;\n    left: -1000px;\n    border: 1px dashed gray;\n    visibility: hidden;\n    color: black;\n    text-decoration: none;\n}\na.popup span img\n{\n    border-width: 0;\n    padding: 2px;\n}\na.popup:hover span\n{\n    visibility: visible;\n    top: 0;\n    left: 60px;\n}\n</style>\n";
            if (producePicture) {
                s = (String)s + "<!--[if IE]><script type='text/javascript' src='excanvas.js'></script><![endif]-->\n<script type='text/javascript'>\nfunction Hash()\n{\n    this.length = 0;\n    this.items = new Array();\n    for (var i = 0; i < arguments.length; i += 2) {\n        if (typeof(arguments[i + 1]) != 'undefined') {\n            this.items[arguments[i]] = arguments[i + 1];\n            this.length++;\n        }\n    }\n    this.remove = function(in_key)\n    {\n        var tmp_value;\n        if (typeof(this.items[in_key]) != 'undefined') {\n            this.length--;\n            var tmp_value = this.items[in_key];\n            delete this.items[in_key];\n        }\n        return tmp_value;\n    }\n    this.get = function(in_key) {\n        return this.items[in_key];\n    }\n    this.set = function(in_key, in_value)\n    {\n        if (typeof(in_value) != 'undefined') {\n            if (typeof(this.items[in_key]) == 'undefined') {\n                this.length++;\n            }\n            this.items[in_key] = in_value;\n        }\n        return in_value;\n    }\n    this.has = function(in_key)\n    {\n        return typeof(this.items[in_key]) != 'undefined';\n    }\n}\nfunction drawNet(id, name)\n{\n    var ctx = document.getElementById(id).getContext('2d');\n    var a = nets.get(name);\n    ctx.strokeStyle = 'red';\n    ctx.lineWidth = 2;\n    var img = new Image();\n    img.src = 'netmap.png';\n" + String.format("    ctx.drawImage(img, 0, 0, %d, %d);\n", 400, 400) + "    if (a.length == 2) {\n" + String.format("        var x1 = %d * a[0] / img.width;\n", 400) + String.format("        var y1 = %d * a[1] / img.height;\n", 400) + "        ctx.beginPath();\n        ctx.arc(x1, y1, 3, 0, Math.PI * 2, true);\n        ctx.stroke();\n    } else if (a.length > 2) {\n        for (var i = 0; a && i < a.length; i += 2) {\n            ctx.beginPath();\n" + String.format("            var x1 = %d * a[i] / img.width;\n", 400) + String.format("            var y1 = %d * a[i + 1] / img.height;\n", 400) + String.format("            var x2 = %d * a[i + 2] / img.width;\n", 400) + String.format("            var y2 = %d * a[i + 3] / img.height;\n", 400) + "            ctx.moveTo(x1, y1);\n            ctx.lineTo(x2, y2);\n            ctx.closePath();\n            ctx.stroke();\n        }\n    }\n}\n</script>";
            }
            s = (String)s + "</head><body>\n";
            fwriter.write((String)s);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)("Can not write to " + fwriter.toString()), (Object[])new Object[0]);
        }
    }

    private void addHTMLNetInfo(String fileName, FileWriter fwriter, Net net, ArrayList<HierPin> dpps, boolean picture, Color titleColor) {
        Object netName = net.getName();
        if (this.cellHasMultipleLocalNets(dpps)) {
            netName = (String)netName + "...";
        }
        try {
            if (!picture) {
                fwriter.write(String.format("\t\t\t<a class='popup' href='#thumb'>\n\t\t\t<b><font color=%s> %s (%d) </b></font>\n", AColor.formatColor((Color)titleColor, (boolean)false), netName, dpps.size()));
                fwriter.write("\t\t\t<span>");
                StringBuilder buffer = new StringBuilder();
                for (HierPin dpp : dpps) {
                    if (buffer.length() > 0) {
                        buffer.append("\n");
                    }
                    buffer.append(" " + dpp.getPath().getLast().getName() + ":" + dpp.getPin().getName());
                }
                fwriter.write(buffer.toString());
                fwriter.write("</span></a>\n");
            } else {
                StringBuilder buffer = new StringBuilder();
                int filteredSize = 0;
                for (HierPin dpp : dpps) {
                    if (buffer.length() > 0) {
                        buffer.append("\n \t\t\t\t\t");
                    }
                    buffer.append(dpp.getPath().getLast().getName() + ":" + dpp.getPin().getName() + "<br>");
                    ++filteredSize;
                }
                String netNameString = (String)netName + " (" + filteredSize + ")";
                String id = String.format("C%d", this.mID++);
                String s = String.format("\t\t\t\t <a class='popup' href='#thumb' onmouseover='drawNet(\"%s\", \"%s\")'>\n\t\t\t\t <b><font color=%s>%s</font></b>\n\t\t\t\t <span><canvas id=%s width=%d height=%d ></canvas>\n\t\t\t\t <br /> %s <br> </span></a>\n", id, net.getKeyStr(), AColor.formatColor((Color)titleColor, (boolean)false), netNameString, id, 400, 400, buffer);
                fwriter.write(s);
            }
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)("Can not write to " + fileName), (Object[])new Object[0]);
        }
    }

    protected Net getParentNet(Net n) {
        OwnerPorts op = this.netToOwnerPorts.get(n);
        if (op == null) {
            return null;
        }
        for (int i = 0; i < op.devicePathToPorts.size(); ++i) {
            PortsOnNetForDevice pond = op.devicePathToPorts.get(i);
            ArrayList<HierPin> dppl = pond.dpp;
            if (dppl.isEmpty()) continue;
            HierPin dpp = dppl.get(0);
            Net parentNet = NetMap.getTopmostNet((Net)dpp.getNet(), (DevicePath)dpp.getPath());
            if (parentNet.getDeviceTemplate() == this.parent.getDeviceTemplate()) {
                return parentNet;
            }
            return null;
        }
        return null;
    }

    protected PortsOnNetForDevice getPortsOnNetForDevice(DevicePath dp, Net n) {
        OwnerPorts op = this.netToOwnerPorts.get(n);
        if (op == null) {
            return null;
        }
        for (int i = 0; i < op.devicePathToPorts.size(); ++i) {
            if (!op.devicePathToPorts.get((int)i).owner.sameAs(dp)) continue;
            return op.devicePathToPorts.get(i);
        }
        return null;
    }

    protected boolean isDynamicDevice(DevicePath candidate) {
        for (DevicePath dp : this.interestingChildren) {
            if (dp.sameAs(candidate)) {
                return true;
            }
            if (!candidate.isChildOf(dp)) continue;
            return true;
        }
        return false;
    }

    protected void addNet(DevicePath owner, Net n, HierPin dpp) {
        int i;
        OwnerPorts op = this.netToOwnerPorts.get(n);
        if (op == null) {
            op = new OwnerPorts();
            this.netToOwnerPorts.put(n, op);
            this.nets.add(n);
        }
        PortsOnNetForDevice ns = null;
        for (i = 0; i < op.devicePathToPorts.size(); ++i) {
            if (!op.devicePathToPorts.get((int)i).owner.sameAs(owner)) continue;
            ns = op.devicePathToPorts.get(i);
            break;
        }
        if (i >= op.devicePathToPorts.size()) {
            ns = new PortsOnNetForDevice();
            ns.owner = owner;
            op.devicePathToPorts.add(ns);
        }
        assert (ns != null);
        ns.dpp.add(dpp);
    }

    public void addStatic(DevicePath dp) {
        for (DevicePath childPath : dp.getDescendants()) {
            if (this.isDynamicDevice(childPath)) continue;
            Device p = childPath.getLast();
            for (PinInstance port : p.getPins()) {
                Net portNet = port.getNet();
                Net n = NetMap.getTopmostNet((Net)portNet, (DevicePath)childPath);
                if (n.isUnused()) continue;
                this.addNet(dp, n, new HierPin(childPath, port));
            }
        }
    }

    private void groupNets() {
        for (Net n : this.nets) {
            PortsOnNetForDevice pon = this.getPortsOnNetForDevice(this.parent, n);
            boolean needToConnect = false;
            if (pon != null) {
                for (int i = 0; i < pon.dpp.size(); ++i) {
                    HierPin dpp = pon.dpp.get(i);
                    if (!this.canBeSwapped(dpp)) continue;
                    this.mToBeConnectedNets.add(n);
                    needToConnect = true;
                    break;
                }
            }
            if (pon == null || !needToConnect) {
                for (DevicePath dp : this.interestingChildren) {
                    PortsOnNetForDevice pocn = this.getPortsOnNetForDevice(dp, n);
                    if (pocn != null) {
                        for (HierPin dpp : pocn.dpp) {
                            if (!this.canBeSwapped(dpp)) continue;
                            this.mToBeConnectedNets.add(n);
                            needToConnect = true;
                            break;
                        }
                    }
                    if (!needToConnect) continue;
                    break;
                }
            }
            if (needToConnect) continue;
            this.mConnectedNets.add(n);
        }
        if (!this.mToBeConnectedNets.isEmpty()) {
            this.mBestConnects = new ArrayList();
            Collections.sort(this.mToBeConnectedNets);
            this.groupPersonalityPins(this.parent);
        }
    }

    public void setSumOfRectForDevice(DevicePath dp) {
        for (Net n : this.nets) {
            PortsOnNetForDevice pon = this.getPortsOnNetForDevice(dp, n);
            if (pon == null) continue;
            pon.currentR = null;
            for (int i = 0; i < pon.dpp.size(); ++i) {
                HierPin dpp = pon.dpp.get(i);
                if (this.canBeSwapped(dpp)) continue;
                APoint2D p = pon.dpp.get(i).getWorldLoc();
                ARect r = new ARect(p, p);
                if (pon.currentR == null) {
                    pon.currentR = r;
                    continue;
                }
                pon.currentR.expand(r);
            }
        }
    }

    public double calcSumOfRectAreasForDeviceList(List<DevicePath> dps) {
        double perimeter = this.calcSumOfRectAreasForConnectedNets(dps);
        if (this.mToBeConnectedNets != null && !this.mToBeConnectedNets.isEmpty()) {
            perimeter += this.getSumOfRectAreasForToBeConnectedNets(dps);
        }
        return perimeter;
    }

    public double calcSumOfRectAreasForConnectedNets(List<DevicePath> dps) {
        double perimeter = 0.0;
        for (Net n : this.mConnectedNets) {
            ARect r = null;
            for (DevicePath dp : dps) {
                PortsOnNetForDevice pon = this.getPortsOnNetForDevice(dp, n);
                if (pon == null || pon.currentR == null) continue;
                if (r == null) {
                    r = new ARect(pon.currentR);
                    continue;
                }
                r.expand(pon.currentR);
            }
            if (r == null) continue;
            perimeter += r.perimeter();
        }
        return perimeter;
    }

    public double getSumOfRectAreasForToBeConnectedNets(List<DevicePath> dps) {
        this.mBestConnects.clear();
        double perimeter = 0.0;
        ArrayList<PinInstance> usedPorts = new ArrayList<PinInstance>();
        for (Net n : this.mToBeConnectedNets) {
            ArrayList<HierPin> swap = new ArrayList<HierPin>();
            ARect r = null;
            for (DevicePath dp : dps) {
                PortsOnNetForDevice pon = this.getPortsOnNetForDevice(dp, n);
                if (pon == null) continue;
                if (pon.currentR != null) {
                    if (r == null) {
                        r = new ARect(pon.currentR);
                    } else {
                        r.expand(pon.currentR);
                    }
                }
                for (HierPin p : pon.dpp) {
                    if (!this.canBeSwapped(p)) continue;
                    swap.add(p);
                }
            }
            ARect bestR = null;
            for (HierPin p : swap) {
                double bestScore = -1.0;
                HierPin bestPort = null;
                HierPin bestFixedPort = null;
                PinInstance swapPort = p.getPin();
                Personality personality = swapPort.getPersonality();
                ArrayList<PinInstance> pps = this.mPersonalityPins.get(personality);
                for (PinInstance port : pps) {
                    if (usedPorts.contains(port)) continue;
                    HierPin dpp = new HierPin(p.getPath(), port);
                    ARect cr = new ARect(r);
                    cr.expand(this.mPinSize.get(port));
                    double score = cr.perimeter();
                    if (bestScore != -1.0 && !(bestScore > score)) continue;
                    bestScore = score;
                    bestPort = dpp;
                }
                if (bestPort == null) continue;
                PinInstance port = bestPort.getPin();
                usedPorts.add(port);
                if (bestR == null) {
                    bestR = new ARect(this.mPinSize.get(port));
                } else {
                    bestR.expand(this.mPinSize.get(port));
                }
                PortPair bestConn = new PortPair(bestPort, bestFixedPort, p);
                this.mBestConnects.add(bestConn);
            }
            if (bestR != null) {
                if (r == null) {
                    r = new ARect(bestR);
                } else {
                    r.expand(bestR);
                }
            }
            if (r == null) continue;
            perimeter += r.perimeter();
        }
        return perimeter;
    }

    public ArrayList<PortPair> getBestNewConnects() {
        return this.mBestConnects == null ? null : new ArrayList<PortPair>(this.mBestConnects);
    }

    private void groupPersonalityPins(DevicePath dp) {
        this.mPersonalityPins = new HashMap();
        this.mPinSize = new HashMap();
        Device device = dp.getLast();
        for (PinInstance port : device.getPins()) {
            Personality personality;
            HierPin dpp = new HierPin(this.parent, port);
            if (!this.canBeSwapped(dpp) || (personality = port.getPersonality()) == null) continue;
            if (!this.collectAllPersonalityPinsAtOnce) {
                ArrayList<Object> ports;
                APoint2D loc = dpp.getWorldLoc();
                this.mPinSize.put(port, new ARect(loc, loc));
                if (this.mPersonalityPins.get(personality) == null) {
                    ports = new ArrayList();
                    this.mPersonalityPins.put(personality, ports);
                } else {
                    ports = this.mPersonalityPins.get(personality);
                }
                ports.add(port);
                continue;
            }
            if (this.mPersonalityPins.get(personality) != null) continue;
            ArrayList ports = new ArrayList();
            personality.getObjects().filter(hi -> ((DevicePath)hi.first).equals((Object)dp)).forEach(hi -> {
                PinInstance p = (PinInstance)hi.second;
                HierPin pdpp = new HierPin(dpp.getPath(), p);
                APoint2D loc = pdpp.getWorldLoc();
                this.mPinSize.put(p, new ARect(loc, loc));
                ports.add(p);
            });
            if (!ports.isEmpty()) {
                Collections.sort(ports);
            }
            this.mPersonalityPins.put(personality, ports);
        }
        if (!this.collectAllPersonalityPinsAtOnce) {
            Set<Personality> ps = this.mPersonalityPins.keySet();
            for (Personality p : ps) {
                ArrayList<PinInstance> ports = this.mPersonalityPins.get(p);
                Collections.sort(ports);
            }
        }
    }

    public ArrayList<HierPin> getNetLength(Net net) {
        ArrayList<HierPin> ports = this.getNetPorts(net);
        if (ports == null) {
            return null;
        }
        if (ports.size() <= 2) {
            return ports;
        }
        APoint2D loc = ports.get(0).getWorldLoc();
        ARect bound = new ARect(loc, loc);
        for (HierPin p : ports) {
            bound.expand(p.getWorldLoc());
        }
        if (bound.width() >= bound.height()) {
            loc.setLoc(bound.left(), bound.centerY());
        } else {
            loc.setLoc(bound.centerX(), bound.top());
        }
        boolean roughOrder = true;
        if (roughOrder) {
            Collections.sort(ports, new DevicePathPortSort(loc));
            return ports;
        }
        ArrayList<HierPin> sortedPorts = new ArrayList<HierPin>();
        int total = ports.size();
        while (sortedPorts.size() != total) {
            Collections.sort(ports, new DevicePathPortSort(loc));
            HierPin lastPort = ports.get(0);
            ports.remove(lastPort);
            sortedPorts.add(lastPort);
            loc = lastPort.getWorldLoc();
        }
        return sortedPorts;
    }

    private ArrayList<HierPin> getNetPorts(Net net) {
        ArrayList<HierPin> ports = new ArrayList<HierPin>();
        Device pDevice = this.parent.getLast();
        for (PinInstance port : pDevice.getPins()) {
            Net portNet = port.getNet();
            Net n = NetMap.getTopmostNet((Net)portNet, (DevicePath)this.parent);
            if (n != net) continue;
            ports.add(new HierPin(this.parent, port));
        }
        for (DevicePath child : this.interestingChildren) {
            PortsOnNetForDevice pon = this.getPortsOnNetForDevice(child, net);
            if (pon == null || pon.dpp == null) continue;
            ports.addAll(pon.dpp);
        }
        return ports.isEmpty() ? null : ports;
    }

    private boolean canBeSwapped(HierPin dpp) {
        PinInstance port = dpp.getPin();
        Personality p = port.getPersonality();
        if (p == null) {
            return false;
        }
        Constraint s = Constraint.getConstraint((Db)p.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.ALLOW_SWAPPING);
        if (s == null) {
            return false;
        }
        return (Boolean)s.getValue();
    }

    protected int numSubstrateNetAttachesTo(Net n) {
        int count = 0;
        PortsOnNetForDevice pon = this.getPortsOnNetForDevice(this.parent, n);
        if (pon != null && pon.dpp.size() > 0) {
            ++count;
        }
        for (DevicePath child : this.interestingChildren) {
            PortsOnNetForDevice ponc = this.getPortsOnNetForDevice(child, n);
            if (ponc == null || ponc.dpp.size() <= 0) continue;
            ++count;
        }
        return count;
    }

    public void test() {
        System.out.println("===================================");
        for (Net n : this.nets) {
            if (!n.getName().contains("VNEG_HPH") && !n.getName().contains("VDDPX_4") && !n.getName().contains("GPIO")) continue;
            ArrayList<HierPin> nl = this.getNetLength(n);
            System.out.print("# net " + n.getName());
            for (HierPin p : nl) {
                System.out.print(" " + p.getPath().toString() + ":" + p.getPin().getName() + "[" + p.getWorldLoc() + "]");
            }
            System.out.println();
        }
    }

    protected void initXml() {
        try {
            this.mDv2d = (DesignView2D)OrbitIO.getCurView();
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            this.mXmlDoc = builder.newDocument();
            this.mRoot = this.mXmlDoc.createElement("NetTable");
            this.mPersonalities = this.mXmlDoc.createElement("Personalities");
            this.mInterestingChildren = this.mXmlDoc.createElement("InterestingChildren");
            this.mRoot.appendChild(this.mPersonalities);
            this.mRoot.appendChild(this.mInterestingChildren);
            this.mXmlDoc.appendChild(this.mRoot);
        }
        catch (Exception e) {
            ALog.logError((String)e.getMessage());
        }
    }

    protected void outputXml(String file) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(file));){
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.transform(new DOMSource(this.mXmlDoc), new StreamResult(fileOutputStream));
        }
        catch (Exception e) {
            ALog.logError((String)e.getMessage());
        }
    }

    protected boolean fixPendingAttribute(Element parent, ElementPath tagPath, ElementHandler handler) {
        if (tagPath.isEmpty()) {
            handler.handleItem(parent);
            return true;
        }
        NodeList l = parent.getElementsByTagName((String)tagPath.get(0));
        ElementPath nextPath = new ElementPath(tagPath);
        nextPath.remove(0);
        for (int j = 0; j < l.getLength(); ++j) {
            Element e = (Element)l.item(j);
            this.fixPendingAttribute(e, nextPath, handler);
        }
        return true;
    }

    protected void fixPendingElement() {
        this.mRoot.setAttribute("parent", this.parent.toString());
        for (DevicePath dp : this.interestingChildren) {
            Element eChild = this.mXmlDoc.createElement("Children");
            eChild.setAttribute("key", dp.toString());
            eChild.setAttribute("name", dp.getLast().getName());
            this.mInterestingChildren.appendChild(eChild);
        }
    }

    protected Element getChildByAttribute(Element parent, String tagName, AttributePair[] attrs) {
        NodeList l = parent.getElementsByTagName(tagName);
        for (int i = 0; i < l.getLength(); ++i) {
            int j;
            Element e = (Element)l.item(i);
            for (j = 0; j < attrs.length && e.getAttribute((String)attrs[j].first).equals(attrs[j].second); ++j) {
            }
            if (j != attrs.length) continue;
            return e;
        }
        return null;
    }

    protected void addNetElement(DevicePath owner, Net n, HierPin dpp) {
        Element eDevice;
        Element eOwner;
        DevicePath dp = dpp.getPath();
        if (this.interestingChildren.contains(owner)) {
            dp = this.getChildDeviceSubstratePath(dp);
        }
        Net captionNet = NetMap.getTopmostNet((Net)dpp.getNet(), (DevicePath)dp);
        AttributePair[] attrs = new AttributePair[]{new AttributePair("key", n.getKeyStr())};
        Element eNet = this.getChildByAttribute(this.mRoot, "Net", attrs);
        if (eNet == null) {
            eNet = this.mXmlDoc.createElement("Net");
            eNet.setAttribute("key", n.getKeyStr());
            eNet.setAttribute("name", n.getName());
            this.mRoot.appendChild(eNet);
        }
        if ((eOwner = this.getChildByAttribute(eNet, "Owner", attrs = new AttributePair[]{new AttributePair("key", owner.toString())})) == null) {
            eOwner = this.mXmlDoc.createElement("Owner");
            eOwner.setAttribute("key", owner.toString());
            eOwner.setAttribute("name", owner.getLast().getName());
            eOwner.setAttribute("caption", captionNet.getName());
            eNet.appendChild(eOwner);
        }
        if ((eDevice = this.getChildByAttribute(eOwner, "Device", attrs = new AttributePair[]{new AttributePair("key", dpp.getPath().toString())})) == null) {
            eDevice = this.mXmlDoc.createElement("Device");
            eDevice.setAttribute("key", dpp.getPath().toString());
            eDevice.setAttribute("name", dpp.getPath().getLast().getName());
            eOwner.appendChild(eDevice);
        }
        DesignCanvas2D.XForm screenForm = this.mDv2d.getCanvas().getXForm();
        Element ePin = this.mXmlDoc.createElement("Pin");
        APoint2D pt2d = dpp.getWorldLoc();
        long sx = screenForm.getScreenX(pt2d.getX());
        long sy = screenForm.getScreenX(pt2d.getY());
        ePin.setAttribute("name", dpp.getPin().getName());
        ePin.setAttribute("x", Long.toString(sx));
        ePin.setAttribute("y", Long.toString(sy));
        eDevice.appendChild(ePin);
        Personality ps = dpp.getPin().getPersonality();
        if (ps != null) {
            Element ePersonality = this.mXmlDoc.createElement("Personality");
            ePersonality.setAttribute("name", ps.getKeyStr());
            ePin.appendChild(ePersonality);
            attrs = new AttributePair[]{new AttributePair("name", ps.getKeyStr())};
            Element ePs = this.getChildByAttribute(this.mPersonalities, "Personality", attrs);
            if (ePs == null) {
                ePs = this.mXmlDoc.createElement("Personality");
                ePs.setAttribute("name", ps.getKeyStr());
                ePs.setAttribute("type", ps.getTypeName());
                ePs.setAttribute("color", AColor.formatColor((Color)ps.getColor(), (boolean)false));
                this.mPersonalities.appendChild(ePs);
            }
        }
    }

    protected DevicePath getChildDeviceSubstratePath(DevicePath childDevicePath) {
        Device d;
        DevicePath trucatedPath = new DevicePath();
        for (int j = childDevicePath.size() - 1; j >= 0 && !NetTable.isSubstrate(d = childDevicePath.get(j)); --j) {
            trucatedPath.addFirst(d);
        }
        return trucatedPath;
    }

    public void testxml(String htmlFile) {
        this.initXml();
        for (Net n : this.nets) {
            OwnerPorts ops = this.netToOwnerPorts.get(n);
            for (PortsOnNetForDevice pd : ops.devicePathToPorts) {
                for (HierPin dpp : pd.dpp) {
                    this.addNetElement(pd.owner, n, dpp);
                }
            }
        }
        this.fixPendingElement();
        try {
            File f = new File(AApp.getInstallDir(), "examples/ORI_DDR_Demo/nettable_demo.xsl");
            StreamSource stTpl = new StreamSource(f);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(stTpl);
            transformer.transform(new DOMSource(this.mXmlDoc), new StreamResult(new File(htmlFile)));
        }
        catch (Exception e) {
            ALog.logError((String)e.getMessage());
        }
    }

    public static boolean isSubstrate(Device d) {
        return d.getIsSubstrate() || Optional.ofNullable(d.getTemplate()).filter(devT -> DeviceTemplate.isSubstrateType((DeviceTemplate.Type)devT.getType())).isPresent();
    }

    protected static interface ElementHandler {
        public void handleItem(Element var1);
    }

    protected static final class AttributePair
    extends APair<String, String> {
        public AttributePair(String s1, String s2) {
            super((Object)s1, (Object)s2);
        }
    }

    protected static class ElementPath
    extends ArrayList<String> {
        public ElementPath(String[] paths) {
            for (String s : paths) {
                this.add(s);
            }
        }

        public ElementPath(ElementPath p) {
            super(p);
        }
    }

    public class NetSorter
    implements Comparator<Net> {
        @Override
        public int compare(Net n1, Net n2) {
            int c1 = NetTable.this.numSubstrateNetAttachesTo(n1);
            int c2 = NetTable.this.numSubstrateNetAttachesTo(n2);
            if (c1 <= 1 && c2 > 1) {
                return 1;
            }
            if (c2 <= 1 && c1 > 1) {
                return -1;
            }
            return n1.getName().compareTo(n2.getName());
        }
    }

    protected static class PortsOnNetForDevice {
        DevicePath owner = null;
        ArrayList<HierPin> dpp = new ArrayList();
        ARect currentR = null;

        protected PortsOnNetForDevice() {
        }
    }

    protected static class OwnerPorts {
        protected ArrayList<PortsOnNetForDevice> devicePathToPorts = new ArrayList();

        protected OwnerPorts() {
        }
    }

    public static class DevicePathPortSort
    implements Comparator<HierPin> {
        APoint2D mLoc;

        public DevicePathPortSort(APoint2D loc) {
            this.mLoc = loc;
        }

        @Override
        public int compare(HierPin o1, HierPin o2) {
            long d1 = o1.getWorldLoc().manhattanDistance(this.mLoc);
            long d2 = o2.getWorldLoc().manhattanDistance(this.mLoc);
            return Long.compare(d1, d2);
        }
    }
}

