/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.PinSpreadOptimizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PinSpreadCenter
implements PinSpreadOptimizer.PinSpreadAlgo {
    int mIdentifier = 0;

    public PinSpreadCenter(int identifier) {
        this.mIdentifier = identifier;
    }

    @Override
    public String name() {
        return this.mIdentifier == 0 ? "Near Center" : "Far From Center";
    }

    @Override
    public String description() {
        return this.mIdentifier == 0 ? "Spread extra pins in center of floorplan" : "Spread signal pins in center of floorplan";
    }

    @Override
    public List<HierPin> filter(List<HierPin> originList, long omitCount, Object userData) {
        ArrayList<HierPin> diffPairList = new ArrayList<HierPin>();
        ArrayList<HierPin> filteredList = new ArrayList<HierPin>();
        if (omitCount <= 0L || omitCount > (long)originList.size()) {
            return originList;
        }
        long sumX = 0L;
        long sumY = 0L;
        long numPins = 0L;
        for (HierPin p : originList) {
            if (p == null) continue;
            sumX += p.getWorldLoc().getX();
            sumY += p.getWorldLoc().getY();
            ++numPins;
        }
        APoint2D avgLoc = new APoint2D(sumX / numPins, sumY / numPins);
        DevicePath devP = (DevicePath)userData;
        for (HierPin p : originList) {
            Net net = ((PinInstance)p.second).getNet();
            Personality diffPairPers = Net.isDiffPair((Net)net, (DevicePath)devP);
            if (diffPairPers == null) {
                filteredList.add(p);
                continue;
            }
            diffPairList.add(p);
        }
        Collections.sort(filteredList, new DistanceSorter(avgLoc, this.mIdentifier));
        int validOmit = omitCount >= (long)filteredList.size() ? 0 : (int)omitCount;
        filteredList.subList(0, validOmit).clear();
        filteredList.addAll(diffPairList);
        return filteredList;
    }

    private static class DistanceSorter
    implements Comparator<HierPin> {
        APoint2D avgLoc = null;
        int identifier = 0;

        public DistanceSorter(APoint2D loc, int i) {
            this.avgLoc = loc;
            this.identifier = i;
        }

        @Override
        public int compare(HierPin p1, HierPin p2) {
            if (p1 == null || p2 == null) {
                return -1;
            }
            APoint2D pinLoc1 = p1.getWorldLoc();
            APoint2D pinLoc2 = p2.getWorldLoc();
            if (pinLoc1.distance(this.avgLoc) <= pinLoc2.distance(this.avgLoc)) {
                return this.identifier == 0 ? -1 : 1;
            }
            return this.identifier == 0 ? 1 : -1;
        }
    }
}

