/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.PinSpreadOptimizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PinSpreadDeviceEdge
implements PinSpreadOptimizer.PinSpreadAlgo {
    int mIdentifier = 0;

    public PinSpreadDeviceEdge(int identifier) {
        this.mIdentifier = identifier;
    }

    @Override
    public String name() {
        return this.mIdentifier == 0 ? "Closest to Edge" : "Furthest From Edge";
    }

    @Override
    public String description() {
        return this.mIdentifier == 0 ? "Spread extra pins closest to edge" : "Spread signal pins closest to edge";
    }

    @Override
    public List<HierPin> filter(List<HierPin> originList, long omitCount, Object userData) {
        ArrayList<HierPin> diffPairList = new ArrayList<HierPin>();
        ArrayList<HierPin> filteredList = new ArrayList<HierPin>();
        if (omitCount <= 0L || omitCount > (long)originList.size()) {
            return originList;
        }
        if (!(userData instanceof DevicePath)) {
            return originList;
        }
        DevicePath devP = (DevicePath)userData;
        Device dev = devP.getDevice();
        ARect bb = dev.getBounds();
        for (HierPin p : originList) {
            Net net = ((PinInstance)p.second).getNet();
            Personality diffPairPers = Net.isDiffPair((Net)net, (DevicePath)devP);
            if (diffPairPers == null) {
                filteredList.add(p);
                continue;
            }
            diffPairList.add(p);
        }
        Collections.sort(filteredList, new DistanceSorter(bb, this.mIdentifier));
        filteredList.subList(0, (int)omitCount).clear();
        filteredList.addAll(diffPairList);
        return filteredList;
    }

    private static class DistanceSorter
    implements Comparator<HierPin> {
        ARect box = null;
        int identifier = 0;

        public DistanceSorter(ARect b, int i) {
            this.box = b;
            this.identifier = i;
        }

        @Override
        public int compare(HierPin p1, HierPin p2) {
            if (p1 == null || p2 == null) {
                return -1;
            }
            APoint2D pinLoc1 = p1.getWorldLoc();
            APoint2D pinLoc2 = p2.getWorldLoc();
            long dist1 = this.box.leftEdge().distance(pinLoc1);
            dist1 = Math.min(dist1, this.box.topEdge().distance(pinLoc1));
            dist1 = Math.min(dist1, this.box.rightEdge().distance(pinLoc1));
            dist1 = Math.min(dist1, this.box.bottomEdge().distance(pinLoc1));
            long dist2 = this.box.leftEdge().distance(pinLoc2);
            dist2 = Math.min(dist2, this.box.topEdge().distance(pinLoc2));
            dist2 = Math.min(dist2, this.box.rightEdge().distance(pinLoc2));
            if (dist1 < (dist2 = Math.min(dist2, this.box.bottomEdge().distance(pinLoc2)))) {
                return this.identifier == 0 ? -1 : 1;
            }
            if (dist1 > dist2) {
                return this.identifier == 0 ? 1 : -1;
            }
            return 0;
        }
    }
}

