/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.PinSpreadOptimizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PinSpreadEven
implements PinSpreadOptimizer.PinSpreadAlgo {
    int mIdentifier = 0;

    public PinSpreadEven(int identifier) {
        this.mIdentifier = identifier;
    }

    @Override
    public String name() {
        return "Even";
    }

    @Override
    public String description() {
        return this.mIdentifier == 0 ? "Spread extra pins evenly starting from the edge" : "Spread extra pins evenly starting furthest from the edge";
    }

    @Override
    public List<HierPin> filter(List<HierPin> originList, long omitCount, Object userData) {
        ArrayList<HierPin> filteredList = new ArrayList<HierPin>();
        ArrayList<HierPin> diffPairList = new ArrayList<HierPin>();
        ArrayList<HierPin> returnList = new ArrayList<HierPin>();
        long size = originList.size();
        if (omitCount <= 0L || omitCount > size) {
            return originList;
        }
        if (!(userData instanceof DevicePath)) {
            return originList;
        }
        DevicePath devP = (DevicePath)userData;
        Device dev = devP.getDevice();
        ARect bb = dev.getBounds();
        String side = this.getSide(originList, bb);
        if (side == null) {
            return originList;
        }
        for (HierPin p : originList) {
            Net net = ((PinInstance)p.second).getNet();
            Personality diffPairPers = Net.isDiffPair((Net)net, (DevicePath)devP);
            if (diffPairPers == null) {
                filteredList.add(p);
                continue;
            }
            diffPairList.add(p);
        }
        Collections.sort(filteredList, new DistanceSorter(this.mIdentifier, side));
        long sizeL = filteredList.size();
        int ratio = (int)(sizeL / omitCount);
        int count = 0;
        int omitted = 0;
        while ((long)count < sizeL) {
            if (ratio == 1 || (count + 1) % ratio != 0 || (long)omitted == omitCount) {
                returnList.add((HierPin)filteredList.get(count));
            } else {
                ++omitted;
            }
            ++count;
        }
        returnList.addAll(diffPairList);
        return returnList;
    }

    protected String getSide(List<HierPin> list, ARect box) {
        String retSide = null;
        long ptX = 0L;
        long ptY = 0L;
        long numPts = 0L;
        APoint2D avgLoc = null;
        if (list == null || list.isEmpty()) {
            return retSide;
        }
        for (HierPin pin : list) {
            ptX += pin.getWorldLoc().getX();
            ptY += pin.getWorldLoc().getY();
            ++numPts;
        }
        if (numPts > 0L) {
            avgLoc = new APoint2D(ptX / numPts, ptY / numPts);
        }
        if (avgLoc != null) {
            retSide = "W";
            long dist = box.leftEdge().distance(avgLoc);
            if (box.topEdge().distance(avgLoc) < dist) {
                dist = box.topEdge().distance(avgLoc);
                retSide = "N";
            }
            if (box.bottomEdge().distance(avgLoc) < dist) {
                dist = box.bottomEdge().distance(avgLoc);
                retSide = "S";
            }
            if (box.rightEdge().distance(avgLoc) < dist) {
                dist = box.rightEdge().distance(avgLoc);
                retSide = "E";
            }
        }
        return retSide;
    }

    private static class DistanceSorter
    implements Comparator<HierPin> {
        int identifier = 0;
        String side = null;

        public DistanceSorter(int i, String s) {
            this.identifier = i;
            this.side = s;
        }

        @Override
        public int compare(HierPin p1, HierPin p2) {
            if (p1 == null || p2 == null) {
                return -1;
            }
            APoint2D pinLoc1 = p1.getWorldLoc();
            APoint2D pinLoc2 = p2.getWorldLoc();
            if (this.side.equals("N")) {
                if (this.identifier == 0) {
                    if (pinLoc1.getY() > pinLoc2.getY()) {
                        return -1;
                    }
                    if (pinLoc1.getY() < pinLoc2.getY()) {
                        return 1;
                    }
                    if (pinLoc1.getX() < pinLoc2.getX()) {
                        return -1;
                    }
                    if (pinLoc1.getX() > pinLoc2.getX()) {
                        return 1;
                    }
                } else {
                    if (pinLoc1.getY() < pinLoc2.getY()) {
                        return -1;
                    }
                    if (pinLoc1.getY() > pinLoc2.getY()) {
                        return 1;
                    }
                    if (pinLoc1.getX() < pinLoc2.getX()) {
                        return -1;
                    }
                    if (pinLoc1.getX() > pinLoc2.getX()) {
                        return 1;
                    }
                }
                return 0;
            }
            if (this.side.equals("S")) {
                if (this.identifier == 0) {
                    if (pinLoc1.getY() < pinLoc2.getY()) {
                        return -1;
                    }
                    if (pinLoc1.getY() > pinLoc2.getY()) {
                        return 1;
                    }
                    if (pinLoc1.getX() < pinLoc2.getX()) {
                        return -1;
                    }
                    if (pinLoc1.getX() > pinLoc2.getX()) {
                        return 1;
                    }
                } else {
                    if (pinLoc1.getY() > pinLoc2.getY()) {
                        return -1;
                    }
                    if (pinLoc1.getY() < pinLoc2.getY()) {
                        return 1;
                    }
                    if (pinLoc1.getX() < pinLoc2.getX()) {
                        return -1;
                    }
                    if (pinLoc1.getX() > pinLoc2.getX()) {
                        return 1;
                    }
                }
                return 0;
            }
            if (this.side.equals("E")) {
                if (this.identifier == 0) {
                    if (pinLoc1.getX() > pinLoc2.getX()) {
                        return -1;
                    }
                    if (pinLoc1.getX() < pinLoc2.getX()) {
                        return 1;
                    }
                    if (pinLoc1.getY() > pinLoc2.getY()) {
                        return -1;
                    }
                    if (pinLoc1.getY() < pinLoc2.getY()) {
                        return 1;
                    }
                } else {
                    if (pinLoc1.getX() < pinLoc2.getX()) {
                        return -1;
                    }
                    if (pinLoc1.getX() > pinLoc2.getX()) {
                        return 1;
                    }
                    if (pinLoc1.getY() > pinLoc2.getY()) {
                        return -1;
                    }
                    if (pinLoc1.getY() < pinLoc2.getY()) {
                        return 1;
                    }
                }
                return 0;
            }
            if (this.side.equals("W")) {
                if (this.identifier == 0) {
                    if (pinLoc1.getX() < pinLoc2.getX()) {
                        return -1;
                    }
                    if (pinLoc1.getX() > pinLoc2.getX()) {
                        return 1;
                    }
                    if (pinLoc1.getY() > pinLoc2.getY()) {
                        return -1;
                    }
                    if (pinLoc1.getY() < pinLoc2.getY()) {
                        return 1;
                    }
                } else {
                    if (pinLoc1.getX() > pinLoc2.getX()) {
                        return -1;
                    }
                    if (pinLoc1.getX() < pinLoc2.getX()) {
                        return 1;
                    }
                    if (pinLoc1.getY() > pinLoc2.getY()) {
                        return -1;
                    }
                    if (pinLoc1.getY() < pinLoc2.getY()) {
                        return 1;
                    }
                }
                return 0;
            }
            return 0;
        }
    }
}

