/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.PinSpreadCenter;
import com.sigrity.orbit.automation.PinSpreadDeviceEdge;
import com.sigrity.orbit.automation.PinSpreadEven;
import java.util.LinkedList;
import java.util.List;

public class PinSpreadOptimizer {
    public static void registerStandardSpreads() {
        PinSpreadRegistry.clear();
        PinSpreadRegistry.add(new PinSpreadCenter(0));
        PinSpreadRegistry.add(new PinSpreadCenter(1));
        PinSpreadRegistry.add(new PinSpreadDeviceEdge(0));
        PinSpreadRegistry.add(new PinSpreadDeviceEdge(1));
        PinSpreadRegistry.add(new PinSpreadEven(0));
    }

    public static class PinSpreadRegistry {
        protected static List<PinSpreadAlgo> registry = new LinkedList<PinSpreadAlgo>();

        public static void clear() {
            registry.clear();
        }

        public static void add(PinSpreadAlgo sps) {
            registry.add(sps);
        }

        public static PinSpreadAlgo getSelected() {
            return registry.get(0);
        }

        public static void setSelected(PinSpreadAlgo sps) {
            registry.remove(sps);
            registry.add(0, sps);
        }

        public static List<PinSpreadAlgo> getRegistryList() {
            return registry;
        }

        public static PinSpreadAlgo getPinSpreadAlgo(String algo) {
            for (PinSpreadAlgo p : registry) {
                if (!p.name().equals(algo)) continue;
                return p;
            }
            return null;
        }
    }

    public static interface PinSpreadAlgo {
        public List<HierPin> filter(List<HierPin> var1, long var2, Object var4);

        public String name();

        public String description();
    }
}

