/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.APair;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;

public class PortPair {
    APair<HierPin, HierPin> mNew;
    APair<HierPin, HierPin> mOld;
    String mNewPortNetName;
    String mOldPortNetName;

    public PortPair(HierPin newPort, HierPin fixedPort, HierPin oldPort) {
        this.mNew = new APair((Object)newPort, (Object)fixedPort);
        this.mOld = new APair((Object)oldPort, (Object)fixedPort);
        this.mNewPortNetName = NetMap.getTopmostNet((Net)newPort.getNet(), (DevicePath)newPort.getPath()).getName();
        this.mOldPortNetName = NetMap.getTopmostNet((Net)oldPort.getNet(), (DevicePath)oldPort.getPath()).getName();
    }

    public HierPin getNewPort() {
        return (HierPin)this.mNew.first;
    }

    public void update() {
        PinInstance op;
        PinInstance np = ((HierPin)this.mNew.first).getPin();
        if (np == (op = ((HierPin)this.mOld.first).getPin())) {
            return;
        }
        DevicePath dp = ((HierPin)this.mNew.first).getPath().commonParent(((HierPin)this.mOld.first).getPath());
        DeviceTemplate stop = dp.getDeviceTemplate();
        np.setNetFromHereToTemplate(this.mOldPortNetName, stop);
        op.setNetFromHereToTemplate(this.mNewPortNetName, stop);
    }

    public void restore() {
        PinInstance op;
        PinInstance np = ((HierPin)this.mNew.first).getPin();
        if (np == (op = ((HierPin)this.mOld.first).getPin())) {
            return;
        }
        DevicePath dp = ((HierPin)this.mNew.first).getPath().commonParent(((HierPin)this.mOld.first).getPath());
        DeviceTemplate stop = dp.getDeviceTemplate();
        np.setNetFromHereToTemplate(this.mNewPortNetName, stop);
        op.setNetFromHereToTemplate(this.mOldPortNetName, stop);
    }
}

