/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.HierPin;
import java.util.ArrayList;

public class PortZoneTable {
    private int mZoneFactor = 3;
    private PortList[][] mZones = new PortList[this.mZoneFactor][this.mZoneFactor];
    private ARect mBound;
    private long mXInc;
    private long mYInc;

    public PortZoneTable(ARect bound) {
        this.mBound = bound;
        this.mXInc = (this.mBound.width() + (long)(this.mZoneFactor - 1)) / (long)this.mZoneFactor;
        this.mYInc = (this.mBound.height() + (long)(this.mZoneFactor - 1)) / (long)this.mZoneFactor;
    }

    public void addPorts(ArrayList<HierPin> ports) {
        for (HierPin p : ports) {
            this.addPort(p);
        }
    }

    public void addPort(HierPin port) {
        int j;
        APoint2D l = port.getWorldLoc();
        int i = (int)(l.xDistance(this.mBound.getLL()) / this.mXInc);
        if (this.mZones[i][j = (int)(l.yDistance(this.mBound.getLL()) / this.mYInc)] == null) {
            this.mZones[i][j] = new PortList();
        }
        this.mZones[i][j].add(port);
    }

    public ArrayList<HierPin> getNearByPorts(APoint2D loc) {
        int i = (int)(loc.xDistance(this.mBound.getLL()) / this.mXInc);
        int j = (int)(loc.yDistance(this.mBound.getLL()) / this.mYInc);
        i = this.adjIndex(i);
        j = this.adjIndex(j);
        return this.mZones[i][j];
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.mZoneFactor; ++i) {
            for (int j = 0; j < this.mZoneFactor; ++j) {
                if (this.mZones[i][j] == null || this.mZones[i][j].isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaxExpansion(APoint2D loc) {
        int i = (int)(loc.xDistance(this.mBound.getLL()) / this.mXInc);
        int j = (int)(loc.yDistance(this.mBound.getLL()) / this.mYInc);
        int expand = i;
        int max = this.mZoneFactor - 1;
        if (expand < max - i) {
            expand = max - i;
        }
        if (expand < j) {
            expand = j;
        }
        if (expand < max - j) {
            expand = max - j;
        }
        return expand;
    }

    public ArrayList<HierPin> getNearByPortsWithExpand(APoint2D loc, int expand) {
        int jj;
        int ii;
        int i = (int)(loc.xDistance(this.mBound.getLL()) / this.mXInc);
        int j = (int)(loc.yDistance(this.mBound.getLL()) / this.mYInc);
        ArrayList<HierPin> ports = new ArrayList<HierPin>();
        int starti = this.adjIndex(i - expand);
        int endi = this.adjIndex(i + expand);
        int startj = this.adjIndex(j - expand);
        int endj = this.adjIndex(j + expand);
        for (ii = starti; ii <= endi; ++ii) {
            if (this.mZones[ii][startj] == null || this.mZones[ii][startj].isEmpty()) continue;
            ports.addAll(this.mZones[ii][startj]);
        }
        for (ii = starti; ii <= endi; ++ii) {
            if (this.mZones[ii][endj] == null || this.mZones[ii][endj].isEmpty()) continue;
            ports.addAll(this.mZones[ii][endj]);
        }
        for (jj = startj; jj <= endj; ++jj) {
            if (this.mZones[starti][jj] == null || this.mZones[starti][jj].isEmpty()) continue;
            ports.addAll(this.mZones[starti][jj]);
        }
        for (jj = startj; jj <= endj; ++jj) {
            if (this.mZones[endi][jj] == null || this.mZones[endi][jj].isEmpty()) continue;
            ports.addAll(this.mZones[endi][jj]);
        }
        return ports;
    }

    private int adjIndex(int index) {
        int max = this.mZoneFactor - 1;
        if (index < 0) {
            index = 0;
        }
        if (index > max) {
            index = max;
        }
        return index;
    }

    protected class PortList
    extends ArrayList<HierPin> {
        protected PortList() {
        }
    }
}

