/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AMathUtil;
import com.sigrity.acl.APair;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.ATriple;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierShape;
import com.sigrity.orbit.OrbitGridUtil;
import com.sigrity.orbit.util.PhysicalNetUtil;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ViaFanout {
    private static APoint2D getEscapePoint(AffineTransform xform, Layer layer, long distFromEdge, HierPin.FanoutDirection direction, List<PortTemplate> ports) {
        APoint2D ans = new APoint2D(0L, 0L);
        long maxR = 0L;
        List lShapes = ports.stream().flatMap(port -> port.getLayerShapesOnLayer(layer).stream()).collect(Collectors.toList());
        for (LayerShape lShape : lShapes) {
            AGeom geom = lShape.getGeom().transform(xform);
            maxR = Math.max(maxR, PadTemplate.geomRadForDir((AGeom)geom, (HierPin.FanoutDirection)direction));
        }
        maxR += distFromEdge;
        if (direction == HierPin.FanoutDirection.N) {
            ans.setY(maxR);
        } else if (direction == HierPin.FanoutDirection.S) {
            ans.setY(-maxR);
        } else if (direction == HierPin.FanoutDirection.E) {
            ans.setX(maxR);
        } else if (direction == HierPin.FanoutDirection.W) {
            ans.setX(-maxR);
        } else {
            maxR = AMathUtil.roundUp((double)((double)maxR / Math.sqrt(2.0)));
            if (direction == HierPin.FanoutDirection.NE) {
                ans.setLoc(maxR, maxR);
            } else if (direction == HierPin.FanoutDirection.NW) {
                ans.setLoc(-maxR, maxR);
            } else if (direction == HierPin.FanoutDirection.SE) {
                ans.setLoc(maxR, -maxR);
            } else if (direction == HierPin.FanoutDirection.SW) {
                ans.setLoc(-maxR, -maxR);
            }
        }
        return ans;
    }

    private static APoint2D adjustLoc(Layer layer, APoint2D loc, HierPin.FanoutDirection direction, HierPin pin, long pinViaSpace, List<PortTemplate> ports) {
        if (loc == null) {
            return null;
        }
        AffineTransform xForm = pin.getDbObject().getWorldTransform(pin.getPath());
        return loc.add(ViaFanout.getEscapePoint(xForm, layer, pinViaSpace, direction, ports));
    }

    private static HierPin preparePinsToFanout(PinInstance pinInst, DevicePath pinPath, Layer startLayer, Set<Net> usedNets, boolean includeUnassignedPins, boolean includeAllSameNetPins) {
        DevicePath packagePath;
        Net net = NetMap.getSubstrateNet((Net)pinInst.getNet(), (DevicePath)pinPath);
        if (net.getSubstrate() != startLayer.getSubstrate()) {
            return null;
        }
        if (!includeUnassignedPins && net.isUnused()) {
            return null;
        }
        if (!includeAllSameNetPins) {
            if (usedNets.contains(net)) {
                return null;
            }
            usedNets.add(net);
        }
        if ((packagePath = pinPath.copy()).getLast().isDriver()) {
            packagePath.removeLast();
        }
        DevicePath fullPinPath = pinPath.copy();
        if (pinInst.getPinTemplate().getType() == PinTemplate.Type.VIA) {
            PinInstance otherPin = PhysicalNetUtil.getPinConnectedTo((PinInstance)pinInst, (DevicePath)fullPinPath);
            if (otherPin == null) {
                return null;
            }
            ViaFanout.removeWires(pinInst);
            pinInst.getPinTemplate().deleteFromDb();
            if (otherPin.getDevice() != fullPinPath.getLast()) {
                fullPinPath.add(otherPin.getDevice());
            }
            pinInst = otherPin;
        } else {
            LinkedList otherVias = PhysicalNetUtil.getViasConnectedTo((PinInstance)pinInst, (DevicePath)fullPinPath);
            for (PinInstance otherVia1 : otherVias) {
                ViaFanout.removeWires(otherVia1);
                otherVia1.getPinTemplate().deleteFromDb();
            }
        }
        return new HierPin(fullPinPath, pinInst);
    }

    static List<FanoutPin> getPinsToFanout(Db db, boolean includeUnassignedPins, boolean includeAllSameNetPins, String startLayerKeyStr) {
        return ViaFanout.getPinsToFanout(db, includeUnassignedPins, includeAllSameNetPins, startLayerKeyStr, false);
    }

    static List<FanoutPin> getPinsToFanout(Db db, boolean includeUnassignedPins, boolean includeAllSameNetPins, String startLayerKeyStr, boolean includeAllInstances) {
        HierPin putPin;
        PinInstance pinInst;
        ASingletonItr paths;
        DevicePath basePath;
        ArrayList<FanoutPin> ans = new ArrayList<FanoutPin>();
        HashSet nets = new HashSet();
        Layer startLayer = (Layer)db.getByKeyStr(Layer.class, startLayerKeyStr);
        Selection sel = Design.getSelection((Db)db);
        HashSet<HierInst> checkSet = new HashSet<HierInst>();
        HashMap<HierInst, HierPin> prepareMap = new HashMap<HierInst, HierPin>();
        for (HierInst hierPin : sel.getSelectedHierInsts(PinInstance.class)) {
            PinTemplate pinT;
            basePath = hierPin.getPath();
            if (!checkSet.add(new HierInst(basePath, (DbObject)(pinT = ((PinInstance)hierPin.getDbObject()).getPinTemplate())))) continue;
            paths = includeAllInstances ? basePath.getDeviceTemplate().getHierarchicalInstances() : ASingletonItr.create((Object)basePath);
            for (DevicePath path : paths) {
                checkSet.add(new HierInst(path, (DbObject)pinT));
                pinInst = PinInstance.getPinInstance((Device)path.getDevice(), (PinTemplate)pinT);
                putPin = prepareMap.computeIfAbsent(HierPin.create((DevicePath)path, (DbObject)pinInst), k -> ViaFanout.preparePinsToFanout(pinInst, path, startLayer, nets, includeUnassignedPins, includeAllSameNetPins));
                if (putPin == null) continue;
                ans.add(new FanoutPin(putPin, putPin.getDbObject().getPinTemplate().getPortTemplates().stream().collect(Collectors.toList())));
            }
        }
        for (HierInst hierPort : sel.getSelectedHierInsts(PortTemplate.class)) {
            PortTemplate port;
            basePath = hierPort.getPath();
            if (checkSet.contains(new HierInst(basePath, (DbObject)(port = (PortTemplate)hierPort.getDbObject())))) continue;
            paths = includeAllInstances ? basePath.getDeviceTemplate().getHierarchicalInstances() : ASingletonItr.create((Object)basePath);
            for (DevicePath portPath : paths) {
                if (!checkSet.add(new HierInst(portPath, (DbObject)port)) || (putPin = prepareMap.computeIfAbsent(HierPin.create((DevicePath)portPath, (DbObject)(pinInst = port.getPinTemplate().getPinInstance(portPath))), k -> ViaFanout.preparePinsToFanout(pinInst, portPath, startLayer, nets, includeUnassignedPins, includeAllSameNetPins))) == null) continue;
                ans.add(new FanoutPin(putPin, AUtil.linkedList((Object[])new PortTemplate[]{(PortTemplate)hierPort.getDbObject()})));
            }
        }
        for (HierInst hierShape : sel.getSelectedHierInsts(LayerShape.class)) {
            ASingletonItr paths2;
            basePath = hierShape.getPath();
            LayerShape ls = (LayerShape)hierShape.getDbObject();
            if (!(ls.getOwner() instanceof PadTemplate) || !HierShape.class.isInstance(hierShape)) continue;
            HierShape hiShape = (HierShape)HierShape.cast((HierInst)hierShape);
            Object object = paths2 = includeAllInstances ? basePath.getDeviceTemplate().getHierarchicalInstances() : ASingletonItr.create((Object)basePath);
            if (!checkSet.add(HierInst.cast((HierInst)hierShape))) continue;
            for (DevicePath shapePath : paths2) {
                ASingletonItr ports = ASingletonItr.create((Object)((PortTemplate)hiShape.getOwner()));
                for (PortTemplate port : ports) {
                    PinInstance pinInst2 = port.getPinTemplate().getPinInstance(shapePath);
                    HierPin putPin2 = prepareMap.computeIfAbsent(HierPin.create((DevicePath)shapePath, (DbObject)pinInst2), k -> ViaFanout.preparePinsToFanout(pinInst2, shapePath, startLayer, nets, includeUnassignedPins, includeAllSameNetPins));
                    if (putPin2 == null) continue;
                    ans.add(new FanoutPin(putPin2, List.of(port), List.of(new APair((Object)port, (Object)ls))));
                }
            }
        }
        return new ArrayList<FanoutPin>(ans);
    }

    public static void removeWires(PinInstance pI) {
        if (pI == null) {
            return;
        }
        List wires = pI.getConnectedWires(false).collect(Collectors.toList());
        for (Wire w : wires) {
            Bundle b = w.getBundle();
            if (b != null) {
                Object sc2;
                LinkedList<Object> toBeDeleted = new LinkedList<Object>();
                for (Object sc2 : b.getSchedConn()) {
                    if (!sc2.getDPPA().getSecond().equals(pI) && !sc2.getDPPB().getSecond().equals(pI)) continue;
                    toBeDeleted.add(sc2);
                }
                Personality p = b.getRouteGroup();
                if (p != null) {
                    for (SchedConn rsc : p.getSchedConns()) {
                        if (!rsc.getDPPA().getSecond().equals(pI) && !rsc.getDPPB().getSecond().equals(pI)) continue;
                        toBeDeleted.add(rsc);
                    }
                }
                if ((p = b.getRouteGroupFree()) != null) {
                    for (SchedConn rsc : p.getSchedConns()) {
                        if (!rsc.getDPPA().getSecond().equals(pI) && !rsc.getDPPB().getSecond().equals(pI)) continue;
                        toBeDeleted.add(rsc);
                    }
                }
                sc2 = toBeDeleted.iterator();
                while (sc2.hasNext()) {
                    SchedConn sC = (SchedConn)sc2.next();
                    sC.deleteFromDb();
                }
                PinTemplate pt = (PinTemplate)w.getPinA().getSecond();
                if (pt.getType() == PinTemplate.Type.TOPOLOGYPOINT) {
                    pt.deleteFromDb();
                } else if (pt.getType() == PinTemplate.Type.TOPOLOGYPOINT) {
                    pt.deleteFromDb();
                }
            }
            w.deleteFromDb();
        }
    }

    public static ALine getLineForDirection(APoint2D pt, HierPin.FanoutDirection dir) {
        switch (dir) {
            case N: {
                return new ALine(pt.getX(), pt.getY(), pt.getX(), pt.getY() + 100L);
            }
            case S: {
                return new ALine(pt.getX(), pt.getY(), pt.getX(), pt.getY() - 100L);
            }
            case E: {
                return new ALine(pt.getX(), pt.getY(), pt.getX() + 100L, pt.getY());
            }
            case W: {
                return new ALine(pt.getX(), pt.getY(), pt.getX() - 100L, pt.getY());
            }
        }
        return new ALine(pt.getX(), pt.getY(), pt.getX(), pt.getY());
    }

    public static void createFanouts(Db db, boolean includeUnassignedPins, boolean includeAllSameNetPins, String startLayerKeyStr, String endLayerKeyStr, String padstackKeyStr, String directionStr, long lineWidth, long pinViaSpace, long minChannelSpace) {
        LinkedList<Wire> wires = new LinkedList<Wire>();
        HierPin.FanoutDirection direction = HierPin.FanoutDirection.fromString((String)directionStr);
        List<FanoutPin> pins = ViaFanout.getPinsToFanout(db, includeUnassignedPins, includeAllSameNetPins, startLayerKeyStr);
        boolean inOutStyle = direction == HierPin.FanoutDirection.InOut;
        boolean inOrOutStyle = direction == HierPin.FanoutDirection.Inward || direction == HierPin.FanoutDirection.Outward || inOutStyle;
        Collections.sort(pins);
        int total = 0;
        int numOutsideSubstrate = 0;
        int wireConflicts = 0;
        int numNotOnStartLayer = 0;
        Layer startLayer = (Layer)db.getByKeyStr(Layer.class, startLayerKeyStr);
        PadTemplate padTemplate = PadTemplate.getByKeyStr((Db)db, (String)padstackKeyStr, (Substrate)startLayer.getSubstrate());
        LinkedList<HierPin> prevAddedVias = new LinkedList<HierPin>();
        for (FanoutPin fPin : pins) {
            long padDist;
            if (inOutStyle) {
                direction = direction == HierPin.FanoutDirection.InOut || direction == HierPin.FanoutDirection.Outward ? HierPin.FanoutDirection.Inward : HierPin.FanoutDirection.Outward;
            }
            HierPin hPin = fPin.pin;
            DevicePath packagePath = hPin.getPackagePath();
            DevicePath pathToPutViasOn = hPin.getPackagePath().pathToSubstrate();
            if (pathToPutViasOn == null) {
                ++numNotOnStartLayer;
                continue;
            }
            NamedGrid grid = OrbitGridUtil.getGrid((DbObject)packagePath.getDevice());
            ARect substrateBB = pathToPutViasOn.getBB();
            substrateBB.expandBy(-padTemplate.getEscapeDist(null, HierPin.FanoutDirection.W), -padTemplate.getEscapeDist(null, HierPin.FanoutDirection.S), -padTemplate.getEscapeDist(null, HierPin.FanoutDirection.E), -padTemplate.getEscapeDist(null, HierPin.FanoutDirection.N));
            APoint2D pinWorldLoc = fPin.getWorldLocCenter(hPin.getPath(), startLayer);
            if (pinWorldLoc == null) {
                ++numNotOnStartLayer;
                continue;
            }
            HierPin.FanoutDirection dir = hPin.getDirection(direction);
            APoint2D viaLoc = ViaFanout.adjustLoc(startLayer, pinWorldLoc, dir, hPin, pinViaSpace + (padDist = padTemplate.getEscapeDist(startLayer, HierPin.getOppositeDirection((HierPin.FanoutDirection)dir))), fPin.portList);
            if (!viaLoc.inside(substrateBB)) {
                ++numOutsideSubstrate;
                continue;
            }
            if ((viaLoc = ViaFanout.adjustLocForPreviouslyAdded(viaLoc, prevAddedVias, minChannelSpace, padTemplate, dir, substrateBB, grid)) == null) {
                ++numOutsideSubstrate;
                continue;
            }
            HierInst hierPort = new HierInst(hPin.getPath(), (DbObject)fPin.portList.get(0));
            PinInstance newVia = ViaFanout.createFanoutVia(padTemplate, viaLoc, packagePath, hPin.getDbObject(), hPin.getPath());
            if (direction != HierPin.FanoutDirection.ViaInPad) {
                Wire wire = Wire.createStraightWireBetween((HierInst)hierPort, (APoint2D)viaLoc, (long)lineWidth, (Layer)startLayer, (DevicePath)packagePath);
                wire.setPinA(StoredPath.get((DeviceTemplate)newVia.getDeviceTemplate()), newVia.getPinTemplate());
                DevicePath pinPath = new DevicePath(packagePath.getDeviceTemplate());
                if (hPin.getPin().getDevice() != packagePath.getLast()) {
                    pinPath.add(hPin.getPin().getDevice());
                }
                wire.setPinB(StoredPath.get((DevicePath)pinPath), hPin.getPinTemplate());
                if (wire.overlapsWithOthers(wires, lineWidth)) {
                    ++wireConflicts;
                    wire.deleteFromDb();
                    newVia.deleteFromDb();
                    continue;
                }
                wires.add(wire);
                if (inOrOutStyle) {
                    prevAddedVias.add(new HierPin(packagePath, newVia));
                }
            }
            ++total;
        }
        if (numNotOnStartLayer > 0) {
            ALog.logWarn((String)"%d pins were not escaped because they have no geometry on the start layer.", (Object[])new Object[]{numNotOnStartLayer});
        }
        if (wireConflicts > 0) {
            ALog.logWarn((String)"%d vias were not added because the connecting wires would cross.", (Object[])new Object[]{wireConflicts});
        }
        if (numOutsideSubstrate > 0) {
            ALog.logWarn((String)"%d fanouts were not created because they would fall outside of the substrate with the current parameters.", (Object[])new Object[]{numOutsideSubstrate});
        }
        ALog.logInfo((String)"%d fanouts created.", (Object[])new Object[]{total});
    }

    private static APoint2D adjustLocForPreviouslyAdded(APoint2D viaLoc, List<HierPin> prevAddedPins, long minChannelSpace, PadTemplate padTemplate, HierPin.FanoutDirection dir, ARect substrateBB, NamedGrid grid) {
        APoint2D startLoc = viaLoc.copy();
        if (prevAddedPins.isEmpty()) {
            return viaLoc;
        }
        ARect bB = padTemplate.getBB(null);
        ARect expandedBB = bB.expandBy(Math.max(bB.height(), bB.width()) + minChannelSpace + 1L);
        expandedBB.moveCenterTo(viaLoc);
        HierPin.expandBBoxInDir((ARect)expandedBB, (HierPin.FanoutDirection)dir, (ARect)substrateBB);
        ArrayList possibleConflicts = prevAddedPins.stream().filter(hP -> hP.getWorldLoc().inside(expandedBB)).collect(Collectors.toCollection(ArrayList::new));
        if (!prevAddedPins.isEmpty() && minChannelSpace > 0L) {
            boolean conflictFound = true;
            while (conflictFound) {
                conflictFound = false;
                for (HierPin prevAddedPin : possibleConflicts) {
                    ATriple distanceInfo = prevAddedPin.distTo(viaLoc, padTemplate);
                    if (distanceInfo == null || (Long)distanceInfo.first >= minChannelSpace) continue;
                    if ((viaLoc = prevAddedPin.findFirstPointOnLineNotInConflict(ViaFanout.getLineForDirection(viaLoc, dir), minChannelSpace, padTemplate, grid)) == null || ViaFanout.viaLocTooFar(startLoc, viaLoc, dir, substrateBB)) {
                        return null;
                    }
                    conflictFound = true;
                }
            }
        }
        return viaLoc;
    }

    public static boolean viaLocTooFar(APoint2D startLoc, APoint2D viaLoc, HierPin.FanoutDirection dir, ARect substrateBB) {
        if (startLoc.distance(viaLoc) > (dir == HierPin.FanoutDirection.N || dir == HierPin.FanoutDirection.S ? substrateBB.height() : substrateBB.width()) / 2L) {
            return true;
        }
        return !viaLoc.inside(substrateBB);
    }

    public void addThisPortToObstacles(HierPin dpp, Layer avoid) {
        AGeom s = dpp.getPin().getWorldShapeOnLayer(dpp.getPath(), avoid);
        if (s != null) {
            // empty if block
        }
    }

    public static PinInstance createFanoutVia(PadTemplate pt, APoint2D worldPoint, DevicePath packagePath, PinInstance pinInst, DevicePath associatedPinPath) {
        Net viaNet = pinInst.getNet();
        Personality p = pinInst.getPersonality();
        AffineTransform t = packagePath.getInverseTransform();
        APoint2D ptCenter = pt.getBB(null).center();
        worldPoint = worldPoint.add(ptCenter);
        APoint2D pP = worldPoint.transform(t);
        Net n = NetMap.getNetAt((Net)viaNet, (DevicePath)associatedPinPath, (DeviceTemplate)packagePath.getDeviceTemplate());
        if (n.getDeviceTemplate() != packagePath.getDeviceTemplate()) {
            ALog.logWarn((String)("The via  does not map to " + packagePath.toString() + ", NetUnused will be used."));
            n = packagePath.getDeviceTemplate().getNetUnused();
        }
        PinTemplate dtp = PinTemplate.create((Net)n, (String)"via");
        dtp.setPadTemplate(pt);
        dtp.setType(PinTemplate.Type.VIA);
        dtp.setLoc(new APoint2D(pP));
        PinInstance dp = new PinInstance("Via", packagePath.getLast(), dtp);
        pt.getDb().add((DbObject)dp);
        if (p != null) {
            dp.assignToPersonality(p);
        }
        return dp;
    }

    static class FanoutPin
    implements Comparable<FanoutPin> {
        final HierPin pin;
        final List<PortTemplate> portList;
        final List<APair<PortTemplate, LayerShape>> shapeList;

        public FanoutPin(HierPin pin, List<PortTemplate> portList) {
            this(pin, portList, null);
        }

        public FanoutPin(HierPin pin, List<PortTemplate> portList, List<APair<PortTemplate, LayerShape>> shapeList) {
            this.pin = pin;
            this.portList = portList;
            if (shapeList != null) {
                this.shapeList = shapeList;
            } else {
                this.shapeList = new ArrayList<APair<PortTemplate, LayerShape>>();
                for (PortTemplate port : portList) {
                    for (LayerShape ls : port.getLayerShapes()) {
                        this.shapeList.add((APair<PortTemplate, LayerShape>)new APair((Object)port, (Object)ls));
                    }
                }
            }
        }

        @Override
        public int compareTo(FanoutPin fpin) {
            int c = HierPin.CompareForFanoutProcessing.compare(this.pin, fpin.pin);
            if (c != 0) {
                return c;
            }
            c = Integer.compare(this.portList.size(), fpin.portList.size());
            return c;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FanoutPin)) {
                return false;
            }
            FanoutPin fpin = (FanoutPin)obj;
            return this.pin.equals((Object)fpin.pin);
        }

        public int hashCode() {
            return Objects.hash(this.pin);
        }

        public APoint2D getWorldLocCenter(DevicePath path, Layer layer) {
            if (this.portList.isEmpty()) {
                return null;
            }
            APoint2D sum = new APoint2D(0L, 0L);
            int count = 0;
            if (this.shapeList != null) {
                for (APair<PortTemplate, LayerShape> e : this.shapeList) {
                    if (((LayerShape)e.getSecond()).getLayer() != layer) continue;
                    PortTemplate port = (PortTemplate)e.getFirst();
                    LayerShape ls = (LayerShape)e.getSecond();
                    APoint2D c = ls.getGeom().getBounds().transform(port.getLocalTransform()).transform(path.getTransform()).getBounds().center();
                    sum = sum.add(c);
                    ++count;
                }
            } else {
                for (PortTemplate port : this.portList) {
                    APoint2D pt = port.getCenterLoc(path, layer);
                    if (pt == null) continue;
                    sum = sum.add(pt);
                    ++count;
                }
            }
            if (count == 0) {
                return null;
            }
            return new APoint2D(sum.getX() / (long)count, sum.getY() / (long)count);
        }
    }
}

