/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.automation.WeightedGoalFunction;
import com.sigrity.orbit.automation.connOpt.AGeneticConnectionOptimizer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JSlider;

public class WeightedGoalRegistry {
    public static final WeightedGoalRegistry sRegistry = new WeightedGoalRegistry();
    protected LinkedList<WeightedGoalFunction> registry = new LinkedList();
    protected LinkedList<JSlider> sliders = new LinkedList();

    public static WeightedGoalFunction getFunction(String name) {
        for (WeightedGoalFunction wgf : WeightedGoalRegistry.sRegistry.registry) {
            if (!wgf.name().equals(name)) continue;
            return wgf;
        }
        return null;
    }

    public static void addToRegistry(WeightedGoalFunction f) {
        for (WeightedGoalFunction fnow : WeightedGoalRegistry.sRegistry.registry) {
            if (!fnow.name().equals(f.name())) continue;
            return;
        }
        WeightedGoalRegistry.sRegistry.registry.add(f);
    }

    public static LinkedList<WeightedGoalFunction> getRegistry() {
        return WeightedGoalRegistry.sRegistry.registry;
    }

    public static void clearRegistry() {
        WeightedGoalRegistry.sRegistry.registry.clear();
    }

    static {
        WeightedGoalRegistry.addToRegistry(new RoutabilityFitness());
        WeightedGoalRegistry.addToRegistry(new DiffPairFitness());
        WeightedGoalRegistry.addToRegistry(new BankFitness());
    }

    protected static class DiffPairFitness
    extends WeightedGoalFunction {
        boolean allocateAGroundPin = false;

        protected DiffPairFitness() {
        }

        @Override
        public void init(AGeneticConnectionOptimizer.ConnectedChromosome c) {
        }

        @Override
        public String name() {
            return "Diff Pair";
        }

        @Override
        public String toolTip() {
            return "Minimizes Diff Pair Skew";
        }

        @Override
        public Color color() {
            return Color.red;
        }

        @Override
        public double fitness(AGeneticConnectionOptimizer.ConnectedChromosome c) {
            HashMap<Personality, Integer> pToI = new HashMap<Personality, Integer>();
            HashMap<Integer, ArrayList<AGeneticConnectionOptimizer.Connected>> diffList = new HashMap<Integer, ArrayList<AGeneticConnectionOptimizer.Connected>>();
            double fitness = 0.0;
            Integer nextI = 0;
            for (int i = 0; i < c.size(); ++i) {
                AGeneticConnectionOptimizer.Connected cI = (AGeneticConnectionOptimizer.Connected)((Object)c.get(i));
                if (cI.first == null || cI.second == null) continue;
                DevicePath stopPathA = cI.getFrom().getDpp().getPath().pathToSubstrate();
                Net netA = NetMap.getTopmostNet((Net)cI.getFrom().getDpp().getNet(), (DevicePath)stopPathA);
                Personality p = netA.getPersonality();
                ArrayList<AGeneticConnectionOptimizer.Connected> myDiffList = null;
                if (p == null) continue;
                Integer v = (Integer)pToI.get(p);
                if (v != null) {
                    myDiffList = (ArrayList<AGeneticConnectionOptimizer.Connected>)diffList.get(v);
                } else {
                    Boolean matchLength = (Boolean)Constraint.getValue((Db)p.getDb(), (DbObject)p, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH);
                    if (matchLength != null && matchLength.booleanValue()) {
                        v = nextI;
                        Integer n = nextI;
                        Integer n2 = nextI = Integer.valueOf(nextI + 1);
                        pToI.put(p, n);
                        myDiffList = new ArrayList<AGeneticConnectionOptimizer.Connected>();
                        diffList.put(v, myDiffList);
                    }
                }
                if (myDiffList == null) continue;
                myDiffList.add(cI);
            }
            for (Integer I : diffList.keySet()) {
                ArrayList cList = (ArrayList)diffList.get(I);
                if (cList.size() <= 1) continue;
                DevicePath toPath = ((DevicePath)((AGeneticConnectionOptimizer.DPPL)((AGeneticConnectionOptimizer.Connected)((Object)cList.get((int)0))).second).getDpp().first).pathToSubstrate();
                ARect ref = toPath.getLast().getWorldBound(toPath.getParent());
                long dx = Math.abs(((AGeneticConnectionOptimizer.DPPL)((AGeneticConnectionOptimizer.Connected)((Object)cList.get((int)0))).second).getP().xDistance(((AGeneticConnectionOptimizer.DPPL)((AGeneticConnectionOptimizer.Connected)((Object)cList.get((int)1))).second).getP()));
                long dy = Math.abs(((AGeneticConnectionOptimizer.DPPL)((AGeneticConnectionOptimizer.Connected)((Object)cList.get((int)0))).second).getP().yDistance(((AGeneticConnectionOptimizer.DPPL)((AGeneticConnectionOptimizer.Connected)((Object)cList.get((int)1))).second).getP()));
                int q = AGeomUtil.getQuadrant((APoint2D)((AGeneticConnectionOptimizer.DPPL)((AGeneticConnectionOptimizer.Connected)((Object)cList.get((int)0))).second).getP(), (ARect)ref);
                if (q == 0 || q == 2) {
                    fitness += (double)(dx * 2L + dy);
                    continue;
                }
                fitness += (double)(dy * 2L + dx);
            }
            fitness = diffList.size() > 0 ? (fitness /= (double)diffList.size()) : 0.0;
            return fitness;
        }

        @Override
        public void finish(AGeneticConnectionOptimizer.ConnectedChromosome c) {
        }
    }

    public static class BankFitness
    extends WeightedGoalFunction {
        static final long OutOfNeighborhoodFactor = 10L;
        HashMap<HierPin, APoint2D> pinToP = new HashMap();

        @Override
        public void init(AGeneticConnectionOptimizer.ConnectedChromosome c) {
            for (AGeneticConnectionOptimizer.Connected cI : c) {
                if (cI.second == null) continue;
                APoint2D p = ((AGeneticConnectionOptimizer.DPPL)cI.second).getDpp().getWorldLoc();
                this.pinToP.put(((AGeneticConnectionOptimizer.DPPL)cI.second).getDpp(), p);
            }
        }

        @Override
        public String name() {
            return "Personality Separation";
        }

        @Override
        public String toolTip() {
            return "Groups";
        }

        @Override
        public Color color() {
            return Color.green;
        }

        @Override
        public double fitness(AGeneticConnectionOptimizer.ConnectedChromosome c) {
            HashMap<Personality, APolygon> maps = new HashMap<Personality, APolygon>();
            for (AGeneticConnectionOptimizer.Connected cI : c) {
                if (cI.first == null || cI.second == null) continue;
                Personality p = cI.getFrom().getDpp().getPin().getPersonality();
                APoint2D pt = this.pinToP.get(cI.getTo().getDpp());
                APolygon poly = (APolygon)maps.get(p);
                if (poly == null) {
                    poly = new APolygon(new APoint2D[]{pt});
                } else {
                    poly.addPoint(pt);
                }
                maps.put(p, poly);
            }
            double fitness = 0.0;
            for (AGeneticConnectionOptimizer.Connected cI : c) {
                if (cI.first == null || cI.second == null) continue;
                Personality p = cI.getFrom().getDpp().getPin().getPersonality();
                APoint2D pt = this.pinToP.get(cI.getTo().getDpp());
                APolygon poly = (APolygon)maps.get(p);
                long distance = pt.distance(poly.getBounds().center());
                for (APolygon ps : maps.values()) {
                    if (ps != poly && ps.pointInside(pt)) {
                        distance *= 10L;
                    }
                    distance += cI.length();
                }
                fitness += (double)distance;
            }
            return fitness;
        }

        @Override
        public void finish(AGeneticConnectionOptimizer.ConnectedChromosome c) {
        }
    }

    protected static class RoutabilityFitness
    extends WeightedGoalFunction {
        protected RoutabilityFitness() {
        }

        @Override
        public void init(AGeneticConnectionOptimizer.ConnectedChromosome c) {
        }

        @Override
        public String name() {
            return "Routability";
        }

        @Override
        public String toolTip() {
            return "Maximizes routability";
        }

        @Override
        public Color color() {
            return Color.blue;
        }

        @Override
        public double fitness(AGeneticConnectionOptimizer.ConnectedChromosome c) {
            double fitness = 0.0;
            for (AGeneticConnectionOptimizer.Connected cI : c) {
                if (cI.first == null || cI.second == null) continue;
                fitness += (double)cI.length();
            }
            return fitness;
        }

        @Override
        public void finish(AGeneticConnectionOptimizer.ConnectedChromosome c) {
        }
    }
}

