/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.align_device_footprint;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.AVector;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.ObjectCopyOrMoveUI;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;

public class AlignDeviceToFootprint {
    LinkedList<MovedDevice> mMovedDevices = new LinkedList();

    public void addMovedDevice(MovedDevice movedDevice) {
        this.mMovedDevices.add(movedDevice);
    }

    public void autoMoveDevices() {
        this.mMovedDevices.forEach(MovedDevice::moveDevice);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    private static class ContactedPortPair {
        private DevicePath devicePathA;
        private PortTemplate portA;
        private DevicePath devicePathB;
        private PortTemplate portB;

        ContactedPortPair(DevicePath devicePathA, PortTemplate portA, DevicePath devicePathB, PortTemplate portB) {
            this.devicePathA = devicePathA;
            this.portA = portA;
            this.devicePathB = devicePathB;
            this.portB = portB;
        }

        public APair<Long, Long> getPortsDistance() {
            APoint2D pointA = this.getWorldPointA();
            APoint2D pointB = this.getWorldPointB();
            long dx = pointB.xDistance(pointA);
            long dy = pointB.yDistance(pointA);
            return APair.create((Object)dx, (Object)dy);
        }

        public boolean isContact() {
            AffineTransform deviceWorldXform1 = this.devicePathA.getTransform();
            AffineTransform deviceWorldXform2 = this.devicePathB.getTransform();
            AGeom rec1 = this.portA.getBounds().transform(deviceWorldXform1);
            AGeom rec2 = this.portB.getBounds().transform(deviceWorldXform2);
            return rec1.intersects(rec2);
        }

        public String getPortAStr() {
            return this.getPortStr(this.devicePathA, this.portA);
        }

        public String getPortBStr() {
            return this.getPortStr(this.devicePathB, this.portB);
        }

        public APoint2D getWorldPointA() {
            return this.getWorldPoint(this.devicePathA, this.portA);
        }

        public APoint2D getWorldPointB() {
            return this.getWorldPoint(this.devicePathB, this.portB);
        }

        protected APoint2D getWorldPoint(DevicePath devicePath, PortTemplate port) {
            AffineTransform deviceWorldXform = devicePath.getTransform();
            return port.getLoc().transform(deviceWorldXform);
        }

        protected String getPortStr(DevicePath devPath, PortTemplate port) {
            return String.format("%s.%s.%s", devPath.toString(), port.getPinTemplate().getName(), port.getPortNum());
        }
    }

    public static class MovedDevice {
        DevicePath movedDevicePath;
        LinkedList<ContactedPortPair> contactedPortPairs = new LinkedList();

        public MovedDevice(DeviceTemplate anchor, String movedDeviceStr) {
            this(DevicePath.fromString((Db)anchor.getDb(), (String)movedDeviceStr, (DeviceTemplate)anchor));
        }

        public MovedDevice(String movedDeviceStr) {
            this(DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)movedDeviceStr));
        }

        public MovedDevice(DevicePath movedDevicePath) {
            this.movedDevicePath = movedDevicePath;
        }

        public void addContactedPortPair(String devicePathAStr, PortTemplate portA, String devicePathBStr, PortTemplate portB) {
            DeviceTemplate root = this.movedDevicePath.getRoot();
            Db db = root.getDb();
            DevicePath devicePathA = DevicePath.fromString((Db)db, (String)devicePathAStr, (DeviceTemplate)root);
            DevicePath devicePathB = DevicePath.fromString((Db)db, (String)devicePathBStr, (DeviceTemplate)root);
            this.addContactedPortPair(new ContactedPortPair(devicePathA, portA, devicePathB, portB));
        }

        public void addContactedPortPair(DevicePath devicePathA, PortTemplate portA, DevicePath devicePathB, PortTemplate portB) {
            this.addContactedPortPair(new ContactedPortPair(devicePathA, portA, devicePathB, portB));
        }

        public void addContactedPortPair(ContactedPortPair contactPortPair) {
            this.contactedPortPairs.addLast(contactPortPair);
        }

        public Device getMovedDevice() {
            return this.movedDevicePath.getDevice();
        }

        public void moveDevice() {
            if (this.contactedPortPairs.isEmpty()) {
                ALog.logWarn((String)"No contacted ports for device %s", (Object[])new Object[]{this.movedDevicePath});
                return;
            }
            this.setDeviceMirrorAndFlipped();
            this.setDeviceAngle();
            this.connectFirstContactedPortPair();
            this.checkAllContactedPortPairs();
        }

        public void setDeviceAngle() {
            if (this.contactedPortPairs.size() < 2) {
                return;
            }
            ContactedPortPair firstContact = this.contactedPortPairs.getFirst();
            ContactedPortPair secondContact = this.contactedPortPairs.get(1);
            AVector v1 = new AVector(firstContact.getWorldPointA(), secondContact.getWorldPointA());
            AVector v2 = new AVector(firstContact.getWorldPointB(), secondContact.getWorldPointB());
            double diffAngle = this.getVectorsAngle(v1, v2);
            this.movedDevicePath.getDevice().rotBy((float)diffAngle);
        }

        public void setDeviceMirrorAndFlipped() {
            AVector vB2;
            AVector vB1;
            double crossB;
            AVector vA2;
            if (this.contactedPortPairs.size() < 3) {
                return;
            }
            ContactedPortPair firstContact = this.contactedPortPairs.getFirst();
            ContactedPortPair secondContact = this.contactedPortPairs.get(1);
            ContactedPortPair lastContact = this.contactedPortPairs.getLast();
            AVector vA1 = new AVector(firstContact.getWorldPointA(), secondContact.getWorldPointA());
            double crossA = vA1.cross(vA2 = new AVector(firstContact.getWorldPointA(), lastContact.getWorldPointA()));
            if (crossA * (crossB = (vB1 = new AVector(firstContact.getWorldPointB(), secondContact.getWorldPointB())).cross(vB2 = new AVector(firstContact.getWorldPointB(), lastContact.getWorldPointB()))) < 0.0) {
                this.getMovedDevice().setMirror(!this.getMovedDevice().getMirror());
                this.getMovedDevice().setFlipped(this.getMovedDevice().getMirror());
            }
        }

        public void connectFirstContactedPortPair() {
            ContactedPortPair firstContact = this.contactedPortPairs.getFirst();
            APair<Long, Long> distance = firstContact.getPortsDistance();
            ObjectCopyOrMoveUI.moveDeviceRelative(this.movedDevicePath, this.movedDevicePath.getDevice(), (long)((Long)distance.first), (long)((Long)distance.second), 0.0f, false);
        }

        public void checkAllContactedPortPairs() {
            boolean success = true;
            for (ContactedPortPair c : this.contactedPortPairs) {
                if (c.isContact()) continue;
                ALog.logError((String)"Port %s cannot contact with Port %s", (Object[])new Object[]{c.getPortAStr(), c.getPortBStr()});
                success = false;
            }
            if (!success) {
                ALog.logError((String)"Cannot contact with every ports when moving the device %s", (Object[])new Object[]{this.movedDevicePath});
            }
        }

        private double getVectorsAngle(AVector v1, AVector v2) {
            double angle1 = Math.toDegrees(v1.angle());
            double angle2 = Math.toDegrees(v2.angle());
            return (angle2 - angle1 + 360.0) % 360.0;
        }
    }
}

