/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.align_device_footprint;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AlignDeviceToFootprintMode
extends AbstractViewMode {
    public static final String MODE_KEY = "AlignDeviceToFootprintMode";
    public static final String MODE_NAME = "Align device to footprints";
    private Point mCurLoc = null;
    private Db mDb = null;
    private PortGetter mContactStart = null;
    private PortGetter mContactEnd = null;
    private PortGetter mOverPort = null;
    private int mNthPort = 0;
    private JDialog mDialog = null;
    private boolean mWasVisible;
    private JLabel mFromPortName;
    private JLabel mToPortName;
    private JPanel panelOkButton = new JPanel();
    private JTable mTable;
    private ContactPortList mContactPortListModel;
    private static final int MOVE_DEV_COLUMN = 0;
    private static final int FROM_PORT_COLUMN = 1;
    private static final int TO_PORT_COLUMN = 2;
    private static final int REMOVE_COLUMN = 3;
    private static Color mStartColor = Color.red.darker();
    private static Color mEndColor = Color.blue.darker();
    private DesignView2D.ViewMode oldMode = null;
    protected ActionListener mOkHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlignDeviceToFootprintMode.this.mContactPortListModel.contactPortRows.isEmpty()) {
                UIUtil.closeWindow((Window)AlignDeviceToFootprintMode.this.mDialog);
                return;
            }
            Cp.exec((String)"unset(\"_autoMounting\");", (Object[])new Object[0]);
            Cp.exec((String)"_autoMounting = new com.sigrity.orbit.automation.align_device_footprint.AlignDeviceToFootprint();", (Object[])new Object[0]);
            DevicePath curPath = null;
            for (ContactPortDef contactPortDef : AlignDeviceToFootprintMode.this.mContactPortListModel.contactPortRows) {
                if (!contactPortDef.moveDevice.equals(curPath)) {
                    if (curPath != null) {
                        Cp.exec((String)"_autoMounting.addMovedDevice(_mountedDevice);", (Object[])new Object[0]);
                    }
                    Cp.exec((String)"_mountedDevice = new com.sigrity.orbit.automation.align_device_footprint.AlignDeviceToFootprint.MovedDevice(\"%s\")", (Object[])new Object[]{contactPortDef.moveDevice.toString()});
                    curPath = contactPortDef.moveDevice;
                }
                String portAGetByKeyStr = String.format("curDb().getByKeyStr(PortTemplate.class, \"%s\")", contactPortDef.portA.getKeyStr());
                String portBGetByKeyStr = String.format("curDb().getByKeyStr(PortTemplate.class, \"%s\")", contactPortDef.portB.getKeyStr());
                Cp.exec((String)"_mountedDevice.addContactedPortPair(\"%s\", %s, \"%s\", %s);", (Object[])new Object[]{contactPortDef.devicePathA.toString(), portAGetByKeyStr, contactPortDef.devicePathB.toString(), portBGetByKeyStr});
            }
            Cp.exec((String)"_autoMounting.addMovedDevice(_mountedDevice);", (Object[])new Object[0]);
            Cp.exec((String)"_autoMounting.autoMoveDevices();", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_autoMounting\");", (Object[])new Object[0]);
            UIUtil.closeWindow((Window)AlignDeviceToFootprintMode.this.mDialog);
        }
    };
    protected Action backMode = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AlignDeviceToFootprintMode.this.mContactStart != null) {
                AlignDeviceToFootprintMode.this.mContactStart = null;
            }
            AlignDeviceToFootprintMode.this.updateStatus();
        }
    };
    protected Action incrPin = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ++AlignDeviceToFootprintMode.this.mNthPort;
            AlignDeviceToFootprintMode.this.mOverPort = new PortGetter(AlignDeviceToFootprintMode.this.mCurLoc, AlignDeviceToFootprintMode.this.mNthPort);
            AlignDeviceToFootprintMode.this.repaintOverlay();
            AlignDeviceToFootprintMode.this.updateStatus();
        }
    };
    ComponentListener mViewComponentListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent e) {
            AlignDeviceToFootprintMode.this.mWasVisible = AlignDeviceToFootprintMode.this.mDialog.isVisible();
            AlignDeviceToFootprintMode.this.mDialog.setVisible(false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (AlignDeviceToFootprintMode.this.mWasVisible) {
                AlignDeviceToFootprintMode.this.mDialog.setVisible(true);
                AlignDeviceToFootprintMode.this.refocusView();
            }
        }
    };

    public static Action getAction() {
        return new AbstractAction(MODE_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignDeviceToFootprintMode.install((DesignView2D)OrbitIO.getCurView());
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void install(DesignView2D view) {
        if (view == null) {
            return;
        }
        view.setMode(new AlignDeviceToFootprintMode());
    }

    @Override
    public void installMode(DesignView2D view) {
        this.oldMode = view.getPriorMode();
        super.installMode(view);
    }

    @Override
    public void uninstallMode() {
        this.oldMode = null;
        this.uninstallMe();
    }

    protected void uninstallMe() {
        if (this.mOverlay != null) {
            this.mView.removeOverlay(this.mOverlay);
        }
        if (this.mDialog != null) {
            UIUtil.closeWindow((Window)this.mDialog);
        }
        super.uninstallMode();
    }

    @Override
    protected void installedMode() {
        if (this.mDialog != null) {
            UIUtil.closeWindow((Window)this.mDialog);
        }
        this.mDb = OrbitIO.getCurDb();
        this.mDialog = new JDialog(OrbitIO.getMainWindow(), MODE_NAME);
        GridBagManager l = new GridBagManager(this.mDialog.getContentPane());
        l.newline();
        l.push("Select Ports", (GridBagConstraints)GridBagManager.FILLALL);
        l.pushFillX();
        l.add((Component)new JLabel("From Port:"));
        this.mFromPortName = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
        this.mFromPortName.setForeground(mStartColor);
        l.popNl();
        l.pushFillX();
        l.add((Component)new JLabel("To Port:"));
        this.mToPortName = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
        this.mToPortName.setForeground(mEndColor);
        l.popNl();
        l.pop();
        l.newline();
        l.push("Contact Ports", (GridBagConstraints)GridBagManager.FILLALL);
        this.mTable = new JTable();
        int columnWidth = 10;
        int desireWidth = 80;
        int desiredHeight = 100;
        this.mTable.setPreferredScrollableViewportSize(new Dimension(desireWidth * columnWidth, desiredHeight));
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setAutoResizeMode(4);
        this.mContactPortListModel = new ContactPortList();
        this.mTable.setModel(this.mContactPortListModel);
        this.mTable.setSelectionMode(0);
        this.mTable.setRowHeight(this.mTable.getRowHeight() + 8);
        TableColumn col = this.mTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(15 * columnWidth);
        col.setIdentifier(0);
        col.setResizable(true);
        col.setCellEditor(new MovedDeviceComboBoxEditor());
        col = this.mTable.getColumnModel().getColumn(1);
        col.setPreferredWidth(25 * columnWidth);
        col.setIdentifier(1);
        col.setResizable(true);
        col = this.mTable.getColumnModel().getColumn(2);
        col.setPreferredWidth(25 * columnWidth);
        col.setIdentifier(2);
        col.setResizable(true);
        col = this.mTable.getColumnModel().getColumn(3);
        col.setPreferredWidth(1 * columnWidth);
        col.setIdentifier(3);
        col.setResizable(true);
        this.mTable.setDefaultRenderer(Object.class, new ContactPortRowRenderer());
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setColumnSelectionAllowed(true);
        this.mTable.addMouseListener(new TableButtonMouseListener(this.mTable));
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
        l.pop();
        l.newline();
        this.mContactPortListModel.rebuildTable();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        l.addFillX();
        JButton btnOk = new JButton("Ok");
        btnOk.addActionListener(this.mOkHandler);
        this.panelOkButton.add(btnOk);
        l.add((Component)this.panelOkButton);
        l.pop();
        this.updateStatus();
        this.mDialog.pack();
        Rectangle viewBounds = this.mView.getBounds();
        Point p = new Point(viewBounds.x + viewBounds.width / 2 - this.mDialog.getBounds().width / 2, viewBounds.y + viewBounds.height);
        SwingUtilities.convertPointToScreen(p, this.mView.getParent());
        this.mDialog.setLocation(p);
        this.mDialog.setVisible(true);
        this.mDialog.setMinimumSize(this.mDialog.getMinimumSize());
        this.mWasVisible = true;
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AlignDeviceToFootprintMode.this.mView.removeComponentListener(AlignDeviceToFootprintMode.this.mViewComponentListener);
                AlignDeviceToFootprintMode.this.mDialog = null;
                if (AlignDeviceToFootprintMode.this.oldMode != null) {
                    AlignDeviceToFootprintMode.this.mView.setMode(AlignDeviceToFootprintMode.this.oldMode);
                }
                super.windowClosing(e);
            }
        });
        this.mView.addComponentListener(this.mViewComponentListener);
        this.updateStatus();
        this.createKeyBindings();
    }

    protected void createKeyBindings() {
        ((JComponent)this.getViewComponent()).getActionMap().put("NextPin", this.incrPin);
        this.bindKey("N", "NextPin");
        ((JComponent)this.getViewComponent()).getActionMap().put("BackMode", this.backMode);
        this.bindKey("ESCAPE", "BackMode");
    }

    public void bindKey(String key, String action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            ALog.logWarn((String)"Invalid key stroke '%s' specified while attempting to bind key stroketo action '%s'.", (Object[])new Object[]{key, action});
            return;
        }
        InputMap inputMap = ((JComponent)this.getViewComponent()).getInputMap(1);
        inputMap.put(keyStroke, action);
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        this.mCurLoc = e.getPoint();
        this.mOverPort = new PortGetter(this.mCurLoc, this.mNthPort);
        if (this.mOverPort.mHierPort == null) {
            this.mNthPort = 0;
        }
        this.updateStatus();
        this.repaintOverlay();
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.mouseMoved(e);
        PortGetter c = this.mOverPort;
        if (!c.validPort()) {
            return;
        }
        if (this.mContactStart == null) {
            if (c.mHierPort != null) {
                this.mContactStart = c;
            }
        } else if (c.getPinPath().equals((Object)this.mContactStart.getPinPath())) {
            ALog.logError((String)"Cannot mount two ports on the same device.");
        } else if (c.mHierPort != null) {
            this.mContactEnd = c;
            this.mContactPortListModel.setRow(this.mContactStart.mHierPort, this.mContactEnd.mHierPort);
            this.mContactPortListModel.rebuildTable();
            this.mContactEnd = null;
            this.mContactStart = null;
        }
        this.repaintOverlay();
        this.updateStatus();
    }

    @Override
    public String getName() {
        return MODE_NAME;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    protected void updateStatus() {
        if (this.mOverPort != null && this.mOverPort.mHierPort != null) {
            PortTemplate pt = (PortTemplate)this.mOverPort.mHierPort.second;
            DevicePath path = (DevicePath)this.mOverPort.mHierPort.first;
            if (this.mContactStart == null) {
                Icon icon = DbExplorerPanel.getIconForPinTemplate(pt.getPinTemplate());
                this.mFromPortName.setIcon(icon);
                String fromPinNameStr = String.format("%s.%s on %s", pt.getPinTemplate().getName(), pt.getPortNum(), path.getLast().getName());
                this.mFromPortName.setText(fromPinNameStr);
                this.mToPortName.setText(" ");
                this.mToPortName.setIcon(null);
            } else {
                Icon icon = DbExplorerPanel.getIconForPinTemplate(pt.getPinTemplate());
                this.mToPortName.setIcon(icon);
                String toPinNameStr = String.format("%s.%s on %s", pt.getPinTemplate().getName(), pt.getPortNum(), path.getLast().getName());
                this.mToPortName.setText(toPinNameStr);
            }
        } else if (this.mContactStart == null) {
            this.mFromPortName.setText(" ");
            this.mFromPortName.setIcon(DBEResources.ICON_UNKNOWN);
        } else {
            this.mToPortName.setText(" ");
            this.mToPortName.setIcon(DBEResources.ICON_UNKNOWN);
        }
        this.refocusView();
    }

    protected void refocusView() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AlignDeviceToFootprintMode.this.mDialog.isActive()) {
                    UIUtil.getParentWindow((Component)AlignDeviceToFootprintMode.this.mView).setVisible(true);
                }
            }
        });
    }

    public class MovedDeviceComboBoxEditor
    extends DefaultCellEditor {
        private DefaultComboBoxModel<DevicePath> model;

        public MovedDeviceComboBoxEditor() {
            super(new JComboBox());
            this.model = (DefaultComboBoxModel)((JComboBox)this.getComponent()).getModel();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (column == 0) {
                this.model.removeAllElements();
                ContactPortDef def = AlignDeviceToFootprintMode.this.mContactPortListModel.getRow(row);
                DevicePath candidatePath = new DevicePath(def.devicePathA);
                while (!candidatePath.isEmpty() && !candidatePath.equals((Object)def.getPortsCommonAnsector())) {
                    this.model.addElement(new DevicePath(candidatePath));
                    candidatePath.removeLast();
                }
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    class TableButtonMouseListener
    extends MouseAdapter {
        protected JTable table;

        public TableButtonMouseListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                TableColumn moveDeviceColumn;
                DevicePath newPath;
                int row = e.getY() / this.table.getRowHeight();
                if (row >= AlignDeviceToFootprintMode.this.mContactPortListModel.getRowCount()) {
                    return;
                }
                TableColumnModel columnModel = this.table.getColumnModel();
                int column = columnModel.getColumnIndexAtX(e.getX());
                if (column == 3) {
                    AlignDeviceToFootprintMode.this.mContactPortListModel.removeRow(row);
                    AlignDeviceToFootprintMode.this.mTable.repaint();
                }
                if (column == 0 && (newPath = (DevicePath)(moveDeviceColumn = columnModel.getColumn(column)).getCellEditor().getCellEditorValue()) != null) {
                    ContactPortDef def = AlignDeviceToFootprintMode.this.mContactPortListModel.getRow(row);
                    def.moveDevice = newPath;
                    AlignDeviceToFootprintMode.this.mTable.repaint();
                }
            }
        }
    }

    static class ContactPortDef
    implements Comparable<ContactPortDef> {
        DevicePath devicePathA;
        PortTemplate portA;
        DevicePath devicePathB;
        PortTemplate portB;
        DevicePath moveDevice;

        ContactPortDef(HierInst<PortTemplate> fromPort, HierInst<PortTemplate> toPort) {
            this.devicePathA = fromPort.getPath();
            this.portA = fromPort.getPortTemplate();
            this.devicePathB = toPort.getPath();
            this.portB = toPort.getPortTemplate();
            this.setDefaultMovedDevice();
        }

        public String getPortAStr() {
            return this.getPortStr(this.devicePathA, this.portA);
        }

        public String getPortBStr() {
            return this.getPortStr(this.devicePathB, this.portB);
        }

        public String getPortStr(DevicePath devPath, PortTemplate port) {
            return String.format("%s.%s.%s", devPath.toString(), port.getPinTemplate().getName(), port.getPortNum());
        }

        public DevicePath getPortsCommonAnsector() {
            return this.devicePathA.commonAnscestor(this.devicePathB);
        }

        @Override
        public int compareTo(ContactPortDef o) {
            return this.moveDevice.compareTo(o.moveDevice);
        }

        private void setDefaultMovedDevice() {
            int endIdx = DevicePath.getDepth((DevicePath)this.getPortsCommonAnsector()) + 1;
            this.moveDevice = this.devicePathA.getSubPath(0, endIdx);
        }
    }

    public class ContactPortRowRenderer
    extends DefaultTableCellRenderer {
        protected ArrayList<PinTemplate> ioPorts = null;
        protected DeviceTemplate lastDT = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            ContactPortDef def = AlignDeviceToFootprintMode.this.mContactPortListModel.getRow(row);
            this.setIcon(null);
            this.setText(null);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            this.setToolTipText("");
            if (isSelected) {
                this.setBackground(Color.orange);
            }
            if (column == 0) {
                this.setText(def.moveDevice.toString());
            } else if (column == 1) {
                this.setText(def.getPortAStr());
            } else if (column == 2) {
                this.setText(def.getPortBStr());
            } else if (column == 3) {
                this.setIcon(OrbitIcons.DELETE);
            }
            return this;
        }
    }

    class ContactPortList
    extends AbstractTableModel {
        LinkedList<ContactPortDef> contactPortRows = new LinkedList();
        private String[] columnNames = new String[]{"Move Device", "From port", "To port", ""};

        public ContactPortDef getRow(int row) {
            if (row < this.contactPortRows.size()) {
                return this.contactPortRows.get(row);
            }
            return null;
        }

        public void setRow(ContactPortDef contactPortDef) {
            this.contactPortRows.add(contactPortDef);
        }

        public void setRow(HierInst<PortTemplate> fromPort, HierInst<PortTemplate> toPort) {
            this.setRow(new ContactPortDef(fromPort, toPort));
        }

        public void removeRow(ContactPortDef contactPortDef) {
            this.contactPortRows.remove(contactPortDef);
        }

        public void removeRow(int row) {
            this.contactPortRows.remove(row);
        }

        public void rebuildTable() {
            AlignDeviceToFootprintMode.this.mTable.clearSelection();
            Collections.sort(this.contactPortRows);
            AlignDeviceToFootprintMode.this.mTable.repaint();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public int getRowCount() {
            return this.contactPortRows.size();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (value == null) {
                return;
            }
            if (col == 0) {
                ContactPortDef contactPort = this.contactPortRows.get(row);
                contactPort.moveDevice = (DevicePath)value;
                this.rebuildTable();
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }
    }

    protected class PortGetter {
        APoint2D mWorldClick;
        HierInst<PortTemplate> mHierPort = null;
        LinkedList<HierInst<PortTemplate>> portsAtLoc = new LinkedList();

        public APoint2D getWorldClick() {
            return this.mWorldClick;
        }

        public Point getScreenSnap() {
            APoint2D w = ((PortTemplate)this.mHierPort.getDbObject()).getCenterLoc((DevicePath)this.mHierPort.first);
            return AlignDeviceToFootprintMode.this.mView.getCanvas().getXForm().getScreenPt(w);
        }

        public boolean validPort() {
            return this.mHierPort != null && this.mHierPort.isValid();
        }

        public PinTemplate getPinTemplate() {
            if (this.mHierPort != null) {
                return ((PortTemplate)this.mHierPort.second).getPinTemplate();
            }
            return null;
        }

        public DevicePath getPinPath() {
            if (this.mHierPort != null) {
                return (DevicePath)this.mHierPort.first;
            }
            return null;
        }

        public PortGetter(Point screenPt, int nth) {
            this.mWorldClick = AlignDeviceToFootprintMode.this.mView.getCanvas().getWorldPt(screenPt);
            Db db = AlignDeviceToFootprintMode.this.mView.getDb();
            Design design = Design.getDesign((Db)db, (boolean)false);
            if (design == null) {
                return;
            }
            this.mHierPort = null;
            for (HierInst hdbo : design.getObjectsAt(this.mWorldClick)) {
                PortTemplate portT;
                DevicePath dp = hdbo.getPath();
                DbObject dbo = hdbo.getDbObject();
                if (!(dbo instanceof PortTemplate) || !this.visiblePort(portT = (PortTemplate)dbo)) continue;
                PinTemplate pinTemplate = portT.getPinTemplate();
                PinInstance pinInstance = dp.getLast().getPin(pinTemplate);
                if (AlignDeviceToFootprintMode.this.mContactStart != null && pinInstance.fixed()) continue;
                this.portsAtLoc.add((HierInst<PortTemplate>)new HierInst(dp, (DbObject)portT));
            }
            if (!this.portsAtLoc.isEmpty()) {
                this.mHierPort = this.portsAtLoc.get(nth %= this.portsAtLoc.size());
            }
        }

        private boolean visiblePort(PortTemplate port) {
            ViewColorizer col = OrbitIO.getCurColorizer();
            for (Layer l : port.getLayers()) {
                ViewColorizer.LayerKey key = col.getLayerKey(l, true);
                if (!col.getDisplay(null, (ViewColorizer.Key)key)) continue;
                return true;
            }
            return false;
        }
    }
}

