/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.connOpt;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizationControllerThread;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizationUpdateFunction;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizer;
import com.sigrity.acl.optimizer.genetic.Chromosome;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.WeightedGoalFunction;
import com.sigrity.orbit.automation.WeightedGoalRegistry;
import com.sigrity.orbit.ui.CanConnectRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class AGeneticConnectionOptimizer {
    protected ArrayList<DPPL> aSet = new ArrayList();
    protected ArrayList<DPPL> bSet = new ArrayList();
    protected ConnectedChromosome connectedList = new ConnectedChromosome();
    protected HashMap<WeightedGoalFunction, FitnessSpectrum> gfToFs = new HashMap();
    protected AGeneticOptimizationUpdateFunction updateFunction;
    protected AGeneticOptimizer go = new AGeneticOptimizer(true, true);
    protected DevicePath dp;
    protected int ith;
    protected Double beginningScore = null;
    public static AGeneticConnectionOptimizer theGCO = null;
    protected AGeneticOptimizationControllerThread evolveThread;
    public Double startScore;
    public Double endScore;
    protected CanConnectRegistry.CanConnectFunction mCCF = null;
    public static int SpectrumSampleSize = 256;

    public AGeneticConnectionOptimizer() {
        theGCO = null;
        this.startScore = null;
        this.endScore = null;
        this.ith = 3141592;
    }

    public void setASet(List<HierPin> set) {
        for (HierPin dpp : set) {
            DPPL dppl = new DPPL();
            dppl.dpp = dpp;
            dppl.p = dpp.getWorldLoc();
            this.aSet.add(dppl);
        }
    }

    public void setBSet(List<HierPin> set) {
        for (HierPin dpp : set) {
            DPPL dppl = new DPPL();
            dppl.dpp = dpp;
            dppl.p = dpp.getWorldLoc();
            this.bSet.add(dppl);
        }
    }

    public void setConnectionCriteria(String name) {
        this.mCCF = CanConnectRegistry.getCCF(name);
        if (this.mCCF == null) {
            ALog.logWarn((String)("There is not Connection Criteria named " + name));
        }
    }

    protected void greedyAssign() {
        DPPL adppl;
        int i;
        Collections.sort(this.aSet);
        Collections.sort(this.bSet);
        for (DPPL a : this.aSet) {
            a.involved = false;
        }
        for (DPPL b : this.bSet) {
            b.involved = false;
        }
        block2: for (i = 0; i < this.aSet.size(); ++i) {
            adppl = this.aSet.get(i);
            if (adppl.involved) continue;
            for (int j = 0; j < this.bSet.size(); ++j) {
                DPPL bdppl = this.bSet.get(j);
                if (bdppl.involved || ((PinInstance)bdppl.dpp.second).fixed() || this.mCCF != null && !this.mCCF.canConnect(adppl.dpp, bdppl.dpp)) continue;
                Connected c = new Connected(adppl, bdppl);
                this.connectedList.add(c);
                adppl.involved = true;
                bdppl.involved = true;
                continue block2;
            }
        }
        for (i = 0; i < this.aSet.size(); ++i) {
            adppl = this.aSet.get(i);
            if (adppl.involved) continue;
            Connected c = new Connected(adppl, null);
            this.connectedList.add(c);
            adppl.involved = true;
        }
        for (i = 0; i < this.bSet.size(); ++i) {
            DPPL bdppl = this.bSet.get(i);
            if (bdppl.involved || ((PinInstance)bdppl.dpp.second).fixed()) continue;
            Connected c = new Connected(null, bdppl);
            this.connectedList.add(c);
            bdppl.involved = true;
        }
    }

    public AGeneticOptimizationControllerThread optimizeGenetically(long seconds, int maxPopulation) {
        this.greedyAssign();
        if (this.connectedList.size() < 200) {
            maxPopulation *= 10;
        }
        this.developFitnessSpectrum();
        this.go.setMaxPopulation(maxPopulation);
        for (int i = 0; i < maxPopulation; ++i) {
            this.go.addChromosome(this.connectedList.deepCopy(), null);
        }
        for (WeightedGoalFunction gf : WeightedGoalRegistry.getRegistry()) {
            if (!(gf.getWeight() > 0.0)) continue;
            gf.init(this.connectedList);
        }
        this.evolveThread = new AGeneticOptimizationControllerThread(this.go, seconds, OrbitIO.getCurDb().toString());
        this.evolveThread.start();
        return this.evolveThread;
    }

    protected void greedyEnd() {
    }

    protected void developFitnessSpectrum() {
        this.gfToFs.clear();
        for (WeightedGoalFunction gf : WeightedGoalRegistry.getRegistry()) {
            if (!(gf.getWeight() > 0.0)) continue;
            this.gfToFs.put(gf, new FitnessSpectrum());
            gf.init(this.connectedList);
        }
        for (WeightedGoalFunction gf : WeightedGoalRegistry.getRegistry()) {
            if (!(gf.getWeight() > 0.0)) continue;
            ConnectedChromosome best = (ConnectedChromosome)this.connectedList.deepCopy();
            FitnessSpectrum fs = this.gfToFs.get(gf);
            for (int i = 0; i < SpectrumSampleSize; ++i) {
                double f0 = gf.fitness(best);
                fs.fitness(f0);
                ConnectedChromosome mutant = this.connectedList.mutate();
                double f1 = gf.fitness(mutant);
                fs.fitness(f1);
                if (!(f1 < f0)) continue;
                best = mutant;
            }
            fs.expandSpectrum(0.5);
        }
    }

    public ArrayList<APair<HierPin, HierPin>> getConnected() {
        ArrayList<APair<HierPin, HierPin>> ret = new ArrayList<APair<HierPin, HierPin>>();
        ConnectedChromosome best = (ConnectedChromosome)this.go.getBestIndividual();
        for (Connected conn : best) {
            if (conn.first == null || conn.second == null) continue;
            HierPin a = ((DPPL)conn.first).dpp;
            HierPin b = ((DPPL)conn.second).dpp;
            APair pair = new APair((Object)a, (Object)b);
            ret.add((APair<HierPin, HierPin>)pair);
        }
        return ret;
    }

    public class ConnectedChromosome
    extends ArrayList<Connected>
    implements Chromosome {
        protected Random mRandom;

        public ConnectedChromosome() {
            this.mRandom = new Random(AGeneticConnectionOptimizer.this.ith++);
        }

        @Override
        public void endOfEpoch() {
        }

        @Override
        public int length() {
            return this.size();
        }

        @Override
        public double fitness() {
            double fitness = 0.0;
            for (WeightedGoalFunction gf : WeightedGoalRegistry.getRegistry()) {
                if (!(gf.getWeight() > 0.0)) continue;
                FitnessSpectrum fs = AGeneticConnectionOptimizer.this.gfToFs.get(gf);
                double thisFitness = gf.fitness(this);
                double relativeFitness = fs.spectrumFitness(thisFitness);
                fitness += relativeFitness * gf.getWeight();
            }
            return fitness;
        }

        @Override
        public Chromosome mate(Chromosome c) {
            return null;
        }

        @Override
        public ConnectedChromosome mutate() {
            ConnectedChromosome mutant = (ConnectedChromosome)this.deepCopy();
            mutant.mRandom = this.mRandom;
            boolean success = false;
            while (!success) {
                int rJ;
                int rI = mutant.mRandom.nextInt(mutant.size());
                if (rI == (rJ = mutant.mRandom.nextInt(mutant.size()))) continue;
                Connected cI = (Connected)((Object)mutant.get(rI));
                Connected cJ = (Connected)((Object)mutant.get(rJ));
                if (cI.second != null && ((PinInstance)((DPPL)cI.second).dpp.second).fixed() || AGeneticConnectionOptimizer.this.mCCF != null && (cI.first != null && cJ.second != null && !AGeneticConnectionOptimizer.this.mCCF.canConnect(((DPPL)cI.first).dpp, ((DPPL)cJ.second).dpp) || cI.second != null && cJ.first != null && !AGeneticConnectionOptimizer.this.mCCF.canConnect(((DPPL)cJ.first).dpp, ((DPPL)cI.second).dpp))) continue;
                cI.swap(cJ);
                success = true;
            }
            return mutant;
        }

        @Override
        public Chromosome deepCopy() {
            ConnectedChromosome clone = new ConnectedChromosome();
            int i = 0;
            for (Connected c : this) {
                Connected cClone = c.deepCopy();
                clone.add(i++, cClone);
            }
            return clone;
        }

        @Override
        public void updateCondition(String owner, long time) {
        }
    }

    public static class Connected
    extends APair<DPPL, DPPL> {
        public Connected deepCopy() {
            DPPL from = null;
            DPPL to = null;
            if (this.first != null) {
                from = new DPPL((DPPL)this.first);
            }
            if (this.second != null) {
                to = new DPPL((DPPL)this.second);
            }
            return new Connected(from, to);
        }

        public Connected(DPPL a, DPPL b) {
            super((Object)a, (Object)b);
        }

        public DPPL getFrom() {
            return (DPPL)this.first;
        }

        public DPPL getTo() {
            return (DPPL)this.second;
        }

        public ALine line() {
            return new ALine(((DPPL)this.first).p, ((DPPL)this.second).p);
        }

        public void swap(Connected b) {
            DPPL t = (DPPL)this.second;
            this.second = b.second;
            b.second = t;
        }

        public boolean cross(Connected b) {
            return this.line().intersects((AGeom)b.line());
        }

        public long length() {
            return this.line().getLength();
        }

        public boolean connected() {
            return this.first != null && this.second != null;
        }
    }

    public static class DPPL
    implements Comparable<DPPL> {
        protected HierPin dpp;
        protected APoint2D p = new APoint2D();
        protected int color;
        protected int match;
        protected boolean involved = false;
        protected APoint2D oc = new APoint2D();

        public DPPL() {
        }

        public DPPL(DPPL src) {
            this.dpp = new HierPin(src.dpp);
            this.p = src.p;
            this.oc = src.oc;
            this.color = src.color;
            this.match = src.match;
            this.involved = src.involved;
        }

        @Override
        public int compareTo(DPPL o) {
            return this.p.compareTo(o.p);
        }

        public HierPin getDpp() {
            return this.dpp;
        }

        public APoint2D getP() {
            return this.p;
        }

        public boolean isInvolved() {
            return this.involved;
        }
    }

    public static class FitnessSpectrum {
        Double minFitness = null;
        Double maxFitness = null;
        Double thisFitness = null;
        LinkedList<Double> history = new LinkedList();

        public void fitness(double f) {
            if (this.thisFitness == null) {
                this.minFitness = f;
                this.maxFitness = f;
            } else {
                this.maxFitness = Math.max(f, this.maxFitness);
                this.minFitness = Math.min(f, this.minFitness);
            }
            this.thisFitness = f;
        }

        public void expandSpectrum(double d) {
            double span = this.maxFitness - this.minFitness;
            this.maxFitness = this.maxFitness + span * d;
            this.minFitness = this.minFitness - span * d;
        }

        public double spectrumFitness(double d) {
            double spread = this.maxFitness - this.minFitness;
            if (spread > 0.0) {
                return (d - this.minFitness) / (this.maxFitness - this.minFitness);
            }
            return 0.0;
        }
    }
}

