/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.connOpt;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.optimizer.genetic.Chromosome;
import com.sigrity.acl.optimizer.genetic.GeneticOptimization;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizationControllerThread;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizerBroker;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class GeneticConnectionOptimizer {
    protected ArrayList<DPPL> aSet = new ArrayList();
    protected ArrayList<DPPL> bSet = new ArrayList();
    protected ConnectedChromosome connectedList = new ConnectedChromosome();
    protected ColorMgr colorMgr = new ColorMgr();
    protected ColorMgr matchMgr = new ColorMgr();
    GeneticOptimization go = new GeneticOptimization(true, true);
    protected DevicePath dp;
    int ith;
    protected Double beginningScore = null;
    public static GeneticConnectionOptimizer theGCO = null;
    public Double startScore;
    public Double endScore;

    public GeneticConnectionOptimizer() {
        theGCO = null;
        this.startScore = null;
        this.endScore = null;
        this.ith = 3141592;
    }

    public void setASet(List<HierPin> set) {
        for (HierPin dpp : set) {
            Boolean matchLength;
            DPPL dppl = new DPPL();
            dppl.dpp = dpp;
            dppl.p = dpp.getWorldLoc();
            DevicePath diePath = null;
            diePath = dpp.getPath();
            dppl.oc = diePath.getBB().center();
            Personality p = dpp.getPin().getPersonality();
            dppl.color = p != null ? this.colorMgr.addColor(p.getName(), p) : this.colorMgr.addColor("noColor", null);
            dppl.match = this.matchMgr.addColor("noMatch", null);
            DevicePath stopPathA = dpp.getPath().pathToSubstrate();
            Net netA = NetMap.getTopmostNet((Net)dpp.getNet(), (DevicePath)stopPathA);
            Personality pNet = netA.getPersonality();
            if (pNet != null && (matchLength = (Boolean)Constraint.getValue((Db)pNet.getDb(), (DbObject)pNet, (Constraint.Descriptor)Constraint.NET_MATCHLENGTH)) != null && matchLength.booleanValue()) {
                dppl.match = this.matchMgr.addColor(pNet.getName(), dpp);
            }
            this.aSet.add(dppl);
        }
    }

    public void setBSet(List<HierPin> set) {
        for (HierPin dpp : set) {
            DPPL dppl = new DPPL();
            dppl.dpp = dpp;
            dppl.p = dpp.getWorldLoc();
            Personality p = dpp.getPin().getPersonality();
            dppl.color = p != null ? this.colorMgr.addColor(p.getName(), p) : this.colorMgr.addColor("noColor", null);
            this.bSet.add(dppl);
        }
    }

    protected Double getCurrentScoreBasedOnNets() {
        for (DPPL a : this.aSet) {
            a.involved = false;
        }
        for (DPPL b : this.bSet) {
            b.involved = false;
        }
        boolean matchFound = false;
        ConnectedChromosome test = new ConnectedChromosome();
        for (int colorIndex = 0; colorIndex < this.colorMgr.size(); ++colorIndex) {
            Connected c;
            int i;
            for (DPPL a : this.aSet) {
                if (a.color != colorIndex) continue;
                matchFound = false;
                Net tnet = a.dpp.getTopMostNet();
                for (DPPL b : this.bSet) {
                    if (b.color != colorIndex || b.dpp.getTopMostNet() != tnet) continue;
                    if (b.involved) {
                        ALog.logWarn((String)("For Personality " + this.colorMgr.colors.get(colorIndex) + " there are multiple pins for net " + tnet.getName()));
                        continue;
                    }
                    if (matchFound) {
                        ALog.logWarn((String)("For Personality " + this.colorMgr.colors.get(colorIndex) + " there are multiple pins for net " + tnet.getName()));
                        continue;
                    }
                    a.involved = true;
                    b.involved = true;
                    Connected c2 = new Connected(a, b);
                    test.add(c2);
                    matchFound = true;
                }
                if (matchFound) continue;
                return null;
            }
            for (i = 0; i < this.aSet.size(); ++i) {
                DPPL adppl = this.aSet.get(i);
                if (adppl.color != colorIndex || adppl.involved) continue;
                c = new Connected(adppl, null);
                test.add(c);
            }
            for (i = 0; i < this.bSet.size(); ++i) {
                DPPL bdppl = this.bSet.get(i);
                if (bdppl.color != colorIndex || bdppl.involved) continue;
                c = new Connected(null, bdppl);
                test.add(c);
                bdppl.involved = true;
            }
        }
        double dpl = test.diffPairFitness();
        double l = test.lengthFitness();
        if (dpl != 0.0) {
            return dpl / 1000.0;
        }
        return l / 1000.0;
    }

    protected void greedyAssign() {
        Collections.sort(this.aSet);
        Collections.sort(this.bSet);
        for (DPPL a : this.aSet) {
            a.involved = false;
        }
        for (DPPL b : this.bSet) {
            b.involved = false;
        }
        for (int colorIndex = 0; colorIndex < this.colorMgr.size(); ++colorIndex) {
            DPPL adppl;
            int i;
            block3: for (i = 0; i < this.aSet.size(); ++i) {
                adppl = this.aSet.get(i);
                if (adppl.involved || adppl.color != colorIndex) continue;
                for (int j = 0; j < this.bSet.size(); ++j) {
                    DPPL bdppl = this.bSet.get(j);
                    if (bdppl.involved || bdppl.color != colorIndex) continue;
                    Connected c = new Connected(adppl, bdppl);
                    this.connectedList.add(c);
                    adppl.involved = true;
                    bdppl.involved = true;
                    continue block3;
                }
            }
            for (i = 0; i < this.aSet.size(); ++i) {
                adppl = this.aSet.get(i);
                if (adppl.color != colorIndex || adppl.involved) continue;
                Connected c = new Connected(adppl, null);
                this.connectedList.add(c);
                adppl.involved = true;
            }
            for (i = 0; i < this.bSet.size(); ++i) {
                DPPL bdppl = this.bSet.get(i);
                if (bdppl.color != colorIndex || bdppl.involved) continue;
                Connected c = new Connected(null, bdppl);
                this.connectedList.add(c);
                bdppl.involved = true;
            }
        }
    }

    public Double scoreCurrent() {
        Double score = this.getCurrentScoreBasedOnNets();
        return score;
    }

    public void optimizeGenetically(boolean byTime, long stoppingCriteria, int maxPopulation) {
        this.greedyAssign();
        if (this.connectedList.size() < 200) {
            maxPopulation *= 10;
        }
        this.go.setMaxPopulation(maxPopulation);
        for (int i = 0; i < maxPopulation; ++i) {
            this.go.addChromosome(this.connectedList.deepCopy(), null);
        }
        if (!byTime) {
            this.go.evolveForGenerations(stoppingCriteria);
        } else {
            GeneticOptimizationControllerThread evolveThread = new GeneticOptimizationControllerThread(this.go, stoppingCriteria, OrbitIO.getCurDb().toString());
            evolveThread.start();
        }
    }

    public ArrayList<APair<HierPin, HierPin>> getConnected() {
        ArrayList<APair<HierPin, HierPin>> ret = new ArrayList<APair<HierPin, HierPin>>();
        ConnectedChromosome best = (ConnectedChromosome)this.go.getBestIndividual();
        for (Connected conn : best) {
            if (conn.first == null || conn.second == null) continue;
            HierPin a = ((DPPL)conn.first).dpp;
            HierPin b = ((DPPL)conn.second).dpp;
            APair pair = new APair((Object)a, (Object)b);
            ret.add((APair<HierPin, HierPin>)pair);
        }
        return ret;
    }

    class ConnectedChromosome
    extends ArrayList<Connected>
    implements Chromosome {
        protected Random mRandom;

        ConnectedChromosome() {
            this.mRandom = new Random(GeneticConnectionOptimizer.this.ith++);
        }

        @Override
        public int length() {
            return this.size();
        }

        @Override
        public void endOfEpoch() {
        }

        public double diffPairFitness() {
            ArrayList cList;
            HashMap<Integer, ArrayList<Connected>> diffList = new HashMap<Integer, ArrayList<Connected>>();
            double fitness = 0.0;
            for (int i = 0; i < this.size(); ++i) {
                Connected cI = (Connected)((Object)this.get(i));
                if (cI.first == null || cI.second == null || ((DPPL)cI.first).match <= 0) continue;
                cList = (ArrayList)diffList.get(((DPPL)cI.first).match);
                if (cList == null) {
                    cList = new ArrayList();
                    diffList.put(((DPPL)cI.first).match, cList);
                }
                cList.add(cI);
            }
            for (Integer c : diffList.keySet()) {
                cList = (ArrayList)diffList.get(c);
                if (cList.size() <= 1) continue;
                Long sep = Math.abs(((DPPL)((Connected)((Object)cList.get((int)0))).second).p.distance(((DPPL)((Connected)((Object)cList.get((int)1))).second).p));
                fitness += (double)sep.longValue();
                Long diff = Math.abs(((Connected)((Object)cList.get(0))).length() - ((Connected)((Object)cList.get(1))).length());
                if (((Connected)((Object)cList.get(0))).line().intersects((AGeom)((Connected)((Object)cList.get(1))).line())) {
                    diff = diff * 10L;
                }
                fitness += (double)diff.longValue();
            }
            fitness = diffList.size() > 0 ? (fitness /= (double)diffList.size()) : 0.0;
            return fitness;
        }

        protected double lengthFitness() {
            double fitness = 0.0;
            for (int i = 0; i < this.size(); ++i) {
                Connected cI = (Connected)((Object)this.get(i));
                if (cI.first == null || cI.second == null) continue;
                fitness += (double)cI.length();
            }
            return fitness;
        }

        protected double angleFitness() {
            double fitness = 0.0;
            for (int i = 0; i < this.size(); ++i) {
                Connected cI = (Connected)((Object)this.get(i));
                if (cI.first == null || cI.second == null) continue;
                fitness += (double)cI.length();
            }
            return fitness;
        }

        protected double crossFitness() {
            double fitness = 0.0;
            for (int i = 0; i < this.size(); ++i) {
                for (int j = i + 1; j < this.size(); ++j) {
                    Connected cI = (Connected)((Object)this.get(i));
                    Connected cJ = (Connected)((Object)this.get(j));
                    if (cI.first == null || cI.second == null || cJ.first == null || cJ.second == null || !cI.cross(cJ)) continue;
                    fitness += 1.0;
                }
            }
            return fitness;
        }

        @Override
        public double fitness() {
            return this.lengthFitness() + this.diffPairFitness();
        }

        @Override
        public Chromosome mate(Chromosome c) {
            return null;
        }

        @Override
        public Chromosome mutate() {
            ConnectedChromosome mutant = (ConnectedChromosome)this.deepCopy();
            mutant.mRandom = this.mRandom;
            boolean success = false;
            while (!success) {
                int rJ;
                int rI = mutant.mRandom.nextInt(mutant.size() - 1);
                if (rI == (rJ = mutant.mRandom.nextInt(mutant.size() - 1))) continue;
                Connected cI = (Connected)((Object)mutant.get(rI));
                Connected cJ = (Connected)((Object)mutant.get(rJ));
                int ciColor = -1;
                int cjColor = -1;
                ciColor = cI.first == null ? ((DPPL)cI.second).color : ((DPPL)cI.first).color;
                if (ciColor != (cjColor = cJ.first == null ? ((DPPL)cJ.second).color : ((DPPL)cJ.first).color)) continue;
                cI.swap(cJ);
                success = true;
            }
            return mutant;
        }

        @Override
        public Chromosome deepCopy() {
            ConnectedChromosome clone = new ConnectedChromosome();
            int i = 0;
            for (Connected c : this) {
                Connected cClone = c.deepCopy();
                clone.add(i++, cClone);
            }
            return clone;
        }

        @Override
        public void updateCondition(String owner, long time) {
            double cross = this.crossFitness();
            double length = this.lengthFitness();
            double diffPairDiff = this.diffPairFitness();
            double fitness = this.fitness() / 1000.0;
            GeneticOptimizerBroker.setConstraintValue(owner, "Total Length", time, length /= 1000.0);
            GeneticOptimizerBroker.setConstraintValue(owner, "Diff Pair Diff", time, diffPairDiff /= 1000.0);
            GeneticOptimizerBroker.setConstraintValue(owner, "Crossings", time, cross);
            GeneticOptimizerBroker.setConstraintValue(owner, "Fitness", time, fitness);
            if (GeneticConnectionOptimizer.this.startScore != null) {
                double improvement = diffPairDiff != 0.0 ? (GeneticConnectionOptimizer.this.startScore - diffPairDiff) / GeneticConnectionOptimizer.this.startScore : (GeneticConnectionOptimizer.this.startScore - length) / GeneticConnectionOptimizer.this.startScore;
                improvement = Math.rint(improvement * 100.0);
                GeneticOptimizerBroker.setConstraintValue(owner, "Improvement %", time, improvement);
            }
        }
    }

    public static class Connected
    extends APair<DPPL, DPPL> {
        public Connected deepCopy() {
            DPPL from = null;
            DPPL to = null;
            if (this.first != null) {
                from = new DPPL((DPPL)this.first);
            }
            if (this.second != null) {
                to = new DPPL((DPPL)this.second);
            }
            return new Connected(from, to);
        }

        public Connected(DPPL a, DPPL b) {
            super((Object)a, (Object)b);
        }

        public ALine line() {
            return new ALine(((DPPL)this.first).p, ((DPPL)this.second).p);
        }

        public void swap(Connected b) {
            DPPL t = (DPPL)this.second;
            this.second = b.second;
            b.second = t;
        }

        public boolean cross(Connected b) {
            return this.line().intersects((AGeom)b.line());
        }

        public long length() {
            return this.line().getLength();
        }

        public double anglePenalty(APoint2D c) {
            APoint2D a1 = ((DPPL)this.first).p;
            APoint2D b1 = ((DPPL)this.second).p;
            return AGeomUtil.againstTheGrainPercent((APoint2D)c, (APoint2D)a1, (APoint2D)b1);
        }
    }

    protected static class DPPL
    implements Comparable<DPPL> {
        HierPin dpp;
        APoint2D p = new APoint2D();
        int color;
        int match;
        boolean involved = false;
        APoint2D oc = new APoint2D();

        public DPPL() {
        }

        public DPPL(DPPL src) {
            this.dpp = new HierPin(src.dpp);
            this.p = src.p;
            this.oc = src.oc;
            this.color = src.color;
            this.match = src.match;
            this.involved = src.involved;
        }

        @Override
        public int compareTo(DPPL o) {
            return this.p.compareTo(o.p);
        }
    }

    protected class ColorMgr {
        protected ArrayList<String> colors = new ArrayList();
        protected HashMap<String, ArrayList<Object>> colorToList = new HashMap();

        protected ColorMgr() {
        }

        public int addColor(String color, Object o) {
            int index = this.colors.indexOf(color);
            ArrayList<Object> oList = null;
            if (index < 0) {
                this.colors.add(color);
                oList = new ArrayList();
                this.colorToList.put(color, oList);
            } else {
                oList = this.colorToList.get(color);
            }
            oList.add(o);
            return this.colors.indexOf(color);
        }

        public int size() {
            return this.colors.size();
        }
    }
}

