/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.connOpt;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.edaMgrs.NameGenerator;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizationControllerThread;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizer;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.WeightedGoalFunction;
import com.sigrity.orbit.automation.WeightedGoalRegistry;
import com.sigrity.orbit.automation.connOpt.AGeneticConnectionOptimizer;
import java.util.ArrayList;
import java.util.List;

public class GeneticConnectionOptimizerManager {
    protected List<HierPin> from = new ArrayList<HierPin>();
    protected List<HierPin> to = new ArrayList<HierPin>();
    protected long maxTime = 0L;
    protected int maxPopulation = 1;
    protected AGeneticConnectionOptimizer mCO = null;
    protected String mConnectionCriteria = null;
    protected boolean mRemoveOriginalConnections = false;
    protected boolean runningForPlayback = false;

    public void getConnectionsFromPPO() {
        this.setList(PortPairOpt.getActive().getAPorts(), PortPairOpt.getActive().getBPorts());
    }

    public void setList(List<HierPin> from, List<HierPin> to) {
        this.from = from;
        this.to = to;
    }

    public void setEvolveParameters(long maxTime, int maxPopulation) {
        this.maxTime = maxTime;
        this.maxPopulation = maxPopulation;
    }

    public void setConnectionCriteria(String name) {
        this.mConnectionCriteria = name;
    }

    public void setRemoveOriginalConnections(boolean removeOriginalConnections) {
        this.mRemoveOriginalConnections = removeOriginalConnections;
    }

    public void returnWhenFinished() {
        while (this.amIRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                ALog.logError((Throwable)e);
            }
        }
    }

    public boolean amIRunning() {
        return this.runningForPlayback;
    }

    public AGeneticOptimizationControllerThread evolve() {
        this.runningForPlayback = true;
        this.mCO = new AGeneticConnectionOptimizer();
        this.mCO.setASet(this.from);
        this.mCO.setBSet(this.to);
        this.mCO.setConnectionCriteria(this.mConnectionCriteria);
        if (this.mRemoveOriginalConnections) {
            for (HierPin hp : this.to) {
                if (((PinInstance)hp.second).fixed()) continue;
                ((PinInstance)hp.second).getPinTemplate().setNet(((PinInstance)hp.second).getDeviceTemplate().getNetUnused());
            }
        }
        AGeneticOptimizer.addLoadListener(new myUpdateListener());
        return this.mCO.optimizeGenetically(this.maxTime, this.maxPopulation);
    }

    public void finish() {
        AGeneticConnectionOptimizer.ConnectedChromosome best = (AGeneticConnectionOptimizer.ConnectedChromosome)this.mCO.go.getBestIndividual();
        for (WeightedGoalFunction f : WeightedGoalRegistry.getRegistry()) {
            if (!(f.getWeight() > 0.0)) continue;
            f.finish(best);
        }
        this.updateConnections();
    }

    protected void updateConnections() {
        AGeneticConnectionOptimizer co = this.mCO;
        ArrayList<APair<HierPin, HierPin>> created = co.getConnected();
        UserCommands.removeConnections();
        NameGenerator ng = new NameGenerator("NewNet");
        for (APair<HierPin, HierPin> pair : created) {
            if (pair.second != null && ((PinInstance)((HierPin)pair.second).second).fixed()) continue;
            String netName = null;
            if (((HierPin)pair.first).getNet().isUnused()) {
                netName = Net.findAUniqueNetName((NameGenerator)ng);
                NetMap.mapThroughPath((DevicePath)((HierPin)pair.first).getPath(), (PinTemplate)((HierPin)pair.first).getPinTemplate(), (String)netName);
            } else {
                NetMap.mapThroughPath((DevicePath)((HierPin)pair.first).getPath(), (Net)((HierPin)pair.first).getNet());
                netName = NetMap.getTopmostNet((Net)((HierPin)pair.first).getNet(), (DevicePath)((HierPin)pair.first).getPath()).getName();
            }
            NetMap.mapThroughPath((DevicePath)((HierPin)pair.second).getPath(), (PinTemplate)((HierPin)pair.second).getPinTemplate(), (String)netName);
        }
        UserCommands.createConnections();
        OrbitIO.getApp().refreshCurrentView(false);
    }

    class myUpdateListener
    implements AGeneticOptimizer.GeneticOptimizerStatusListener {
        myUpdateListener() {
        }

        @Override
        public void stats(int percent, boolean done, String data) {
            if (done) {
                GeneticConnectionOptimizerManager.this.runningForPlayback = false;
                GeneticConnectionOptimizerManager.this.mCO.go.printPopulation();
            }
        }
    }
}

