/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.contact_sync;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.automation.align_device_footprint.AlignDeviceToFootprint;
import com.sigrity.orbit.automation.contact_sync.ContactSync;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

class ContactDevSync
extends ContactSync {
    private final Device refDev;
    private List<DevicePath> contactDevPaths;
    private List<HierInst<PinTemplate>> contactHierPins;

    public ContactDevSync(Device refDev) {
        super(refDev.getDb());
        this.refDev = refDev;
    }

    @Override
    public boolean hasContactObject() {
        return this.hasContactDev();
    }

    private boolean hasContactDev() {
        return !this.getContactDevPaths().isEmpty() || !this.getContactHierPins().isEmpty();
    }

    @Override
    public List<DevicePath> getRefDevPaths() {
        return AUtil.arrayList((Stream)this.refDev.getAllPaths());
    }

    @Override
    public List<DevicePath> getContactDevPaths() {
        if (this.contactDevPaths == null) {
            this.contactDevPaths = new ArrayList<DevicePath>();
            for (ContactLayer contactLayer : this.getContactLayers()) {
                if (!this.getIsAbstractContactDevice(contactLayer)) continue;
                if (this.isRefOnA(contactLayer)) {
                    this.contactDevPaths.addAll(AUtil.arrayList((Iterator)contactLayer.getDevicePathB().getAllFullPaths()));
                    continue;
                }
                this.contactDevPaths.addAll(AUtil.arrayList((Iterator)contactLayer.getDevicePathA().getAllFullPaths()));
            }
        }
        return this.contactDevPaths;
    }

    @Override
    public List<HierInst<PinTemplate>> getRefHierPins() {
        return Collections.emptyList();
    }

    @Override
    public List<HierInst<PinTemplate>> getContactHierPins() {
        if (this.contactHierPins == null) {
            this.contactHierPins = new ArrayList<HierInst<PinTemplate>>();
            for (ContactLayer contactLayer : this.getContactLayers()) {
                if (this.getIsAbstractContactDevice(contactLayer)) continue;
                if (this.isRefOnA(contactLayer)) {
                    this.contactHierPins.addAll(AUtil.arrayList((Iterator)PinMap.get((ContactLayer)contactLayer).mapAndNonNull(PinMap::getHierPinB)));
                    continue;
                }
                this.contactHierPins.addAll(AUtil.arrayList((Iterator)PinMap.get((ContactLayer)contactLayer).mapAndNonNull(PinMap::getHierPinA)));
            }
        }
        return this.contactHierPins;
    }

    @Override
    public List<ContactLayer> getContactLayers() {
        if (this.contactLayers == null) {
            this.contactLayers = AUtil.arrayList((Iterator)ContactLayer.get((DevicePath)new DevicePath(this.refDev)));
        }
        return this.contactLayers;
    }

    @Override
    public List<PinMap> getPinMaps() {
        if (this.pinMaps == null) {
            this.pinMaps = AUtil.arrayList((Iterator)AIterableItr.itr(this.getContactLayers()).flatMap(PinMap::get));
        }
        return this.pinMaps;
    }

    @Override
    public void delete() {
        for (ContactLayer cl : this.getContactLayers()) {
            if (this.getIsAbstractContactDevice(cl)) {
                this.deleteContactDevices(cl);
                continue;
            }
            this.deleteContactPins(cl);
        }
    }

    @Override
    public void alignLoc() {
        for (ContactLayer cl : this.getContactLayers()) {
            if (!cl.isValid()) continue;
            if (this.getIsAbstractContactDevice(cl)) {
                this.alignContactDevices(cl);
                continue;
            }
            this.alignContactPins(cl);
        }
    }

    private void deleteContactDevices(ContactLayer contactLayer) {
        DevicePath contactDevPath = this.getContactDevPath(contactLayer);
        DeviceTemplate contactDevT = contactDevPath.getDeviceTemplate();
        contactDevT.deleteAllTemplateInsts();
        contactDevT.deleteFromDb();
    }

    private void alignContactDevices(ContactLayer cl) {
        AlignDeviceToFootprint autoMounting = new AlignDeviceToFootprint();
        DevicePath movedDevPath = this.getContactDevPath(cl);
        AlignDeviceToFootprint.MovedDevice mountedDevice = new AlignDeviceToFootprint.MovedDevice(movedDevPath);
        for (PinMap pm : this.getIdeaPinMap(cl)) {
            PortTemplate portA = (PortTemplate)pm.getPinA().getPortTemplates().next();
            PortTemplate portB = (PortTemplate)pm.getPinB().getPortTemplates().next();
            if (this.isRefOnA(cl)) {
                mountedDevice.addContactedPortPair(pm.getPinBPath(), portB, pm.getPinAPath(), portA);
                continue;
            }
            mountedDevice.addContactedPortPair(pm.getPinAPath(), portA, pm.getPinBPath(), portB);
        }
        autoMounting.addMovedDevice(mountedDevice);
        autoMounting.autoMoveDevices();
    }

    private List<PinMap> getIdeaPinMap(ContactLayer cl) {
        ArrayList<PinMap> res = new ArrayList<PinMap>(3);
        APoint2D firstLoc = null;
        APoint2D secondLoc = null;
        IterableIterator clItr = PinMap.get((ContactLayer)cl);
        for (PinMap pm : clItr) {
            PortTemplate portA = ContactDevSync.getPort(pm.getPinA());
            PortTemplate portB = ContactDevSync.getPort(pm.getPinB());
            if (portA == null || portB == null) continue;
            APoint2D pinALoc = pm.getPinAPath().transformPt(portA.getLoc());
            if (firstLoc == null) {
                firstLoc = pinALoc;
                res.add(pm);
            } else if (secondLoc == null) {
                secondLoc = pinALoc;
                res.add(pm);
            } else if (pinALoc.getX() != firstLoc.getX() || pinALoc.getX() != secondLoc.getX() || pinALoc.getY() != firstLoc.getY() || pinALoc.getY() != secondLoc.getY()) {
                res.add(pm);
            }
            if (res.size() != 3) continue;
            break;
        }
        return res;
    }

    @Override
    public boolean isRefOnA(PinMap pinMap) {
        return pinMap.getContactLayer().isContactWithPathA(new DevicePath(this.refDev));
    }

    @Override
    public boolean isRefOnA(ContactLayer contactLayer) {
        return contactLayer.isContactWithPathA(new DevicePath(this.refDev));
    }

    private boolean getIsAbstractContactDevice(ContactLayer contactLayer) {
        return contactLayer.getDeviceTemplateA().getIsAbstractContactDevice() || contactLayer.getDeviceTemplateB().getIsAbstractContactDevice();
    }
}

