/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.contact_sync;

import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.automation.contact_sync.ContactSnapshot;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContactNetSyncEngine {
    private final Db mDb;
    private List<SyncRef> mContactNetSyncs = new LinkedList<SyncRef>();
    private Map<ContactLayer, ContactSnapshot> mContactLayer2Snapshot = new HashMap<ContactLayer, ContactSnapshot>();
    private Map<ContactLayer, Synchronizer> mContactLayer2Synchronizer = new HashMap<ContactLayer, Synchronizer>();
    private boolean mIsVerifySync = false;

    public ContactNetSyncEngine(Db db) {
        this.mDb = db;
    }

    public void setIsVerifySync(boolean b) {
        this.mIsVerifySync = b;
    }

    public void addToSyncNetObject(DbObject pinObj) {
        if (pinObj.getDb() == null || pinObj.getDb() != this.mDb) {
            assert (false);
            return;
        }
        SyncRef contactNetSync = null;
        if (pinObj instanceof PinTemplate) {
            contactNetSync = new PinSyncRef((PinTemplate)pinObj);
            this.mContactNetSyncs.add(contactNetSync);
        } else if (pinObj instanceof Device) {
            Device pinDev = (Device)pinObj;
            if (pinDev.isPin() && pinDev.getPin() != null) {
                contactNetSync = new PinDevSyncRef(pinDev);
                this.mContactNetSyncs.add(contactNetSync);
            }
        } else {
            ALog.logDebug((String)"Sync contact net engine do not handle '%s'", (Object[])new Object[]{pinObj.getKeyStr()});
        }
        if (contactNetSync != null) {
            this.snapshotContactNet(contactNetSync);
        }
    }

    public void execute() {
        if (this.mContactLayer2Snapshot.isEmpty()) {
            return;
        }
        if (this.mIsVerifySync) {
            this.showVerifySyncUI();
        } else {
            this.syncContactNet();
        }
    }

    public void showVerifySyncUI() {
        int resp = OrbitApp.showWarningConfirmDialog((String)"Sync nets of contact objects?", (String)"Sync Contact");
        if (resp == 0) {
            this.syncContactNet();
        }
    }

    private void snapshotContactNet(SyncRef contactNetSync) {
        contactNetSync.getContactLayer().forEach(this::snapshotContactNet);
    }

    private void snapshotContactNet(ContactLayer contactLayer) {
        this.mContactLayer2Snapshot.computeIfAbsent(contactLayer, x -> ContactSnapshot.create(contactLayer));
    }

    public void syncContactNet() {
        this.mContactNetSyncs.forEach(s -> s.getPinMaps().forEach(pm -> {
            ContactLayer cl = pm.getContactLayer();
            Synchronizer synchronizer = this.mContactLayer2Synchronizer.computeIfAbsent(cl, x -> new Synchronizer(this.mContactLayer2Snapshot.get(cl)));
            if (s.isOnA((PinMap)pm)) {
                synchronizer.addCandidatePinMapsOnA((PinMap)pm);
            } else {
                synchronizer.addCandidatePinMapsOnB((PinMap)pm);
            }
        }));
        this.mContactLayer2Synchronizer.forEach((k, v) -> v.execute());
    }

    private static class Synchronizer {
        private final ContactSnapshot mSnapshot;
        private Set<PinMap> mCandidatePinMapsOnA = new HashSet<PinMap>();
        private Set<PinMap> mCandidatePinMapsOnB = new HashSet<PinMap>();

        public Synchronizer(ContactSnapshot snapshot) {
            this.mSnapshot = snapshot;
        }

        public void addCandidatePinMapsOnA(PinMap pinMap) {
            this.mCandidatePinMapsOnA.add(pinMap);
        }

        public void addCandidatePinMapsOnB(PinMap pinMap) {
            this.mCandidatePinMapsOnB.add(pinMap);
        }

        public void execute() {
            DeviceTemplate contactDevT;
            if (!this.mCandidatePinMapsOnA.isEmpty()) {
                contactDevT = this.mSnapshot.getContactLayer().getDeviceTemplateB();
                ALog.logInfo((String)"Sync nets of contact pins in %s...", (Object[])new Object[]{contactDevT});
                this.syncCandidatePinMapsOnA();
                ALog.logInfo((String)"Complete sync nets of contact pins in %s", (Object[])new Object[]{contactDevT});
            }
            if (!this.mCandidatePinMapsOnB.isEmpty()) {
                contactDevT = this.mSnapshot.getContactLayer().getDeviceTemplateA();
                ALog.logInfo((String)"Sync nets of contact pins in %s...", (Object[])new Object[]{contactDevT});
                this.syncCandidatePinMapsOnB();
                ALog.logInfo((String)"Complete sync nets of contact pins in %s", (Object[])new Object[]{contactDevT});
            }
        }

        private void syncCandidatePinMapsOnA() {
            this.mCandidatePinMapsOnA.stream().filter(pm -> !this.mCandidatePinMapsOnB.contains(pm)).forEach(this::syncCandidatePinMapsOnA);
        }

        private void syncCandidatePinMapsOnA(PinMap pinMap) {
            Net refNet = pinMap.getNetAtContactDevA();
            Set<Net> contactNets = this.mSnapshot.getContactNetFromA(refNet);
            if (contactNets == null || contactNets.isEmpty()) {
                ALog.logDebug((String)"No contact net for '%s'", (Object[])new Object[]{refNet});
            } else if (contactNets.size() != 1) {
                ALog.logDebug((String)"Multiple contact nets for '%s'", (Object[])new Object[]{refNet});
            } else {
                Net refContactNet = contactNets.iterator().next();
                Net curContactNet = pinMap.getNetAtContactDevB();
                if (curContactNet == refContactNet) {
                    return;
                }
                DevicePath pinPath = pinMap.getPinBPathFromContactDev();
                assert (pinPath != null);
                if (!pinPath.isEmpty() && pinPath.isPin()) {
                    this.connectNetToPinDev(pinPath, refContactNet);
                } else {
                    this.connectNetToPin(refContactNet, pinMap.getPinB(), pinPath);
                }
            }
        }

        private void syncCandidatePinMapsOnB() {
            this.mCandidatePinMapsOnB.stream().filter(pm -> !this.mCandidatePinMapsOnA.contains(pm)).forEach(this::syncCandidatePinMapsOnB);
        }

        private void syncCandidatePinMapsOnB(PinMap pinMap) {
            Net refNet = pinMap.getNetAtContactDevB();
            Set<Net> contactNets = this.mSnapshot.getContactNetFromB(refNet);
            if (contactNets == null || contactNets.isEmpty()) {
                ALog.logDebug((String)"No contact net for '%s'", (Object[])new Object[]{refNet});
            } else if (contactNets.size() != 1) {
                ALog.logDebug((String)"Multiple contact nets for '%s'", (Object[])new Object[]{refNet});
            } else {
                Net refContactNet = contactNets.iterator().next();
                Net curContactNet = pinMap.getNetAtContactDevA();
                if (curContactNet == refContactNet) {
                    return;
                }
                DevicePath pinPath = pinMap.getPinAPathFromContactDev();
                assert (pinPath != null);
                if (!pinPath.isEmpty() && pinPath.isPin()) {
                    this.connectNetToPinDev(pinPath, refContactNet);
                } else {
                    this.connectNetToPin(refContactNet, pinMap.getPinA(), pinPath);
                }
            }
        }

        private void connectNetToPinDev(DevicePath pinPath, Net targetNet) {
            Device pinDev = pinPath.getDevice();
            assert (pinDev != null && pinDev.isPin() && pinDev.getPin() != null);
            Net pinDevNet = pinDev.getPin().getNet();
            if (pinDevNet.isUnused()) {
                assert (false);
                return;
            }
            ALog.logInfo((String)"Set pin '%s' net from '%s' to '%s'", (Object[])new Object[]{pinDev.getName(), pinDev.getNet().getName(), targetNet.getName()});
            NetMap.mapUpTo((DevicePath)pinPath, (Net)pinDevNet, (Net)targetNet);
        }

        private void connectNetToPin(Net targetNet, PinTemplate contactPin, DevicePath pinPath) {
            Net contactNetAtDevB = null;
            if (pinPath.getDeviceTemplate() == targetNet.getDeviceTemplate()) {
                contactNetAtDevB = targetNet;
            } else {
                Set netSet = NetMap.getAllDescendantNetsAt((Net)targetNet, (Device)pinPath.getDevice());
                if (netSet.isEmpty()) {
                    ALog.logDebug((String)"No connected net for '%s' on at '%s'.", (Object[])new Object[]{targetNet, pinPath});
                } else if (netSet.size() != 1) {
                    ALog.logDebug((String)"Multiple connected net for '%s' on at '%s'", (Object[])new Object[]{targetNet, pinPath});
                } else {
                    contactNetAtDevB = (Net)netSet.iterator().next();
                }
            }
            if (contactNetAtDevB != null) {
                ALog.logInfo((String)"Set pin '%s' net from '%s' to '%s'", (Object[])new Object[]{contactPin.getName(), contactPin.getNet().getName(), contactNetAtDevB.getName()});
                contactPin.setNet(contactNetAtDevB);
            }
        }

        private static abstract class UserSyncOption {
            private final PinMap mPinMap;
            private final Set<Net> mCandidateNets;

            public UserSyncOption(PinMap pinMap, Set<Net> candidateNets) {
                this.mPinMap = pinMap;
                this.mCandidateNets = candidateNets;
            }
        }

        private static class TwoSideUserSyncOption
        extends UserSyncOption {
            private final Set<Net> mCandidateNetsB;

            public TwoSideUserSyncOption(PinMap pinMap, Set<Net> candidateNetsA, Set<Net> candidateNetsB) {
                super(pinMap, candidateNetsA);
                this.mCandidateNetsB = candidateNetsB;
            }
        }

        private static class OneSideUserSyncOption
        extends UserSyncOption {
            private final boolean mIsFromA;

            public OneSideUserSyncOption(PinMap pinMap, Set<Net> candidateNets, boolean isFromA) {
                super(pinMap, candidateNets);
                this.mIsFromA = isFromA;
            }
        }
    }

    private static interface SyncRef {
        public DeviceTemplate getOwner();

        public IterableIterator<PinMap> getPinMaps();

        public boolean isOnA(PinMap var1);

        default public IterableIterator<ContactLayer> getContactLayer() {
            return new StreamIterableIterator(this.getPinMaps().stream().map(PinMap::getContactLayer).distinct());
        }
    }

    private class PinDevSyncRef
    implements SyncRef {
        private final Device mRefPinDev;

        public PinDevSyncRef(Device refPinDev) {
            this.mRefPinDev = refPinDev;
        }

        @Override
        public DeviceTemplate getOwner() {
            return this.mRefPinDev.getParent();
        }

        @Override
        public IterableIterator<PinMap> getPinMaps() {
            return PinMap.get((DevicePath)new DevicePath(this.mRefPinDev), (PinTemplate)this.mRefPinDev.getPin().getPinTemplate());
        }

        @Override
        public boolean isOnA(PinMap pinMap) {
            return pinMap.getDeviceA() == this.mRefPinDev;
        }
    }

    private class PinSyncRef
    implements SyncRef {
        private final PinTemplate mRefPinT;

        public PinSyncRef(PinTemplate refPinT) {
            this.mRefPinT = refPinT;
        }

        @Override
        public DeviceTemplate getOwner() {
            return this.mRefPinT.getDeviceTemplate();
        }

        @Override
        public IterableIterator<PinMap> getPinMaps() {
            return PinMap.get((PinTemplate)this.mRefPinT);
        }

        @Override
        public boolean isOnA(PinMap pinMap) {
            return pinMap.getPinA() == this.mRefPinT;
        }
    }
}

