/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.contact_sync;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.contact_sync.ContactDevSync;
import com.sigrity.orbit.automation.contact_sync.ContactPinDevSync;
import com.sigrity.orbit.automation.contact_sync.ContactPinSync;
import com.sigrity.orbit.automation.contact_sync.ContactSync;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ContactObjectSyncEngine {
    private static final String WARNING_DIALOG_TITLE = "Sync Contact Object";
    private static final int MAX_SHOW_NUM = 10;
    private final Db mDb;
    private List<ContactSync> mSyncDelete = new LinkedList<ContactSync>();
    private List<ContactSync> mSyncLoc = new LinkedList<ContactSync>();

    public ContactObjectSyncEngine(Db db) {
        this.mDb = db;
    }

    public void addToSyncDelete(DbObject obj) {
        ContactSync contactSync = this.createContactSync(obj);
        if (contactSync != null && contactSync.hasContactObject()) {
            this.mSyncDelete.add(contactSync);
        }
    }

    public void addToSyncLoc(DbObject obj) {
        ContactSync contactSync = this.createContactSync(obj);
        if (contactSync != null && contactSync.hasContactObject()) {
            this.mSyncLoc.add(contactSync);
        }
    }

    private ContactSync createContactSync(DbObject obj) {
        ContactSync contactSync = null;
        if (obj instanceof Device) {
            Device devObj = (Device)obj;
            contactSync = devObj.isPin() ? new ContactPinDevSync(devObj) : new ContactDevSync(devObj);
        } else if (obj instanceof PinTemplate) {
            contactSync = new ContactPinSync((PinTemplate)obj);
        } else if (obj instanceof PinInstance) {
            contactSync = new ContactPinSync(((PinInstance)obj).getPinTemplate());
        }
        return contactSync;
    }

    public void execute() {
        this.execute(OrbitIO.getGuiWorkspace() == null);
    }

    public void execute(boolean quiet) {
        this.delete(quiet);
        this.alignLoc(quiet);
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean quiet) {
        if (!this.isToDeleteExist()) {
            return;
        }
        int op = 0;
        if (!quiet) {
            op = this.showWarningOptionDialog("Delete", this.mSyncDelete);
        }
        if (op == 0) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Delete contact");){
                this.mSyncDelete.forEach(ContactSync::delete);
            }
        }
    }

    public void alignLoc(boolean quiet) {
        if (!this.isToAlignExist()) {
            return;
        }
        int op = 0;
        if (!quiet) {
            op = this.showWarningOptionDialog("Align", this.mSyncLoc);
        }
        if (op == 0) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Align contact");){
                this.mSyncLoc.forEach(ContactSync::alignLoc);
            }
        }
    }

    private boolean isToDeleteExist() {
        return this.isToDoExist(this.mSyncDelete);
    }

    private boolean isToAlignExist() {
        return this.isToDoExist(this.mSyncLoc);
    }

    private boolean isToDoExist(List<ContactSync> csList) {
        for (ContactSync cs : csList) {
            if (!cs.hasContactObject()) continue;
            return true;
        }
        return false;
    }

    private int showWarningOptionDialog(String actionStr, List<ContactSync> csList) {
        String message = this.getWarningMassage(actionStr, csList);
        return OrbitApp.showWarningConfirmDialog((String)message, (String)WARNING_DIALOG_TITLE);
    }

    private String getWarningMassage(String actionStr, List<ContactSync> csList) {
        return String.format("<html>%s contact objects?<br/>%s%s</html>", actionStr, this.getContactDevInfoStr(csList), this.getContactPinInfoStr(csList));
    }

    private String getContactDevInfoStr(List<ContactSync> csList) {
        List<DevicePath> contactDevPaths = this.getContactDevPaths(csList);
        if (contactDevPaths.isEmpty()) {
            return "";
        }
        String infoStr = "Contact Device:<br/>";
        int num = 0;
        for (DevicePath devPath : contactDevPaths) {
            for (DevicePath fulldevPath : devPath.getAllFullPaths()) {
                infoStr = String.format("%s &nbsp&nbsp %s <br/>", infoStr, fulldevPath.getString());
            }
            if (++num != 10) continue;
            break;
        }
        if (num == 10) {
            infoStr = String.format("%s &nbsp&nbsp and more ...<br/>", infoStr);
        }
        return infoStr;
    }

    private String getContactPinInfoStr(List<ContactSync> csList) {
        List<HierInst<PinTemplate>> contactHierPins = this.getContactHierPins(csList);
        if (contactHierPins.isEmpty()) {
            return "";
        }
        String infoStr = "Contact Pin:<br/>";
        int num = 0;
        for (HierInst<PinTemplate> hierPin : contactHierPins) {
            for (DevicePath devPath : hierPin.getPath().getAllFullPaths()) {
                infoStr = String.format("%s &nbsp&nbsp %s.%s <br/>", infoStr, devPath, ((PinTemplate)hierPin.getSecond()).getName());
            }
            if (++num != 10) continue;
            break;
        }
        if (num == 10) {
            infoStr = String.format("%s &nbsp&nbsp and more ...<br/>", infoStr);
        }
        return infoStr;
    }

    private List<DevicePath> getContactDevPaths(List<ContactSync> csList) {
        return csList.stream().flatMap(sync -> sync.getContactDevPaths().stream()).collect(Collectors.toList());
    }

    private List<HierInst<PinTemplate>> getContactHierPins(List<ContactSync> csList) {
        return csList.stream().flatMap(sync -> sync.getContactHierPins().stream()).collect(Collectors.toList());
    }
}

