/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.contact_sync;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.automation.contact_sync.ContactSync;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

class ContactPinDevSync
extends ContactSync {
    private final Device refDevPin;
    private List<HierInst<PinTemplate>> contactHierPins;

    public ContactPinDevSync(Device refDevPin) {
        super(refDevPin.getDb());
        this.refDevPin = refDevPin;
    }

    @Override
    public boolean hasContactObject() {
        return this.hasContactPin();
    }

    private boolean hasContactPin() {
        return !this.getContactHierPins().isEmpty();
    }

    @Override
    public List<DevicePath> getRefDevPaths() {
        return Collections.emptyList();
    }

    @Override
    public List<DevicePath> getContactDevPaths() {
        return Collections.emptyList();
    }

    @Override
    public List<HierInst<PinTemplate>> getRefHierPins() {
        PinTemplate pin = this.refDevPin.getTemplate().getPin1();
        return this.refDevPin.getAllPaths().map(refDevPath -> HierInst.create((DevicePath)refDevPath, (DbObject)pin)).collect(Collectors.toList());
    }

    @Override
    public List<ContactLayer> getContactLayers() {
        if (this.contactLayers == null) {
            this.contactLayers = AUtil.arrayList((Iterator)ContactLayer.get((DevicePath)new DevicePath(this.refDevPin)));
        }
        return this.contactLayers;
    }

    @Override
    public List<PinMap> getPinMaps() {
        if (this.pinMaps == null) {
            this.pinMaps = AUtil.arrayList((Iterator)PinMap.get((DevicePath)new DevicePath(this.refDevPin), (PinTemplate)this.refDevPin.getPin().getPinTemplate()));
        }
        return this.pinMaps;
    }

    @Override
    public List<HierInst<PinTemplate>> getContactHierPins() {
        if (this.contactHierPins == null) {
            PinTemplate pin = this.refDevPin.getTemplate().getPin1();
            if (pin == null) {
                return Collections.emptyList();
            }
            this.contactHierPins = this.refDevPin.getAllPaths().flatMap(refDevPath -> PinMap.getContactPin((DevicePath)refDevPath, (PinTemplate)pin).stream()).distinct().collect(Collectors.toList());
        }
        return this.contactHierPins;
    }

    @Override
    public void delete() {
        this.deleteContactPins();
    }

    @Override
    public void alignLoc() {
        this.alignContactPins();
    }

    @Override
    public boolean isRefOnA(PinMap pinMap) {
        return pinMap.getDeviceA() == this.refDevPin;
    }

    @Override
    public boolean isRefOnA(ContactLayer contactLayer) {
        return contactLayer.isContactWithPathA(new DevicePath(this.refDevPin));
    }
}

