/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.contact_sync;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.automation.contact_sync.ContactSync;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

class ContactPinSync
extends ContactSync {
    private final PinTemplate refPin;
    private List<HierInst<PinTemplate>> contactHierPins;

    public ContactPinSync(PinTemplate refPin) {
        super(refPin.getDb());
        this.refPin = refPin;
    }

    @Override
    public boolean hasContactObject() {
        return !this.getContactHierPins().isEmpty();
    }

    @Override
    public void delete() {
        this.deleteContactPins();
    }

    @Override
    public void alignLoc() {
        this.alignContactPins();
    }

    @Override
    public List<DevicePath> getRefDevPaths() {
        return Collections.emptyList();
    }

    @Override
    public List<DevicePath> getContactDevPaths() {
        return Collections.emptyList();
    }

    @Override
    public List<HierInst<PinTemplate>> getRefHierPins() {
        return AUtil.arrayList((Iterator)this.refPin.getDeviceTemplate().getHierarchicalInstances().mapAndNonNull(devPath -> HierInst.create((DevicePath)devPath, (DbObject)this.refPin)));
    }

    @Override
    public List<ContactLayer> getContactLayers() {
        if (this.contactLayers == null) {
            this.contactLayers = this.getPinMaps().stream().map(PinMap::getContactLayer).distinct().collect(Collectors.toList());
        }
        return this.contactLayers;
    }

    @Override
    public List<PinMap> getPinMaps() {
        if (this.pinMaps == null) {
            this.pinMaps = AUtil.arrayList((Iterator)PinMap.get((PinTemplate)this.refPin));
        }
        return this.pinMaps;
    }

    @Override
    public List<HierInst<PinTemplate>> getContactHierPins() {
        if (this.contactHierPins == null) {
            this.contactHierPins = AUtil.arrayList((Iterator)this.refPin.getDeviceTemplate().getHierarchicalInstances().flatMap(devPath -> PinMap.getContactPin((DevicePath)devPath, (PinTemplate)this.refPin)).distinct());
        }
        return this.contactHierPins;
    }

    @Override
    public boolean isRefOnA(PinMap pinMap) {
        return pinMap.getPinA() == this.refPin;
    }

    @Override
    public boolean isRefOnA(ContactLayer contactLayer) {
        return contactLayer.getDeviceTemplateA() == this.refPin.getDeviceTemplate();
    }
}

