/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.contact_sync;

import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ContactSnapshot {
    private ContactLayer mContactLayer;
    private final Map<Net, Set<Net>> mNetA2NetB = new HashMap<Net, Set<Net>>();
    private final Map<Net, Set<Net>> mNetB2NetA = new HashMap<Net, Set<Net>>();

    public static ContactSnapshot create(ContactLayer contactLayer) {
        if (contactLayer == null) {
            assert (false);
            return null;
        }
        return new ContactSnapshot(contactLayer);
    }

    private ContactSnapshot(ContactLayer contactLayer) {
        this.mContactLayer = contactLayer;
        this.init();
    }

    public ContactLayer getContactLayer() {
        return this.mContactLayer;
    }

    public Set<Net> getContactNetFromA(Net netA) {
        return this.mNetA2NetB.get(netA);
    }

    public Set<Net> getContactNetFromB(Net netB) {
        return this.mNetB2NetA.get(netB);
    }

    private void init() {
        PinMap.get((ContactLayer)this.mContactLayer).forEach(pm -> {
            if (pm == null) {
                return;
            }
            Net netAtContactDevA = pm.getNetAtContactDevA();
            Net netAtContactDevB = pm.getNetAtContactDevB();
            Set netAContactSet = this.mNetA2NetB.computeIfAbsent(netAtContactDevA, x -> new HashSet());
            Set netBContactSet = this.mNetB2NetA.computeIfAbsent(netAtContactDevB, x -> new HashSet());
            netAContactSet.add(netAtContactDevB);
            netBContactSet.add(netAtContactDevA);
        });
    }
}

