/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.contact_sync;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.inter_substrate_checks.auto_fix.PinOffsetAutoFix;
import java.util.Iterator;
import java.util.List;

abstract class ContactSync {
    protected Db mDb;
    protected List<ContactLayer> contactLayers;
    protected List<PinMap> pinMaps;

    protected ContactSync(Db db) {
        this.mDb = db;
    }

    public abstract boolean hasContactObject();

    public abstract List<DevicePath> getRefDevPaths();

    public abstract List<DevicePath> getContactDevPaths();

    public abstract List<HierInst<PinTemplate>> getRefHierPins();

    public abstract List<HierInst<PinTemplate>> getContactHierPins();

    public abstract List<PinMap> getPinMaps();

    public abstract List<ContactLayer> getContactLayers();

    public abstract boolean isRefOnA(PinMap var1);

    public abstract boolean isRefOnA(ContactLayer var1);

    public abstract void delete();

    public abstract void alignLoc();

    public int getContactPinSize() {
        return this.getContactHierPins().size();
    }

    protected void deleteContactPins() {
        for (HierInst<PinTemplate> hierPin : this.getContactHierPins()) {
            this.deleteContactPin(hierPin);
        }
    }

    protected void deleteContactPins(ContactLayer contactLayer) {
        boolean isRefOnA = this.isRefOnA(contactLayer);
        for (PinMap pinMap : AUtil.arrayList((Iterator)PinMap.get((ContactLayer)contactLayer))) {
            HierInst hierPin = isRefOnA ? pinMap.getHierPinB() : pinMap.getHierPinA();
            this.deleteContactPin((HierInst<PinTemplate>)hierPin);
        }
    }

    protected void alignContactPins() {
        for (PinMap pinMap : this.getPinMaps()) {
            this.alignContactPin(pinMap);
        }
    }

    protected void alignContactPins(ContactLayer contactLayer) {
        for (PinMap pinMap : PinMap.get((ContactLayer)contactLayer)) {
            this.alignContactPin(pinMap);
        }
    }

    private void deleteContactPin(HierInst<PinTemplate> hierPin) {
        if (!hierPin.isValid()) {
            return;
        }
        if (ContactSync.isPinDevice(hierPin)) {
            hierPin.getPath().getDevice().deleteFromDb();
        } else {
            ((PinTemplate)hierPin.getSecond()).deleteFromDb();
        }
    }

    private void alignContactPin(PinMap pinMap) {
        PortTemplate portA = ContactSync.getPort(pinMap.getPinA());
        PortTemplate portB = ContactSync.getPort(pinMap.getPinB());
        if (portA == null || portB == null) {
            return;
        }
        PinOffsetAutoFix autoFix = new PinOffsetAutoFix(this.mDb, pinMap.getOwner());
        if (this.isRefOnA(pinMap)) {
            autoFix.fixHierPort(pinMap.getPinBPath(), portB, pinMap.getPinAPath(), portA);
        } else {
            autoFix.fixHierPort(pinMap.getPinAPath(), portA, pinMap.getPinBPath(), portB);
        }
    }

    protected static PortTemplate getPort(PinTemplate pin) {
        IterableIterator portItr = pin.getPortTemplates();
        PortTemplate port = null;
        while (portItr.hasNext()) {
            if (port == null) {
                port = (PortTemplate)portItr.next();
                continue;
            }
            ALog.logDebug((String)"Pin '%s' has more than one port", (Object[])new Object[]{pin.getKeyStr()});
            return null;
        }
        return port;
    }

    protected DevicePath getContactDevPath(ContactLayer cl) {
        if (this.isRefOnA(cl)) {
            return cl.getDevicePathB();
        }
        return cl.getDevicePathA();
    }

    private static boolean isPinDevice(HierInst<PinTemplate> hierPin) {
        return hierPin.getPath().getDeviceTemplate().amIAPin();
    }
}

