/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.AUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.experimental.Component;
import com.sigrity.orbit.automation.experimental.GreedyCluster;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class APDebugOverlay {
    protected APDebugOverlay theDebugOverlay = null;
    protected Overlay mOverlay;
    public DesignView2D mView;
    public int mIndex;

    void start(GreedyCluster.GreedyComponentListChromosome starter) {
        this.mView = (DesignView2D)OrbitIO.getCurView();
        if (this.theDebugOverlay != null) {
            this.mView.remove(this.theDebugOverlay.mOverlay);
        }
        this.mOverlay = new Overlay(starter);
        this.mView.addOverlay(this.mOverlay);
        this.theDebugOverlay = this;
    }

    void update(GreedyCluster.GreedyComponentListChromosome c) {
        if (this.mOverlay != null) {
            this.mOverlay.updateChromosome(c);
        }
        ((DesignView2D)OrbitIO.getCurView()).getCanvas().repaint();
    }

    void remove() {
        this.mView = (DesignView2D)OrbitIO.getCurView();
        this.mView.removeOverlay(this.mOverlay);
        this.mView.getCanvas().paintImmediately(this.mView.getCanvas().getBounds());
    }

    public class Overlay
    extends JComponent {
        protected DesignCanvas2D.XForm w2s;
        protected GreedyCluster.GreedyComponentListChromosome mStarter;
        Graphics2D g;
        protected boolean mDrawing = false;

        public Overlay(GreedyCluster.GreedyComponentListChromosome starter) {
            this.mStarter = starter;
            this.setOpaque(false);
            this.setDoubleBuffered(true);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        public void updateChromosome(GreedyCluster.GreedyComponentListChromosome u) {
            this.mStarter = u;
        }

        protected void drawScene(Graphics graphics) {
            for (Component c : this.mStarter) {
                this.g = (Graphics2D)graphics;
                DesignView2D v2 = APDebugOverlay.this.mView;
                this.w2s = v2.getCanvas().getXForm();
                Rectangle r = new Rectangle();
                long w = c.width;
                long h = c.height;
                long x = c.getLeft();
                long y = c.bottom;
                int sx = this.w2s.getScreenX(x);
                int sy = this.w2s.getScreenY(y + h);
                int sw = this.w2s.getScreenLength(w);
                int sh = this.w2s.getScreenLength(h);
                r.setBounds(sx, sy, sw, sh);
                this.g.setColor(Color.ORANGE);
                this.g.drawRect(sx, sy, sw, sh);
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!AUtil.getAclDebugMode()) {
                return;
            }
            if (this.mDrawing) {
                return;
            }
            this.mDrawing = true;
            this.drawScene(graphics);
            this.mDrawing = false;
        }
    }
}

