/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOWriter;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.experimental.GreedyCluster;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class APUtils {
    static HashSet<Double> scoresSeen = new HashSet();

    private APUtils() {
    }

    public static void doExperiment(String path) {
        int epoch = 0;
        OrbitIO.getCurDesign().getCurSelection().clear();
        for (epoch = 0; epoch < 150; ++epoch) {
            APUtils.readDeviceCSV("/tmp/design." + epoch + ".csv");
            UserCommands.createConnections();
            OrbitIO.getApp().refreshCurrentView(true);
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ALog.logInfo((String)"Experiment complete");
    }

    private static FileWriter createCSVFile(String filePath) {
        FileWriter fileWriter;
        try {
            fileWriter = new FileWriter(new File(filePath));
        }
        catch (IOException e) {
            ALog.logError((String)("Can not open " + filePath + " for writing"));
            return null;
        }
        return fileWriter;
    }

    public static void readDeviceCSV(String filePath) {
        Db db = OrbitIO.getCurDb();
        CSVDocument csvDoc = null;
        if (filePath != null) {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            parser2.setDataSepExpression(",");
            try {
                csvDoc = parser2.parse(filePath);
            }
            catch (CSVDOMParser.CSVDOMException e) {
                ALog.logError((Throwable)e, (String)"Error parsing input file '%s'.", (Object[])new Object[]{filePath});
                return;
            }
        }
        if (csvDoc == null) {
            return;
        }
        int line = 0;
        try {
            for (line = 0; line < csvDoc.getItemCount(); ++line) {
                String mountedOn;
                DevicePath devicePath = DevicePath.fromString((Db)db, (String)csvDoc.getItemValue(line, "path"));
                if (devicePath == null) {
                    ALog.logError((String)"Unknown device path: %s", (Object[])new Object[]{csvDoc.getItemValue(line, "path")});
                    continue;
                }
                Device d = devicePath.getLast();
                DeviceTemplate dt = d.getTemplate();
                String heightStr = csvDoc.getItemValue(line, "dtHeight");
                if (!heightStr.equals("null")) {
                    long height = Long.parseLong(csvDoc.getItemValue(line, "dtHeight"));
                    if (dt.getValue("height") == null || (Long)dt.getValue("height") != height) {
                        dt.setValue("height", (Object)height);
                        ALog.logDebug((String)"Updated device template height %s", (Object[])new Object[]{dt.getName()});
                    }
                }
                long locx = Long.parseLong(csvDoc.getItemValue(line, "x"));
                long locy = Long.parseLong(csvDoc.getItemValue(line, "y"));
                float rot = Float.parseFloat(csvDoc.getItemValue(line, "rotation"));
                if (d.getLoc().getX() != locx || d.getLoc().getY() != locy) {
                    d.setLoc(new APoint2D(locx, locy));
                }
                if (d.getRotate() != rot) {
                    d.setRotate(rot);
                }
                if ((mountedOn = csvDoc.getItemValue(line, "mountedOnLayer")).equals("null")) continue;
                Layer layer = Layer.get((Db)db, (Substrate)d.getParent().getSubstrate(), (String)mountedOn);
                if (layer != null) {
                    if (d.getMountLayer().equals(layer)) continue;
                    d.setMountLayer(layer);
                    continue;
                }
                ALog.logWarn((String)"Unknown mountedOnLayer: %s", (Object[])new Object[]{mountedOn});
            }
        }
        catch (NumberFormatException e) {
            ALog.logError((String)"Invalid string format: %s on line %d ", (Object[])new Object[]{e.getMessage(), line + 2});
        }
    }

    public static void writeDeviceCSV(String devicePathString, String filePath) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"No database is open");
            return;
        }
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        FileWriter fileWriter = APUtils.createCSVFile(filePath);
        if (fileWriter == null) {
            return;
        }
        try {
            fileWriter.write("path,x,y,rotation,dtHeight,mountedOnLayer\n");
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
        for (DevicePath child : devicePath.getChildren()) {
            Device d = child.getLast();
            DeviceTemplate dt = d.getTemplate();
            try {
                fileWriter.write(String.format("%s,%d,%d,%f,%d,%s\n", child, d.getLoc().getX(), d.getLoc().getY(), Float.valueOf(d.getRotate()), dt.getValue("height"), d.getMountLayer() == null ? null : d.getMountLayer().getName()));
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
        }
        try {
            fileWriter.close();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    public static void changeTemplate(String devicePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate dt = devicePath.getDeviceTemplate();
        Unit unit = Design.getUnit((Db)db);
        long w = unit.fromUser(30000.0);
        long h = unit.fromUser(30000.0);
        ARect newBounds = new ARect(0L, 0L, w, h);
        dt.setBounds((AGeom)newBounds);
        int idx = 0;
        long pinSize = unit.fromUser(300.0);
        PadTemplate padTemplate = PadTemplate.create((Db)db, (Substrate)dt.getSubstrate(), (String)"p");
        Layer topLayer = dt.getSubstrate().getTopLayer();
        ARect pinRect = new ARect(-pinSize / 2L, -pinSize / 2L, pinSize / 2L, pinSize / 2L);
        LayerShape.create((Layer)topLayer, (DbObject)padTemplate, (AGeom)pinRect);
        long perSide = 51L;
        long spacing = w / (perSide + 1L);
        LinkedList<HierInst> sorted = new LinkedList<HierInst>();
        for (PinTemplate pt : dt.getPins()) {
            HierInst hp = new HierInst(devicePath, (DbObject)pt);
            sorted.add(hp);
        }
        Collections.sort(sorted, new PinSorter());
        for (HierInst hppt : sorted) {
            PinTemplate pt = (PinTemplate)hppt.second;
            APoint2D loc = idx < 51 ? new APoint2D(spacing + (long)idx * spacing, 0L) : (idx < 102 ? new APoint2D(w, spacing + (long)(idx - 51) * spacing) : (idx < 153 ? new APoint2D(spacing + (long)(idx - 102) * spacing, h) : new APoint2D(0L, spacing + (long)(idx - 153) * spacing)));
            pt.setLoc(loc);
            pt.setPadTemplate(padTemplate);
            ++idx;
        }
        IOView.buildIOViewFromCanvasUser();
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void clone(String devicePathString, String libPath) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        OrbitIOWriter.write((Device)devicePath.getLast(), (String)libPath, (boolean)true);
        devicePath.getLast().setName(devicePath.getLast().getName() + ".1");
        devicePath.getDeviceTemplate().setName(devicePath.getLast().getName() + ".1");
    }

    public static void selectAllChildren(String devicePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        Selection s = Design.getSelection((Db)db);
        for (DevicePath dp : devicePath.getChildren()) {
            s.add((DbObject)dp.getLast());
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void makePicture(GreedyCluster.GreedyComponentListChromosome gcl, String directoryName, long index, double score, int placed) {
        String imageName = "study." + index + ".jpg";
        String thisFileName = null;
        thisFileName = directoryName == null || directoryName.length() == 0 ? imageName : directoryName + File.separator + imageName;
        if (index == 0L) {
            scoresSeen.clear();
        }
        if (scoresSeen.contains(score)) {
            return;
        }
        scoresSeen.add(score);
        Object csvFileName = null;
        csvFileName = directoryName == null || directoryName.length() == 0 ? "labelmap.csv" : directoryName + File.separator + "labelmap.csv";
        List backup = OrbitIO.getCurDesign().getCurSelection().getAll().stream().collect(Collectors.toList());
        OrbitIO.getCurDesign().getCurSelection().clear();
        try (FileWriter stats = new FileWriter((String)csvFileName, index != 0L);){
            GreedyCluster.realizeBest(gcl);
            UserCommands.createConnections();
            OrbitIO.getApp().refreshCurrentView(true);
            DesignView2D v = (DesignView2D)OrbitIO.getCurView();
            Image image = v.getCanvas().getImage();
            BufferedImage bImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D g = bImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            File outputfile = new File(thisFileName);
            ImageIO.write((RenderedImage)bImage, "jpg", outputfile);
            stats.write(imageName + "," + score + "\n");
            stats.flush();
        }
        catch (IOException e1) {
            ALog.logError((Throwable)e1);
        }
        for (DbObject dbo : backup) {
            OrbitIO.getCurDesign().getCurSelection().add(dbo);
        }
    }

    public static class PinSorter
    implements Comparator<HierInst<PinTemplate>> {
        @Override
        public int compare(HierInst<PinTemplate> pt0, HierInst<PinTemplate> pt1) {
            Net top0 = NetMap.getParentNet((Device)((DevicePath)pt0.first).getLast(), (Net)((PinTemplate)pt0.second).getNet());
            Net top1 = NetMap.getParentNet((Device)((DevicePath)pt1.first).getLast(), (Net)((PinTemplate)pt1.second).getNet());
            if (top0 == null) {
                return -1;
            }
            if (top1 == null) {
                return -1;
            }
            return top0.getName().compareTo(top1.getName());
        }
    }
}

