/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizationControllerThread;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizer;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.experimental.Component;
import com.sigrity.orbit.automation.experimental.Pin;
import com.sigrity.orbit.automation.experimental.PlacementChromosomes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Pattern;

public class AutoPlace {
    static long baseCCGap = 0L;
    static long baseCEdgeGap = 0L;
    static HashMap<String, Double> net2Weight = new HashMap();
    static HashMap<APair<Integer, Integer>, Long> gapSpacings = new HashMap();
    static HashMap<String, Integer> name2int = new HashMap();
    static HashMap<String, HashSet<DevicePath>> collections = new HashMap();
    private static Unit sUnit;

    private AutoPlace() {
    }

    public static AGeneticOptimizer optimizeGenetically(String devicePathString, long seconds, int maxPopulation) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromEscapedString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return null;
        }
        PlacementChromosomes.GreedyComponentListChromosome starter = new PlacementChromosomes.GreedyComponentListChromosome();
        AGeneticOptimizer ago = new AGeneticOptimizer(true, true);
        Device parent = devicePath.getDevice();
        ARect parentBB = parent.getBB();
        long parentHeight = parentBB.height();
        long parentWidth = parentBB.width();
        ArrayList<String> hashSet = AutoPlace.generateHashSet((IterableIterator<DevicePath>)devicePath.getChildren());
        APoint2D parentLL = parent.getLoc();
        APoint2D parentAnchorPoint = parentBB.getLL();
        long parentOffsetX = Math.abs(parentLL.getX() - parentAnchorPoint.getX());
        long parentOffsetY = Math.abs(parentLL.getY() - parentAnchorPoint.getY());
        for (DevicePath child : devicePath.getChildren()) {
            Device c = child.getDevice();
            starter.add(AutoPlace.toComponent(devicePath, c, parentHeight, parentWidth, parentOffsetX, parentOffsetY, hashSet));
        }
        for (int i = 0; i < maxPopulation; ++i) {
            ago.addChromosome(starter.deepCopy(), null);
        }
        AGeneticOptimizationControllerThread evolveThread = new AGeneticOptimizationControllerThread(ago, seconds, OrbitIO.getCurDb().toString());
        AGeneticOptimizer.addLoadListener(new myUpdateListener());
        evolveThread.start();
        return ago;
    }

    public static ArrayList<String> generateHashSet(IterableIterator<DevicePath> paths) {
        ArrayList<String> netList = new ArrayList<String>();
        for (DevicePath child : paths) {
            Device d = child.getDevice();
            for (Net net : d.getNets()) {
                String netName;
                Net n = NetMap.getTopmostNet((Net)net, (DevicePath)child);
                int count = NetMap.getConnectedDevicePathPortsCount((Net)net, (DevicePath)child, (int)2);
                if (count <= 1 || netList.contains(netName = n.getName())) continue;
                netList.add(netName);
            }
        }
        Collections.sort(netList);
        return netList;
    }

    public static Component toComponent(DevicePath path, Device d, long parentHeight, long parentWidth, long parentOffsetX, long parentOffsetY, ArrayList<String> hashSet) {
        ARect boundingBox = d.getBB();
        long height = boundingBox.height();
        long width = boundingBox.width();
        long x = boundingBox.getLL().getX();
        long y = boundingBox.getLL().getY();
        long left = x;
        long oldLeft = x;
        long bottom = y;
        long oldBottom = y;
        long oldHeight = height;
        long oldWidth = width;
        ArrayList<Pin> pinList = new ArrayList<Pin>();
        DevicePath fullPath = path.withChild(d);
        for (PinInstance myPin : d.getPins()) {
            APoint2D pinLoc = myPin.getLocalLoc();
            Net n = NetMap.getTopmostNet((Net)myPin.getNet(), (DevicePath)fullPath);
            int count = NetMap.getConnectedDevicePathPortsCount((Net)myPin.getNet(), (DevicePath)fullPath, (int)2);
            if (count <= 1) continue;
            long x180 = left + Math.abs(oldLeft + oldWidth - pinLoc.getX());
            long y180 = bottom + Math.abs(oldBottom + oldHeight - pinLoc.getY());
            long left90 = left + width / 2L - height / 2L;
            long bottom90 = bottom + height / 2L - width / 2L;
            long x90 = left90 + Math.abs(oldBottom - pinLoc.getY());
            long y90 = bottom90 + Math.abs(oldLeft + oldWidth - pinLoc.getX());
            long x270 = left90 + Math.abs(oldBottom + oldHeight - pinLoc.getY());
            long y270 = bottom90 + Math.abs(oldLeft - pinLoc.getX());
            pinList.add(new Pin(pinLoc.getX(), pinLoc.getY(), x90, y90, x180, y180, x270, y270, n.getName(), hashSet.indexOf(n.getName()), hashSet.size()));
        }
        int listSize = pinList.size();
        Pin[] pins = new Pin[listSize];
        for (int i = 0; i < listSize; ++i) {
            pins[i] = (Pin)pinList.get(i);
        }
        APoint2D anchorPoint = d.getLoc();
        long centerToAnchorPointX = anchorPoint.getX() - boundingBox.centerX();
        long centerToAnchorPointY = anchorPoint.getY() - boundingBox.centerY();
        if (d.getIsFixed()) {
            return new Component(d.getName(), height, width, x - parentOffsetX, y - parentOffsetY, d.getRotate(), d.getRotate(), d.getMirror(), pins, d.getIsFixed(), d.getIsPlaced(), d, parentHeight, parentWidth, parentOffsetX, parentOffsetY, centerToAnchorPointX, centerToAnchorPointY);
        }
        return new Component(d.getName(), height, width, x, y, d.getRotate(), d.getRotate(), d.getMirror(), pins, d.getIsFixed(), d.getIsPlaced(), d, parentHeight, parentWidth, parentOffsetX, parentOffsetY, centerToAnchorPointX, centerToAnchorPointY);
    }

    public static PlacementChromosomes.GreedyComponentListChromosome pathToComponentList(String devicePathString, int maxIndividualSize) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromEscapedString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"ComponentPath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return null;
        }
        Device parent = devicePath.getDevice();
        ARect parentBB = parent.getBB();
        long parentHeight = parentBB.height();
        long parentWidth = parentBB.width();
        ArrayList<String> hashSet = AutoPlace.generateHashSet((IterableIterator<DevicePath>)devicePath.getChildren());
        APoint2D parentLL = parent.getLoc();
        APoint2D parentAnchorPoint = parentBB.getLL();
        long parentOffsetX = parentAnchorPoint.getX() - parentLL.getX();
        long parentOffsetY = parentAnchorPoint.getY() - parentLL.getY();
        PlacementChromosomes.GreedyComponentListChromosome individual = new PlacementChromosomes.GreedyComponentListChromosome();
        int most = maxIndividualSize;
        LinkedList<DevicePath> sorted = new LinkedList<DevicePath>();
        for (DevicePath child : devicePath.getChildren()) {
            sorted.add(child);
        }
        Collections.sort(sorted, new Comparator<DevicePath>(){

            @Override
            public int compare(DevicePath c1, DevicePath c2) {
                Double a1 = c1.getDevice().getBB().getArea();
                Double a2 = c2.getDevice().getBB().getArea();
                if (Math.abs(a1 - a2) > 1000.0) {
                    return a1.compareTo(a2);
                }
                return c1.compareTo(c2);
            }
        });
        for (int i = 0; i < sorted.size(); ++i) {
            int p1 = (int)Math.floor(Math.random() * (double)sorted.size());
            int p2 = (int)Math.floor(Math.random() * (double)sorted.size());
            DevicePath temp = (DevicePath)sorted.get(p1);
            sorted.set(p1, (DevicePath)sorted.get(p2));
            sorted.set(p2, temp);
        }
        int countFixedElements = 0;
        for (DevicePath child : sorted) {
            Device c = child.getDevice();
            Component myComp = AutoPlace.toComponent(devicePath, c, parentHeight, parentWidth, parentOffsetX, parentOffsetY, hashSet);
            if (most > 0) {
                c.setIsFixed(false);
                individual.add(myComp);
                if (myComp.getIsFixed()) {
                    ++countFixedElements;
                }
            } else {
                c.setIsFixed(false);
                c.setIsPlaced(false);
            }
            --most;
        }
        devicePath.getLast().manageMyUnplacedQ();
        individual.sort(new Comparator<Component>(){

            @Override
            public int compare(Component c1, Component c2) {
                return Boolean.valueOf(c2.getIsFixed()).compareTo(c1.getIsFixed());
            }
        });
        individual.setFixedElements(countFixedElements);
        return individual;
    }

    public static PlacementChromosomes.GreedyComponentListChromosome pathToComponentList2(int maxIndividualSize) {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        ArrayList<Device> children = new ArrayList<Device>();
        for (Device device : s.get(Device.class)) {
            children.add(device);
        }
        LinkedList toBePlaced = new LinkedList();
        children.stream().forEach(d -> toBePlaced.add(d.getADevicePath()));
        if (children.isEmpty()) {
            ALog.logError((String)"No selected device.");
            return null;
        }
        DevicePath devicePath = ((Device)children.get(0)).getAParentDevice().getADevicePath();
        if (devicePath == null) {
            ALog.logWarn((String)"ComponentPath does not exist");
            return null;
        }
        Device parent = devicePath.getDevice();
        ARect parentBB = parent.getBB();
        long parentHeight = parentBB.height();
        long parentWidth = parentBB.width();
        ArrayList<String> hashSet = AutoPlace.generateHashSet((IterableIterator<DevicePath>)devicePath.getChildren());
        APoint2D parentLL = parent.getLoc();
        APoint2D parentAnchorPoint = parentBB.getLL();
        long parentOffsetX = parentAnchorPoint.getX() - parentLL.getX();
        long parentOffsetY = parentAnchorPoint.getY() - parentLL.getY();
        PlacementChromosomes.GreedyComponentListChromosome individual = new PlacementChromosomes.GreedyComponentListChromosome();
        int most = maxIndividualSize;
        LinkedList<DevicePath> sorted = new LinkedList<DevicePath>();
        for (Device child : children) {
            sorted.add(child.getADevicePath());
        }
        Collections.sort(sorted, new Comparator<DevicePath>(){

            @Override
            public int compare(DevicePath c1, DevicePath c2) {
                Double a1 = c1.getDevice().getBB().getArea();
                Double a2 = c2.getDevice().getBB().getArea();
                if (Math.abs(a1 - a2) > 1000.0) {
                    return a1.compareTo(a2);
                }
                return c1.compareTo(c2);
            }
        });
        for (int i = 0; i < sorted.size(); ++i) {
            int p1 = (int)Math.floor(Math.random() * (double)sorted.size());
            int p2 = (int)Math.floor(Math.random() * (double)sorted.size());
            DevicePath temp = (DevicePath)sorted.get(p1);
            sorted.set(p1, (DevicePath)sorted.get(p2));
            sorted.set(p2, temp);
        }
        int countFixedElements = 0;
        for (DevicePath child : sorted) {
            Device c = child.getDevice();
            Component myComp = AutoPlace.toComponent(devicePath, c, parentHeight, parentWidth, parentOffsetX, parentOffsetY, hashSet);
            if (most > 0) {
                individual.add(myComp);
                if (myComp.getIsFixed()) {
                    ++countFixedElements;
                }
            } else {
                c.setIsPlaced(false);
            }
            --most;
        }
        devicePath.getLast().manageMyUnplacedQ();
        individual.sort(new Comparator<Component>(){

            @Override
            public int compare(Component c1, Component c2) {
                return Boolean.valueOf(c2.getIsFixed()).compareTo(c1.getIsFixed());
            }
        });
        individual.setFixedElements(countFixedElements);
        return individual;
    }

    public static void test(String devicePath, int size) {
        PlacementChromosomes.GreedyComponentListChromosome starter = AutoPlace.pathToComponentList(devicePath, size);
        if (starter == null) {
            ALog.logError((String)"Cannot get correct chromosome from '%s'", (Object[])new Object[]{devicePath});
            return;
        }
        ALog.logDebug((String)("fitness = " + Objects.toString(starter.fitness())));
        Db db = OrbitIO.getCurDb();
        for (Component c : starter) {
            Device d = (Device)c.getObject();
            DevicePath devicePath2real = DevicePath.fromEscapedString((Db)db, (String)devicePath);
            ALog.logDebug((String)devicePath2real.getString());
            APoint2D x = d.getBB().getLL();
            ALog.logDebug((String)("parentOffsetX = " + c.getXAnchorPoint()));
            ALog.logDebug((String)("parentOffsetY = " + c.getYAnchorPoint()));
            ALog.logDebug((String)("centerToAnchorPointX= " + c.getXAnchorPoint()));
            ALog.logDebug((String)("centerToAnchorPointY = " + c.getYAnchorPoint()));
            d.setMirror(c.getMirror());
            d.setRotate(c.getRotate());
            d.setLoc(new APoint2D(c.getXAnchorPoint() + c.getParentOffsetX(), c.getYAnchorPoint() + c.getParentOffsetY()));
            ALog.logDebug((String)("testx = " + x));
            ALog.logDebug((String)("name = " + d.getName()));
            ALog.logDebug((String)("rotate = " + d.getRotate()));
        }
        OrbitIO.getApp().refreshCurrentView(true);
    }

    public static double curFitness() {
        PlacementChromosomes.GreedyComponentListChromosome chromosome = AutoPlace.pathToComponentList2(Integer.MAX_VALUE);
        double fitness = chromosome.curFitness();
        ALog.logInfo((String)("Current fitness: " + fitness));
        return fitness;
    }

    public static AGeneticOptimizer testOrder(String devicePathString, String logFile, long seconds, int maxPopulation) {
        AGeneticOptimizer ago = new AGeneticOptimizer(true, true);
        ago.setMaxPopulation(maxPopulation);
        PlacementChromosomes.GreedyComponentListChromosome myChromosome = AutoPlace.pathToComponentList(devicePathString, 1000);
        if (myChromosome == null) {
            ALog.logError((String)"Cannot get correct chromosome from '%s'", (Object[])new Object[]{devicePathString});
            return ago;
        }
        for (int i = 0; i < maxPopulation; ++i) {
            ago.addChromosome(myChromosome.deepCopy(), null);
        }
        ago.evolveForTime(seconds);
        PlacementChromosomes.GreedyComponentListChromosome best = (PlacementChromosomes.GreedyComponentListChromosome)ago.getBestIndividual();
        AutoPlace.placeFromIndividual(best);
        OrbitIO.getApp().refreshCurrentView(true);
        AutoPlace.writeStatsFile(logFile, devicePathString, seconds, maxPopulation, ago);
        return ago;
    }

    public static void collectSelected(String collectionName) {
        Selection selection = Design.getSelection((Db)OrbitIO.getCurDb());
        HashSet<DevicePath> collection = new HashSet<DevicePath>();
        for (Device obj : selection.get(Device.class)) {
            for (DevicePath dp : selection.getSelectedPaths((DbObject)obj)) {
                DevicePath fullPath = dp.withChild(obj);
                collection.add(fullPath);
            }
        }
        collections.put(collectionName, collection);
    }

    public static void selectCollection(String collectionName) {
        HashSet<DevicePath> collection = collections.get(collectionName);
        if (collection == null) {
            ALog.logWarn((String)("Collection " + collectionName + " does not exist"));
            return;
        }
        Selection selection = Design.getSelection((Db)OrbitIO.getCurDb());
        selection.clear();
        for (DevicePath dp : collection) {
            selection.add((DbObject)dp.getLast());
        }
    }

    public static void clearConstraints() {
        baseCCGap = 0L;
        baseCEdgeGap = 0L;
        net2Weight.clear();
    }

    public static void setGaps(double uGap, double uGapEdge) {
        sUnit = Design.getUnit((Db)OrbitIO.getCurDb());
        baseCCGap = sUnit.fromUser(uGap);
        baseCEdgeGap = sUnit.fromUser(uGapEdge);
    }

    public static void setGapsTable(String c1, String c2, double uGap) {
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        sUnit = currentDesign.getUnit();
        APair<Integer, Integer> key = AutoPlace.getUniqueKey(c1, c2);
        gapSpacings.put(key, sUnit.fromUser(uGap));
    }

    static APair<Integer, Integer> getUniqueKey(String name1, String name2) {
        Integer i2;
        Integer i1 = name2int.get(name1);
        if (i1 == null) {
            i1 = name2int.size();
            name2int.put(name1, i1);
        }
        if ((i2 = name2int.get(name2)) == null) {
            i2 = name2int.size();
            name2int.put(name2, i2);
        }
        if (i1 < i2) {
            return new APair((Object)i1, (Object)i2);
        }
        return new APair((Object)i2, (Object)i1);
    }

    public static long getCCGap(Component c1, Component c2) {
        APair<Integer, Integer> key = AutoPlace.getUniqueKey(c1.getName(), c2.getName());
        Long gap = gapSpacings.get(key);
        return gap == null ? baseCCGap : gap;
    }

    public static long getCToEdgeGap(Component c) {
        return baseCEdgeGap;
    }

    public static void clearNetWeights() {
        net2Weight.clear();
        gapSpacings.clear();
        name2int.clear();
    }

    public static void setNetWeight(String netPattern, double weight) {
        Db db = OrbitIO.getCurDb();
        Pattern pattern = Pattern.compile(netPattern);
        for (Net n : db.getObjects(Net.class)) {
            String name = n.getName();
            if (name == null || !pattern.matcher(name).matches()) continue;
            net2Weight.put(name, weight);
            ALog.logInfo((String)(name + " weight set to " + weight));
        }
    }

    public static void getNetWeight(String netName) {
    }

    public static void writeStatsFile(String logFile, String devicePathString, long seconds, int maxPopulation, AGeneticOptimizer ago) {
        try (FileWriter fw = new FileWriter(new File(logFile), true);){
            ZonedDateTime timeStamp = ZonedDateTime.now();
            String date = timeStamp.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT));
            String buffer = date + "," + devicePathString + "," + seconds + "," + maxPopulation + "," + ago.getBestScore() + "," + ago.getReproductionRate() + "," + Runtime.getRuntime().availableProcessors() + "\n";
            fw.write(buffer);
            fw.flush();
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    public static void placeFromIndividual(PlacementChromosomes.GreedyComponentListChromosome ind) {
        for (Component c : ind) {
            Device d = (Device)c.getObject();
            d.setMirror(c.getMirror());
            d.setRotate(c.getRotate());
            d.setLoc(new APoint2D(c.getXAnchorPoint() + c.getParentOffsetX(), c.getYAnchorPoint() + c.getParentOffsetY()));
            d.setIsFixed(c.getIsFixed());
        }
    }

    public static int checkLinkDesign(int numLinks) {
        Db db = OrbitIO.getCurDb();
        int score = 0;
        for (int i = 0; i < numLinks - 1; ++i) {
            Device d0 = Device.getADeviceByName((Db)db, (String)("link" + i));
            Device d1 = Device.getADeviceByName((Db)db, (String)("link" + (i + 1)));
            if (d0.getLoc().getX() >= d1.getLoc().getX()) continue;
            ++score;
        }
        return score;
    }

    public static void makeCellDesign(String parentPath, int rows, int cols) {
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        long pinSize = unit.fromUser(100.0);
        long devSize = unit.fromUser(1000.0);
        long devHalfSize = devSize / 2L;
        DevicePath devicePath = DevicePath.fromEscapedString((Db)db, (String)parentPath);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{parentPath});
            return;
        }
        DeviceTemplate parentTemplate = devicePath.getDeviceTemplate();
        Substrate s = parentTemplate.getSubstrate();
        Layer l = s.getTopLayer();
        ARect pinRect = new ARect(-pinSize / 2L, -pinSize / 2L, pinSize / 2L, pinSize / 2L);
        ARect deviceRect = new ARect(-devSize / 2L, -devSize / 2L, devSize / 2L, devSize / 2L);
        DeviceTemplate dt = DeviceTemplate.create((Substrate)s, (String)"cellT", (boolean)true);
        Net nT = Net.create((DeviceTemplate)dt, (String)"netT");
        Net nR = Net.create((DeviceTemplate)dt, (String)"netR");
        Net nB = Net.create((DeviceTemplate)dt, (String)"netB");
        Net nL = Net.create((DeviceTemplate)dt, (String)"netL");
        PinTemplate pt0 = PinTemplate.create((Net)nT, (String)"pinT");
        PinTemplate pt1 = PinTemplate.create((Net)nR, (String)"pinR");
        PinTemplate pt2 = PinTemplate.create((Net)nB, (String)"pinB");
        PinTemplate pt3 = PinTemplate.create((Net)nL, (String)"pinL");
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)s, (String)"padtempalte");
        LayerShape.create((Layer)l, (DbObject)pt, (AGeom)pinRect);
        pt0.setPadTemplate(pt);
        pt1.setPadTemplate(pt);
        pt2.setPadTemplate(pt);
        pt3.setPadTemplate(pt);
        pt0.setLoc(new APoint2D(0L, devHalfSize));
        pt1.setLoc(new APoint2D(devHalfSize, 0L));
        pt2.setLoc(new APoint2D(0L, -devHalfSize));
        pt3.setLoc(new APoint2D(-devHalfSize, 0L));
        dt.setBounds((AGeom)deviceRect);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                Net n3;
                Device d = Device.create((String)("d." + r + "." + c), (DeviceTemplate)dt, (DeviceTemplate)parentTemplate);
                DevicePath fullPath = devicePath.withChild(d);
                d.setLoc(new APoint2D(0L, 0L));
                Net n0 = Net.create((DeviceTemplate)parentTemplate, (String)("n.t." + r + "." + c));
                Net n1 = Net.create((DeviceTemplate)parentTemplate, (String)("n.r." + r + "." + c));
                NetMap.mapUpTo((DevicePath)fullPath, (Net)d.getPin(pt0).getNet(), (Net)n0);
                NetMap.mapUpTo((DevicePath)fullPath, (Net)d.getPin(pt1).getNet(), (Net)n1);
                Net n2 = Net.get((DeviceTemplate)parentTemplate, (String)("n.t." + (r - 1) + "." + c));
                if (n2 != null) {
                    NetMap.mapUpTo((DevicePath)fullPath, (Net)d.getPin(pt2).getNet(), (Net)n2);
                }
                if ((n3 = Net.get((DeviceTemplate)parentTemplate, (String)("n.r." + r + "." + (c - 1)))) == null) continue;
                NetMap.mapUpTo((DevicePath)fullPath, (Net)d.getPin(pt3).getNet(), (Net)n3);
            }
        }
    }

    public static void makeLinkDesign(String parentPath, int numLinks) {
        Db db = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)db);
        long pinSize = unit.fromUser(1500.0);
        long devSize = unit.fromUser(15000.0);
        DevicePath devicePath = DevicePath.fromEscapedString((Db)db, (String)parentPath);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{parentPath});
            return;
        }
        DeviceTemplate parentTemplate = devicePath.getDeviceTemplate();
        Substrate s = parentTemplate.getSubstrate();
        Layer l = s.getTopLayer();
        ARect pinRect = new ARect(0L, 0L, pinSize, pinSize);
        ARect deviceRect = new ARect(0L, 0L, devSize, pinSize);
        DeviceTemplate dt = DeviceTemplate.create((Substrate)s, (String)"ALINK", (boolean)true);
        Net inNet = Net.create((DeviceTemplate)dt, (String)"in");
        Net outNet = Net.create((DeviceTemplate)dt, (String)"out");
        PinTemplate pt0 = PinTemplate.create((Net)inNet, (String)"in");
        PinTemplate pt1 = PinTemplate.create((Net)outNet, (String)"out");
        PadTemplate pt = PadTemplate.create((Db)db, (Substrate)s, (String)"padtempalte");
        LayerShape.create((Layer)l, (DbObject)pt, (AGeom)pinRect);
        pt0.setPadTemplate(pt);
        pt1.setPadTemplate(pt);
        pt0.setLoc(new APoint2D(0L, 0L));
        pt1.setLoc(new APoint2D(devSize - pinSize, 0L));
        dt.setBounds((AGeom)deviceRect);
        Device lastDevice = null;
        for (int i = 0; i < numLinks; ++i) {
            Device d = Device.create((String)("link" + i), (DeviceTemplate)dt, (DeviceTemplate)parentTemplate);
            if (i == 0) {
                d.setLoc(new APoint2D(100000L, 100000L));
            } else {
                d.setLoc(new APoint2D(0L, (long)i * pinSize));
            }
            Net n1 = Net.create((DeviceTemplate)parentTemplate, (String)("net" + i));
            DevicePath fullPath = devicePath.withChild(d);
            NetMap.mapUpTo((DevicePath)fullPath, (Net)pt1.getNet(), (Net)n1);
            if (lastDevice != null) {
                Net n0 = parentTemplate.getNet("net" + (i - 1));
                NetMap.mapUpTo((DevicePath)fullPath, (Net)pt0.getNet(), (Net)n0);
            }
            lastDevice = d;
        }
    }

    static class myUpdateListener
    implements AGeneticOptimizer.GeneticOptimizerStatusListener {
        myUpdateListener() {
        }

        @Override
        public void stats(int percent, boolean done, String data) {
            if (done) {
                // empty if block
            }
        }
    }
}

