/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.ALog;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.automation.experimental.AutoPlace;
import com.sigrity.orbit.automation.experimental.ComponentLocation;
import com.sigrity.orbit.automation.experimental.Pin;
import java.util.ArrayList;
import java.util.Objects;

public class Component {
    protected String name;
    protected long height;
    protected long width;
    protected long left;
    protected long bottom;
    protected float rotate = 0.0f;
    protected boolean mirror = false;
    protected long centerToAnchorpointX;
    protected long centerToAnchorpointY;
    protected float originalRotate = 0.0f;
    protected Pin[] pins;
    protected boolean isPlaced = true;
    protected boolean isFixed = false;
    protected Object object;
    protected long parentHeight;
    protected long parentWidth;
    protected long parentOffsetX;
    protected long parentOffsetY;
    protected ArrayList<Integer> horizontalOccupation = new ArrayList();
    protected ArrayList<Integer> verticalOccupation = new ArrayList();

    public Component(String objName, long objHeight, long objWidth, long x, long y, float objRotate, float objOriginalRotate, boolean objMirror, Pin[] objPins, boolean objIsFixed, boolean objIsPlaced, Object obj, long parHeight, long parWidth, long parOffsetX, long parOffsetY, long objCenterToAnchorPointX, long objCenterToAnchorPointY) {
        this.name = objName;
        this.height = objHeight;
        this.width = objWidth;
        this.left = x;
        this.bottom = y;
        this.rotate = objRotate;
        this.centerToAnchorpointX = objCenterToAnchorPointX;
        this.centerToAnchorpointY = objCenterToAnchorPointY;
        this.originalRotate = objOriginalRotate;
        this.mirror = objMirror;
        this.pins = objPins;
        this.isPlaced = objIsPlaced;
        this.isFixed = objIsFixed;
        this.object = obj;
        this.parentHeight = parHeight;
        this.parentWidth = parWidth;
        this.parentOffsetX = parOffsetX;
        this.parentOffsetY = parOffsetY;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public long getHeight() {
        return this.height;
    }

    public long getWidth() {
        return this.width;
    }

    public long getXAnchorPoint() {
        float totalRotate = ((this.rotate - this.originalRotate) % 360.0f + 360.0f) % 360.0f;
        long newCenterToAnchorpointX = Math.round((double)this.centerToAnchorpointX * Math.cos(Math.toRadians(totalRotate)) + (double)this.centerToAnchorpointY * Math.sin(Math.toRadians(totalRotate)));
        long left = this.getCenterLeft();
        return left + newCenterToAnchorpointX;
    }

    public long getYAnchorPoint() {
        float totalRotate = ((this.rotate - this.originalRotate) % 360.0f + 360.0f) % 360.0f;
        long newCenterToAnchorpointY = Math.round((double)(-this.centerToAnchorpointX) * Math.sin(Math.toRadians(totalRotate)) + (double)this.centerToAnchorpointY * Math.cos(Math.toRadians(totalRotate)));
        long bot = this.getCenterBottom();
        return bot + newCenterToAnchorpointY;
    }

    public long getLeft() {
        return this.left;
    }

    public long getBottom() {
        return this.bottom;
    }

    public long getRight() {
        return this.left + this.width;
    }

    public long getTop() {
        return this.bottom + this.height;
    }

    public long getCenterLeft() {
        return this.left + this.width / 2L;
    }

    public long getCenterBottom() {
        return this.bottom + this.height / 2L;
    }

    public float getRotate() {
        return this.rotate;
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public Pin[] getPins() {
        return this.pins;
    }

    public int getPinCount() {
        return this.pins.length;
    }

    public boolean getIsFixed() {
        return this.isFixed;
    }

    public boolean getIsPlaced() {
        return this.isPlaced;
    }

    public Object getObject() {
        return this.object;
    }

    public long getParentHeight() {
        return this.parentHeight;
    }

    public long getParentWidth() {
        return this.parentWidth;
    }

    public long getParentOffsetX() {
        return this.parentOffsetX;
    }

    public long getParentOffsetY() {
        return this.parentOffsetY;
    }

    public ArrayList<Integer> getHorizontalOccupation() {
        return this.horizontalOccupation;
    }

    public ArrayList<Integer> getVerticalOccupation() {
        return this.verticalOccupation;
    }

    public void setLL(long x, long y) {
        for (Pin p : this.pins) {
            long xv = p.getX() + (x - this.left);
            long yv = p.getY() + (y - this.bottom);
            p.setLoc(xv, yv);
        }
        this.left = x;
        this.bottom = y;
    }

    public void recalcRotations() {
    }

    public void setCenter(long x, long y) {
        this.setLL(x - this.width / 2L, y - this.height / 2L);
    }

    public void moveBy(long x, long y) {
        this.setLL(this.left + x, this.bottom + y);
    }

    public void moveHoriz(long x) {
        this.setLL(this.left + x, this.bottom);
    }

    public void moveVert(long y) {
        this.setLL(this.left, this.bottom + y);
    }

    public void setRotate(float newAngle) {
        if (newAngle % 90.0f != 0.0f) {
            ALog.logError((String)"You can only use angles that are multiple of 90 degrees.");
        } else {
            long oldLeft = this.left;
            long oldBottom = this.bottom;
            long oldHeight = this.height;
            long oldWidth = this.width;
            if ((newAngle - this.rotate) % 180.0f == 90.0f || (newAngle - this.rotate) % 180.0f == -90.0f) {
                this.left = this.left + this.width / 2L - this.height / 2L;
                this.bottom = this.bottom + this.height / 2L - this.width / 2L;
                long temp = this.width;
                this.width = this.height;
                this.height = temp;
            }
            switch ((int)((newAngle - this.rotate) % 360.0f + 360.0f) % 360) {
                case 0: {
                    break;
                }
                case 90: {
                    for (Pin p : this.pins) {
                        p.setLoc(this.left + Math.abs(oldBottom - p.getY()), this.bottom + Math.abs(oldLeft + oldWidth - p.getX()));
                    }
                    break;
                }
                case 180: {
                    for (Pin p : this.pins) {
                        p.setLoc(this.left + Math.abs(oldLeft + oldWidth - p.getX()), this.bottom + Math.abs(oldBottom + oldHeight - p.getY()));
                    }
                    break;
                }
                case 270: {
                    for (Pin p : this.pins) {
                        p.setLoc(this.left + Math.abs(oldBottom + oldHeight - p.getY()), this.bottom + Math.abs(oldLeft - p.getX()));
                    }
                    break;
                }
            }
            this.rotate = newAngle % 360.0f;
        }
    }

    public void setRotateLL(long x, long y, float r) {
        this.setRotate(r);
        this.setLL(x, y);
    }

    public void setMirrorRotateLL(long x, long y, float r, boolean m) {
        this.setMirror(m);
        this.setRotate(r);
        this.setLL(x, y);
    }

    public void setMirrorRotateLL(ComponentLocation loc) {
        this.setMirror(loc.getMirror());
        this.setRotate(loc.getRotate());
        this.setLL(loc.getX(), loc.getY());
    }

    public void rotateClock() {
        this.setRotate(this.rotate + 90.0f);
    }

    public void rotateClock(float angle) {
        this.setRotate(this.rotate + angle);
    }

    public void rotateAntiClock() {
        this.setRotate(this.rotate - 90.0f);
    }

    public void rotateAntiClock(float angle) {
        this.setRotate(this.rotate - angle);
    }

    public void setMirror(boolean m) {
        if (m == this.mirror) {
            return;
        }
        this.setMirror();
    }

    public void setMirror() {
        this.mirror = !this.mirror;
        for (Pin p : this.pins) {
            p.setLoc(Math.abs(this.left + this.width - p.getX()), p.getY());
        }
    }

    public void setCoordinates(long x, long y, float rot, boolean mir) {
        this.setMirror(mir);
        this.setRotate(rot);
        this.setLL(x, y);
    }

    public boolean vOverlaps(Component c) {
        return c.getTop() > this.getBottom() && c.getBottom() < this.getTop();
    }

    public boolean hOverlaps(Component c) {
        return c.getRight() > this.getLeft() && c.getLeft() < this.getRight();
    }

    public boolean intersects(Component c) {
        return this.hOverlaps(c) && this.vOverlaps(c);
    }

    public boolean vOverlapsWithGap(Component c, Long gap) {
        return c.getTop() + gap > this.getBottom() && c.getBottom() - gap < this.getTop();
    }

    public boolean hOverlapsWithGap(Component c, Long gap) {
        return c.getRight() + gap > this.getLeft() && c.getLeft() - gap < this.getRight();
    }

    public boolean intersectsWithGap(Component c) {
        Long gap = AutoPlace.getCCGap(this, c);
        return this.hOverlapsWithGap(c, gap) && this.vOverlapsWithGap(c, gap);
    }

    public boolean vBelong() {
        for (Pin p : this.getPins()) {
            if (p.getY() > this.getBottom() && p.getY() < this.getTop()) continue;
            return false;
        }
        return true;
    }

    public boolean hBelong() {
        for (Pin p : this.getPins()) {
            if (p.getX() > this.getLeft() && p.getX() < this.getRight()) continue;
            return false;
        }
        return true;
    }

    public boolean pinBelong() {
        return this.hBelong() && this.vBelong();
    }

    public boolean withinVerticalBounds() {
        return this.getBottom() >= 0L && this.getTop() <= this.parentHeight;
    }

    public boolean withinHorizontalBounds() {
        return this.getLeft() >= 0L && this.getRight() <= this.parentWidth;
    }

    public boolean withinBounds() {
        return this.withinVerticalBounds() && this.withinHorizontalBounds();
    }

    public boolean withinVerticalBoundsWithGap() {
        boolean b;
        long edgeGap = AutoPlace.getCToEdgeGap(this);
        long bottom = this.getBottom();
        long top = this.getTop();
        long bottomlimit = 0L - this.parentOffsetY + edgeGap;
        long toplimit = this.parentHeight - this.parentOffsetY - edgeGap;
        boolean a = bottom >= bottomlimit;
        boolean bl = b = top <= toplimit;
        return a && b;
    }

    public boolean withinHorizontalBoundsWithGap() {
        boolean b;
        long edgeGap = AutoPlace.getCToEdgeGap(this);
        long limitl = 0L - this.parentOffsetX + edgeGap;
        long limitr = this.parentWidth + this.parentOffsetX - edgeGap;
        long left = this.getLeft();
        long right = this.getRight();
        boolean a = left >= limitl;
        boolean bl = b = right <= limitr;
        return a && b;
    }

    public boolean withinBoundsWithGap() {
        return this.withinVerticalBoundsWithGap() && this.withinHorizontalBoundsWithGap();
    }

    public void setIsPlaced(boolean b) {
        this.isPlaced = b;
    }

    public void setIsFixed(boolean b) {
        this.isFixed = b;
    }

    public void setHorizontalOccupation(ArrayList<Integer> newOccupation) {
        this.horizontalOccupation = newOccupation;
    }

    public void setVerticalOccupation(ArrayList<Integer> newOccupation) {
        this.verticalOccupation = newOccupation;
    }

    public Component deepCopy() {
        String nameCopy = this.name;
        long heightCopy = this.height;
        long widthCopy = this.width;
        long leftCopy = this.left;
        long bottomCopy = this.bottom;
        float rotateCopy = this.rotate;
        boolean mirrorCopy = this.mirror;
        long centerToAnchorpointXCopy = this.centerToAnchorpointX;
        long centerToAnchorpointYCopy = this.centerToAnchorpointY;
        float originalRotateCopy = this.originalRotate;
        Pin[] pinsCopy = new Pin[this.pins.length];
        for (int i = 0; i < this.pins.length; ++i) {
            pinsCopy[i] = this.pins[i].deepCopy();
        }
        boolean isPlacedCopy = this.isPlaced;
        boolean isFixedCopy = this.isFixed;
        long parentHeightCopy = this.parentHeight;
        long parentWidthCopy = this.parentWidth;
        long parentOffsetXCopy = this.parentOffsetX;
        long parentOffsetYCopy = this.parentOffsetY;
        return new Component(nameCopy, heightCopy, widthCopy, leftCopy, bottomCopy, rotateCopy, originalRotateCopy, mirrorCopy, pinsCopy, isFixedCopy, isPlacedCopy, this.object, parentHeightCopy, parentWidthCopy, parentOffsetXCopy, parentOffsetYCopy, centerToAnchorpointXCopy, centerToAnchorpointYCopy);
    }

    public void printAll() {
        ALog.logDebug((String)("height = " + Objects.toString(this.height) + " width = " + Objects.toString(this.width)));
        ALog.logDebug((String)("x = " + Objects.toString(this.left) + " y = " + Objects.toString(this.bottom)));
        ALog.logDebug((String)("rotate = " + Objects.toString(Float.valueOf(this.rotate)) + " mirror = " + Objects.toString(this.mirror)));
    }

    public ARect getBounds() {
        return new ARect(this.left, this.bottom, this.left + this.width, this.bottom + this.height);
    }
}

