/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.ARandom;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DrawGraph
extends JPanel {
    private static int MAX_SCORE = 10;
    private static final int PREF_W = 800;
    private static final int PREF_H = 650;
    private static final int BORDER_GAP = 30;
    private static final Color GRAPH_COLOR = Color.green;
    private static final Color GRAPH_POINT_COLOR = new Color(150, 50, 50, 180);
    private static final Stroke GRAPH_STROKE = new BasicStroke(3.0f);
    private static final int GRAPH_POINT_WIDTH = 0;
    private static final int Y_HATCH_CNT = 10;
    private List<Float> scores;

    public DrawGraph(List<Float> scores) {
        this.scores = scores;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i;
        int y1;
        int y0;
        int x1;
        int x0;
        int i2;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double xScale = ((double)this.getWidth() - 60.0) / (double)(this.scores.size() - 1);
        double yScale = ((double)this.getHeight() - 60.0) / (double)(MAX_SCORE - 1);
        ArrayList<Point> graphPoints = new ArrayList<Point>();
        for (i2 = 0; i2 < this.scores.size(); ++i2) {
            int x12 = (int)((double)i2 * xScale + 30.0);
            int y12 = (int)((double)((float)MAX_SCORE - this.scores.get(i2).floatValue()) * yScale + 30.0);
            graphPoints.add(new Point(x12, y12));
        }
        g2.drawLine(30, this.getHeight() - 30, 30, 30);
        g2.drawLine(30, this.getHeight() - 30, this.getWidth() - 30, this.getHeight() - 30);
        for (i2 = 0; i2 < 10; ++i2) {
            x0 = 30;
            x1 = 30;
            y1 = y0 = this.getHeight() - ((i2 + 1) * (this.getHeight() - 60) / 10 + 30);
            g2.drawLine(x0, y0, x1, y1);
        }
        for (i2 = 0; i2 < this.scores.size() - 1; ++i2) {
            x1 = x0 = (i2 + 1) * (this.getWidth() - 60) / (this.scores.size() - 1) + 30;
            y0 = this.getHeight() - 30;
            y1 = y0 - 0;
            g2.drawLine(x0, y0, x1, y1);
        }
        Stroke oldStroke = g2.getStroke();
        g2.setColor(GRAPH_COLOR);
        g2.setStroke(GRAPH_STROKE);
        for (i = 0; i < graphPoints.size() - 1; ++i) {
            x1 = ((Point)graphPoints.get((int)i)).x;
            int y13 = ((Point)graphPoints.get((int)i)).y;
            int x2 = ((Point)graphPoints.get((int)(i + 1))).x;
            int y2 = ((Point)graphPoints.get((int)(i + 1))).y;
            g2.drawLine(x1, y13, x2, y2);
        }
        g2.setStroke(oldStroke);
        g2.setColor(GRAPH_POINT_COLOR);
        for (i = 0; i < graphPoints.size(); ++i) {
            int x = ((Point)graphPoints.get((int)i)).x - 0;
            int y = ((Point)graphPoints.get((int)i)).y - 0;
            int ovalW = 0;
            int ovalH = 0;
            g2.fillOval(x, y, ovalW, ovalH);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 650);
    }

    private static void createAndShowGui() {
        ArrayList<Float> scores = new ArrayList<Float>();
        Random random = ARandom.get();
        int maxDataPoints = 16;
        int maxScore = 20;
        for (int i = 0; i < maxDataPoints; ++i) {
            scores.add(Float.valueOf(random.nextInt(maxScore)));
        }
        DrawGraph mainPanel = new DrawGraph(scores);
        JFrame frame = new JFrame("DrawGraph");
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(mainPanel);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public void draw() {
        MAX_SCORE = 10;
        ArrayList<Float> intscores = new ArrayList<Float>();
        for (Float score : this.scores) {
            double decimalPlaces = Math.log10(score.floatValue());
            decimalPlaces = Math.floor(decimalPlaces);
            float test = (float)((double)score.floatValue() / Math.pow(10.0, decimalPlaces));
            intscores.add(Float.valueOf(test));
        }
        MAX_SCORE = ((Float)Collections.max(intscores)).intValue() + 1;
        DrawGraph mainPanel = new DrawGraph(intscores);
        JFrame frame = new JFrame("DrawGraph");
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().add(mainPanel);
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DrawGraph.createAndShowGui();
            }
        });
    }
}

