/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.ACsvReader;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizer;
import com.sigrity.acl.optimizer.genetic.Chromosome;
import com.sigrity.acl.topology.Binner;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.experimental.APDebugOverlay;
import com.sigrity.orbit.automation.experimental.APUtils;
import com.sigrity.orbit.automation.experimental.AutoPlace;
import com.sigrity.orbit.automation.experimental.Component;
import com.sigrity.orbit.automation.experimental.ComponentLocation;
import com.sigrity.orbit.automation.experimental.DrawGraph;
import com.sigrity.orbit.automation.experimental.Pin;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class GreedyCluster {
    protected LinkedList<Component> mFreePlaceList = new LinkedList();
    protected LinkedList<Component> mFixedPlaceList = new LinkedList();
    protected LinkedList<ARect> mKeepouts = new LinkedList();
    protected ARect mKeepIn;
    protected Db db = OrbitIO.getCurDb();
    protected List<Device> list = this.db.getObjects(Device.class).stream().filter(x -> x.getIsFixed()).collect(Collectors.toList());
    static APDebugOverlay test2 = new APDebugOverlay();
    protected static List<Obstacle> obsList = new ArrayList<Obstacle>();
    protected int mNumberOfObs = this.db.getObjectCount(Obstacle.class);
    protected static boolean mAnimation = false;
    protected static long mPlacementMode = 1L;
    protected static boolean mSwitchMode = false;
    public AGeneticOptimizer mGeneticOptimizer;
    ArrayList<Long> mScores = new ArrayList();
    ImageGeneration mIG;
    String mLearnDirName = "";
    String mExperimentName = "";
    String mMode = "";
    long mEpoch = 0L;
    protected boolean mVerboseMode = true;

    public void addFree(Component c) {
        this.mFreePlaceList.add(c);
    }

    public void addFixed(Component c) {
        this.mFixedPlaceList.add(c);
    }

    public void setParentBounds(ARect r) {
        this.mKeepIn = r;
    }

    public void setLearnParams(String dirName, String experimentName, String mode) {
        this.mLearnDirName = dirName;
        this.mExperimentName = experimentName;
        this.mMode = mode;
    }

    public void getScore() {
        GreedyComponentListChromosome starter = new GreedyComponentListChromosome();
        AGeneticOptimizer GeneticOptimizer2 = new AGeneticOptimizer(true, true);
        AutoPlace.setGaps(1400.0, 800.0);
        this.mFixedPlaceList.stream().forEach(c -> starter.add(c));
        this.mFreePlaceList.stream().forEach(c -> starter.add(c));
        GeneticOptimizer2.addChromosome(starter.deepCopy(), null);
    }

    public LinkedList<Double> getBestScores() {
        return this.mGeneticOptimizer.getBestScores();
    }

    public void setVerboseMode(boolean verbose) {
        this.mVerboseMode = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AGeneticOptimizer go(int time, long deviceSpacing, long parentSpacing, boolean anim, String rulesCsvPath, long placementMode) {
        GreedyComponentListChromosome starter = new GreedyComponentListChromosome();
        mAnimation = anim;
        this.mNumberOfObs = this.db.getObjectCount(Obstacle.class);
        this.mGeneticOptimizer = new AGeneticOptimizer(true, true);
        mPlacementMode = placementMode;
        if (!this.mMode.equals("heuristic")) {
            this.mIG = new ImageGeneration(this.mKeepIn);
        }
        this.db.getObjects(Obstacle.class).forEachRemaining(obsList::add);
        AutoPlace.setGaps(deviceSpacing, parentSpacing);
        this.mFixedPlaceList.stream().forEach(c -> starter.add(c));
        this.mFreePlaceList.sort(new Comparator<Component>(){

            @Override
            public int compare(Component c1, Component c2) {
                double area1 = c1.getPinCount();
                double area2 = c2.getPinCount();
                return -Double.compare(area1, area2);
            }
        });
        this.mFreePlaceList.stream().forEach(c -> starter.add(c));
        starter.analyze();
        EventQueue.invokeLater(() -> {
            if (anim) {
                test2.start(starter);
            }
            OrbitIO.getApp().refreshCurrentView(true);
        });
        AutoPlace.clearNetWeights();
        if (rulesCsvPath != null && !rulesCsvPath.isEmpty()) {
            ACsvReader csvReader = new ACsvReader();
            if (!csvReader.openFile(rulesCsvPath)) {
                csvReader.close();
                ALog.logError((String)"csv reading error");
            }
            HashMap Groups = new HashMap();
            block8: for (String[] row : csvReader.getRows()) {
                int mode = -1;
                boolean validRow = false;
                if (row[0].toLowerCase().equals("component class")) {
                    mode = 1;
                    validRow = true;
                } else if (row[0].toLowerCase().equals("clearance")) {
                    mode = 2;
                    validRow = true;
                } else if (row[0].toLowerCase().equals("net weight")) {
                    mode = 0;
                    validRow = true;
                }
                if (!validRow) continue;
                switch (mode) {
                    case 0: {
                        if (row.length < 2) break;
                        AutoPlace.setNetWeight(row[1], Double.parseDouble(row[2]));
                        break;
                    }
                    case 1: {
                        if (row.length < 2) break;
                        Pattern pattern = Pattern.compile(row[2]);
                        ArrayList<Component> matchingComponents = new ArrayList<Component>();
                        for (int j = 0; j < starter.size(); ++j) {
                            String s = ((Component)starter.get(j)).toString();
                            if (!pattern.matcher(s).matches()) continue;
                            matchingComponents.add((Component)starter.get(j));
                        }
                        Groups.put(row[1], matchingComponents);
                        break;
                    }
                    case 2: {
                        if (Groups.size() == 0 || row.length < 3) break;
                        if (Groups.get(row[1].trim()) != null && Groups.get(row[2].trim()) != null) {
                            ArrayList group1 = (ArrayList)Groups.get(row[1].trim());
                            ArrayList group2 = (ArrayList)Groups.get(row[2].trim());
                            for (int x = 0; x < group1.size(); ++x) {
                                for (int y = 0; y < group2.size(); ++y) {
                                    AutoPlace.setGapsTable(((Component)group1.get(x)).toString(), ((Component)group2.get(y)).toString(), Double.parseDouble(row[3].trim()));
                                }
                            }
                            continue block8;
                        }
                        ALog.logInfo((String)"error when setting spacings");
                    }
                }
            }
            csvReader.close();
        }
        this.mGeneticOptimizer.addChromosome(starter.deepCopy(), null);
        AGeneticOptimizer.addLoadListener(new AutoPlace.myUpdateListener());
        this.mGeneticOptimizer.evolveForTime(time);
        GreedyComponentListChromosome best = (GreedyComponentListChromosome)this.mGeneticOptimizer.getBestIndividual();
        ArrayList<Float> intscores = new ArrayList<Float>();
        ArrayList<Long> arrayList = this.mScores;
        synchronized (arrayList) {
            for (Long score : this.mScores) {
                float test = score.longValue();
                intscores.add(Float.valueOf(test));
            }
        }
        if (anim) {
            DrawGraph graph = new DrawGraph(intscores);
            graph.draw();
        }
        GreedyCluster.realizeBest(best);
        EventQueue.invokeLater(() -> {
            if (anim) {
                test2.remove();
            }
            OrbitIO.getApp().refreshCurrentView(true);
        });
        return this.mGeneticOptimizer;
    }

    public static void realizeBest(GreedyComponentListChromosome best) {
        for (Component c : best) {
            Device d = (Device)c.getObject();
            if (d.getIsFixed()) continue;
            d.setMirror(c.getMirror());
            d.setRotate(c.getRotate());
            d.setIsPlaced(true);
            d.setLoc(new APoint2D(c.getXAnchorPoint(), c.getYAnchorPoint()));
        }
    }

    public class GreedyComponentListChromosome
    extends ArrayList<Component>
    implements Chromosome {
        protected int mNumFixedItems;
        protected int inbound = 0;
        protected int outbound = 0;
        public boolean mCancel = false;

        protected void analyze() {
            this.mNumFixedItems = 0;
            for (int i = 0; i < this.size(); ++i) {
                if (!((Component)this.get((int)i)).isFixed) continue;
                ++this.mNumFixedItems;
            }
            ALog.logDebug((String)"%s", (Object[])new Object[]{this.mNumFixedItems});
        }

        @Override
        public Chromosome mutate() {
            GreedyComponentListChromosome mutant = (GreedyComponentListChromosome)this.deepCopy();
            int p1 = 0;
            int p2 = 0;
            int nonFixedSize = mutant.length() - this.mNumFixedItems;
            if (nonFixedSize > 1) {
                while (p1 == p2) {
                    p1 = this.mNumFixedItems + (int)Math.floor(Math.random() * (double)nonFixedSize);
                    p2 = this.mNumFixedItems + (int)Math.floor(Math.random() * (double)nonFixedSize);
                }
                Component temp = (Component)mutant.get(p1);
                mutant.set(p1, (Component)mutant.get(p2));
                mutant.set(p2, temp);
            }
            return mutant;
        }

        @Override
        public Chromosome mate(Chromosome c) {
            int i;
            GreedyComponentListChromosome parent1 = this;
            GreedyComponentListChromosome parent2 = (GreedyComponentListChromosome)c;
            int nonFixedSize = parent1.length() - this.mNumFixedItems;
            int int1 = this.mNumFixedItems + (int)(Math.random() * (double)nonFixedSize);
            int int2 = this.mNumFixedItems + (int)(Math.random() * (double)nonFixedSize);
            int min = Math.min(int1, int2);
            int max = Math.max(int1, int2);
            GreedyComponentListChromosome child = new GreedyComponentListChromosome();
            int k = 0;
            for (i = 0; i < min; ++i) {
                while (this.belong((Component)parent2.get(k), parent1, min, max)) {
                    ++k;
                }
                child.add((Component)parent2.get(k));
                ++k;
            }
            for (i = min; i <= max; ++i) {
                child.add((Component)parent1.get(i));
            }
            for (i = max + 1; i < this.length(); ++i) {
                while (this.belong((Component)parent2.get(k), parent1, min, max)) {
                    ++k;
                }
                child.add((Component)parent2.get(k));
                ++k;
            }
            return child;
        }

        @Override
        public Chromosome deepCopy() {
            GreedyComponentListChromosome clone = new GreedyComponentListChromosome();
            int i = 0;
            for (Component c : this) {
                clone.add(i++, c.deepCopy());
            }
            clone.mNumFixedItems = this.mNumFixedItems;
            return clone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double fitness() {
            long fitScore = 0L;
            Component first = (Component)this.get(0);
            int numberOfNets = first.getPins()[0].getNumberOfNets();
            long[][] netBoundsTable = new long[numberOfNets][4];
            if (GreedyCluster.this.mGeneticOptimizer.getIsStoped()) {
                return Double.MAX_VALUE;
            }
            Binner binner = new Binner();
            long spacing = AutoPlace.getCToEdgeGap((Component)this.get(0));
            ARect world = new ARect(GreedyCluster.this.mKeepIn.left() + spacing, GreedyCluster.this.mKeepIn.bottom() + spacing, GreedyCluster.this.mKeepIn.right() - spacing, GreedyCluster.this.mKeepIn.height() - spacing);
            binner.setWorld(world);
            for (int i = 0; i < this.mNumFixedItems; ++i) {
                Component c = (Component)this.get(i);
                binner.insert((Object)c, c.getBounds());
                fitScore = this.newScore(c, fitScore, netBoundsTable, true);
            }
            double totalScore = 0.0;
            for (int i = this.mNumFixedItems; i < this.length() && !this.mCancel; ++i) {
                Component theComponentBeingPlaced = (Component)this.get(i);
                long cHeight = theComponentBeingPlaced.getHeight();
                long cWidth = theComponentBeingPlaced.getWidth();
                Pin[] pinOfBeingPlaced = theComponentBeingPlaced.getPins();
                ComponentLocation minLoc = new ComponentLocation();
                if (i == 0) {
                    theComponentBeingPlaced.setCenter(first.getParentWidth() / 2L, first.getParentHeight() / 2L);
                    fitScore = this.newScore(theComponentBeingPlaced, fitScore, netBoundsTable, true);
                } else {
                    for (int j = 0; j < i; ++j) {
                        int numOfPos;
                        Component theAlreadyPlacedComponent = (Component)this.get(j);
                        long placedX = theAlreadyPlacedComponent.getLeft();
                        long placedY = theAlreadyPlacedComponent.getBottom();
                        long placedHeight = theAlreadyPlacedComponent.getHeight();
                        long placedWidth = theAlreadyPlacedComponent.getWidth();
                        Pin[] pinOfPlaced = theAlreadyPlacedComponent.getPins();
                        long gap = AutoPlace.getCCGap(theAlreadyPlacedComponent, theComponentBeingPlaced);
                        if (mPlacementMode == 1L || mPlacementMode == 3L && theAlreadyPlacedComponent.getPinCount() > 3 && theComponentBeingPlaced.getPinCount() > 3 || mPlacementMode == 4L && !GreedyCluster.this.mGeneticOptimizer.getSwitchTimer()) {
                            int k;
                            numOfPos = 3;
                            if (cWidth != placedWidth) {
                                for (k = 0; k < numOfPos; ++k) {
                                    theComponentBeingPlaced.setCenter(placedX + cWidth / 2L + (long)k * (placedWidth - cWidth) / 2L, placedY - cHeight / 2L - gap);
                                    this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 0);
                                    theComponentBeingPlaced.setCenter(placedX + cWidth / 2L + (long)k * (placedWidth - cWidth) / 2L, placedY + placedHeight + cHeight / 2L + gap);
                                    this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 1);
                                }
                            } else {
                                theComponentBeingPlaced.setCenter(placedX + placedWidth / 2L, placedY - cHeight / 2L - gap);
                                this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 2);
                                theComponentBeingPlaced.setCenter(placedX + placedWidth / 2L, placedY + placedHeight + cHeight / 2L + gap);
                                this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 3);
                            }
                            if (cHeight != placedHeight) {
                                for (k = 0; k < numOfPos; ++k) {
                                    theComponentBeingPlaced.setCenter(placedX + placedWidth + cWidth / 2L + gap, placedY + cHeight / 2L + (long)k * (placedHeight - cHeight) / 2L);
                                    this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 4);
                                    theComponentBeingPlaced.setCenter(placedX - cWidth / 2L - gap, placedY + cHeight / 2L + (long)k * (placedHeight - cHeight) / 2L);
                                    this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 5);
                                }
                                continue;
                            }
                            theComponentBeingPlaced.setCenter(placedX + placedWidth + cWidth / 2L + gap, placedY + placedHeight / 2L);
                            this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 6);
                            theComponentBeingPlaced.setCenter(placedX - cWidth / 2L - gap, placedY + placedHeight / 2L);
                            this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 7);
                            continue;
                        }
                        if (mPlacementMode != 2L && (mPlacementMode != 3L || theAlreadyPlacedComponent.getPinCount() > 3 || theComponentBeingPlaced.getPinCount() > 3) && (mPlacementMode != 4L || !GreedyCluster.this.mGeneticOptimizer.getSwitchTimer())) continue;
                        numOfPos = 1;
                        for (Pin p : pinOfPlaced) {
                            int n;
                            int k;
                            long pinX = p.getX();
                            long pinY = p.getY();
                            if (cWidth != placedWidth) {
                                for (k = 0; k < numOfPos; ++k) {
                                    long x;
                                    for (Pin pBeingPlaced : pinOfBeingPlaced) {
                                        x = pBeingPlaced.getX() - theComponentBeingPlaced.getCenterLeft();
                                        theComponentBeingPlaced.setCenter(pinX - x, placedY - cHeight / 2L - gap - (long)k * cHeight);
                                        this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 8);
                                    }
                                    Pin[] pinArray = pinOfBeingPlaced;
                                    n = pinArray.length;
                                    for (int i2 = 0; i2 < n; ++i2) {
                                        Pin pBeingPlaced;
                                        pBeingPlaced = pinArray[i2];
                                        x = pBeingPlaced.getX() - theComponentBeingPlaced.getCenterLeft();
                                        theComponentBeingPlaced.setCenter(pinX - x, placedY - cHeight / 2L - gap - (long)k * cHeight);
                                        this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 8);
                                    }
                                }
                            } else {
                                for (Pin pBeingPlaced : pinOfBeingPlaced) {
                                    long x = pBeingPlaced.getX() - theComponentBeingPlaced.getCenterLeft();
                                    theComponentBeingPlaced.setCenter(pinX - x, placedY - cHeight / 2L - gap);
                                    this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 10);
                                }
                                for (Pin pBeingPlaced : pinOfBeingPlaced) {
                                    long x = theComponentBeingPlaced.getCenterLeft() - pBeingPlaced.getX();
                                    theComponentBeingPlaced.setCenter(pinX + x, placedY + placedHeight + cHeight / 2L + gap);
                                    this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 11);
                                }
                            }
                            if (cHeight != placedHeight) {
                                long y;
                                for (k = 0; k < numOfPos; ++k) {
                                    Pin[] pinArray = pinOfBeingPlaced;
                                    n = pinArray.length;
                                    for (int pBeingPlaced = 0; pBeingPlaced < n; ++pBeingPlaced) {
                                        Pin pBeingPlaced2 = pinArray[pBeingPlaced];
                                        y = theComponentBeingPlaced.getCenterBottom() - pBeingPlaced2.getY();
                                        theComponentBeingPlaced.setCenter(placedX + placedWidth + cWidth / 2L + gap + (long)k * cWidth, pinY + y);
                                        this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 12);
                                    }
                                }
                                for (k = 0; k < numOfPos; ++k) {
                                    Pin[] pinArray = pinOfBeingPlaced;
                                    n = pinArray.length;
                                    for (int pBeingPlaced = 0; pBeingPlaced < n; ++pBeingPlaced) {
                                        Pin pBeingPlaced3 = pinArray[pBeingPlaced];
                                        y = theComponentBeingPlaced.getCenterBottom() - pBeingPlaced3.getY();
                                        theComponentBeingPlaced.setCenter(placedX - cWidth / 2L - gap - (long)k * cWidth, pinY + y);
                                        this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 13);
                                    }
                                }
                                continue;
                            }
                            for (Pin pBeingPlaced : pinOfBeingPlaced) {
                                long y = theComponentBeingPlaced.getCenterBottom() - pBeingPlaced.getY();
                                theComponentBeingPlaced.setCenter(placedX + placedWidth + cWidth / 2L + gap, pinY + y);
                                this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 14);
                            }
                            for (Pin pBeingPlaced : pinOfBeingPlaced) {
                                long y = theComponentBeingPlaced.getCenterBottom() - pBeingPlaced.getY();
                                theComponentBeingPlaced.setCenter(placedX - cWidth / 2L - gap, pinY + y);
                                this.updateMinScore(theComponentBeingPlaced, gap, (Binner<Component>)binner, fitScore, netBoundsTable, minLoc, 15);
                            }
                        }
                        theComponentBeingPlaced.rotateClock();
                    }
                    theComponentBeingPlaced.setMirrorRotateLL(minLoc);
                    fitScore = this.newScore(theComponentBeingPlaced, fitScore, netBoundsTable, true);
                }
                binner.insert((Object)theComponentBeingPlaced, theComponentBeingPlaced.getBounds());
            }
            totalScore = this.totalScore(this, netBoundsTable);
            ArrayList<Long> arrayList = GreedyCluster.this.mScores;
            synchronized (arrayList) {
                GreedyCluster.this.mScores.add((long)totalScore);
            }
            return totalScore;
        }

        public boolean updateMinScore(Component c, long gap, Binner<Component> binner, long fitScore, long[][] netBoundsTable, ComponentLocation minLoc, int debug) {
            if (GreedyCluster.this.mGeneticOptimizer.getIsStoped()) {
                return false;
            }
            if (!this.overlaps(c, gap, binner) && c.withinBoundsWithGap() && this.withInBoundsComplex(c)) {
                long score = this.newScore(c, fitScore, netBoundsTable, false);
                ++this.inbound;
                if (score < minLoc.getScore()) {
                    minLoc.updateLocation(c, score);
                    if (mAnimation) {
                        test2.update(this);
                    }
                }
                return true;
            }
            ++this.outbound;
            return false;
        }

        public boolean withInBoundsComplex(Component toBePlaced) {
            APoint2D[] increasedDevicePoints;
            APoint2D UR = new APoint2D(toBePlaced.getRight(), toBePlaced.getTop());
            APoint2D BL = new APoint2D(toBePlaced.getLeft(), toBePlaced.getBottom());
            long spacing = AutoPlace.getCToEdgeGap(null);
            ARect toBePlacedShape = new ARect(BL, UR).expandBy(spacing, spacing);
            for (Obstacle o : GreedyCluster.this.db.getObjects(Obstacle.class)) {
                AGeom obs = o.getShape(0).getGeom();
                if (!obs.intersects((AGeom)toBePlacedShape)) continue;
                return false;
            }
            Device parent = ((Device)toBePlaced.getObject()).getAParentDevice();
            AGeom shape = parent.getTransformedShape();
            if (shape instanceof ARect) {
                return true;
            }
            for (APoint2D point : increasedDevicePoints = toBePlacedShape.getPoints()) {
                if (shape.intersects(point)) continue;
                return false;
            }
            return true;
        }

        public long newScore(Component c, long curScore, long[][] netBoundsTable, boolean updateTable) {
            Pin[] pins = c.getPins();
            long[] start = new long[4];
            for (Pin p : pins) {
                if (p.index < 0) continue;
                long pinX = p.getX();
                long pinY = p.getY();
                long[] netBounds = new long[4];
                for (int i = 0; i < 4; ++i) {
                    netBounds[i] = netBoundsTable[p.getIndex()][i];
                }
                Double weight = AutoPlace.net2Weight.get(p.net);
                if (weight == null) {
                    weight = 1.0;
                }
                if (weight == 0.0) continue;
                if (!Arrays.equals(netBounds, start)) {
                    if (pinX < netBounds[0]) {
                        curScore = (long)((double)curScore + (double)(netBounds[0] - pinX) * weight);
                        netBounds[0] = pinX;
                    } else if (pinX > netBounds[1]) {
                        curScore = (long)((double)curScore + (double)(pinX - netBounds[1]) * weight);
                        netBounds[1] = pinX;
                    }
                    if (pinY < netBounds[2]) {
                        curScore = (long)((double)curScore + (double)(netBounds[2] - pinY) * weight);
                        netBounds[2] = pinY;
                    } else if (pinY > netBounds[3]) {
                        curScore = (long)((double)curScore + (double)(pinY - netBounds[3]) * weight);
                        netBounds[3] = pinY;
                    }
                } else {
                    netBounds = new long[]{pinX, pinX, pinY, pinY};
                }
                if (!updateTable) continue;
                netBoundsTable[p.getIndex()] = netBounds;
            }
            return curScore;
        }

        protected double totalScore(GreedyComponentListChromosome chrome, long[][] netBoundsTable) {
            double total = 0.0;
            for (long[] netTable : netBoundsTable) {
                netTable[0] = 0L;
                netTable[1] = 0L;
                netTable[2] = 0L;
                netTable[3] = 0L;
            }
            Object object = chrome.iterator();
            while (object.hasNext()) {
                Component c = (Component)object.next();
                for (Pin p : c.getPins()) {
                    int netIndex = p.getIndex();
                    if (netBoundsTable[netIndex][0] == 0L && netBoundsTable[netIndex][1] == 0L) {
                        netBoundsTable[netIndex][0] = p.getX();
                        netBoundsTable[netIndex][1] = p.getX();
                        netBoundsTable[netIndex][2] = p.getY();
                        netBoundsTable[netIndex][3] = p.getY();
                        continue;
                    }
                    netBoundsTable[netIndex][0] = Math.min(p.getX(), netBoundsTable[netIndex][0]);
                    netBoundsTable[netIndex][1] = Math.max(p.getX(), netBoundsTable[netIndex][1]);
                    netBoundsTable[netIndex][2] = Math.min(p.getY(), netBoundsTable[netIndex][2]);
                    netBoundsTable[netIndex][3] = Math.max(p.getY(), netBoundsTable[netIndex][3]);
                }
            }
            long minY = Long.MAX_VALUE;
            long maxY = Long.MIN_VALUE;
            for (long[] netTable : netBoundsTable) {
                long x0 = netTable[0];
                long x1 = netTable[1];
                long y0 = netTable[2];
                long y1 = netTable[3];
                minY = Math.min(minY, y0);
                minY = Math.min(minY, y1);
                maxY = Math.max(maxY, y0);
                maxY = Math.max(maxY, y1);
                total += (double)(Math.abs(x1 - x0) + Math.abs(y1 - y0));
            }
            if (total == 3.0E8 && maxY != minY) {
                ALog.logInfo((String)"");
            }
            return total;
        }

        public long[][] findNetBounds() {
            int numberOfNets = ((Component)this.get(0)).getPins()[0].getNumberOfNets();
            long[][] netBoundsTable = new long[numberOfNets][4];
            for (Component c : this) {
                Pin[] pins = c.getPins();
                long[] start = new long[4];
                for (Pin p : pins) {
                    if (p.index < 0) continue;
                    long pinX = p.getX();
                    long pinY = p.getY();
                    long[] netBounds = new long[4];
                    for (int i = 0; i < 4; ++i) {
                        netBounds[i] = netBoundsTable[p.getIndex()][i];
                    }
                    if (!Arrays.equals(netBounds, start)) {
                        if (pinX < netBounds[0]) {
                            netBounds[0] = pinX;
                        } else if (pinX > netBounds[1]) {
                            netBounds[1] = pinX;
                        }
                        if (pinY < netBounds[2]) {
                            netBounds[2] = pinY;
                        } else if (pinY > netBounds[3]) {
                            netBounds[3] = pinY;
                        }
                    } else {
                        netBounds = new long[]{pinX, pinX, pinY, pinY};
                    }
                    netBoundsTable[p.getIndex()] = netBounds;
                }
            }
            return netBoundsTable;
        }

        public double curFitness() {
            long[][] netBoundsTable = this.findNetBounds();
            return this.totalScore(this, netBoundsTable);
        }

        @Override
        public int length() {
            return this.size();
        }

        @Override
        public void updateCondition(String owner, long time) {
        }

        @Override
        public void endOfEpoch() {
            for (AGeneticOptimizer.Individual i : GreedyCluster.this.mGeneticOptimizer.getChromosomes()) {
                if (GreedyCluster.this.mVerboseMode) {
                    APUtils.makePicture((GreedyComponentListChromosome)i.getChromosome(), GreedyCluster.this.mLearnDirName, GreedyCluster.this.mEpoch, i.getCalculatedFitness(), 0);
                }
                ++GreedyCluster.this.mEpoch;
            }
        }

        public boolean belong(Component elmt, GreedyComponentListChromosome chromosome, int min, int max) {
            for (int i = min; i <= max; ++i) {
                if (chromosome.get(i) != elmt) continue;
                return true;
            }
            return false;
        }

        public int minIndex(long[] array) {
            long minVal = 0L;
            int minIndx = 0;
            for (int k = 0; k < array.length; ++k) {
                if (minVal <= array[k]) continue;
                minVal = array[k];
                minIndx = k;
            }
            return minIndx;
        }

        public boolean overlaps(Component toBePlaced, long gap, Binner<Component> binner) {
            boolean useBinner = false;
            if (useBinner) {
                ARect r = new ARect(toBePlaced.left - gap / 2L, toBePlaced.bottom - gap / 2L, toBePlaced.left + toBePlaced.width + gap / 2L, toBePlaced.bottom + toBePlaced.height + gap / 2L);
                return binner.findAnyIntersect(r) != null;
            }
            int i = 0;
            Component placed = (Component)this.get(i);
            while (placed != toBePlaced) {
                if (toBePlaced.intersectsWithGap(placed)) {
                    return true;
                }
                placed = (Component)this.get(i++);
            }
            return false;
        }
    }

    static class ImageGeneration {
        protected DesignCanvas2D.XForm toImageFromWorld;
        protected int screenDimX = 1024;
        protected int screenDimY = 1024;
        protected Rectangle screenRect = new Rectangle();
        BufferedImage myImage = new BufferedImage(this.screenDimX, this.screenDimY, 2);
        Graphics2D graphics;
        long generation;
        double mM;
        double mAX;
        double mAY;

        public ImageGeneration(ARect worldRect) {
            double sx = (double)this.screenDimX / (double)worldRect.width();
            double sy = (double)this.screenDimY / (double)worldRect.height();
            this.mM = Math.abs(sx) < Math.abs(sy) ? sx : sy;
            this.mAX = (double)this.screenDimX / 2.0 - (double)worldRect.centerX() * this.mM;
            this.mAY = (double)this.screenDimY / 2.0 - (double)worldRect.centerY() * this.mM;
            this.generation = 0L;
            this.graphics = this.myImage.createGraphics();
        }

        protected Point toScreen(long xW, long yW) {
            int x = (int)Math.floor((double)xW * this.mM + this.mAX);
            int y = (int)Math.floor((double)yW * this.mM + this.mAY);
            Point p = new Point(x, y);
            return p;
        }

        public void update(String name, double score, long[][] netBoundsTable) {
            Color back = new Color(0, 0, 0);
            this.graphics.setPaint(back);
            BasicStroke stroke = new BasicStroke(1.0f);
            this.graphics.setStroke(stroke);
            this.graphics.fillRect(0, 0, this.screenDimX, this.screenDimY);
            Color cL = new Color(255, 255, 255);
            this.graphics.setPaint(cL);
            for (long[] bounds : netBoundsTable) {
                Point p0 = this.toScreen(bounds[0], bounds[2]);
                Point p1 = this.toScreen(bounds[1], bounds[3]);
                this.graphics.drawLine(p0.x, p0.y, p1.x, p1.y);
            }
            File outputfile = new File(name + "-" + this.generation + ".png");
            try {
                ImageIO.write((RenderedImage)this.myImage, "png", outputfile);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
            ++this.generation;
        }
    }
}

