/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.automation.experimental.Component;
import com.sigrity.orbit.automation.experimental.Pin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

public class OrbitToComponent {
    public static Component toCompnent(DevicePath path, ArrayList<String> listOfNets) {
        Device device = path.getLast();
        Device parentDevice = path.getParent().getLast();
        if (parentDevice == null) {
            return null;
        }
        ARect parentBB = parentDevice.getBB();
        long parentHeight = parentBB.height();
        long parentWidth = parentBB.width();
        APoint2D parentLL = parentDevice.getLoc();
        APoint2D parentAnchorPoint = parentBB.getLL();
        long parentOffsetX = parentLL.getX() - parentAnchorPoint.getX();
        long parentOffsetY = parentLL.getY() - parentAnchorPoint.getY();
        return OrbitToComponent.toComponent(path.getParent(), device, parentHeight, parentWidth, parentOffsetX, parentOffsetY, listOfNets);
    }

    public static ArrayList<String> generateHashSet(LinkedList<DevicePath> paths) {
        ArrayList<String> netList = new ArrayList<String>();
        for (DevicePath child : paths) {
            Device d = child.getDevice();
            for (PinInstance pin : d.getPins()) {
                String netName;
                Net n = NetMap.getTopmostNet((Net)pin.getNet(), (DevicePath)child);
                int count = NetMap.getConnectedDevicePathPortsCount((Net)pin.getNet(), (DevicePath)child, (int)2);
                if (count <= 1 || netList.contains(netName = n.getName())) continue;
                netList.add(netName);
            }
        }
        Collections.sort(netList);
        return netList;
    }

    public static Component toComponent(DevicePath path, Device d, long parentHeight, long parentWidth, long parentOffsetX, long parentOffsetY, ArrayList<String> hashSet) {
        ARect boundingBox = d.getExtent();
        long height = boundingBox.height();
        long width = boundingBox.width();
        long x = boundingBox.getLL().getX();
        long y = boundingBox.getLL().getY();
        long left = x;
        long oldLeft = x;
        long bottom = y;
        long oldBottom = y;
        long oldHeight = height;
        long oldWidth = width;
        ArrayList<Pin> pinList = new ArrayList<Pin>();
        DevicePath fullPath = path.withChild(d);
        for (PinInstance myPin : d.getPins()) {
            APoint2D pinLoc = myPin.getLocalLoc();
            Net n = NetMap.getTopmostNet((Net)myPin.getNet(), (DevicePath)fullPath);
            int count = NetMap.getConnectedDevicePathPortsCount((Net)myPin.getNet(), (DevicePath)fullPath, (int)2);
            if (count <= 1) continue;
            long x180 = left + Math.abs(oldLeft + oldWidth - pinLoc.getX());
            long y180 = bottom + Math.abs(oldBottom + oldHeight - pinLoc.getY());
            long left90 = left + width / 2L - height / 2L;
            long bottom90 = bottom + height / 2L - width / 2L;
            long x90 = left90 + Math.abs(oldBottom - pinLoc.getY());
            long y90 = bottom90 + Math.abs(oldLeft + oldWidth - pinLoc.getX());
            long x270 = left90 + Math.abs(oldBottom + oldHeight - pinLoc.getY());
            long y270 = bottom90 + Math.abs(oldLeft - pinLoc.getX());
            pinList.add(new Pin(pinLoc.getX(), pinLoc.getY(), x90, y90, x180, y180, x270, y270, n.getName(), hashSet.indexOf(n.getName()), hashSet.size()));
        }
        int listSize = pinList.size();
        Pin[] pins = new Pin[listSize];
        for (int i = 0; i < listSize; ++i) {
            pins[i] = (Pin)pinList.get(i);
        }
        APoint2D anchorPoint = d.getLoc();
        long centerToAnchorPointX = anchorPoint.getX() - boundingBox.centerX();
        long centerToAnchorPointY = anchorPoint.getY() - boundingBox.centerY();
        return new Component(d.getName(), height, width, x, y, d.getRotate(), d.getRotate(), d.getMirror(), pins, d.getIsFixed(), d.getIsPlaced(), d, parentHeight, parentWidth, parentOffsetX, parentOffsetY, centerToAnchorPointX, centerToAnchorPointY);
    }
}

