/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Stopwatch;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.genetic.Chromosome;
import com.sigrity.orbit.automation.experimental.AutoPlace;
import com.sigrity.orbit.automation.experimental.Component;
import com.sigrity.orbit.automation.experimental.ComponentLocation;
import com.sigrity.orbit.automation.experimental.Pin;
import com.sigrity.orbit.automation.experimental.RandomizedChromosome;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class PlacementChromosomes {
    public static void testImageSpeed() {
        int xDim = 1024;
        int yDim = 1024;
        BufferedImage myImage = new BufferedImage(xDim, yDim, 2);
        Graphics2D graphics = myImage.createGraphics();
        Color back = new Color(0, 0, 0);
        graphics.setPaint(back);
        BasicStroke stroke = new BasicStroke(1.0f);
        graphics.setStroke(stroke);
        graphics.fillRect(0, 0, 1024, 1024);
        Color cL = new Color(255, 255, 255);
        graphics.setPaint(cL);
        long numExperiments = 10L;
        long numWires = 1000L;
        Stopwatch timer = Stopwatch.startTiming();
        int experiment = 0;
        while ((long)experiment < numExperiments) {
            int wire = 0;
            while ((long)wire < numWires) {
                int x0 = (int)Math.floor(Math.random() * (double)xDim);
                int y0 = (int)Math.floor(Math.random() * (double)yDim);
                int x1 = (int)Math.floor(Math.random() * (double)yDim);
                int y1 = (int)Math.floor(Math.random() * (double)yDim);
                graphics.drawLine(x0, y0, x1, y1);
                ++wire;
            }
            ++experiment;
        }
        timer.stop();
        ALog.logInfo((String)"Image write time, elapsed time %s.", (Object[])new Object[]{timer.elapsedStr()});
        File outputfile = new File("saved.png");
        try {
            ImageIO.write((RenderedImage)myImage, "png", outputfile);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e);
        }
    }

    static class GreedyComponentListChromosome
    extends ArrayList<Component>
    implements Chromosome {
        BufferedImage myImage = new BufferedImage(1024, 1024, 2);
        protected int fixedElements;

        GreedyComponentListChromosome() {
        }

        public int getNbFixedElements() {
            return this.fixedElements;
        }

        public void setFixedElements(int nb) {
            this.fixedElements = nb;
        }

        @Override
        public void endOfEpoch() {
        }

        @Override
        public Chromosome mutate() {
            GreedyComponentListChromosome mutant = (GreedyComponentListChromosome)this.deepCopy();
            int p1 = 0;
            int p2 = 0;
            int nonFixedSize = mutant.length() - this.fixedElements;
            if (nonFixedSize > 1) {
                while (p1 == p2) {
                    p1 = this.fixedElements + (int)Math.floor(Math.random() * (double)nonFixedSize);
                    p2 = this.fixedElements + (int)Math.floor(Math.random() * (double)nonFixedSize);
                }
                Component temp = (Component)mutant.get(p1);
                mutant.set(p1, (Component)mutant.get(p2));
                mutant.set(p2, temp);
            }
            return mutant;
        }

        @Override
        public Chromosome mate(Chromosome c) {
            int i;
            GreedyComponentListChromosome parent1 = this;
            GreedyComponentListChromosome parent2 = (GreedyComponentListChromosome)c;
            int nonFixedSize = parent1.length() - this.fixedElements;
            int int1 = this.fixedElements + (int)(Math.random() * (double)nonFixedSize);
            int int2 = this.fixedElements + (int)(Math.random() * (double)nonFixedSize);
            int min = Math.min(int1, int2);
            int max = Math.max(int1, int2);
            GreedyComponentListChromosome child = new GreedyComponentListChromosome();
            int k = 0;
            for (i = 0; i < min; ++i) {
                while (GreedyComponentListChromosome.belong((Component)parent2.get(k), parent1, min, max)) {
                    ++k;
                }
                child.add((Component)parent2.get(k));
                ++k;
            }
            for (i = min; i <= max; ++i) {
                child.add((Component)parent1.get(i));
            }
            for (i = max + 1; i < this.length(); ++i) {
                while (GreedyComponentListChromosome.belong((Component)parent2.get(k), parent1, min, max)) {
                    ++k;
                }
                child.add((Component)parent2.get(k));
                ++k;
            }
            return child;
        }

        @Override
        public Chromosome deepCopy() {
            GreedyComponentListChromosome clone = new GreedyComponentListChromosome();
            int i = 0;
            for (Component c : this) {
                clone.add(i++, c.deepCopy());
                clone.setFixedElements(this.fixedElements);
            }
            return clone;
        }

        @Override
        public double fitness() {
            long fitScore = 0L;
            Component first = (Component)this.get(0);
            int numberOfNets = first.getPins()[0].getNumberOfNets();
            long[][] netBoundsTable = new long[numberOfNets][4];
            for (int i = 0; i < this.fixedElements; ++i) {
                Component c = (Component)this.get(i);
                fitScore = this.newScore(c, fitScore, netBoundsTable, true);
            }
            double totalScore = 0.0;
            for (int i = this.fixedElements; i < this.length(); ++i) {
                Component theComponentBeingPlaced = (Component)this.get(i);
                if (i == 0) {
                    theComponentBeingPlaced.setCenter(first.getParentWidth() / 2L, first.getParentHeight() / 2L);
                    fitScore = this.newScore(theComponentBeingPlaced, fitScore, netBoundsTable, true);
                    continue;
                }
                ComponentLocation minLoc = new ComponentLocation();
                for (int j = 0; j < i; ++j) {
                    Component theAlreadyPlacedComponent = (Component)this.get(j);
                    long placedX = theAlreadyPlacedComponent.getLeft();
                    long placedY = theAlreadyPlacedComponent.getBottom();
                    long placedHeight = theAlreadyPlacedComponent.getHeight();
                    long placedWidth = theAlreadyPlacedComponent.getWidth();
                    long gap = AutoPlace.getCCGap(theAlreadyPlacedComponent, theComponentBeingPlaced);
                    for (int h = 0; h < 4; ++h) {
                        int k;
                        long cHeight = theComponentBeingPlaced.getHeight();
                        long cWidth = theComponentBeingPlaced.getWidth();
                        if (cWidth != placedWidth) {
                            for (k = 0; k < 3; ++k) {
                                theComponentBeingPlaced.setCenter(placedX + cWidth / 2L + (long)k * (placedWidth - cWidth) / 2L, placedY - cHeight / 2L - gap);
                                this.updateMinScore(theComponentBeingPlaced, fitScore, netBoundsTable, minLoc);
                            }
                            for (k = 0; k < 3; ++k) {
                                theComponentBeingPlaced.setCenter(placedX + cWidth / 2L + (long)k * (placedWidth - cWidth) / 2L, placedY + placedHeight + cHeight / 2L + gap);
                                this.updateMinScore(theComponentBeingPlaced, fitScore, netBoundsTable, minLoc);
                            }
                        } else {
                            theComponentBeingPlaced.setCenter(placedX + placedWidth / 2L, placedY - cHeight / 2L - gap);
                            this.updateMinScore(theComponentBeingPlaced, fitScore, netBoundsTable, minLoc);
                            theComponentBeingPlaced.setCenter(placedX + placedWidth / 2L, placedY + placedHeight + cHeight / 2L + gap);
                            this.updateMinScore(theComponentBeingPlaced, fitScore, netBoundsTable, minLoc);
                        }
                        if (cHeight != placedHeight) {
                            for (k = 0; k < 3; ++k) {
                                theComponentBeingPlaced.setCenter(placedX + placedWidth + cWidth / 2L + gap, placedY + cHeight / 2L + (long)k * (placedHeight - cHeight) / 2L);
                                this.updateMinScore(theComponentBeingPlaced, fitScore, netBoundsTable, minLoc);
                            }
                            for (k = 0; k < 3; ++k) {
                                theComponentBeingPlaced.setCenter(placedX - cWidth / 2L - gap, placedY + cHeight / 2L + (long)k * (placedHeight - cHeight) / 2L);
                                this.updateMinScore(theComponentBeingPlaced, fitScore, netBoundsTable, minLoc);
                            }
                        } else {
                            theComponentBeingPlaced.setCenter(placedX + placedWidth + cWidth / 2L + gap, placedY + placedHeight / 2L);
                            this.updateMinScore(theComponentBeingPlaced, fitScore, netBoundsTable, minLoc);
                            theComponentBeingPlaced.setCenter(placedX - cWidth / 2L - gap, placedY + placedHeight / 2L);
                            this.updateMinScore(theComponentBeingPlaced, fitScore, netBoundsTable, minLoc);
                        }
                        theComponentBeingPlaced.rotateClock();
                    }
                }
                theComponentBeingPlaced.setMirrorRotateLL(minLoc);
                fitScore = this.newScore(theComponentBeingPlaced, fitScore, netBoundsTable, true);
            }
            totalScore = GreedyComponentListChromosome.totalScore(this, netBoundsTable);
            return totalScore;
        }

        public void updateMinScore(Component c, long fitScore, long[][] netBoundsTable, ComponentLocation minLoc) {
            long score;
            if (c.withinBoundsWithGap() && !this.overlaps(c) && (score = 1L) < minLoc.getScore()) {
                minLoc.updateLocation(c, score);
            }
        }

        public long newScoreByImage(Component c, long[][] netBoundsTable) {
            Graphics2D graphics = this.myImage.createGraphics();
            Color color = new Color(50, 50, 50);
            BasicStroke stroke = new BasicStroke(1.0f);
            graphics.setStroke(stroke);
            graphics.setPaint(color);
            graphics.fill(new Rectangle(0, 0, 100, 10));
            return 1L;
        }

        public long newScore(Component c, long curScore, long[][] netBoundsTable, boolean updateTable) {
            Pin[] pins = c.getPins();
            long[] start = new long[4];
            for (Pin p : pins) {
                if (p.index < 0) continue;
                long pinX = p.getX();
                long pinY = p.getY();
                long[] netBounds = new long[4];
                for (int i = 0; i < 4; ++i) {
                    netBounds[i] = netBoundsTable[p.getIndex()][i];
                }
                Double weight = AutoPlace.net2Weight.get(p.net);
                if (weight == null) {
                    weight = 1.0;
                }
                if (weight == 0.0) continue;
                if (!Arrays.equals(netBounds, start)) {
                    if (pinX < netBounds[0]) {
                        curScore += netBounds[0] - pinX;
                        netBounds[0] = pinX;
                    } else if (pinX > netBounds[1]) {
                        curScore += pinX - netBounds[1];
                        netBounds[1] = pinX;
                    }
                    if (pinY < netBounds[2]) {
                        curScore += netBounds[2] - pinY;
                        netBounds[2] = pinY;
                    } else if (pinY > netBounds[3]) {
                        curScore += pinY - netBounds[3];
                        netBounds[3] = pinY;
                    }
                } else {
                    netBounds = new long[]{pinX, pinX, pinY, pinY};
                }
                if (!updateTable) continue;
                netBoundsTable[p.getIndex()] = netBounds;
            }
            return curScore;
        }

        protected static double totalScore(GreedyComponentListChromosome chrome, long[][] netBoundsTable) {
            double total = 0.0;
            for (long[] netTable : netBoundsTable) {
                netTable[0] = 0L;
                netTable[1] = 0L;
                netTable[2] = 0L;
                netTable[3] = 0L;
            }
            Object object = chrome.iterator();
            while (object.hasNext()) {
                Component c = (Component)object.next();
                for (Pin p : c.getPins()) {
                    int netIndex = p.getIndex();
                    if (netBoundsTable[netIndex][0] == 0L && netBoundsTable[netIndex][1] == 0L) {
                        netBoundsTable[netIndex][0] = p.getX();
                        netBoundsTable[netIndex][1] = p.getX();
                        netBoundsTable[netIndex][2] = p.getY();
                        netBoundsTable[netIndex][3] = p.getY();
                        continue;
                    }
                    netBoundsTable[netIndex][0] = Math.min(p.getX(), netBoundsTable[netIndex][0]);
                    netBoundsTable[netIndex][1] = Math.max(p.getX(), netBoundsTable[netIndex][1]);
                    netBoundsTable[netIndex][2] = Math.min(p.getY(), netBoundsTable[netIndex][2]);
                    netBoundsTable[netIndex][3] = Math.max(p.getY(), netBoundsTable[netIndex][3]);
                }
            }
            long minY = Long.MAX_VALUE;
            long maxY = Long.MIN_VALUE;
            for (long[] netTable : netBoundsTable) {
                long x0 = netTable[0];
                long x1 = netTable[1];
                long y0 = netTable[2];
                long y1 = netTable[3];
                minY = Math.min(minY, y0);
                minY = Math.min(minY, y1);
                maxY = Math.max(maxY, y0);
                maxY = Math.max(maxY, y1);
                total += (double)(Math.abs(x1 - x0) + Math.abs(y1 - y0));
            }
            if (total == 3.0E8 && maxY != minY) {
                ALog.logInfo((String)"");
            }
            return total;
        }

        public long[][] findNetBounds() {
            int numberOfNets = ((Component)this.get(0)).getPins()[0].getNumberOfNets();
            long[][] netBoundsTable = new long[numberOfNets][4];
            for (Component c : this) {
                Pin[] pins = c.getPins();
                long[] start = new long[4];
                for (Pin p : pins) {
                    if (p.index < 0) continue;
                    long pinX = p.getX();
                    long pinY = p.getY();
                    long[] netBounds = new long[4];
                    for (int i = 0; i < 4; ++i) {
                        netBounds[i] = netBoundsTable[p.getIndex()][i];
                    }
                    if (!Arrays.equals(netBounds, start)) {
                        if (pinX < netBounds[0]) {
                            netBounds[0] = pinX;
                        } else if (pinX > netBounds[1]) {
                            netBounds[1] = pinX;
                        }
                        if (pinY < netBounds[2]) {
                            netBounds[2] = pinY;
                        } else if (pinY > netBounds[3]) {
                            netBounds[3] = pinY;
                        }
                    } else {
                        netBounds = new long[]{pinX, pinX, pinY, pinY};
                    }
                    netBoundsTable[p.getIndex()] = netBounds;
                }
            }
            return netBoundsTable;
        }

        public double curFitness() {
            long[][] netBoundsTable = this.findNetBounds();
            return GreedyComponentListChromosome.totalScore(this, netBoundsTable);
        }

        @Override
        public int length() {
            return this.size();
        }

        @Override
        public void updateCondition(String owner, long time) {
        }

        public static boolean belong(Component elmt, GreedyComponentListChromosome chromosome, int min, int max) {
            for (int i = min; i <= max; ++i) {
                if (chromosome.get(i) != elmt) continue;
                return true;
            }
            return false;
        }

        public int minIndex(long[] array) {
            long minVal = 0L;
            int minIndx = 0;
            for (int k = 0; k < array.length; ++k) {
                if (minVal <= array[k]) continue;
                minVal = array[k];
                minIndx = k;
            }
            return minIndx;
        }

        public boolean overlaps(Component toBePlaced) {
            int i = 0;
            Component placed = (Component)this.get(i);
            while (placed != toBePlaced) {
                if (toBePlaced.intersectsWithGap(placed)) {
                    return true;
                }
                placed = (Component)this.get(i++);
            }
            return false;
        }
    }

    static class RandomizedComponentListChromosome
    extends ArrayList<Component>
    implements RandomizedChromosome {
        protected long boardHeight;
        protected long boardWidth;
        protected long gridVerticalSize;
        protected long gridHorizontalSize;
        protected ArrayList<Component>[][] grid;
        protected ImageGeneration ig;

        public RandomizedComponentListChromosome(long parentHeight, long parentWidth, long gridVerticalDimension, long gridHorizontalDimension) {
            this.boardHeight = parentHeight;
            this.boardWidth = parentWidth;
            this.gridVerticalSize = gridVerticalDimension;
            this.gridHorizontalSize = gridHorizontalDimension;
            this.ig = new ImageGeneration(new ARect(0L, 0L, parentWidth, parentHeight));
            ArrayList[][] _array = new ArrayList[(int)(this.boardWidth / this.gridHorizontalSize)][(int)(this.boardHeight / this.gridVerticalSize)];
            this.grid = _array;
            for (int i = 0; i < (int)(this.boardWidth / this.gridHorizontalSize); ++i) {
                for (int j = 0; j < (int)(this.boardHeight / this.gridVerticalSize); ++j) {
                    this.grid[i][j] = new ArrayList();
                }
            }
        }

        @Override
        public String toString() {
            Object buffer = "";
            for (Component c : this) {
                buffer = (String)buffer + " " + c.getName();
            }
            return buffer;
        }

        public long getBoardHeight() {
            return this.boardHeight;
        }

        public long getBoardWidth() {
            return this.boardWidth;
        }

        public long getGridVerticalSize() {
            return this.gridVerticalSize;
        }

        public long getGridHorizontalSize() {
            return this.gridHorizontalSize;
        }

        public ArrayList<Component>[][] getGrid() {
            return this.grid;
        }

        @Override
        public RandomizedChromosome mutate(double boxProportion, int mutationSize) {
            int sizeOfMutation = mutationSize;
            for (int i = 0; i < sizeOfMutation; ++i) {
                int index = (int)Math.floor(Math.random() * (double)this.length());
                Component c = (Component)this.get(index);
                this.singleRandomizedPlacement(boxProportion, c);
            }
            return this;
        }

        @Override
        public RandomizedChromosome mate(RandomizedChromosome chrom) {
            RandomizedComponentListChromosome parent1 = this;
            RandomizedComponentListChromosome parent2 = (RandomizedComponentListChromosome)chrom;
            int int1 = (int)(Math.random() * (double)this.boardWidth / (double)this.gridHorizontalSize);
            int int2 = (int)(Math.random() * (double)this.boardWidth / (double)this.gridHorizontalSize);
            int int3 = (int)(Math.random() * (double)this.boardHeight / (double)this.gridVerticalSize);
            int int4 = (int)(Math.random() * (double)this.boardHeight / (double)this.gridVerticalSize);
            int minX = Math.min(int1, int2);
            int maxX = Math.max(int1, int2);
            int minY = Math.min(int3, int4);
            int maxY = Math.max(int3, int4);
            RandomizedComponentListChromosome child = new RandomizedComponentListChromosome(this.boardHeight, this.boardWidth, this.gridVerticalSize, this.gridHorizontalSize);
            ArrayList<Component> tempComponentList = new ArrayList<Component>();
            for (Component c : parent1) {
                tempComponentList.add(c);
            }
            for (int i = minX; i <= maxX; ++i) {
                for (int j = minY; j <= maxY; ++j) {
                    for (Component c : parent1.getGrid()[i][j]) {
                        ALog.logDebug((String)c.getName());
                        child.add(c.deepCopy());
                        tempComponentList.remove(c);
                    }
                }
            }
            Collections.sort(tempComponentList, new Comparator<Component>(){

                @Override
                public int compare(Component c1, Component c2) {
                    return Long.valueOf(c1.getHeight() + c2.getWidth()).compareTo(c2.getHeight() + c1.getWidth());
                }
            });
            for (Component c : tempComponentList) {
                Component compCopy = c.deepCopy();
                Iterator iter = parent2.iterator();
                Component next = (Component)iter.next();
                while (iter.hasNext() && !c.getName().equals(next.getName())) {
                    next = (Component)iter.next();
                }
                compCopy.setCoordinates(next.getLeft(), next.getBottom(), next.getRotate(), next.getMirror());
                child.add(compCopy);
                if (!child.overlaps(compCopy)) continue;
                child.singleRandomizedPlacement(compCopy);
            }
            child.initializeGridOccupation();
            return child;
        }

        @Override
        public RandomizedChromosome deepCopy() {
            RandomizedComponentListChromosome clone = new RandomizedComponentListChromosome(this.boardHeight, this.boardWidth, this.gridVerticalSize, this.gridHorizontalSize);
            int i = 0;
            for (Component c : this) {
                clone.add(i++, c.deepCopy());
            }
            clone.initializeGridOccupation();
            return clone;
        }

        @Override
        public double fitness() {
            long fitness = 0L;
            int numberOfNets = 0;
            if (!Arrays.equals(((Component)this.get(0)).getPins(), new Pin[0])) {
                numberOfNets = ((Component)this.get(0)).getPins()[0].getNumberOfNets();
            }
            long[][] netBoundsTable = new long[numberOfNets][4];
            for (Component c : this) {
                Pin[] pins = c.getPins();
                long[] start = new long[4];
                for (Pin p : pins) {
                    if (p.index < 0) continue;
                    long pinX = p.getX();
                    long pinY = p.getY();
                    long[] netBounds = new long[4];
                    for (int i = 0; i < 4; ++i) {
                        netBounds[i] = netBoundsTable[p.getIndex()][i];
                    }
                    if (!Arrays.equals(netBounds, start)) {
                        if (pinX < netBounds[0]) {
                            netBounds[0] = pinX;
                        } else if (pinX > netBounds[1]) {
                            netBounds[1] = pinX;
                        }
                        if (pinY < netBounds[2]) {
                            netBounds[2] = pinY;
                        } else if (pinY > netBounds[3]) {
                            netBounds[3] = pinY;
                        }
                    } else {
                        netBounds = new long[]{pinX, pinX, pinY, pinY};
                    }
                    netBoundsTable[p.getIndex()] = netBounds;
                }
            }
            for (Object bounds : (Object)netBoundsTable) {
                fitness += bounds[1] - bounds[0] + (bounds[3] - bounds[2]);
            }
            this.ig.update("test", fitness, netBoundsTable);
            return fitness;
        }

        @Override
        public int length() {
            return this.size();
        }

        @Override
        public void updateCondition(String owner, long time) {
        }

        public void randomizePlacement() {
            int maxTrial = 1000;
            Collections.sort(this, new Comparator<Component>(){

                @Override
                public int compare(Component c1, Component c2) {
                    return Long.valueOf(c1.getHeight() + c2.getWidth()).compareTo(c2.getHeight() + c1.getWidth());
                }
            });
            long parentHeight = this.boardHeight;
            long parentWidth = this.boardWidth;
            block0: for (Component c : this) {
                float rotation = (float)Math.floor(Math.random() * 4.0) * 90.0f;
                c.setRotate(rotation);
                int count = 0;
                do {
                    long x = (long)(Math.random() * (double)(parentWidth - c.getWidth()));
                    long y = (long)(Math.random() * (double)(parentHeight - c.getHeight()));
                    c.setLL(x, y);
                    if (++count < maxTrial) continue;
                    ALog.logError((String)"Could not generate a random placement.");
                    continue block0;
                } while (this.overlaps(c));
            }
        }

        public void singleRandomizedPlacement(double boxProportion, Component c) {
            int maxTrial = 1000;
            long parentHeight = ((Component)this.get(0)).getParentHeight();
            long parentWidth = ((Component)this.get(0)).getParentWidth();
            float rotation = (float)Math.floor(Math.random() * 4.0) * 90.0f;
            c.setRotate(rotation);
            int count = 0;
            do {
                long yInBox;
                long xInBox;
                long x = 0L;
                long y = 0L;
                while ((x = (xInBox = (long)(Math.random() * (boxProportion * (double)parentWidth))) + c.getLeft() - (long)(boxProportion * (double)parentWidth) / 2L) <= 0L || x + c.getWidth() >= parentWidth) {
                }
                while ((y = (yInBox = (long)(Math.random() * (boxProportion * (double)parentHeight))) + c.getBottom() - (long)(boxProportion * (double)parentHeight) / 2L) <= 0L || y + c.getHeight() >= parentHeight) {
                }
                c.setLL(x, y);
                if (++count < maxTrial) continue;
                ALog.logError((String)"Could not generate a random placement.");
                break;
            } while (this.overlaps(c));
            this.updateGridOccupation(c);
        }

        public void singleRandomizedPlacement(Component c) {
            int maxTrial = 1000;
            long parentHeight = ((Component)this.get(0)).getParentHeight();
            long parentWidth = ((Component)this.get(0)).getParentWidth();
            long initialX = c.getLeft();
            long initialY = c.getBottom();
            float rotation = (float)Math.floor(Math.random() * 4.0) * 90.0f;
            c.setRotate(rotation);
            int count = 0;
            do {
                long x = (long)Math.floor(Math.random() * (double)(parentWidth - c.getWidth()));
                long y = (long)Math.floor(Math.random() * (double)(parentHeight - c.getHeight()));
                c.setLL(x, y);
                if (++count < maxTrial) continue;
                ALog.logError((String)"Could not generate a random placement.");
                c.setLL(initialX, initialY);
                break;
            } while (this.overlaps(c));
        }

        public boolean overlaps(Component toBePlaced) {
            for (int i = 0; i < this.length(); ++i) {
                Component placed = (Component)this.get(i);
                if (!toBePlaced.intersects(placed) || toBePlaced == placed) continue;
                return true;
            }
            return false;
        }

        public void updateGridOccupation(Component c) {
            long i;
            ArrayList<Integer> horizontalOccupation = c.getHorizontalOccupation();
            ArrayList<Integer> verticalOccupation = c.getVerticalOccupation();
            long left = c.getLeft();
            long bottom = c.getBottom();
            long right = c.getRight();
            long top = c.getTop();
            for (int i2 : horizontalOccupation) {
                for (int j : verticalOccupation) {
                    this.grid[i2][j].remove(c);
                }
            }
            for (i = left / this.gridHorizontalSize; i <= right / this.gridHorizontalSize; ++i) {
                horizontalOccupation.add((int)i);
            }
            for (i = bottom / this.gridVerticalSize; i <= top / this.gridVerticalSize; ++i) {
                verticalOccupation.add((int)i);
            }
            c.setHorizontalOccupation(horizontalOccupation);
            c.setVerticalOccupation(verticalOccupation);
            for (int i2 : horizontalOccupation) {
                for (int j : verticalOccupation) {
                    this.grid[i2][j].add(c);
                }
            }
        }

        public void initializeGridOccupation() {
            for (Component c : this) {
                long i;
                ArrayList<Integer> horizontalOccupation = new ArrayList<Integer>();
                ArrayList<Integer> verticalOccupation = new ArrayList<Integer>();
                long left = c.getLeft();
                long right = c.getRight();
                long bottom = c.getBottom();
                long top = c.getTop();
                for (i = left / this.gridHorizontalSize; i <= right / this.gridHorizontalSize; ++i) {
                    horizontalOccupation.add((int)i);
                }
                for (i = bottom / this.gridVerticalSize; i <= top / this.gridVerticalSize; ++i) {
                    verticalOccupation.add((int)i);
                }
                c.setHorizontalOccupation(horizontalOccupation);
                c.setVerticalOccupation(verticalOccupation);
                for (int i2 : horizontalOccupation) {
                    for (int j : verticalOccupation) {
                        this.grid[i2][j].add(c);
                    }
                }
            }
        }
    }

    static class ImageGeneration {
        protected DesignCanvas2D.XForm toImageFromWorld;
        protected int screenDimX = 1024;
        protected int screenDimY = 1024;
        protected Rectangle screenRect = new Rectangle();
        BufferedImage myImage = new BufferedImage(this.screenDimX, this.screenDimY, 2);
        Graphics2D graphics;
        long experiment;

        public ImageGeneration(ARect worldRect) {
            this.screenRect = new Rectangle(0, 0, this.screenDimX, this.screenDimY);
            this.toImageFromWorld.setWorld(worldRect);
            this.toImageFromWorld.setScreen(this.screenRect);
            this.experiment = 0L;
        }

        public void update(String name, double score, long[][] netBoundsTable) {
            this.graphics = this.myImage.createGraphics();
            Color back = new Color(0, 0, 0);
            this.graphics.setPaint(back);
            BasicStroke stroke = new BasicStroke(1.0f);
            this.graphics.setStroke(stroke);
            this.graphics.fillRect(0, 0, this.screenDimX, this.screenDimY);
            Color cL = new Color(255, 255, 255);
            this.graphics.setPaint(cL);
            for (long[] bounds : netBoundsTable) {
                int x0 = (int)bounds[0];
                int y0 = (int)bounds[2];
                int x1 = (int)bounds[1];
                int y1 = (int)bounds[3];
                this.graphics.drawLine(x0, y0, x1, y1);
            }
            File outputfile = new File(name + "-" + this.experiment + ".png");
            try {
                ImageIO.write((RenderedImage)this.myImage, "png", outputfile);
            }
            catch (IOException e) {
                ALog.logError((Throwable)e);
            }
        }
    }
}

