/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

import com.sigrity.orbit.automation.experimental.PlacementChromosomes;
import com.sigrity.orbit.automation.experimental.RandomizedIndividual;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.stream.Stream;

public class RandomizedGeneticOptimizer {

    static class GeneticOptimizer
    extends LinkedList<RandomizedIndividual> {
        protected int maxPopulation;
        protected int numberOfGenerations;
        protected int currentGeneration = 0;
        protected long boardHeight;
        protected long boardWidth;
        protected long gridVerticalSize;
        protected long gridHorizontalSize;
        protected int divisionBy;

        public GeneticOptimizer(int maxPop, int nbOfGenerations, int generationNb, long parentHeight, long parentWidth, int divBy) {
            this.maxPopulation = maxPop;
            this.numberOfGenerations = nbOfGenerations;
            this.currentGeneration = generationNb;
            this.boardHeight = parentHeight;
            this.boardWidth = parentWidth;
            this.divisionBy = divBy;
            this.gridVerticalSize = parentHeight / (long)this.divisionBy;
            this.gridHorizontalSize = parentWidth / (long)this.divisionBy;
        }

        public void generateInitialRandomPopulation(PlacementChromosomes.RandomizedComponentListChromosome chrom) {
            RandomizedIndividual starter = new RandomizedIndividual(chrom);
            for (int n = 0; n < this.maxPopulation; ++n) {
                RandomizedIndividual individual = starter.deepCopy();
                PlacementChromosomes.RandomizedComponentListChromosome chromosome = individual.getChromosome();
                chromosome.randomizePlacement();
                individual.setChromosome(chromosome);
                this.add(individual);
            }
        }

        public void scoreMe(RandomizedIndividual ind) {
            double fitness = ind.getChromosome().fitness();
            ind.setFitness(fitness);
        }

        public void calculateFitness() {
            ((Stream)this.stream().parallel()).forEach(this::scoreMe);
        }

        public void sortGeneration() {
            this.sort(new Comparator<RandomizedIndividual>(){

                @Override
                public int compare(RandomizedIndividual ind1, RandomizedIndividual ind2) {
                    return Double.valueOf(ind1.getFitness()).compareTo(ind2.getFitness());
                }
            });
        }

        public void mateRandom() {
            int mateSize = this.size();
            for (int i = 0; i < mateSize; ++i) {
                RandomizedIndividual ind1 = this.getRandomIndividual();
                RandomizedIndividual ind2 = this.getRandomIndividual();
                RandomizedIndividual child = ind1.mate(ind2);
                this.add(child);
            }
        }

        public void mutateProbabilistically() {
            LinkedList<RandomizedIndividual> mutatedList = new LinkedList<RandomizedIndividual>();
            double coeff = -Math.log(0.1) / (double)this.numberOfGenerations;
            double proportion = Math.exp(-coeff * (double)this.currentGeneration);
            int mutationSize = ((RandomizedIndividual)this.getFirst()).getChromosome().length() / 4;
            for (RandomizedIndividual ind : this) {
                RandomizedIndividual newInd = ind.deepCopy();
                newInd.getChromosome().mutate(proportion, mutationSize);
                mutatedList.add(newInd);
            }
            for (RandomizedIndividual ind : mutatedList) {
                this.add(ind);
            }
        }

        public GeneticOptimizer selectProbabilistically() {
            int i;
            double proportionKept = 0.7;
            GeneticOptimizer newGeneration = new GeneticOptimizer(this.maxPopulation, this.numberOfGenerations, this.currentGeneration, this.boardHeight, this.boardWidth, this.divisionBy);
            this.sortGeneration();
            int lastKept = (int)Math.floor(proportionKept * (double)this.maxPopulation);
            for (i = 0; i < lastKept; ++i) {
                newGeneration.add(((RandomizedIndividual)this.get(i)).deepCopy());
            }
            for (i = lastKept; i < this.maxPopulation; ++i) {
                int index = (int)Math.floor(Math.random() * (double)(this.size() - lastKept) + (double)lastKept);
                newGeneration.add(((RandomizedIndividual)this.get(index)).deepCopy());
            }
            return newGeneration;
        }

        public RandomizedIndividual getRandomIndividual() {
            int index = (int)Math.floor(Math.random() * (double)this.size());
            return (RandomizedIndividual)this.get(index);
        }

        public void increaseGeneration() {
            ++this.currentGeneration;
        }

        public int getGeneration() {
            return this.currentGeneration;
        }
    }
}

