/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.automation.experimental;

public class SpringForce {
    protected Object obj1;
    protected Object obj2;
    protected double k;
    protected long anchorPointXObj1;
    protected long anchorPointYObj1;
    protected long anchorPointXObj2;
    protected long anchorPointYObj2;
    protected SpringForce oppositeForce;

    public SpringForce(Object object1, Object object2, double springConstant, long ancPointXObj1, long ancPointYObj1, long ancPointXObj2, long ancPointYObj2) {
        this.obj1 = object1;
        this.obj2 = object2;
        this.k = springConstant;
        this.anchorPointXObj1 = ancPointXObj1;
        this.anchorPointYObj1 = ancPointYObj1;
        this.anchorPointXObj2 = ancPointXObj2;
        this.anchorPointYObj2 = ancPointYObj2;
    }

    public SpringForce(Object object1, Object object2, double springConstant, long ancPointXObj1, long ancPointYObj1, long ancPointXObj2, long ancPointYObj2, SpringForce opposite) {
        this.obj1 = object1;
        this.obj2 = object2;
        this.k = springConstant;
        this.anchorPointXObj1 = ancPointXObj1;
        this.anchorPointYObj1 = ancPointYObj1;
        this.anchorPointXObj2 = ancPointXObj2;
        this.anchorPointYObj2 = ancPointYObj2;
        this.oppositeForce = opposite;
    }

    public Object getObj1() {
        return this.obj1;
    }

    public Object getObj2() {
        return this.obj2;
    }

    public long getDistX() {
        return this.anchorPointXObj2 - this.anchorPointXObj1;
    }

    public long getDistY() {
        return this.anchorPointYObj2 - this.anchorPointYObj1;
    }

    public double getMagnitude() {
        return this.k;
    }

    public double getX() {
        return this.k * Math.cos(this.getAngle());
    }

    public double getY() {
        return this.k * Math.sin(this.getAngle());
    }

    public double getAngle() {
        double cos = (double)this.getDistX() / Math.sqrt(Math.pow(this.getDistX(), 2.0) + Math.pow(this.getDistY(), 2.0));
        return (double)Math.signum(this.getDistY()) * Math.acos(cos);
    }

    public void move(Object obj, long x, long y) {
        if (obj == this.obj1) {
            this.moveObj1(x, y);
        } else {
            this.moveObj2(x, y);
        }
    }

    public void moveObj1(long x, long y) {
        this.anchorPointXObj1 += x;
        this.anchorPointYObj1 += y;
    }

    public void moveObj2(long x, long y) {
        this.anchorPointXObj2 += x;
        this.anchorPointYObj2 += y;
    }

    public void moveXObj1(long x) {
        this.anchorPointXObj1 += x;
    }

    public void moveYObj1(long y) {
        this.anchorPointYObj1 += y;
    }

    public void moveXObj2(long x) {
        this.anchorPointXObj2 += x;
    }

    public void moveYObj2(long y) {
        this.anchorPointYObj2 += y;
    }

    public void moveAll(long x, long y) {
        this.anchorPointXObj1 += x;
        this.anchorPointYObj1 += y;
        this.anchorPointXObj2 += x;
        this.anchorPointYObj2 += y;
    }

    public SpringForce getForceFromOtherObj() {
        SpringForce opposite = new SpringForce(this.obj2, this.obj1, this.k, this.anchorPointXObj2, this.anchorPointYObj2, this.anchorPointXObj1, this.anchorPointYObj1, this);
        this.setOppositeForce(opposite);
        return opposite;
    }

    public void setOppositeForce(SpringForce opposite) {
        this.oppositeForce = opposite;
    }

    public Object getOtherObj(Object obj) {
        if (obj == this.obj1) {
            return this.obj2;
        }
        return this.obj1;
    }

    public SpringForce getOpposite() {
        return this.oppositeForce;
    }
}

